/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVIFHeader;
import org.tmatesoft.svn.core.internal.server.dav.DAVIFState;
import org.tmatesoft.svn.core.internal.server.dav.DAVIFStateType;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockScope;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.IDAVResourceWalkHandler;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVValidateWalker
implements IDAVResourceWalkHandler {
    @Override
    public DAVResponse handleResource(DAVResponse response, DAVResource resource, DAVLockInfoProvider lockInfoProvider, LinkedList ifHeaders, int flags, DAVLockScope lockScope, IDAVResourceWalkHandler.CallType callType) throws DAVException {
        DAVException exception = null;
        try {
            this.validateResourceState(ifHeaders, resource, lockInfoProvider, lockScope, flags);
            return response;
        }
        catch (DAVException e) {
            exception = e;
            if (DAVServlet.isHTTPServerError(exception.getResponseCode())) {
                throw exception;
            }
            DAVResponse resp = new DAVResponse(null, resource.getResourceURI().getRequestURI(), response, null, exception.getResponseCode());
            return resp;
        }
    }

    public void validateResourceState(LinkedList ifHeaders, DAVResource resource, DAVLockInfoProvider provider, DAVLockScope lockScope, int flags) throws DAVException {
        DAVLock lock = null;
        if (provider != null) {
            try {
                lock = provider.getLock(resource);
            }
            catch (DAVException dave) {
                throw new DAVException("The locks could not be queried for verification against a possible \"If:\" header.", null, 500, null, SVNLogType.NETWORK, Level.FINE, dave, null, null, 0, null);
            }
        }
        boolean seenLockToken = false;
        if (lockScope == DAVLockScope.EXCLUSIVE) {
            if (lock != null) {
                throw new DAVException("Existing lock(s) on the requested resource prevent an exclusive lock.", 423, 0);
            }
            seenLockToken = true;
        } else if (lockScope == DAVLockScope.SHARED) {
            if (lock.getScope() == DAVLockScope.EXCLUSIVE) {
                throw new DAVException("The requested resource is already locked exclusively.", 423, 0);
            }
            seenLockToken = true;
        } else {
            boolean bl = seenLockToken = lock == null;
        }
        if (ifHeaders == null || ifHeaders.isEmpty()) {
            if (seenLockToken) {
                return;
            }
            throw new DAVException("This resource is locked and an \"If:\" header was not supplied to allow access to the resource.", 423, 0);
        }
        DAVIFHeader ifHeader = (DAVIFHeader)ifHeaders.getFirst();
        if (lock == null && ifHeader.isDummyHeader()) {
            if ((flags & 0x100) != 0) {
                return;
            }
            throw new DAVException("The locktoken specified in the \"Lock-Token:\" header is invalid because this resource has no outstanding locks.", 400, 0);
        }
        String eTag = resource.getETag();
        String uri = DAVPathUtil.dropTraillingSlash(resource.getResourceURI().getRequestURI());
        int numThatAppy = 0;
        String reason = null;
        Iterator ifHeadersIter = ifHeaders.iterator();
        while (ifHeadersIter.hasNext()) {
            ifHeader = (DAVIFHeader)ifHeadersIter.next();
            if (ifHeader.getURI() != null && !uri.equals(ifHeader.getURI())) continue;
            ++numThatAppy;
            LinkedList stateList = ifHeader.getStateList();
            boolean doContinue = false;
            for (DAVIFState state : stateList) {
                if (state.getType() == DAVIFStateType.IF_ETAG) {
                    boolean eTagsDoNotMatch;
                    String currentETag = null;
                    String givenETag = null;
                    String stateETag = state.getETag();
                    givenETag = stateETag.startsWith("W/") ? stateETag.substring(2) : stateETag;
                    currentETag = eTag.startsWith("W/") ? eTag.substring(2) : eTag;
                    boolean bl = eTagsDoNotMatch = !givenETag.equals(currentETag);
                    if (state.getCondition() == 0 && eTagsDoNotMatch) {
                        reason = "an entity-tag was specified, but the resource's actual ETag does not match.";
                        doContinue = true;
                        break;
                    }
                    if (state.getCondition() != 1 || eTagsDoNotMatch) continue;
                    reason = "an entity-tag was specified using the \"Not\" form, but the resource's actual ETag matches the provided entity-tag.";
                    doContinue = true;
                    break;
                }
                if (state.getType() == DAVIFStateType.IF_OPAQUE_LOCK) {
                    if (provider == null) {
                        if (state.getCondition() == 1) continue;
                        reason = "a State-token was supplied, but a lock database is not available for to provide the required lock.";
                        doContinue = true;
                        break;
                    }
                    boolean matched = false;
                    if (lock != null) {
                        if (!lock.getLockToken().equals(state.getLockToken())) continue;
                        seenLockToken = true;
                        if (state.getCondition() == 1) {
                            reason = "a State-token was supplied, which used a \"Not\" condition. The State-token was found in the locks on this resource";
                            doContinue = true;
                            break;
                        }
                        String lockAuthUser = lock.getAuthUser();
                        String requestUser = resource.getUserName();
                        if (!(lockAuthUser == null || requestUser != null && lockAuthUser.equals(requestUser))) {
                            throw new DAVException("User \"{0}\" submitted a locktoken created by user \"{1}\".", new Object[]{requestUser, lockAuthUser}, 403, 0);
                        }
                        matched = true;
                    }
                    if (matched || state.getCondition() != 0) continue;
                    reason = "a State-token was supplied, but it was not found in the locks on this resource.";
                    doContinue = true;
                    break;
                }
                if (state.getType() != DAVIFStateType.IF_UNKNOWN || state.getCondition() != 0) continue;
                reason = "an unknown state token was supplied";
                doContinue = true;
                break;
            }
            if (doContinue) continue;
            if (!seenLockToken) break;
            return;
        }
        if (!ifHeadersIter.hasNext()) {
            if (numThatAppy == 0) {
                if (seenLockToken) {
                    return;
                }
                if (this.findSubmittedLockToken(ifHeaders, lock)) {
                    return;
                }
                throw new DAVException("This resource is locked and the \"If:\" header did not specify one of the locktokens for this resource's lock(s).", 423, 0);
            }
            ifHeader = (DAVIFHeader)ifHeaders.getFirst();
            if (ifHeader.isDummyHeader()) {
                throw new DAVException("The locktoken specified in the \"Lock-Token:\" header did not specify one of this resource's locktoken(s).", 400, 0);
            }
            if (reason == null) {
                throw new DAVException("The preconditions specified by the \"If:\" header did not match this resource.", 412, 0);
            }
            throw new DAVException("The precondition(s) specified by the \"If:\" header did not match this resource. At least one failure is because: {0}", new Object[]{reason}, 412, 0);
        }
        if (this.findSubmittedLockToken(ifHeaders, lock)) {
            return;
        }
        if (ifHeader.isDummyHeader()) {
            throw new DAVException("The locktoken specified in the \"Lock-Token:\" header did not specify one of this resource's locktoken(s).", 400, 0);
        }
        throw new DAVException("This resource is locked and the \"If:\" header did not specify one of the locktokens for this resource's lock(s).", 423, 1);
    }

    private boolean findSubmittedLockToken(LinkedList ifHeaders, DAVLock lock) {
        for (DAVIFHeader ifHeader : ifHeaders) {
            LinkedList ifStates = ifHeader.getStateList();
            for (DAVIFState ifState : ifStates) {
                String stateLockToken;
                String lockToken;
                if (ifState.getType() != DAVIFStateType.IF_OPAQUE_LOCK || !(lockToken = lock.getLockToken()).equals(stateLockToken = ifState.getLockToken())) continue;
                return true;
            }
        }
        return false;
    }
}

