/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.NullProjectCheckAction;
import com.avaje.ebean.Expr;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AbstractPostingApp;
import controllers.LabelApp;
import controllers.MigrationApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.routes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import models.AbstractPosting;
import models.Attachment;
import models.Comment;
import models.IssueLabel;
import models.NotificationEvent;
import models.Organization;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.ProjectUser;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Result;
import play.mvc.With;
import play.twirl.api.Content;
import playRepository.BareCommit;
import playRepository.BareRepository;
import utils.AccessControl;
import utils.ErrorViews;
import utils.GitUtil;
import utils.HttpUtil;
import utils.JodaDateUtil;
import utils.LineEnding;
import utils.MenuType;
import utils.RouteUtil;
import views.html.board.create;
import views.html.board.edit;
import views.html.board.list;
import views.html.board.view;
import views.html.organization.group_board_list;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BoardApp
extends AbstractPostingApp {
    @AnonymousCheck(requiresLogin=false, displaysFlashMessage=true)
    public static Result organizationBoards(@Nonnull String organizationName, int pageNum) {
        Organization organization2;
        Form postParamForm = new Form(SearchCondition.class);
        SearchCondition searchCondition = (SearchCondition)postParamForm.bindFromRequest(new String[0]).get();
        int n = pageNum - 1;
        SearchCondition searchCondition2 = searchCondition;
        searchCondition2.setPageNum(n);
        searchCondition2 = searchCondition;
        String string = null;
        string = searchCondition2.getOrderBy();
        if (string.equals("id")) {
            string = "createdDate";
            searchCondition2 = searchCondition;
            searchCondition2.setOrderBy(string);
        }
        if ((organization2 = Organization.findByName(organizationName)) == null) {
            return BoardApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.organization"));
        }
        ExpressionList el = searchCondition.asExpressionList(organization2);
        searchCondition2 = searchCondition;
        int n2 = 0;
        n2 = searchCondition2.getPageNum();
        Page posts2 = el.findPagingList(15).getPage(n2);
        return BoardApp.ok((Content)group_board_list.render("menu.board", organization2, (Page<Posting>)posts2, searchCondition, null));
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.PROJECT)
    public static Result posts(String userName, String projectName, int pageNum) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Form postParamForm = new Form(SearchCondition.class);
        SearchCondition searchCondition = (SearchCondition)postParamForm.bindFromRequest(new String[0]).get();
        int n = pageNum - 1;
        SearchCondition searchCondition2 = searchCondition;
        searchCondition2.setPageNum(n);
        searchCondition2 = searchCondition;
        Set<Long> set = null;
        set = searchCondition2.getOrderBy();
        if (((String)((Object)set)).equals("id")) {
            set = "createdDate";
            searchCondition2 = searchCondition;
            searchCondition2.setOrderBy((String)((Object)set));
        }
        searchCondition2 = searchCondition;
        set = null;
        set = searchCondition2.getLabelIdSet();
        set.addAll(LabelApp.getLabelIds(BoardApp.request()));
        searchCondition2 = searchCondition;
        set = null;
        set = searchCondition2.getLabelIdSet();
        set.remove(null);
        ExpressionList el = searchCondition.asExpressionList(project2);
        el.eq("notice", (Object)false);
        searchCondition2 = searchCondition;
        int n2 = 0;
        n2 = searchCondition2.getPageNum();
        Page posts2 = el.findPagingList(15).getPage(n2);
        List<Posting> notices = Posting.findNotices(project2);
        return BoardApp.ok((Content)list.render("menu.board", project2, (Page<Posting>)posts2, searchCondition, notices));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.BOARD_POST)
    public static Result newPostForm(String userName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        boolean isAllowedToNotice = AccessControl.isProjectResourceCreatable(UserApp.currentUser(), project2, ResourceType.BOARD_NOTICE);
        String preparedBodyText = "";
        if (BoardApp.readmeEditRequested() && BoardApp.projectHasReadme(project2)) {
            preparedBodyText = BareRepository.readREADME(project2);
        }
        if (BoardApp.issueTemplateEditRequested()) {
            preparedBodyText = (String)StringUtils.defaultIfBlank((CharSequence)project2.getIssueTemplate(), (CharSequence)"");
        }
        if (BoardApp.textFileEditRequested()) {
            boolean isAllowedToFileEdit = AccessControl.isProjectResourceCreatable(UserApp.currentUser(), project2, ResourceType.COMMIT);
            if (!isAllowedToFileEdit) {
                return BoardApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
            }
            preparedBodyText = GitUtil.getReadTextFile(project2, BoardApp.getBranchNameFromQueryString(), BoardApp.request().getQueryString("path"));
        }
        return BoardApp.ok((Content)create.render("post.new", (Form<Posting>)new Form(Posting.class), project2, isAllowedToNotice, preparedBodyText));
    }

    private static boolean projectHasReadme(Project project2) {
        return project2.readme() != null;
    }

    private static boolean readmeEditRequested() {
        return BoardApp.request().getQueryString("readme") != null;
    }

    private static boolean issueTemplateEditRequested() {
        return BoardApp.request().getQueryString("issueTemplate") != null;
    }

    private static boolean textFileEditRequested() {
        return BoardApp.request().getQueryString("path") != null;
    }

    private static String getBranchNameFromQueryString() {
        return BoardApp.request().getQueryString("branch");
    }

    @Transactional
    @IsCreatable(value=ResourceType.BOARD_POST)
    public static Result newPost(String userName, String projectName) {
        Form postForm = new Form(Posting.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        if (postForm.hasErrors()) {
            boolean isAllowedToNotice = AccessControl.isProjectResourceCreatable(UserApp.currentUser(), project2, ResourceType.BOARD_NOTICE);
            return BoardApp.badRequest((Content)create.render("error.validation", (Form<Posting>)postForm, project2, isAllowedToNotice, ""));
        }
        Posting post2 = (Posting)postForm.get();
        Model model = post2;
        Object object = null;
        object = model.getBody();
        if (object == null) {
            return BoardApp.status((int)413, (Content)ErrorViews.RequestTextEntityTooLarge.render());
        }
        object = JodaDateUtil.now();
        model = post2;
        model.setCreatedDate((Date)object);
        object = JodaDateUtil.now();
        model = post2;
        model.setUpdatedDate((Date)object);
        post2.setAuthor(UserApp.currentUser());
        object = project2;
        model = post2;
        model.setProject((Project)object);
        model = post2;
        boolean bl = false;
        bl = model.getReadme();
        if (bl) {
            Posting readmePosting = Posting.findREADMEPosting(project2);
            if (readmePosting != null) {
                return BoardApp.editPost(userName, projectName, readmePosting.getNumber());
            }
            BoardApp.commitReadmeFile(project2, post2);
        }
        model = post2;
        String string = null;
        string = model.getIssueTemplate();
        if (string.equals("true")) {
            BoardApp.commitIssueTemplateFile(project2, post2);
            model = project2;
            string = null;
            string = model.getOwner();
            return BoardApp.redirect((Call)routes.ProjectApp.project(string, projectName));
        }
        model = post2;
        string = null;
        string = model.getPath();
        if (StringUtils.isNotEmpty((CharSequence)string) && UserApp.currentUser().isMemberOf(project2)) {
            model = post2;
            string = null;
            String string2 = string = model.getBranch();
            model = post2;
            string = null;
            String string3 = string = model.getPath();
            model = post2;
            string = null;
            String string4 = string = model.getBody();
            model = post2;
            string = null;
            string = model.getLineEnding();
            String string5 = LineEnding.changeLineEnding(string4, string);
            model = post2;
            string = null;
            string = model.getTitle();
            GitUtil.commitTextFile(project2, string2, string3, string5, string);
            model = project2;
            string = null;
            String string6 = string = model.getOwner();
            model = project2;
            string = null;
            String string7 = string = model.getName();
            model = post2;
            string = null;
            String string8 = string = model.getBranch();
            model = post2;
            string = null;
            string = model.getPath();
            return BoardApp.redirect((Call)routes.CodeApp.codeBrowserWithBranch(string6, string7, string8, HttpUtil.getEncodeEachPathName(string)));
        }
        post2.save();
        BoardApp.attachUploadFilesToPost(post2.asResource());
        NotificationEvent.afterNewPost(post2);
        model = post2;
        boolean bl2 = false;
        bl2 = model.getReadme();
        if (bl2) {
            return BoardApp.redirect((Call)routes.ProjectApp.project(userName, projectName));
        }
        model = project2;
        String string9 = null;
        String string10 = string9 = model.getOwner();
        model = project2;
        string9 = null;
        string9 = model.getName();
        return BoardApp.redirect((Call)routes.BoardApp.post(string10, string9, post2.getNumber()));
    }

    private static void commitReadmeFile(Project project2, Posting post2) {
        BareCommit bare = new BareCommit(project2, UserApp.currentUser());
        try {
            Model model = post2;
            String string = null;
            String string2 = string = model.getBody();
            model = post2;
            string = null;
            string = model.getTitle();
            ObjectId objectId = bare.commitTextFile("README.md", string2, string);
            model = project2;
            string = null;
            string = model.getName();
            Logger.debug((String)("Online Commit: README " + string + ":" + objectId));
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.error((String)e.getMessage());
        }
    }

    private static void commitIssueTemplateFile(Project project2, Posting post2) {
        BareCommit bare = new BareCommit(project2, UserApp.currentUser());
        try {
            Model model = post2;
            String string = null;
            String string2 = string = model.getBody();
            model = post2;
            string = null;
            string = model.getTitle();
            ObjectId objectId = bare.commitTextFile("ISSUE_TEMPLATE.md", string2, string);
            model = project2;
            string = null;
            string = model.getName();
            Logger.debug((String)("Online Commit: ISSUE_TEMPLATE " + string + ":" + objectId));
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.error((String)e.getMessage());
        }
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.BOARD_POST)
    public static Result post(String userName, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Posting post2 = Posting.findByNumber(project2, number);
        Model model = post2;
        boolean bl = false;
        bl = model.getReadme();
        if (bl) {
            model = project2;
            String string = null;
            string = model.getVcs();
            if ("GIT".equals(string)) {
                string = StringUtils.defaultString((String)BareRepository.readREADME(project2));
                model = post2;
                model.setBody(string);
            }
        }
        if (BoardApp.request().getHeader("Accept").contains("application/json")) {
            ObjectNode json = Json.newObject();
            model = post2;
            Object object = null;
            object = model.getTitle();
            json.put("title", (String)object);
            json.put("type", post2.asResource().getType().toString());
            model = post2;
            object = null;
            object = model.getAuthorLoginId();
            json.put("author", (String)object);
            model = post2;
            object = null;
            object = model.getAuthorName();
            json.put("authorName", (String)object);
            model = post2;
            object = null;
            object = model.getCreatedDate();
            json.put("created_at", ((Date)object).getTime());
            model = post2;
            object = null;
            object = model.getBody();
            json.put("body", (String)object);
            json.put("attachments", Json.toJson(Attachment.findByContainer(post2.asResource())));
            json.put("comments", Json.toJson(MigrationApp.composePlainCommentsJson(post2, ResourceType.NONISSUE_COMMENT)));
            return BoardApp.ok((JsonNode)json);
        }
        UserApp.currentUser().visits(project2);
        UserApp.currentUser().visits(post2);
        Form commentForm2 = new Form(PostingComment.class);
        return BoardApp.ok((Content)view.render(post2, (Form<PostingComment>)commentForm2, project2));
    }

    @With(value={NullProjectCheckAction.class})
    public static Result editPostForm(String owner, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        if (!AccessControl.isAllowed(UserApp.currentUser(), posting.asResource(), Operation.READ)) {
            return BoardApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        Form editForm = new Form(Posting.class).fill((Object)posting);
        boolean isAllowedToNotice = ProjectUser.isAllowedToNotice(UserApp.currentUser(), project2);
        Model model = posting;
        boolean bl = false;
        bl = model.getReadme();
        if (bl) {
            model = project2;
            String string = null;
            string = model.getVcs();
            if ("GIT".equals(string)) {
                string = BareRepository.readREADME(project2);
                model = posting;
                model.setBody(string);
            }
        }
        return BoardApp.ok((Content)edit.render("post.modify", (Form<Posting>)editForm, posting, number, project2, isAllowedToNotice));
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result editPost(String userName, String projectName, Long number) {
        Form postForm = new Form(Posting.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        if (postForm.hasErrors()) {
            boolean isAllowedToNotice = AccessControl.isProjectResourceCreatable(UserApp.currentUser(), project2, ResourceType.BOARD_NOTICE);
            return BoardApp.badRequest((Content)edit.render("error.validation", (Form<Posting>)postForm, Posting.findByNumber(project2, number), number, project2, isAllowedToNotice));
        }
        final Posting post2 = (Posting)postForm.get();
        final Posting original = Posting.findByNumber(project2, number);
        Model model = post2;
        boolean bl = false;
        bl = model.getReadme();
        if (bl) {
            post2.setAuthor(UserApp.currentUser());
            BoardApp.commitReadmeFile(project2, post2);
            BoardApp.unmarkAnotherReadmePostingIfExists(project2, number);
        }
        model = project2;
        String string = null;
        String string2 = string = model.getOwner();
        model = project2;
        string = null;
        string = model.getName();
        play.api.mvc.Call redirectTo = routes.BoardApp.post(string2, string, number);
        Runnable updatePostingBeforeUpdate = new Runnable(){

            @Override
            public void run() {
                Object object = original.comments;
                Posting posting = post2;
                posting.setComments((List<PostingComment>)object);
                if (AbstractPostingApp.isSelectedToSendNotificationMail() || !original.isAuthoredBy(UserApp.currentUser())) {
                    posting = original;
                    object = null;
                    object = posting.getBody();
                    NotificationEvent.afterUpdatePosting((String)object, post2);
                }
            }
        };
        return BoardApp.editPosting(original, post2, (Form<? extends AbstractPosting>)postForm, (Call)redirectTo, updatePostingBeforeUpdate);
    }

    private static void unmarkAnotherReadmePostingIfExists(Project project2, Long postingNumber) {
        Posting previousReadmePosting = Posting.findREADMEPosting(project2);
        if (previousReadmePosting != null && !Objects.equals(previousReadmePosting.getNumber(), postingNumber)) {
            boolean bl = false;
            Posting posting = previousReadmePosting;
            posting.setReadme(bl);
            previousReadmePosting.directSave();
        }
    }

    @Transactional
    @IsAllowed(value=Operation.DELETE, resourceType=ResourceType.BOARD_POST)
    public static Result deletePost(String owner, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        play.api.mvc.Call redirectTo = routes.BoardApp.posts(string2, string, 1);
        NotificationEvent.afterResourceDeleted(posting, UserApp.currentUser());
        return BoardApp.delete(posting, posting.asResource(), (Call)redirectTo);
    }

    @Transactional
    @IsAllowed(value=Operation.READ, resourceType=ResourceType.BOARD_POST)
    @With(value={NullProjectCheckAction.class})
    public static Result newComment(String owner, String projectName, Long number) throws IOException {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Posting posting = Posting.findByNumber(project2, number);
        Form commentForm2 = new Form(PostingComment.class).bindFromRequest(new String[0]);
        if (commentForm2.hasErrors()) {
            return BoardApp.badRequest((Content)ErrorViews.BadRequest.render("error.validation", project2, MenuType.BOARD));
        }
        if (!AccessControl.isResourceCreatable(UserApp.currentUser(), posting.asResource(), ResourceType.NONISSUE_COMMENT)) {
            return BoardApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        PostingComment comment = (PostingComment)commentForm2.get();
        if (commentForm2.hasErrors()) {
            BoardApp.flash((String)"warning", (String)"common.comment.empty");
            Project project3 = project2;
            String string = null;
            String string2 = string = project3.getOwner();
            project3 = project2;
            string = null;
            string = project3.getName();
            return BoardApp.redirect((Call)routes.BoardApp.post(string2, string, number));
        }
        PostingComment postingComment = comment;
        String string = null;
        string = postingComment.getParentCommentId();
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            postingComment = comment;
            string = null;
            string = postingComment.getParentCommentId();
            comment.setParentComment((Comment)PostingComment.find.byId((Object)Long.valueOf(string)));
        }
        BoardApp.AddPreviousContent(posting, comment);
        Comment savedComment = BoardApp.saveComment(project2, posting, comment);
        return BoardApp.redirect((String)RouteUtil.getUrl(savedComment));
    }

    private static void AddPreviousContent(Posting posting, PostingComment comment) {
        Model model = posting;
        int n = 0;
        n = model.getNumOfComments();
        if (n == 0) {
            model = posting;
            Object object = null;
            object = model.getBody();
            String string = object;
            model = posting;
            object = null;
            Object object2 = object = model.getUpdatedDate();
            model = posting;
            object = null;
            object = model.getAuthorLoginId();
            object = BoardApp.getPrevious("Original posting", string, (Date)object2, (String)object);
            model = comment;
            model.setPreviousContents((String)object);
        } else {
            List<PostingComment> siblingComments;
            model = comment;
            Object object = null;
            object = model.getParentCommentId();
            Comment previousComment = object != null ? ((siblingComments = comment.getSiblingComments()).size() > 0 ? (Comment)siblingComments.get(siblingComments.size() - 1) : comment.getParentComment()) : (Comment)posting.comments.get(posting.comments.size() - 1);
            model = previousComment;
            object = null;
            object = model.getContents();
            String string = object;
            model = previousComment;
            object = null;
            Object object3 = object = model.getCreatedDate();
            model = previousComment;
            object = null;
            object = model.getAuthorLoginId();
            object = BoardApp.getPrevious("Previous comment", string, (Date)object3, (String)object);
            model = comment;
            model.setPreviousContents((String)object);
        }
    }

    private static String getPrevious(String templateTitle, String contents, Date updatedDate, String authorLoginId) {
        return "\n\n<br />\n\n--- " + templateTitle + " from @" + authorLoginId + "  " + JodaDateUtil.getOptionalShortDate(updatedDate) + " ---\n\n<br />\n\n" + contents;
    }

    public static Result updateComment(String ownerName, String projectName, Long number, Long commentId) throws IOException {
        return BoardApp.newComment(ownerName, projectName, number);
    }

    private static Comment saveComment(Project project2, Posting posting, PostingComment comment) {
        Comment savedComment;
        Model model = comment;
        Object object = null;
        object = model.getId();
        PostingComment existingComment = (PostingComment)PostingComment.find.where().eq("id", object).findUnique();
        if (existingComment != null) {
            model = comment;
            object = null;
            object = model.getContents();
            model = existingComment;
            model.setContents((String)object);
            savedComment = BoardApp.saveComment(existingComment, BoardApp.getContainerUpdater(posting, comment));
            if (BoardApp.isSelectedToSendNotificationMail() || !existingComment.isAuthoredBy(UserApp.currentUser())) {
                NotificationEvent.afterCommentUpdated(savedComment);
            }
        } else {
            model = project2;
            object = null;
            object = model.getId();
            model = comment;
            model.setProjectId((Long)object);
            savedComment = BoardApp.saveComment(comment, BoardApp.getContainerUpdater(posting, comment));
            NotificationEvent.afterNewComment(savedComment);
        }
        return savedComment;
    }

    private static Runnable getContainerUpdater(final Posting posting, final PostingComment comment) {
        return new Runnable(){

            @Override
            public void run() {
                Object object = JodaDateUtil.now();
                Model model = posting;
                model.setUpdatedDate((Date)object);
                object = posting;
                model = comment;
                model.setPosting((Posting)object);
            }
        };
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result deleteComment(String userName, String projectName, Long number, Long commentId) {
        Project project2;
        Comment comment = (Comment)PostingComment.find.byId((Object)commentId);
        Project project3 = project2 = comment.asResource().getProject();
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        play.api.mvc.Call redirectTo = routes.BoardApp.post(string2, string, number);
        return BoardApp.delete(comment, comment.asResource(), (Call)redirectTo);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class SearchCondition
    extends AbstractPostingApp.SearchCondition {
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public List<String> projectNames;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String[] labelIds;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public Set<Long> labelIdSet;

        public SearchCondition() {
            HashSet<Long> hashSet = new HashSet<Long>();
            SearchCondition searchCondition = this;
            searchCondition.setLabelIdSet(hashSet);
        }

        private ExpressionList<Posting> asExpressionList(Project project2) {
            Object object = project2;
            Object object2 = null;
            object2 = ((Project)object).getId();
            ExpressionList el = Posting.finder.where().eq("project.id", object2);
            object = this;
            object2 = null;
            object2 = ((AbstractPostingApp.SearchCondition)object).getFilter();
            if (object2 != null) {
                object = this;
                object2 = null;
                object2 = ((AbstractPostingApp.SearchCondition)object).getFilter();
                Expression expression = Expr.icontains((String)"title", (String)object2);
                object = this;
                object2 = null;
                object2 = ((AbstractPostingApp.SearchCondition)object).getFilter();
                el.or(expression, Expr.icontains((String)"body", (String)object2));
            }
            object = this;
            object2 = null;
            object2 = ((SearchCondition)object).getLabelIdSet();
            if (CollectionUtils.isNotEmpty(object2)) {
                object = this;
                object2 = null;
                object2 = ((SearchCondition)object).getLabelIdSet();
                Set labels2 = IssueLabel.finder.where().idIn(new ArrayList<Long>((Collection<Long>)object2)).findSet();
                el.in("id", (Collection)Posting.finder.where().in("labels", (Collection)labels2).findIds());
            }
            object = this;
            object2 = null;
            object2 = ((AbstractPostingApp.SearchCondition)object).getOrderBy();
            if (StringUtils.isNotBlank((CharSequence)object2)) {
                object = this;
                object2 = null;
                object2 = ((AbstractPostingApp.SearchCondition)object).getOrderBy();
                StringBuilder stringBuilder = new StringBuilder().append((String)object2).append(" ");
                object = this;
                object2 = null;
                object2 = ((AbstractPostingApp.SearchCondition)object).getOrderDir();
                el.orderBy(stringBuilder.append((String)object2).toString());
            }
            return el;
        }

        private ExpressionList<Posting> asExpressionList(@Nonnull Organization organization2) {
            ExpressionList el = Posting.finder.where();
            if (this.isFilteredByProject()) {
                el.in("project.id", this.getFilteredProjectIds(organization2));
            } else {
                el.in("project.id", this.getVisibleProjectIds(organization2));
            }
            SearchCondition searchCondition = this;
            String string = null;
            string = searchCondition.getFilter();
            if (string != null) {
                searchCondition = this;
                string = null;
                string = searchCondition.getFilter();
                Expression expression = Expr.icontains((String)"title", (String)string);
                searchCondition = this;
                string = null;
                string = searchCondition.getFilter();
                el.or(expression, Expr.icontains((String)"body", (String)string));
            }
            searchCondition = this;
            string = null;
            string = searchCondition.getOrderBy();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                searchCondition = this;
                string = null;
                string = searchCondition.getOrderBy();
                StringBuilder stringBuilder = new StringBuilder().append(string).append(" ");
                searchCondition = this;
                string = null;
                string = searchCondition.getOrderDir();
                el.orderBy(stringBuilder.append(string).toString());
            }
            return el;
        }

        private boolean isFilteredByProject() {
            SearchCondition searchCondition = this;
            List<String> list2 = null;
            list2 = searchCondition.getProjectNames();
            return CollectionUtils.isNotEmpty(list2);
        }

        private List<Long> getFilteredProjectIds(@Nonnull Organization organization2) {
            ArrayList<Long> projectIdsFilter = new ArrayList<Long>();
            Object object = this;
            Object object2 = null;
            object2 = ((SearchCondition)object).getProjectNames();
            Iterator<String> iterator = object2.iterator();
            block0: while (iterator.hasNext()) {
                String projectName = iterator.next();
                object = organization2;
                object2 = null;
                object2 = ((Organization)object).getProjects();
                Iterator<Object> iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Project project2 = (Project)iterator2.next();
                    object = project2;
                    object2 = null;
                    object2 = ((Project)object).getName();
                    if (!((String)object2).equalsIgnoreCase(projectName)) continue;
                    object = project2;
                    object2 = null;
                    object2 = ((Project)object).getId();
                    if (!this.getVisibleProjectIds(organization2).contains(((Long)object2).toString())) continue;
                    object = project2;
                    object2 = null;
                    object2 = ((Project)object).getId();
                    projectIdsFilter.add((Long)object2);
                    continue block0;
                }
            }
            return projectIdsFilter;
        }

        private List<String> getVisibleProjectIds(Organization organization2) {
            List<Project> projects2 = organization2.getVisibleProjects(UserApp.currentUser());
            ArrayList<String> projectsIds = new ArrayList<String>();
            Iterator<Project> iterator = projects2.iterator();
            while (iterator.hasNext()) {
                Project project2;
                Project project3 = project2 = iterator.next();
                Long l = null;
                l = project3.getId();
                projectsIds.add(l.toString());
            }
            return projectsIds;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public List<String> getProjectNames() {
            return this.projectNames;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setProjectNames(List<String> list2) {
            this.projectNames = list2;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String[] getLabelIds() {
            return this.labelIds;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLabelIds(String[] stringArray) {
            this.labelIds = stringArray;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Set<Long> getLabelIdSet() {
            return this.labelIdSet;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLabelIdSet(Set<Long> set) {
            this.labelIdSet = set;
        }
    }
}

