/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import models.CommentThread;
import models.NotificationEvent;
import models.enumeration.Operation;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.mvc.Controller;
import play.mvc.Result;
import utils.AccessControl;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CommentThreadApp
extends Controller {
    @Transactional
    public static Result updateState(Long id, CommentThread.ThreadState state) {
        Operation operation;
        CommentThread thread = (CommentThread)CommentThread.find.byId((Object)id);
        if (thread == null) {
            return CommentThreadApp.notFound();
        }
        switch (state) {
            case OPEN: {
                operation = Operation.REOPEN;
                break;
            }
            case CLOSED: {
                operation = Operation.CLOSE;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), thread.asResource(), operation)) {
            return CommentThreadApp.forbidden();
        }
        CommentThread commentThread = thread;
        CommentThread.ThreadState threadState = null;
        CommentThread.ThreadState previousState = threadState = commentThread.getState();
        threadState = state;
        commentThread = thread;
        commentThread.setState(threadState);
        thread.update();
        try {
            NotificationEvent.afterStateChanged(previousState, thread);
        }
        catch (Exception e) {
            Logger.warn((String)"Failed to send a notification for a change of review thread's state", (Throwable)e);
        }
        return CommentThreadApp.ok();
    }

    public static Result open(Long id) {
        return CommentThreadApp.updateState(id, CommentThread.ThreadState.OPEN);
    }

    public static Result close(Long id) {
        return CommentThreadApp.updateState(id, CommentThread.ThreadState.CLOSED);
    }
}

