/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.routes;
import java.util.HashMap;
import models.NotificationEvent;
import models.Organization;
import models.OrganizationUser;
import models.User;
import models.enumeration.RequestState;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Result;
import utils.ValidationResult;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class EnrollOrganizationApp
extends Controller {
    @Transactional
    public static Result enroll(String organizationName) {
        ValidationResult result2 = EnrollOrganizationApp.validateForEnroll(organizationName);
        if (result2.hasError()) {
            return result2.getResult();
        }
        Organization organization2 = Organization.findByName(organizationName);
        if (!User.enrolled(organization2)) {
            User user = UserApp.currentUser();
            user.enroll(organization2);
            NotificationEvent.afterOrganizationMemberRequest(organization2, user, RequestState.REQUEST);
        }
        EnrollOrganizationApp.response().setHeader("Content-Type", "application/json");
        HashMap<String, String> representationData = new HashMap<String, String>();
        representationData.put("message", "You enrolled in " + organizationName + ".");
        representationData.put("statusMonitorUrl", "http://" + EnrollOrganizationApp.request().host() + routes.OrganizationApp.organization(organizationName).url());
        return EnrollOrganizationApp.status((int)202, (JsonNode)Json.toJson(representationData));
    }

    private static ValidationResult validateForEnroll(String organizationName) {
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return new ValidationResult((Result)EnrollOrganizationApp.badRequest(), true);
        }
        User user = UserApp.currentUser();
        if (!OrganizationUser.isGuest(organization2, user)) {
            return new ValidationResult((Result)EnrollOrganizationApp.badRequest(), true);
        }
        return new ValidationResult(null, false);
    }

    @Transactional
    public static Result cancelEnroll(String organizationName) {
        ValidationResult result2 = EnrollOrganizationApp.validateForCancelEnroll(organizationName);
        if (result2.hasError()) {
            return result2.getResult();
        }
        Organization organization2 = Organization.findByName(organizationName);
        if (User.enrolled(organization2)) {
            User user = UserApp.currentUser();
            user.cancelEnroll(organization2);
            NotificationEvent.afterOrganizationMemberRequest(organization2, user, RequestState.CANCEL);
        }
        EnrollOrganizationApp.response().setHeader("Content-Type", "application/json");
        HashMap<String, String> representationData = new HashMap<String, String>();
        representationData.put("message", "You canceled to enroll in " + organizationName + ".");
        representationData.put("statusMonitorUrl", "http://" + EnrollOrganizationApp.request().host() + routes.OrganizationApp.organization(organizationName).url());
        return EnrollOrganizationApp.status((int)202, (JsonNode)Json.toJson(representationData));
    }

    private static ValidationResult validateForCancelEnroll(String organizationName) {
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return new ValidationResult((Result)EnrollOrganizationApp.badRequest(), true);
        }
        User user = UserApp.currentUser();
        if (!OrganizationUser.isGuest(organization2, user)) {
            return new ValidationResult((Result)EnrollOrganizationApp.badRequest(), true);
        }
        return new ValidationResult(null, false);
    }
}

