/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.Expr;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlRow;
import com.fasterxml.jackson.databind.JsonNode;
import controllers.annotation.AnonymousCheck;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import models.Label;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LabelApp
extends Controller {
    private static final int MAX_FETCH_LABELS = 1000;

    public static Result labels(String query, String category2, Integer limit) {
        if (!LabelApp.request().accepts("application/json")) {
            return LabelApp.status((int)406);
        }
        if (limit == null) {
            return LabelApp.badRequest((String)"No limit");
        }
        ExpressionList el = Label.find.where().and(Expr.icontains((String)"category", (String)category2), Expr.icontains((String)"name", (String)query));
        int total = el.findRowCount();
        if (total > limit) {
            el.setMaxRows(limit.intValue());
            LabelApp.response().setHeader("Content-Range", "items " + limit + "/" + total);
        }
        ArrayList<String> labels2 = new ArrayList<String>();
        Iterator iterator = el.findList().iterator();
        while (iterator.hasNext()) {
            Label label;
            Label label2 = label = (Label)iterator.next();
            String string = null;
            string = label2.getName();
            labels2.add(string);
        }
        return LabelApp.ok((JsonNode)Json.toJson(labels2));
    }

    public static Result categories(String query, Integer limit) {
        SqlQuery sqlCountQuery;
        SqlQuery sqlQuery;
        String sqlString;
        if (!LabelApp.request().accepts("application/json")) {
            return LabelApp.status((int)406);
        }
        if (limit == null) {
            return LabelApp.badRequest((String)"No limit");
        }
        if (query != null && query.length() > 0) {
            sqlString = "SELECT DISTINCT category FROM label WHERE lower(category) LIKE :category";
            sqlQuery = Ebean.createSqlQuery((String)sqlString).setParameter("category", (Object)("%" + query.toLowerCase() + "%"));
            sqlCountQuery = Ebean.createSqlQuery((String)("SELECT COUNT(*) AS cnt FROM (" + sqlString + ") categories")).setParameter("category", (Object)("%" + query.toLowerCase() + "%"));
        } else {
            sqlString = "SELECT DISTINCT category FROM label";
            sqlQuery = Ebean.createSqlQuery((String)sqlString);
            sqlCountQuery = Ebean.createSqlQuery((String)("SELECT COUNT(*) AS cnt FROM (" + sqlString + ") categories"));
        }
        int cnt = sqlCountQuery.findUnique().getInteger("cnt");
        if (limit > 1000) {
            limit = 1000;
        }
        if (cnt > limit) {
            sqlQuery.setMaxRows(limit.intValue());
            LabelApp.response().setHeader("Content-Range", "items " + limit + "/" + cnt);
        }
        ArrayList<String> categories2 = new ArrayList<String>();
        for (SqlRow row : sqlQuery.findList()) {
            categories2.add(row.getString("category"));
        }
        return LabelApp.ok((JsonNode)Json.toJson(categories2));
    }

    public static Set<Long> getLabelIds(Http.Request request) {
        HashSet<Long> set = new HashSet<Long>();
        String[] labelIds = (String[])request.queryString().get("labelIds");
        if (labelIds != null) {
            for (String labelId : labelIds) {
                if (StringUtils.isEmpty((CharSequence)labelId)) continue;
                set.add(Long.valueOf(labelId));
            }
        }
        return set;
    }
}

