/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Application;
import controllers.PullRequestApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.GuestProhibit;
import controllers.routes;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import models.Attachment;
import models.FavoriteOrganization;
import models.NotificationEvent;
import models.Organization;
import models.OrganizationUser;
import models.Project;
import models.PullRequest;
import models.Role;
import models.User;
import models.enumeration.Operation;
import models.enumeration.RequestState;
import models.enumeration.RoleType;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.data.validation.Validation;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.ErrorViews;
import utils.LogoUtil;
import utils.ValidationResult;
import views.html.organization.create;
import views.html.organization.deleteForm;
import views.html.organization.group_pullrequest_list;
import views.html.organization.list;
import views.html.organization.members;
import views.html.organization.setting;
import views.html.organization.view;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OrganizationApp
extends Controller {
    @AnonymousCheck(requiresLogin=false, displaysFlashMessage=true)
    public static Result organizationPullRequests(String organizationName, String category2) {
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.organization"));
        }
        PullRequestApp.SearchCondition condition = (PullRequestApp.SearchCondition)Form.form(PullRequestApp.SearchCondition.class).bindFromRequest(new String[0]).get();
        if (category2.equals("open")) {
            condition.setOrganization(organization2).setCategory(PullRequestApp.Category.OPEN);
        } else {
            condition.setOrganization(organization2).setCategory(PullRequestApp.Category.CLOSED);
        }
        Page<PullRequest> page = PullRequest.findPagingList(condition);
        return OrganizationApp.ok((Content)group_pullrequest_list.render("title.pullrequest", organization2, page, condition, category2));
    }

    @AnonymousCheck(requiresLogin=false, displaysFlashMessage=true)
    public static Result organizationClosedPullRequests(String organizationName) {
        return OrganizationApp.organizationPullRequests(organizationName, "closed");
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result newForm() {
        return OrganizationApp.ok((Content)create.render("title.newOrganization", (Form<Organization>)new Form(Organization.class)));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @GuestProhibit
    public static Result newOrganization() throws Exception {
        Form newOrgForm = Form.form(Organization.class).bindFromRequest(new String[0]);
        if (newOrgForm.hasErrors()) {
            Logger.warn((String)("newOrgForm.errors().keySet() " + newOrgForm.error("name").messages()));
            OrganizationApp.flash((String)"warning", (String)newOrgForm.error("name").message());
            return OrganizationApp.badRequest((Content)create.render("title.newOrganization", (Form<Organization>)newOrgForm));
        }
        OrganizationApp.validate((Form<Organization>)newOrgForm);
        if (newOrgForm.hasErrors()) {
            OrganizationApp.flash((String)"warning", (String)newOrgForm.error("name").message());
            return OrganizationApp.badRequest((Content)create.render("title.newOrganization", (Form<Organization>)newOrgForm));
        }
        Organization org = (Organization)newOrgForm.get();
        Object object = new Date();
        Organization organization2 = org;
        organization2.setCreated((Date)object);
        org.save();
        UserApp.currentUser().createOrganization(org);
        organization2 = org;
        object = null;
        object = organization2.getName();
        return OrganizationApp.redirect((Call)routes.OrganizationApp.organization((String)object));
    }

    private static void validate(Form<Organization> newOrgForm) {
        String name;
        Organization organization2;
        Organization organization3 = organization2 = (Organization)newOrgForm.get();
        String string = null;
        string = organization3.getName();
        Logger.error((String)("org: " + string));
        Set results = Validation.getValidator().validate(newOrgForm.get(), new Class[0]);
        if (!results.isEmpty()) {
            newOrgForm.reject("name", "organization.name.alert");
        }
        if (User.isLoginIdExist(name = newOrgForm.field("name").value())) {
            newOrgForm.reject("name", "organization.name.duplicate");
        }
        if (Organization.isNameExist(name)) {
            newOrgForm.reject("name", "organization.name.duplicate");
        }
    }

    public static Result organization(String organizationName) {
        Organization org = Organization.findByName(organizationName);
        if (org == null) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.organization"));
        }
        return OrganizationApp.ok((Content)view.render(org));
    }

    @Transactional
    public static Result addMember(String organizationName) {
        Form addMemberForm = Form.form(User.class).bindFromRequest(new String[0]);
        Result result2 = OrganizationApp.validateForAddMember((Form<User>)addMemberForm, organizationName);
        if (result2 != null) {
            return result2;
        }
        Model model = (User)addMemberForm.get();
        Object object = null;
        object = model.getLoginId();
        User targetUser = User.findByLoginId((String)object);
        Organization organization2 = Organization.findByName(organizationName);
        model = targetUser;
        object = null;
        Object object2 = object = model.getId();
        model = organization2;
        object = null;
        object = model.getId();
        OrganizationUser.assignRole((Long)object2, (Long)object, RoleType.ORG_MEMBER.roleType());
        organization2.cleanEnrolledUsers();
        NotificationEvent.afterOrganizationMemberRequest(organization2, targetUser, RequestState.ACCEPT);
        return OrganizationApp.redirect((Call)routes.OrganizationApp.members(organizationName));
    }

    private static Result validateForAddMember(Form<User> addMemberForm, String organizationName) {
        Model model = (User)addMemberForm.get();
        String string = null;
        String userLoginId = string = model.getLoginId();
        User userToBeAdded = User.findByLoginId(userLoginId);
        if (addMemberForm.hasErrors() || userToBeAdded.isAnonymous()) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.unknownUser");
            return OrganizationApp.redirect((Call)routes.OrganizationApp.members(organizationName));
        }
        model = userToBeAdded;
        boolean bl = false;
        bl = model.getIsGuest();
        if (bl) {
            OrganizationApp.flash((String)"warning", (String)"error.forbidden.to.guest.user");
            return OrganizationApp.redirect((Call)routes.OrganizationApp.members(organizationName));
        }
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.unknownOrganization");
            return OrganizationApp.redirect((Call)routes.OrganizationApp.members(organizationName));
        }
        User currentUser = UserApp.currentUser();
        if (!AccessControl.isAllowed(currentUser, organization2.asResource(), Operation.UPDATE)) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.needManagerRole");
            return OrganizationApp.redirect((Call)routes.OrganizationApp.members(organizationName));
        }
        model = organization2;
        Long l = null;
        Long l2 = l = model.getId();
        model = userToBeAdded;
        l = null;
        l = model.getId();
        if (OrganizationUser.exist(l2, l)) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.alreadyMember");
            return OrganizationApp.redirect((Call)routes.OrganizationApp.members(organizationName));
        }
        return null;
    }

    @Transactional
    public static Result deleteMember(String organizationName, Long userId) {
        Result result2 = OrganizationApp.validateForDeleteMember(organizationName, userId);
        if (result2 != null) {
            return result2;
        }
        Organization organization2 = Organization.findByName(organizationName);
        Model model = organization2;
        Long l = null;
        l = model.getId();
        OrganizationUser.delete(l, userId);
        model = UserApp.currentUser();
        l = null;
        l = model.getId();
        if (l.equals(userId)) {
            return OrganizationApp.okWithLocation(routes.OrganizationApp.organization(organizationName).url());
        }
        return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
    }

    private static Result validateForDeleteMember(String organizationName, Long userId) {
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("organization.member.unknownOrganization", organization2));
        }
        Model model = organization2;
        Long l = null;
        l = model.getId();
        if (!OrganizationUser.exist(l, userId)) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.isNotAMember");
            return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
        }
        User currentUser = UserApp.currentUser();
        if (!AccessControl.isAllowed(currentUser, organization2.asResource(), Operation.UPDATE)) {
            model = currentUser;
            l = null;
            l = model.getId();
            if (!l.equals(userId)) {
                OrganizationApp.flash((String)"warning", (String)"organization.member.needManagerRole");
                return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
            }
        }
        model = organization2;
        l = null;
        l = model.getId();
        if (OrganizationUser.isAdmin(l, userId) && organization2.getAdmins().size() == 1) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.atLeastOneAdmin");
            return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
        }
        return null;
    }

    @Transactional
    public static Result editMember(String organizationName, Long userId) {
        Form roleForm = Form.form(Role.class).bindFromRequest(new String[0]);
        Result result2 = OrganizationApp.validateForEditMember((Form<Role>)roleForm, organizationName, userId);
        if (result2 != null) {
            return result2;
        }
        Organization organization2 = Organization.findByName(organizationName);
        Model model = organization2;
        Long l = null;
        Long l2 = l = model.getId();
        model = (Role)((Object)roleForm.get());
        l = null;
        l = model.getId();
        OrganizationUser.assignRole(userId, l2, l);
        return OrganizationApp.status((int)204);
    }

    private static Result validateForEditMember(Form<Role> roleForm, String organizationName, Long userId) {
        if (roleForm.hasErrors()) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.unknownRole");
            return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
        }
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("organization.member.unknownOrganization", organization2));
        }
        Model model = organization2;
        Long l = null;
        l = model.getId();
        if (!OrganizationUser.exist(l, userId)) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.isNotAMember");
            return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
        }
        User currentUser = UserApp.currentUser();
        if (!AccessControl.isAllowed(currentUser, organization2.asResource(), Operation.UPDATE)) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.needManagerRole");
            return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
        }
        if (organization2.isLastAdmin((User)User.find.byId((Object)userId))) {
            model = (Role)((Object)roleForm.get());
            l = null;
            l = model.getId();
            if (l.equals(RoleType.ORG_MEMBER.roleType())) {
                OrganizationApp.flash((String)"warning", (String)"organization.member.atLeastOneAdmin");
                return OrganizationApp.okWithLocation(routes.OrganizationApp.members(organizationName).url());
            }
        }
        return null;
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result leave(String organizationName) {
        ValidationResult result2 = OrganizationApp.validateForLeave(organizationName);
        if (!result2.hasError()) {
            Model model = Organization.findByName(organizationName);
            Long l = null;
            Long l2 = l = model.getId();
            model = UserApp.currentUser();
            l = null;
            l = model.getId();
            OrganizationUser.delete(l2, l);
        }
        return result2.getResult();
    }

    public static ValidationResult validateForLeave(String organizationName) {
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return new ValidationResult((Result)OrganizationApp.notFound((JsonNode)OrganizationApp.getJsonErrorMsg("organization.member.unknownOrganization")), true);
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), organization2.asResource(), Operation.LEAVE) && OrganizationUser.findAdminsOf(organization2).size() == 1) {
            return new ValidationResult((Result)OrganizationApp.forbidden((JsonNode)OrganizationApp.getJsonErrorMsg("organization.member.atLeastOneAdmin")), true);
        }
        return new ValidationResult(OrganizationApp.okWithLocation(routes.OrganizationApp.organization(organizationName).url()), false);
    }

    private static JsonNode getJsonErrorMsg(String errMsg) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("errorMsg", errMsg);
        return Json.toJson(response);
    }

    public static Result members(String organizationName) {
        Result result2 = OrganizationApp.validateForSetting(organizationName);
        if (result2 != null) {
            return result2;
        }
        Organization organization2 = Organization.findByName(organizationName);
        return OrganizationApp.ok((Content)members.render(organization2, Role.findOrganizationRoles()));
    }

    private static Result validateForSetting(String organizationName) {
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("organization.member.unknownOrganization", organization2));
        }
        User currentUser = UserApp.currentUser();
        if (!AccessControl.isAllowed(currentUser, organization2.asResource(), Operation.UPDATE)) {
            return OrganizationApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", organization2));
        }
        return null;
    }

    public static Result settingForm(String organizationName) {
        Result result2 = OrganizationApp.validateForSetting(organizationName);
        if (result2 != null) {
            return result2;
        }
        Organization organization2 = Organization.findByName(organizationName);
        return OrganizationApp.ok((Content)setting.render(organization2, (Form<Organization>)Form.form(Organization.class).fill((Object)organization2)));
    }

    private static Result okWithLocation(String location) {
        ObjectNode result2 = Json.newObject();
        result2.put("location", location);
        return OrganizationApp.ok((JsonNode)result2);
    }

    public static Result updateOrganizationInfo(String organizationName) throws IOException, NoSuchAlgorithmException, ServletException {
        Organization modifiedOrganization;
        Form organizationForm = Form.form(Organization.class).bindFromRequest(new String[0]);
        Result result2 = OrganizationApp.validateForUpdate((Form<Organization>)organizationForm, modifiedOrganization = (Organization)organizationForm.get());
        if (result2 != null) {
            return result2;
        }
        Http.MultipartFormData.FilePart filePart = OrganizationApp.request().body().asMultipartFormData().getFile("logoPath");
        if (!LogoUtil.isEmptyFilePart(filePart)) {
            Attachment.deleteAll(modifiedOrganization.asResource());
            new Attachment().store(filePart.getFile(), filePart.getFilename(), modifiedOrganization.asResource());
        }
        Organization organization2 = modifiedOrganization;
        Object object = null;
        object = organization2.getId();
        Organization original = (Organization)Organization.find.byId(object);
        original.updateWith(modifiedOrganization);
        UserApp.currentUser().updateFavoriteOrganization(modifiedOrganization);
        FavoriteOrganization.updateFavoriteOrganization(modifiedOrganization);
        organization2 = modifiedOrganization;
        object = null;
        object = organization2.getName();
        return OrganizationApp.redirect((Call)routes.OrganizationApp.settingForm((String)object));
    }

    private static Result validateForUpdate(Form<Organization> organizationForm, Organization modifiedOrganization) {
        Organization organization2 = modifiedOrganization;
        Long l = null;
        l = organization2.getId();
        Organization organization3 = (Organization)Organization.find.byId((Object)l);
        if (organization3 == null) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("organization.member.unknownOrganization"));
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), organization3.asResource(), Operation.UPDATE)) {
            OrganizationApp.flash((String)"warning", (String)"organization.member.needManagerRole");
            return OrganizationApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", organization3));
        }
        if (OrganizationApp.isDuplicateName(organization3, modifiedOrganization)) {
            organizationForm.reject("name", "organization.name.duplicate");
            return OrganizationApp.badRequest((Content)setting.render(organization3, organizationForm));
        }
        Http.MultipartFormData.FilePart filePart = OrganizationApp.request().body().asMultipartFormData().getFile("logoPath");
        if (!LogoUtil.isEmptyFilePart(filePart)) {
            if (!LogoUtil.isImageFile(filePart.getFilename())) {
                OrganizationApp.flash((String)"warning", (String)"project.logo.alert");
                organizationForm.reject("logoPath");
            }
            if (filePart.getFile().length() > 5120000L) {
                OrganizationApp.flash((String)"warning", (String)"project.logo.fileSizeAlert");
                organizationForm.reject("logoPath");
            }
        }
        if (organizationForm.hasErrors()) {
            return OrganizationApp.badRequest((Content)setting.render(organization3, organizationForm));
        }
        return null;
    }

    private static boolean isDuplicateName(Organization organization2, Organization modifiedOrganization) {
        Organization organization3 = organization2;
        String string = null;
        String string2 = string = organization3.getName();
        organization3 = modifiedOrganization;
        string = null;
        string = organization3.getName();
        if (OrganizationApp.isNotChangedName(string2, string)) {
            return false;
        }
        organization3 = modifiedOrganization;
        string = null;
        string = organization3.getName();
        if (User.isLoginIdExist(string)) {
            return true;
        }
        organization3 = modifiedOrganization;
        string = null;
        string = organization3.getName();
        return Organization.isNameExist(string);
    }

    private static boolean isNotChangedName(String name, String modifiedName) {
        return name.equals(modifiedName);
    }

    public static Result deleteForm(String organizationName) {
        Result result2 = OrganizationApp.validateForSetting(organizationName);
        if (result2 != null) {
            return result2;
        }
        Organization organization2 = Organization.findByName(organizationName);
        return OrganizationApp.ok((Content)deleteForm.render(organization2));
    }

    @Transactional
    public static Result deleteOrganization(String organizationName) {
        Organization organization2 = Organization.findByName(organizationName);
        ValidationResult result2 = OrganizationApp.validateForDelete(organization2);
        if (result2.hasError()) {
            return result2.getResult();
        }
        organization2.delete();
        return OrganizationApp.redirect((Call)routes.Application.index());
    }

    private static ValidationResult validateForDelete(Organization organization2) {
        if (organization2 == null) {
            return new ValidationResult((Result)OrganizationApp.notFound((JsonNode)OrganizationApp.getJsonErrorMsg("organization.member.unknownOrganization")), true);
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), organization2.asResource(), Operation.DELETE)) {
            return new ValidationResult((Result)OrganizationApp.notFound((JsonNode)OrganizationApp.getJsonErrorMsg("organization.member.needManagerRole")), true);
        }
        Organization organization3 = organization2;
        List<Project> list2 = null;
        list2 = organization3.getProjects();
        if (list2 != null) {
            organization3 = organization2;
            list2 = null;
            list2 = organization3.getProjects();
            if (list2.size() > 0) {
                return new ValidationResult((Result)OrganizationApp.notFound((JsonNode)OrganizationApp.getJsonErrorMsg("organization.delete.impossible.project.exist")), true);
            }
        }
        organization3 = organization2;
        list2 = null;
        list2 = organization3.getName();
        return new ValidationResult(OrganizationApp.okWithLocation(routes.OrganizationApp.organization((String)((Object)list2)).url()), false);
    }

    @GuestProhibit
    public static Result orgList(String query, int pageNum) {
        if (Application.HIDE_PROJECT_LISTING) {
            return OrganizationApp.forbidden((Content)ErrorViews.Forbidden.render("error.auth.unauthorized.waringMessage"));
        }
        if (pageNum < 1) {
            return OrganizationApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        Page orgs = Organization.findByNameLike(query).getPage(pageNum - 1);
        return OrganizationApp.ok((Content)list.render("title.projectList", (Page<Organization>)orgs, query));
    }
}

