/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import models.CodeCommentThread;
import models.CommentThread;
import models.Issue;
import models.IssueLabel;
import models.NonRangedCodeCommentThread;
import models.Project;
import models.ReviewComment;
import models.UserIdent;
import models.enumeration.Operation;
import models.support.ReviewSearchCondition;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Transactional;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.HttpUtil;
import utils.JodaDateUtil;
import views.html.reviewthread.list;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ReviewThreadApp
extends Controller {
    public static final int REVIEWS_PER_PAGE = 15;

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.READ)
    @Transactional
    public static Result reviewThreads(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        ReviewSearchCondition searchCondition = (ReviewSearchCondition)Form.form(ReviewSearchCondition.class).bindFromRequest(new String[0]).get();
        ExpressionList<CommentThread> el = searchCondition.asExpressionList(project2);
        if ("xls".equals(ReviewThreadApp.request().getQueryString("format"))) {
            return ReviewThreadApp.reviewThreadsDownload(project2, el);
        }
        ReviewSearchCondition reviewSearchCondition = searchCondition;
        int n = 0;
        n = reviewSearchCondition.getPageNum();
        Page commentThreads = el.findPagingList(15).getPage(n - 1);
        return ReviewThreadApp.ok((Content)list.render(project2, (Page<CommentThread>)commentThreads, searchCondition));
    }

    private static Result reviewThreadsDownload(Project project2, ExpressionList<CommentThread> el) {
        List commentThreads = el.findList();
        String filename = null;
        byte[] excelData = null;
        try {
            excelData = ReviewThreadApp.excelFrom(commentThreads);
            Project project3 = project2;
            String string = null;
            string = project3.getName();
            filename = HttpUtil.encodeContentDisposition(string + "_reviews_" + JodaDateUtil.getDateStringWithoutSpace(new Date()) + ".xls");
        }
        catch (IOException | WriteException e) {
            e.printStackTrace();
        }
        ReviewThreadApp.response().setHeader("Content-Type", new Tika().detect(filename));
        ReviewThreadApp.response().setHeader("Content-Disposition", "attachment; " + filename);
        assert (excelData != null);
        return ReviewThreadApp.ok((byte[])excelData);
    }

    public static byte[] excelFrom(List<CommentThread> commentThreads) throws WriteException, IOException {
        WritableCellFormat headerCellFormat = ReviewThreadApp.getHeaderCellFormat();
        WritableCellFormat bodyCellFormat = ReviewThreadApp.getBodyCellFormat();
        WritableCellFormat dateCellFormat = ReviewThreadApp.getDateCellFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)bos);
        WritableSheet sheet = workbook.createSheet(String.valueOf(JodaDateUtil.today().getTime()), 0);
        String[] titles = new String[]{"No", "COMMIT ID", "REVIEW ID", "REVIEW TITLE", "Thread Author", "Response Text", "Response", "REVIEW STATE", "is PullRequest?", "Date"};
        for (int i = 0; i < titles.length; ++i) {
            sheet.addCell((WritableCell)new Label(i, 0, titles[i], (CellFormat)headerCellFormat));
            sheet.setColumnView(i, 20);
        }
        int rowNumber = 0;
        block3: for (int idx = 0; idx < commentThreads.size(); ++idx) {
            Object object;
            Object object2;
            CommentThread commentThread = commentThreads.get(idx);
            String commitId = "";
            if (commentThread instanceof NonRangedCodeCommentThread) {
                object2 = (NonRangedCodeCommentThread)commentThread;
                object = null;
                object = ((NonRangedCodeCommentThread)object2).getCommitId();
                commitId = object;
            } else {
                object2 = (CodeCommentThread)commentThread;
                object = null;
                object = ((CodeCommentThread)object2).getCommitId();
                commitId = object;
            }
            String threadFirstComment = commentThread.getFirstReviewComment().getContents();
            int j = 0;
            while (true) {
                Object object3;
                Object object4;
                object2 = commentThread;
                object = null;
                object = ((CommentThread)object2).getReviewComments();
                if (j >= object.size()) continue block3;
                object2 = commentThread;
                object = null;
                object = ((CommentThread)object2).getReviewComments();
                ReviewComment comment = object.get(j);
                int columnPos = 0;
                String reponseComment = threadFirstComment.equals(comment.getContents()) ? "" : comment.getContents();
                sheet.addCell((WritableCell)new Label(columnPos++, rowNumber + 1, "" + (rowNumber + 1), (CellFormat)bodyCellFormat));
                sheet.addCell((WritableCell)new Label(columnPos++, rowNumber + 1, commitId.substring(0, 7), (CellFormat)bodyCellFormat));
                int n = columnPos++;
                object2 = commentThread;
                object = null;
                object = ((CommentThread)object2).getId();
                sheet.addCell((WritableCell)new Label(n, rowNumber + 1, ((Long)object).toString(), (CellFormat)bodyCellFormat));
                sheet.addCell((WritableCell)new Label(columnPos++, rowNumber + 1, StringUtils.isEmpty((CharSequence)reponseComment) ? threadFirstComment : "", (CellFormat)bodyCellFormat));
                int n2 = columnPos++;
                if (StringUtils.isEmpty((CharSequence)reponseComment)) {
                    object2 = commentThread;
                    object = null;
                    object2 = object = ((CommentThread)object2).getAuthor();
                    object = null;
                    object4 = object = ((UserIdent)object2).getName();
                } else {
                    object4 = "";
                }
                sheet.addCell((WritableCell)new Label(n2, rowNumber + 1, (String)object4, (CellFormat)bodyCellFormat));
                sheet.addCell((WritableCell)new Label(columnPos++, rowNumber + 1, reponseComment, (CellFormat)bodyCellFormat));
                int n3 = columnPos++;
                if (StringUtils.isNotEmpty((CharSequence)reponseComment)) {
                    object2 = comment;
                    object = null;
                    object2 = object = ((ReviewComment)object2).getAuthor();
                    object = null;
                    object3 = object = ((UserIdent)object2).getName();
                } else {
                    object3 = "";
                }
                sheet.addCell((WritableCell)new Label(n3, rowNumber + 1, (String)object3, (CellFormat)bodyCellFormat));
                int n4 = columnPos++;
                object2 = commentThread;
                object = null;
                object = ((CommentThread)object2).getState();
                sheet.addCell((WritableCell)new Label(n4, rowNumber + 1, ((Enum)object).toString(), (CellFormat)bodyCellFormat));
                sheet.addCell((WritableCell)new Label(columnPos++, rowNumber + 1, "" + commentThread.isOnPullRequest(), (CellFormat)bodyCellFormat));
                int n5 = columnPos++;
                object2 = comment;
                object = null;
                object = ((ReviewComment)object2).getCreatedDate();
                sheet.addCell((WritableCell)new DateTime(n5, rowNumber + 1, (Date)object, (CellFormat)dateCellFormat));
                ++rowNumber;
                ++j;
            }
        }
        workbook.write();
        try {
            workbook.close();
        }
        catch (IOException | WriteException e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    private static String getIssueLabels(Issue issue2) {
        StringBuilder labels2 = new StringBuilder();
        Iterator<IssueLabel> iterator = issue2.getLabels().iterator();
        while (iterator.hasNext()) {
            IssueLabel issueLabel;
            IssueLabel issueLabel2 = issueLabel = iterator.next();
            String string = null;
            string = issueLabel2.getName();
            labels2.append(string).append(", ");
        }
        return labels2.toString().replaceAll(", $", "");
    }

    private static WritableCellFormat getDateCellFormat() throws WriteException {
        WritableFont baseFont = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
        DateFormat valueFormatDate = new DateFormat("yyyy-MM-dd HH:mm");
        WritableCellFormat cellFormat = new WritableCellFormat((DisplayFormat)valueFormatDate);
        cellFormat.setFont((FontRecord)baseFont);
        cellFormat.setShrinkToFit(true);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setAlignment(Alignment.CENTRE);
        cellFormat.setVerticalAlignment(VerticalAlignment.TOP);
        return cellFormat;
    }

    private static WritableCellFormat getBodyCellFormat() throws WriteException {
        WritableFont baseFont = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
        return ReviewThreadApp.getBodyCellFormat(baseFont);
    }

    private static WritableCellFormat getBodyCellFormat(WritableFont baseFont) throws WriteException {
        WritableCellFormat cellFormat = new WritableCellFormat(baseFont);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setWrap(true);
        cellFormat.setVerticalAlignment(VerticalAlignment.TOP);
        return cellFormat;
    }

    private static WritableCellFormat getHeaderCellFormat() throws WriteException {
        WritableFont headerFont = new WritableFont(WritableFont.ARIAL, 14, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.NORMAL_SCRIPT);
        WritableCellFormat headerCell = new WritableCellFormat(headerFont);
        headerCell.setBorder(Border.ALL, BorderLineStyle.DOUBLE);
        headerCell.setAlignment(Alignment.CENTRE);
        return headerCell;
    }
}

