/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.routes;
import data.DataService;
import info.schleichardt.play2.mailplugin.Mailer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import models.Attachment;
import models.Issue;
import models.Posting;
import models.Project;
import models.ProjectUser;
import models.SiteAdmin;
import models.User;
import models.YobiUpdate;
import models.enumeration.State;
import models.enumeration.UserState;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.format.datetime.DateFormatter;
import play.Configuration;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.With;
import play.twirl.api.Content;
import utils.CacheStore;
import utils.Config;
import utils.Diagnostic;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.SiteManagerAuthAction;
import views.html.site.data;
import views.html.site.diagnostic;
import views.html.site.issueList;
import views.html.site.mail;
import views.html.site.massMail;
import views.html.site.postList;
import views.html.site.projectList;
import views.html.site.update;
import views.html.site.userList;

@With(value={SiteManagerAuthAction.class})
@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SiteApp
extends Controller {
    private static final int PROJECT_COUNT_PER_PAGE = 25;
    private static final int POSTING_COUNT_PER_PAGE = 30;
    private static final int ISSUE_COUNT_PER_PAGE = 30;

    public static Result sendMail() throws EmailException {
        SimpleEmail email = new SimpleEmail();
        Map formData = SiteApp.request().body().asFormUrlEncoded();
        email.setFrom(HttpUtil.getFirstValueFromQuery(formData, "from"));
        email.setSubject(HttpUtil.getFirstValueFromQuery(formData, "subject"));
        email.addTo(HttpUtil.getFirstValueFromQuery(formData, "to"));
        email.setMsg(HttpUtil.getFirstValueFromQuery(formData, "body"));
        email.setCharset("utf-8");
        String errorMessage = null;
        String result2 = Mailer.send((Email)email);
        Logger.info((String)(">>>" + result2));
        boolean sended = true;
        return SiteApp.writeMail(errorMessage, sended);
    }

    public static Result writeMail(String errorMessage, boolean sended) {
        String[] requiredItems;
        Configuration config = Play.application().configuration();
        ArrayList<String> notConfiguredItems = new ArrayList<String>();
        for (String key : requiredItems = new String[]{"smtp.host", "smtp.user", "smtp.password"}) {
            if (config.getString(key) != null) continue;
            notConfiguredItems.add(key);
        }
        String sender = Config.getEmailFromSmtp();
        return SiteApp.ok((Content)mail.render("title.sendMail", notConfiguredItems, sender, errorMessage, sended));
    }

    public static Result massMail() {
        return SiteApp.ok((Content)massMail.render("title.massMail"));
    }

    public static Result userList(int pageNum, String query) {
        String state = (String)StringUtils.defaultIfBlank((CharSequence)SiteApp.request().getQueryString("state"), (CharSequence)UserState.ACTIVE.name());
        UserState userState = UserState.valueOf(state);
        Page<User> users2 = User.findUsers(pageNum - 1, query, userState);
        return SiteApp.ok((Content)userList.render("title.siteSetting", users2, userState, query));
    }

    public static Result postList(int pageNum) {
        Page page = Posting.finder.order("createdDate DESC").findPagingList(30).getPage(pageNum - 1);
        return SiteApp.ok((Content)postList.render("title.siteSetting", (Page<Posting>)page));
    }

    public static Result issueList(int pageNum) {
        String state = (String)StringUtils.defaultIfBlank((CharSequence)SiteApp.request().getQueryString("state"), (CharSequence)State.OPEN.name());
        State currentState = State.valueOf(state.toUpperCase());
        Page<Issue> page = Issue.findIssuesByState(30, pageNum - 1, currentState);
        return SiteApp.ok((Content)issueList.render("title.siteSetting", page, currentState));
    }

    @Transactional
    public static Result deleteUser(Long userId) {
        if (User.findByLoginId((String)SiteApp.session().get((Object)"loginId")).isSiteManager()) {
            User user;
            if (Project.isOnlyManager(userId)) {
                SiteApp.flash((String)"warning", (String)"site.userList.deleteAlert");
                return SiteApp.forbidden();
            }
            User user2 = user = (User)User.find.byId((Object)userId);
            List<ProjectUser> list2 = null;
            list2 = user2.getProjectUser();
            for (ProjectUser projectUser : list2) {
                projectUser.delete();
            }
            user.changeState(UserState.DELETED);
            return SiteApp.redirect((Call)routes.SiteApp.userList(1, null));
        }
        SiteApp.flash((String)"warning", (String)"error.auth.unauthorized.waringMessage");
        return SiteApp.forbidden();
    }

    @Transactional
    public static Result toggleSiteAdminRole(String loginId) {
        Object object;
        Model model;
        if (!User.findByLoginId((String)SiteApp.session().get((Object)"loginId")).isSiteManager()) {
            SiteApp.flash((String)"warning", (String)"error.auth.unauthorized.waringMessage");
            return SiteApp.forbidden();
        }
        User user = User.findByLoginId(loginId);
        if (SiteAdmin.exists(user)) {
            model = user;
            object = null;
            object = model.getLoginId();
            SiteAdmin siteAdmin = SiteAdmin.findByUserLoginId((String)object);
            siteAdmin.delete();
        } else {
            SiteAdmin siteAdmin = new SiteAdmin();
            object = user;
            model = siteAdmin;
            model.setAdmin((User)object);
            siteAdmin.save();
        }
        model = user;
        object = null;
        object = model.getId();
        CacheStore.yonaUsers.invalidate(object);
        return SiteApp.redirect((Call)routes.SiteApp.userList(1, null));
    }

    public static Result projectList(String projectName, int pageNum) {
        Page<Project> projects2 = Project.findByName(projectName, 25, pageNum);
        return SiteApp.ok((Content)projectList.render("title.projectList", projects2, projectName));
    }

    @Transactional
    public static Result deleteProject(Long projectId) {
        if (User.findByLoginId((String)SiteApp.session().get((Object)"loginId")).isSiteManager()) {
            ((Project)Project.find.byId((Object)projectId)).delete();
        } else {
            SiteApp.flash((String)"warning", (String)"error.auth.unauthorized.waringMessage");
        }
        return SiteApp.redirect((Call)routes.SiteApp.projectList("", 0));
    }

    public static Result toggleAccountLock(String loginId, String state, String query) {
        String stateParam = (String)StringUtils.defaultIfBlank((CharSequence)state, (CharSequence)UserState.ACTIVE.name());
        UserState userState = UserState.valueOf(stateParam);
        if (User.findByLoginId((String)SiteApp.session().get((Object)"loginId")).isSiteManager()) {
            User targetUser = User.findByLoginId(loginId);
            if (targetUser.isAnonymous()) {
                SiteApp.flash((String)"warning", (String)"user.notExists.name");
                return SiteApp.redirect((Call)routes.SiteApp.userList(0, null));
            }
            User user = targetUser;
            UserState userState2 = null;
            userState2 = user.getState();
            if (userState2 == UserState.ACTIVE) {
                targetUser.changeState(UserState.LOCKED);
            } else {
                targetUser.changeState(UserState.ACTIVE);
            }
            return SiteApp.ok((Content)userList.render("title.siteSetting", User.findUsers(0, query, userState), userState, query));
        }
        SiteApp.flash((String)"warning", (String)"error.auth.unauthorized.waringMessage");
        return SiteApp.redirect((Call)routes.Application.index());
    }

    public static Result toggleGuestMode(String loginId, String state, String query) {
        String stateParam = (String)StringUtils.defaultIfBlank((CharSequence)state, (CharSequence)UserState.ACTIVE.name());
        UserState userState = UserState.valueOf(stateParam);
        if (User.findByLoginId((String)SiteApp.session().get((Object)"loginId")).isSiteManager()) {
            User targetUser = User.findByLoginId(loginId);
            if (targetUser.isAnonymous()) {
                SiteApp.flash((String)"warning", (String)"user.notExists.name");
                return SiteApp.redirect((Call)routes.SiteApp.userList(0, null));
            }
            User user = targetUser;
            boolean bl = false;
            bl = user.getIsGuest();
            bl = !bl;
            user = targetUser;
            user.setIsGuest(bl);
            targetUser.update();
            user = targetUser;
            Long l = null;
            l = user.getId();
            CacheStore.yonaUsers.put((Object)l, (Object)targetUser);
            return SiteApp.ok((Content)userList.render("title.siteSetting", User.findUsers(0, query, userState), userState, query));
        }
        SiteApp.flash((String)"warning", (String)"error.auth.unauthorized.waringMessage");
        return SiteApp.redirect((Call)routes.Application.index());
    }

    public static Result mailList() {
        HashSet<Object> emails;
        block7: {
            Map projects2;
            block6: {
                emails = new HashSet<Object>();
                projects2 = SiteApp.request().body().asFormUrlEncoded();
                if (!UserApp.currentUser().isSiteManager()) {
                    return SiteApp.forbidden((Content)ErrorViews.Forbidden.render("error.auth.unauthorized.waringMessage"));
                }
                if (!SiteApp.request().accepts("application/json")) {
                    return SiteApp.status((int)406);
                }
                if (projects2 == null) {
                    return SiteApp.ok((JsonNode)Json.toJson(new HashSet()));
                }
                if (!projects2.containsKey("all")) break block6;
                if (!((String[])projects2.get("all"))[0].equals("true")) break block7;
                Iterator iterator = User.find.findList().iterator();
                while (iterator.hasNext()) {
                    User user;
                    User user2 = user = (User)iterator.next();
                    String string = null;
                    string = user2.getEmail();
                    emails.add(string);
                }
                break block7;
            }
            for (String[] projectNames : projects2.values()) {
                String projectName = projectNames[0];
                String[] parts = projectName.split("/");
                String owner = parts[0];
                String name = parts[1];
                Project project2 = Project.findByOwnerAndProjectName(owner, name);
                Object object = project2;
                Object object2 = null;
                object2 = ((Project)object).getId();
                for (ProjectUser projectUser : ProjectUser.findMemberListByProject((Long)object2)) {
                    object = projectUser;
                    object2 = null;
                    object = object2 = ((ProjectUser)((Object)object)).getUser();
                    object2 = null;
                    object2 = ((User)object).getEmail();
                    Logger.debug((String)object2);
                    object = projectUser;
                    object2 = null;
                    object = object2 = ((ProjectUser)((Object)object)).getUser();
                    object2 = null;
                    object2 = ((User)object).getEmail();
                    emails.add(object2);
                }
            }
        }
        return SiteApp.ok((JsonNode)Json.toJson(emails));
    }

    public static Result unwatchUpdate() {
        YobiUpdate.isWatched = false;
        return SiteApp.ok();
    }

    public static Result update() throws GitAPIException {
        String currentVersion = null;
        Exception exception = null;
        try {
            boolean useUpdateCheck = Configuration.root().getBoolean("application.update.check.use");
            if (useUpdateCheck) {
                currentVersion = Config.getCurrentVersion();
                YobiUpdate.refreshVersionToUpdate();
            }
        }
        catch (Exception e) {
            exception = e;
        }
        return SiteApp.ok((Content)update.render("title.siteSetting", currentVersion, YobiUpdate.versionToUpdate, exception));
    }

    public static Result diagnose() {
        return SiteApp.ok((Content)diagnostic.render("title.siteSetting", Diagnostic.checkAll()));
    }

    public static Result data() {
        return SiteApp.ok((Content)data.render("title.siteSetting"));
    }

    public static Result exportData() throws JsonProcessingException {
        Date date = new Date();
        DateFormatter formatter = new DateFormatter("yyyyMMddHHmm");
        String formattedDate = formatter.print(date, Locale.getDefault());
        InputStream in = new DataService().exportData();
        SiteApp.response().setContentType("application/x-download");
        SiteApp.response().setHeader("Content-disposition", "attachment; filename=yobi-data-" + formattedDate + ".json");
        return SiteApp.ok((InputStream)in);
    }

    public static Result importData() throws IOException {
        Http.MultipartFormData body = SiteApp.request().body().asMultipartFormData();
        Http.MultipartFormData.FilePart yobiData = body.getFile("data");
        if (yobiData != null) {
            File file = yobiData.getFile();
            try {
                new DataService().importData(file);
                return SiteApp.redirect((Call)routes.Application.index());
            }
            catch (Exception e) {
                return SiteApp.badRequest((Content)ErrorViews.BadRequest.render());
            }
        }
        return SiteApp.redirect((Call)routes.SiteApp.data());
    }

    public static Result noAvatarUsers() {
        List users2 = User.find.where().eq("state", (Object)UserState.ACTIVE).findList();
        ArrayList<ObjectNode> usersNode = new ArrayList<ObjectNode>();
        ObjectNode result2 = Json.newObject();
        for (User user : users2) {
            if (user.avatarId() != null) continue;
            usersNode.add(SiteApp.composeUserNode(user));
        }
        result2.put("users", Json.toJson(usersNode));
        return SiteApp.ok((JsonNode)result2);
    }

    private static ObjectNode composeUserNode(User user) {
        ObjectNode userNode = Json.newObject();
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        userNode.put("loginId", string);
        user2 = user;
        string = null;
        string = user2.getName();
        userNode.put("name", string);
        user2 = user;
        string = null;
        string = user2.getEmail();
        userNode.put("email", string);
        return userNode;
    }

    public static Result setAttachmentToUserAvatar() {
        Attachment attachment;
        ObjectNode result2 = Json.newObject();
        JsonNode json = SiteApp.request().body().asJson();
        if (json == null) {
            return SiteApp.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        long avatarFileId = json.findValue("avatarFileId").asLong();
        Attachment attachment2 = attachment = (Attachment)Attachment.find.byId((Object)avatarFileId);
        String string = null;
        string = attachment2.getMimeType();
        String primary = string.split("/")[0].toLowerCase();
        String targetUserEmail = json.findValue("email").asText();
        User targetUser = User.findByEmail(targetUserEmail);
        if (primary.equals("image") && !targetUser.isAnonymous()) {
            Attachment.deleteAll(targetUser.avatarAsResource());
            attachment.moveTo(targetUser.avatarAsResource());
        }
        result2.put("status", 200);
        result2.put("message", "OK");
        return SiteApp.ok((JsonNode)result2);
    }
}

