/*
 * Decompiled with CFR 0.152.
 */
package mailbox;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import com.sun.mail.imap.IMAPMessage;
import controllers.routes;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import mailbox.Content;
import mailbox.IMAPMessageUtil;
import mailbox.exceptions.IssueNotFound;
import mailbox.exceptions.MailHandlerException;
import mailbox.exceptions.PermissionDenied;
import mailbox.exceptions.PostingNotFound;
import models.AbstractPosting;
import models.Attachment;
import models.CodeCommentThread;
import models.Comment;
import models.CommentThread;
import models.Issue;
import models.IssueComment;
import models.NonRangedCodeCommentThread;
import models.NotificationEvent;
import models.OriginalEmail;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.PullRequest;
import models.ReviewComment;
import models.User;
import models.UserIdent;
import models.enumeration.ResourceType;
import models.resource.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import play.Logger;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import utils.AccessControl;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CreationViaEmail {
    @Transactional
    public static Comment saveComment(IMAPMessage message, Resource target) throws MessagingException, MailHandlerException, IOException, NoSuchAlgorithmException {
        User author = IMAPMessageUtil.extractSender((Message)message);
        if (!AccessControl.isProjectResourceCreatable(author, target.getProject(), target.getType())) {
            throw new PermissionDenied(CreationViaEmail.cannotCreateMessage(author, target.getProject(), target.getType()));
        }
        Content parsedMessage = CreationViaEmail.extractContent((MimePart)message);
        Object object = parsedMessage;
        String string = null;
        string = ((Content)object).getBody();
        Comment comment = CreationViaEmail.makeNewComment(target, author, string);
        comment.save();
        Map<String, Attachment> relatedAttachments = CreationViaEmail.saveAttachments(parsedMessage.attachments, comment.asResource());
        object = parsedMessage;
        string = null;
        string = ((Content)object).getType();
        if (new ContentType(string).match("text/html")) {
            object = comment;
            string = null;
            string = ((Comment)object).getContents();
            string = CreationViaEmail.postprocessForHTML(string, relatedAttachments);
            object = comment;
            ((Comment)object).setContents(string);
            comment.update();
        }
        new OriginalEmail(message.getMessageID(), comment.asResource()).save();
        CreationViaEmail.addEvent(NotificationEvent.forNewComment(comment, author), message.getAllRecipients(), author);
        return comment;
    }

    private static String postprocessForHTML(String contents, Map<String, Attachment> relatedAttachments) {
        return new HtmlCompressor().compress(CreationViaEmail.replaceCidWithAttachments(contents, relatedAttachments));
    }

    private static Comment makeNewComment(Resource target, User sender, String body) throws IssueNotFound, PostingNotFound {
        Comment comment;
        Long id = Long.valueOf(target.getId());
        switch (target.getType()) {
            case ISSUE_POST: {
                Issue issue2 = (Issue)Issue.finder.byId((Object)id);
                if (issue2 == null) {
                    throw new IssueNotFound(id);
                }
                comment = new IssueComment(issue2, sender, body);
                break;
            }
            case BOARD_POST: {
                Posting posting = (Posting)Posting.finder.byId((Object)id);
                if (posting == null) {
                    throw new PostingNotFound(id);
                }
                comment = new PostingComment(posting, sender, body);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported resource type: " + (Object)((Object)target.getType()));
            }
        }
        return comment;
    }

    static Issue saveIssue(IMAPMessage message, Project project2) throws MessagingException, PermissionDenied, IOException, NoSuchAlgorithmException {
        User sender = IMAPMessageUtil.extractSender((Message)message);
        if (!AccessControl.isProjectResourceCreatable(sender, project2, ResourceType.ISSUE_POST)) {
            throw new PermissionDenied(CreationViaEmail.cannotCreateMessage(sender, project2, ResourceType.ISSUE_POST));
        }
        Content parsedMessage = CreationViaEmail.extractContent((MimePart)message);
        String messageId = message.getMessageID();
        Address[] recipients = message.getAllRecipients();
        String subject = message.getSubject();
        return CreationViaEmail.saveIssue(subject, project2, sender, parsedMessage, messageId, recipients);
    }

    @Transactional
    public static Issue saveIssue(String subject, Project project2, User sender, Content parsedMessage, String messageId, Address[] recipients) throws MessagingException, IOException, NoSuchAlgorithmException {
        Object object = parsedMessage;
        String string = null;
        string = ((Content)object).getBody();
        Issue issue2 = new Issue(project2, sender, subject, string);
        issue2.save();
        Map<String, Attachment> relatedAttachments = CreationViaEmail.saveAttachments(parsedMessage.attachments, issue2.asResource());
        object = parsedMessage;
        string = null;
        string = ((Content)object).getType();
        if (new ContentType(string).match("text/html")) {
            issue2.refresh();
            object = issue2;
            string = null;
            string = ((AbstractPosting)object).getBody();
            string = CreationViaEmail.postprocessForHTML(string, relatedAttachments);
            object = issue2;
            ((AbstractPosting)object).setBody(string);
            issue2.update();
        }
        new OriginalEmail(messageId, issue2.asResource()).save();
        NotificationEvent event = NotificationEvent.forNewIssue(issue2, sender);
        CreationViaEmail.addEvent(event, recipients, sender);
        return issue2;
    }

    static void saveReviewComment(IMAPMessage message, Resource target) throws IOException, MessagingException, PermissionDenied, NoSuchAlgorithmException {
        User sender = IMAPMessageUtil.extractSender((Message)message);
        if (!AccessControl.isProjectResourceCreatable(sender, target.getProject(), ResourceType.REVIEW_COMMENT)) {
            throw new PermissionDenied(CreationViaEmail.cannotCreateMessage(sender, target.getProject(), target.getType()));
        }
        Content content = CreationViaEmail.extractContent((MimePart)message);
        String messageID = message.getMessageID();
        Address[] allRecipients = message.getAllRecipients();
        CreationViaEmail.saveReviewComment(target, sender, content, messageID, allRecipients);
    }

    @Transactional
    protected static ReviewComment saveReviewComment(Resource target, User sender, Content content, String messageID, Address[] allRecipients) throws MessagingException, IOException, NoSuchAlgorithmException {
        CommentThread thread = (CommentThread)CommentThread.find.byId((Object)Long.valueOf(target.getId()));
        if (thread == null) {
            throw new IllegalArgumentException();
        }
        ReviewComment comment = new ReviewComment();
        Object object = content;
        Object object2 = null;
        object2 = ((Content)object).getBody();
        comment.setContents((String)object2);
        object2 = new UserIdent(sender);
        object = comment;
        ((ReviewComment)object).setAuthor((UserIdent)object2);
        object2 = thread;
        object = comment;
        ((ReviewComment)object).setThread((CommentThread)object2);
        comment.save();
        Map<String, Attachment> relatedAttachments = CreationViaEmail.saveAttachments(content.attachments, comment.asResource());
        object = content;
        object2 = null;
        object2 = ((Content)object).getType();
        if (new ContentType((String)object2).match("text/html")) {
            comment.setContents(CreationViaEmail.replaceCidWithAttachments(comment.getContents(), relatedAttachments));
            comment.update();
        }
        new OriginalEmail(messageID, comment.asResource()).save();
        if (thread.isOnPullRequest()) {
            object = thread;
            object2 = null;
            object2 = ((CommentThread)object).getPullRequest();
            CreationViaEmail.addEvent(NotificationEvent.forNewComment(sender, (PullRequest)object2, comment), allRecipients, sender);
        } else {
            try {
                Object commitId;
                if (thread instanceof CodeCommentThread) {
                    object = (CodeCommentThread)thread;
                    object2 = null;
                    commitId = object2 = ((CodeCommentThread)object).getCommitId();
                } else if (thread instanceof NonRangedCodeCommentThread) {
                    object = (NonRangedCodeCommentThread)thread;
                    object2 = null;
                    commitId = object2 = ((NonRangedCodeCommentThread)object).getCommitId();
                } else {
                    throw new IllegalArgumentException();
                }
                CreationViaEmail.addEvent(NotificationEvent.forNewCommitComment(target.getProject(), comment, (String)commitId, sender), allRecipients, sender);
            }
            catch (Exception e) {
                Logger.warn((String)"Failed to send a notification", (Throwable)e);
            }
        }
        return comment;
    }

    private CreationViaEmail() {
    }

    @Nonnull
    private static Content extractContent(MimePart part) throws IOException, MessagingException {
        return CreationViaEmail.processPart(part, null);
    }

    @Nonnull
    private static Content processPart(MimePart part, MimePart parent) throws MessagingException, IOException {
        if (part == null) {
            return new Content();
        }
        if (part.getFileName() != null) {
            return new Content(part);
        }
        if (part.isMimeType("text/*")) {
            return CreationViaEmail.getContent(part);
        }
        if (part.isMimeType("multipart/*")) {
            if (part.isMimeType("multipart/related")) {
                return CreationViaEmail.getContentWithAttachments(part);
            }
            if (part.isMimeType("multipart/alternative")) {
                return CreationViaEmail.getContentOfBestPart(part, parent);
            }
            return CreationViaEmail.getJoinedContent(part);
        }
        return new Content();
    }

    private static Content getJoinedContent(MimePart part) throws IOException, MessagingException {
        Content result2 = new Content();
        MimeMultipart mp = (MimeMultipart)part.getContent();
        for (int i = 0; i < mp.getCount(); ++i) {
            MimeBodyPart p = (MimeBodyPart)mp.getBodyPart(i);
            result2.merge(CreationViaEmail.processPart((MimePart)p, part));
        }
        return result2;
    }

    private static Content getContent(MimePart part) throws IOException, MessagingException {
        Content result2 = new Content();
        String string = (String)part.getContent();
        Content content = result2;
        content.setBody(string);
        string = part.getContentType();
        content = result2;
        content.setType(string);
        return result2;
    }

    private static Content getContentOfBestPart(MimePart part, MimePart parent) throws IOException, MessagingException {
        MimeBodyPart best = null;
        MimeMultipart mp = (MimeMultipart)part.getContent();
        for (int i = 0; i < mp.getCount(); ++i) {
            boolean isHtmlPreferred = parent != null && parent.isMimeType("multipart/related");
            best = CreationViaEmail.better((MimeBodyPart)mp.getBodyPart(i), best, isHtmlPreferred);
        }
        return CreationViaEmail.processPart(best, part);
    }

    private static Content getContentWithAttachments(MimePart part) throws MessagingException, IOException {
        Content result2 = new Content();
        String rootId = new ContentType(part.getContentType()).getParameter("start");
        MimeMultipart mp = (MimeMultipart)part.getContent();
        for (int i = 0; i < mp.getCount(); ++i) {
            MimePart p = (MimePart)mp.getBodyPart(i);
            if (CreationViaEmail.isRootPart(p, i, rootId)) {
                result2 = result2.merge(CreationViaEmail.processPart(p, part));
                continue;
            }
            result2.attachments.add(p);
        }
        return result2;
    }

    private static boolean isRootPart(MimePart part, int nthPart, String rootId) throws MessagingException {
        return rootId == null && nthPart == 0 || StringUtils.equals((CharSequence)part.getContentID(), (CharSequence)rootId);
    }

    private static int getPoint(BodyPart p, String[] preferences) throws MessagingException {
        if (p == null) {
            return 0;
        }
        for (int i = 0; i < preferences.length; ++i) {
            if (!p.isMimeType(preferences[i])) continue;
            return preferences.length + 1 - i;
        }
        return 1;
    }

    private static MimeBodyPart better(MimeBodyPart p, MimeBodyPart best, boolean isHtmlPreferred) throws MessagingException {
        String[] preferences = isHtmlPreferred ? new String[]{"multipart/related", "text/html", "text/plain"} : new String[]{"multipart/related", "text/plain", "text/html"};
        return CreationViaEmail.getPoint((BodyPart)p, preferences) > CreationViaEmail.getPoint((BodyPart)best, preferences) ? p : best;
    }

    private static String cannotCreateMessage(User user, Project project2, ResourceType resourceType) {
        Lang lang = Lang.apply((String)user.getPreferredLanguage());
        String resourceTypeName = resourceType.getName(lang);
        return Messages.get((Lang)lang, (String)"viaEmail.error.cannotCreate", (Object[])new Object[]{user, resourceTypeName, project2});
    }

    private static void addEvent(NotificationEvent event, Address[] recipients, User sender) {
        HashSet<User> emailUsers = new HashSet<User>();
        emailUsers.add(sender);
        for (Address addr : recipients) {
            emailUsers.add(User.findByEmail(((InternetAddress)addr).getAddress()));
        }
        NotificationEvent notificationEvent = event;
        Set<User> set = null;
        set = notificationEvent.getReceivers();
        set.removeAll(emailUsers);
        NotificationEvent.add(event);
    }

    private static String replaceCidWithAttachments(String html, Map<String, Attachment> attachments) {
        String[] attrNames;
        Document doc = Jsoup.parse((String)html);
        for (String attrName : attrNames = new String[]{"src", "href"}) {
            Elements tags = doc.select("*[" + attrName + "]");
            for (Element tag : tags) {
                String cid;
                String uriString = tag.attr(attrName).trim();
                if (!uriString.toLowerCase().startsWith("cid:") || !attachments.containsKey(cid = uriString.substring("cid:".length()))) continue;
                Attachment attachment = attachments.get(cid);
                Long l = null;
                Long id = l = attachment.getId();
                tag.attr(attrName, routes.AttachmentApp.getFile(id).url());
            }
        }
        Elements bodies = doc.getElementsByTag("body");
        if (bodies.size() > 0) {
            return ((Element)bodies.get(0)).html();
        }
        return doc.html();
    }

    private static Attachment saveAttachment(Part partToAttach, Resource container) throws MessagingException, IOException, NoSuchAlgorithmException {
        Attachment attach = new Attachment();
        String fileName = MimeUtility.decodeText((String)partToAttach.getFileName());
        attach.store(partToAttach.getInputStream(), fileName, container);
        Attachment attachment = attach;
        String string = null;
        string = attachment.getMimeType();
        if (!string.equalsIgnoreCase(partToAttach.getContentType())) {
            attachment = attach;
            string = null;
            string = attachment.getMimeType();
            Logger.info((String)("The email says the content type is '" + partToAttach.getContentType() + "' but Yobi determines it is '" + string + "'"));
        }
        return attach;
    }

    private static Map<String, Attachment> saveAttachments(Collection<MimePart> partsToAttach, Resource container) throws MessagingException, IOException, NoSuchAlgorithmException {
        HashMap<String, Attachment> result2 = new HashMap<String, Attachment>();
        for (MimePart partToAttach : partsToAttach) {
            Attachment attachment = CreationViaEmail.saveAttachment((Part)partToAttach, container);
            if (partToAttach.getContentID() == null) continue;
            String cid = partToAttach.getContentID().trim();
            cid = cid.replace("<", "");
            cid = cid.replace(">", "");
            result2.put(cid, attachment);
        }
        return result2;
    }
}

