/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanSet;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import models.AbstractPosting;
import models.Comment;
import models.Issue;
import models.PostingComment;
import models.Project;
import models.User;
import models.enumeration.ResourceType;
import models.resource.Resource;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueComment
extends Comment
implements EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, IssueComment> find = new Model.Finder(Long.class, IssueComment.class);
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Issue issue;
    @OneToOne
    private IssueComment parentComment;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="issue_comment_voter", joinColumns={@JoinColumn(name="issue_comment_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<User> voters;
    private static String _EBEAN_MARKER = "models.IssueComment";

    public IssueComment(Issue issue2, User author, String contents) {
        super(author, contents);
        Object object = new HashSet<User>();
        Object object2 = this;
        ((IssueComment)object2).setVoters((Set<User>)object);
        object = issue2;
        object2 = this;
        ((IssueComment)object2).setIssue((Issue)object);
        object2 = issue2;
        object = null;
        object2 = object = ((AbstractPosting)object2).getProject();
        object = null;
        object = ((Project)object2).getId();
        object2 = this;
        ((Comment)object2).setProjectId((Long)object);
    }

    @Override
    public AbstractPosting getParent() {
        IssueComment issueComment = this;
        Issue issue2 = null;
        issue2 = issueComment.getIssue();
        return issue2;
    }

    @Override
    public IssueComment getParentComment() {
        return this._ebean_get_parentComment();
    }

    @Override
    public void setParentComment(Comment comment) {
        this._ebean_set_parentComment((IssueComment)comment);
    }

    public List<IssueComment> getSiblingComments() {
        if (this._ebean_get_parentComment() == null) {
            return null;
        }
        IssueComment issueComment = this._ebean_get_parentComment();
        Long l = null;
        l = issueComment.getId();
        List comments = find.where().eq("parentComment.id", (Object)l).findList();
        return comments;
    }

    public List<IssueComment> getChildComments() {
        IssueComment issueComment = this;
        Long l = null;
        l = issueComment.getId();
        List comments = find.where().eq("parentComment.id", (Object)l).findList();
        return comments;
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                IssueComment issueComment = IssueComment.this;
                Long l = null;
                l = issueComment.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                Model model = IssueComment.this;
                Model model2 = null;
                model2 = model.getIssue();
                model = model2;
                model2 = null;
                model2 = model.getProject();
                return model2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.ISSUE_COMMENT;
            }

            @Override
            public Long getAuthorId() {
                IssueComment issueComment = IssueComment.this;
                Long l = null;
                l = issueComment.getAuthorId();
                return l;
            }

            @Override
            public Resource getContainer() {
                IssueComment issueComment = IssueComment.this;
                Issue issue2 = null;
                issue2 = issueComment.getIssue();
                return issue2.asResource();
            }
        };
    }

    public void addVoter(User user) {
        IssueComment issueComment = this;
        Set<User> set = null;
        set = issueComment.getVoters();
        if (set.add(user)) {
            this.update();
        }
    }

    public void removeVoter(User user) {
        IssueComment issueComment = this;
        Set<User> set = null;
        set = issueComment.getVoters();
        if (set.remove(user)) {
            this.update();
        }
    }

    public static IssueComment from(PostingComment postingComment, Issue issue2) {
        User user = new User();
        Model model = postingComment;
        Object object = null;
        object = model.getAuthorId();
        model = user;
        model.setId((Long)object);
        model = postingComment;
        object = null;
        object = model.getAuthorLoginId();
        model = user;
        model.setLoginId((String)object);
        model = postingComment;
        object = null;
        object = model.getAuthorName();
        model = user;
        model.setName((String)object);
        model = postingComment;
        object = null;
        Object contents = object = model.getContents();
        IssueComment issueComment = new IssueComment(issue2, user, (String)contents);
        model = postingComment;
        object = null;
        object = model.getCreatedDate();
        model = issueComment;
        model.setCreatedDate((Date)object);
        model = postingComment;
        object = null;
        object = model.getAuthorId();
        model = issueComment;
        model.setAuthorId((Long)object);
        model = postingComment;
        object = null;
        object = model.getAuthorLoginId();
        model = issueComment;
        model.setAuthorLoginId((String)object);
        model = postingComment;
        object = null;
        object = model.getAuthorName();
        model = issueComment;
        model.setAuthorName((String)object);
        model = postingComment;
        object = null;
        object = model.getProjectId();
        model = issueComment;
        model.setProjectId((Long)object);
        return issueComment;
    }

    public static List<IssueComment> from(Collection<PostingComment> postingComments, Issue issue2) {
        ArrayList<IssueComment> issueComments = new ArrayList<IssueComment>();
        for (PostingComment postingComment : postingComments) {
            issueComments.add(IssueComment.from(postingComment, issue2));
        }
        return issueComments;
    }

    public static int countAllCreatedBy(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        return find.where().eq("author_id", (Object)l).findRowCount();
    }

    public static int countVoterOf(User user) {
        String template = "SELECT issue_comment.id FROM issue_comment INNER JOIN issue_comment_voter ON issue_comment.id = issue_comment_voter.issue_comment_id WHERE issue_comment_voter.user_id = %d";
        Object[] objectArray = new Object[1];
        User user2 = user;
        Long l = null;
        l = user2.getId();
        objectArray[0] = l;
        String sql = String.format(template, objectArray);
        Set set = find.setRawSql(RawSqlBuilder.parse((String)sql).create()).findSet();
        return set.size();
    }

    @Override
    public String toString() {
        IssueComment issueComment = this;
        Object object = null;
        object = issueComment.getId();
        StringBuilder stringBuilder = new StringBuilder().append("IssueComment{id=").append(object).append(", contents='");
        issueComment = this;
        object = null;
        object = issueComment.getContents();
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append('\'').append(", createdDate=");
        issueComment = this;
        object = null;
        object = issueComment.getCreatedDate();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", authorId=");
        issueComment = this;
        object = null;
        object = issueComment.getAuthorId();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", authorLoginId='");
        issueComment = this;
        object = null;
        object = issueComment.getAuthorLoginId();
        StringBuilder stringBuilder5 = stringBuilder4.append((String)object).append('\'').append(", authorName='");
        issueComment = this;
        object = null;
        object = issueComment.getAuthorName();
        StringBuilder stringBuilder6 = stringBuilder5.append((String)object).append('\'').append(", projectId=");
        issueComment = this;
        object = null;
        object = issueComment.getProjectId();
        return stringBuilder6.append(object).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Issue getIssue() {
        return this._ebean_get_issue();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssue(Issue issue2) {
        this._ebean_set_issue(issue2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<User> getVoters() {
        return this._ebean_get_voters();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setVoters(Set<User> set) {
        this._ebean_set_voters(set);
    }

    public IssueComment() {
    }

    @Override
    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Issue _ebean_get_issue() {
        this._ebean_intercept.preGetter("issue");
        return this.issue;
    }

    protected void _ebean_set_issue(Issue newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "issue", (Object)this._ebean_get_issue(), (Object)newValue);
        this.issue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Issue _ebean_getni_issue() {
        return this.issue;
    }

    protected void _ebean_setni_issue(Issue _newValue) {
        this.issue = _newValue;
    }

    protected IssueComment _ebean_get_parentComment() {
        this._ebean_intercept.preGetter("parentComment");
        return this.parentComment;
    }

    protected void _ebean_set_parentComment(IssueComment newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "parentComment", (Object)this._ebean_get_parentComment(), (Object)newValue);
        this.parentComment = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected IssueComment _ebean_getni_parentComment() {
        return this.parentComment;
    }

    protected void _ebean_setni_parentComment(IssueComment _newValue) {
        this.parentComment = _newValue;
    }

    protected Set _ebean_get_voters() {
        this._ebean_intercept.preGetter("voters");
        if (this.voters == null) {
            this.voters = new BeanSet();
            ((BeanCollection)this.voters).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.voters;
    }

    protected void _ebean_set_voters(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "voters", (Object)this._ebean_get_voters(), (Object)newValue);
        this.voters = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_voters() {
        return this.voters;
    }

    protected void _ebean_setni_voters(Set _newValue) {
        this.voters = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object _ebean_createCopy() {
        void p;
        IssueComment issueComment = new IssueComment();
        issueComment._ebean_setni_id(this._ebean_getni_id());
        issueComment._ebean_setni_contents(this._ebean_getni_contents());
        issueComment._ebean_setni_createdDate(this._ebean_getni_createdDate());
        issueComment._ebean_setni_authorId(this._ebean_getni_authorId());
        issueComment._ebean_setni_authorLoginId(this._ebean_getni_authorLoginId());
        issueComment._ebean_setni_authorName(this._ebean_getni_authorName());
        issueComment._ebean_setni_projectId(this._ebean_getni_projectId());
        issueComment.issue = this.issue;
        issueComment.parentComment = this.parentComment;
        issueComment.voters = this.voters;
        return p;
    }

    @Override
    public Object _ebean_getField(int index2, Object o) {
        IssueComment p = (IssueComment)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p._ebean_getni_id();
            }
            case 2: {
                return p._ebean_getni_contents();
            }
            case 3: {
                return p._ebean_getni_createdDate();
            }
            case 4: {
                return p._ebean_getni_authorId();
            }
            case 5: {
                return p._ebean_getni_authorLoginId();
            }
            case 6: {
                return p._ebean_getni_authorName();
            }
            case 7: {
                return p._ebean_getni_projectId();
            }
            case 8: {
                return p._ebean_getni_parentCommentId();
            }
            case 9: {
                return p._ebean_getni_previousContents();
            }
            case 10: {
                return p.issue;
            }
            case 11: {
                return p.parentComment;
            }
            case 12: {
                return p.voters;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public Object _ebean_getFieldIntercept(int index2, Object o) {
        IssueComment p = (IssueComment)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_contents();
            }
            case 3: {
                return p._ebean_get_createdDate();
            }
            case 4: {
                return p._ebean_get_authorId();
            }
            case 5: {
                return p._ebean_get_authorLoginId();
            }
            case 6: {
                return p._ebean_get_authorName();
            }
            case 7: {
                return p._ebean_get_projectId();
            }
            case 8: {
                return p._ebean_get_parentCommentId();
            }
            case 9: {
                return p._ebean_get_previousContents();
            }
            case 10: {
                return p._ebean_get_issue();
            }
            case 11: {
                return p._ebean_get_parentComment();
            }
            case 12: {
                return p._ebean_get_voters();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setField(int index2, Object o, Object arg) {
        IssueComment p = (IssueComment)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_setni_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_setni_contents((String)arg);
                return;
            }
            case 3: {
                p._ebean_setni_createdDate((Date)arg);
                return;
            }
            case 4: {
                p._ebean_setni_authorId((Long)arg);
                return;
            }
            case 5: {
                p._ebean_setni_authorLoginId((String)arg);
                return;
            }
            case 6: {
                p._ebean_setni_authorName((String)arg);
                return;
            }
            case 7: {
                p._ebean_setni_projectId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_setni_parentCommentId((String)arg);
                return;
            }
            case 9: {
                p._ebean_setni_previousContents((String)arg);
                return;
            }
            case 10: {
                p.issue = (Issue)arg;
                return;
            }
            case 11: {
                p.parentComment = (IssueComment)arg;
                return;
            }
            case 12: {
                p.voters = (Set)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        IssueComment p = (IssueComment)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_contents((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 4: {
                p._ebean_set_authorId((Long)arg);
                return;
            }
            case 5: {
                p._ebean_set_authorLoginId((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_authorName((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_projectId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_set_parentCommentId((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_previousContents((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_issue((Issue)arg);
                return;
            }
            case 11: {
                p._ebean_set_parentComment((IssueComment)arg);
                return;
            }
            case 12: {
                p._ebean_set_voters((Set)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "contents", "createdDate", "authorId", "authorLoginId", "authorName", "projectId", "parentCommentId", "previousContents", "issue", "parentComment", "voters"};
    }

    @Override
    public void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public Object _ebean_newInstance() {
        return new IssueComment();
    }
}

