/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Expr;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import com.avaje.ebean.common.BeanSet;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import models.AbstractPosting;
import models.Comment;
import models.Issue;
import models.IssueLabel;
import models.PostingComment;
import models.Project;
import models.User;
import models.enumeration.ResourceType;
import models.resource.Resource;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import utils.JodaDateUtil;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"project_id", "number"})})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Posting
extends AbstractPosting
implements EntityBean {
    private static final long serialVersionUID = 5287703642071155249L;
    public static final Model.Finder<Long, Posting> finder = new Model.Finder(Long.class, Posting.class);
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean notice;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean readme;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String issueTemplate;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String path;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String branch;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String lineEnding;
    @OneToMany(cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<PostingComment> comments;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<IssueLabel> labels;
    @OneToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Posting parent;
    private static String _EBEAN_MARKER = "models.Posting";

    public Set<Long> getLabelIds() {
        HashSet<Long> labelIds = new HashSet<Long>();
        Model model = this;
        Object object = null;
        object = model.getLabels();
        Iterator<IssueLabel> iterator = object.iterator();
        while (iterator.hasNext()) {
            IssueLabel label = iterator.next();
            model = label;
            object = null;
            object = model.getId();
            labelIds.add((Long)object);
        }
        return labelIds;
    }

    public Posting(Project project2, User author, String title, String body) {
        super(project2, author, title, body);
    }

    @Override
    protected Long increaseNumber() {
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        return Project.increaseLastPostingNumber((Long)object);
    }

    @Override
    protected void fixLastNumber() {
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getId();
        Project.fixLastPostingNumber((Long)object);
    }

    @Override
    public int computeNumOfComments() {
        return this._ebean_get_comments().size();
    }

    public Posting() {
    }

    @Override
    public Resource asResource() {
        return this.asResource(ResourceType.BOARD_POST);
    }

    public static List<Posting> findNotices(Project project2) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).add(Expr.eq((String)"notice", (Object)true)).order().desc("createdDate").findList();
    }

    public static List<Posting> findRecentlyCreated(Project project2, int size) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).order().desc("createdDate").findPagingList(size).getPage(0).getList();
    }

    public static List<Posting> findRecentlyCreatedByDaysAgo(Project project2, int days) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).ge("createdDate", (Object)JodaDateUtil.before(days)).order().desc("createdDate").findList();
    }

    @Override
    @Transient
    public List<? extends Comment> getComments() {
        Collections.sort(this.comments, Comment.comparator());
        return this.comments;
    }

    @Override
    public void checkLabels() {
    }

    public static Posting findByNumber(Project project2, long number) {
        return AbstractPosting.findByNumber(finder, project2, number);
    }

    public static int countAllCreatedBy(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        return finder.where().eq("author_id", (Object)l).findRowCount();
    }

    public static int countPostings(Project project2) {
        return finder.where().eq("project", (Object)project2).findRowCount();
    }

    @Override
    public void directSave() {
        super.directSave();
    }

    public static Posting findREADMEPosting(Project project2) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return (Posting)finder.where().eq("project.id", (Object)l).add(Expr.eq((String)"readme", (Object)true)).findUnique();
    }

    public PostingComment findCommentByCommentId(Long id) {
        Iterator iterator = this._ebean_get_comments().iterator();
        while (iterator.hasNext()) {
            PostingComment comment;
            PostingComment postingComment = comment = (PostingComment)iterator.next();
            Long l = null;
            l = postingComment.getId();
            if (!l.equals(id)) continue;
            return comment;
        }
        return null;
    }

    public static Posting from(Issue issue2) {
        Posting posting = new Posting();
        AbstractPosting abstractPosting = issue2;
        Object object = null;
        object = abstractPosting.getTitle();
        abstractPosting = posting;
        abstractPosting.setTitle((String)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getBody();
        abstractPosting = posting;
        abstractPosting.setBody((String)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getHistory();
        abstractPosting = posting;
        abstractPosting.setHistory((String)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getCreatedDate();
        abstractPosting = posting;
        abstractPosting.setCreatedDate((Date)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getUpdatedDate();
        abstractPosting = posting;
        abstractPosting.setUpdatedDate((Date)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getAuthorId();
        abstractPosting = posting;
        abstractPosting.setAuthorId((Long)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getAuthorLoginId();
        abstractPosting = posting;
        abstractPosting.setAuthorLoginId((String)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getAuthorName();
        abstractPosting = posting;
        abstractPosting.setAuthorName((String)object);
        abstractPosting = issue2;
        object = null;
        object = abstractPosting.getProject();
        abstractPosting = posting;
        abstractPosting.setProject((Project)object);
        return posting;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getNotice() {
        return this._ebean_get_notice();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNotice(boolean bl) {
        this._ebean_set_notice(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getReadme() {
        return this._ebean_get_readme();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setReadme(boolean bl) {
        this._ebean_set_readme(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getIssueTemplate() {
        return this.issueTemplate;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssueTemplate(String string) {
        this.issueTemplate = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPath() {
        return this.path;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPath(String string) {
        this.path = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getBranch() {
        return this.branch;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setBranch(String string) {
        this.branch = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getLineEnding() {
        return this.lineEnding;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLineEnding(String string) {
        this.lineEnding = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setComments(List<PostingComment> list2) {
        this._ebean_set_comments(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<IssueLabel> getLabels() {
        return this._ebean_get_labels();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLabels(Set<IssueLabel> set) {
        this._ebean_set_labels(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Posting getParent() {
        return this._ebean_get_parent();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setParent(Posting posting) {
        this._ebean_set_parent(posting);
    }

    @Override
    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected boolean _ebean_get_notice() {
        this._ebean_intercept.preGetter("notice");
        return this.notice;
    }

    protected void _ebean_set_notice(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "notice", this._ebean_get_notice(), newValue);
        this.notice = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_notice() {
        return this.notice;
    }

    protected void _ebean_setni_notice(boolean _newValue) {
        this.notice = _newValue;
    }

    protected boolean _ebean_get_readme() {
        this._ebean_intercept.preGetter("readme");
        return this.readme;
    }

    protected void _ebean_set_readme(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "readme", this._ebean_get_readme(), newValue);
        this.readme = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_readme() {
        return this.readme;
    }

    protected void _ebean_setni_readme(boolean _newValue) {
        this.readme = _newValue;
    }

    protected String _ebean_get_issueTemplate() {
        return this.issueTemplate;
    }

    protected void _ebean_set_issueTemplate(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "issueTemplate", (Object)this._ebean_get_issueTemplate(), (Object)newValue);
        this.issueTemplate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_issueTemplate() {
        return this.issueTemplate;
    }

    protected void _ebean_setni_issueTemplate(String _newValue) {
        this.issueTemplate = _newValue;
    }

    protected String _ebean_get_path() {
        return this.path;
    }

    protected void _ebean_set_path(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "path", (Object)this._ebean_get_path(), (Object)newValue);
        this.path = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_path() {
        return this.path;
    }

    protected void _ebean_setni_path(String _newValue) {
        this.path = _newValue;
    }

    protected String _ebean_get_branch() {
        return this.branch;
    }

    protected void _ebean_set_branch(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "branch", (Object)this._ebean_get_branch(), (Object)newValue);
        this.branch = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_branch() {
        return this.branch;
    }

    protected void _ebean_setni_branch(String _newValue) {
        this.branch = _newValue;
    }

    protected String _ebean_get_lineEnding() {
        return this.lineEnding;
    }

    protected void _ebean_set_lineEnding(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "lineEnding", (Object)this._ebean_get_lineEnding(), (Object)newValue);
        this.lineEnding = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_lineEnding() {
        return this.lineEnding;
    }

    protected void _ebean_setni_lineEnding(String _newValue) {
        this.lineEnding = _newValue;
    }

    protected List _ebean_get_comments() {
        this._ebean_intercept.preGetter("comments");
        if (this.comments == null) {
            this.comments = new BeanList();
        }
        return this.comments;
    }

    protected void _ebean_set_comments(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "comments", (Object)this._ebean_get_comments(), (Object)newValue);
        this.comments = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_comments() {
        return this.comments;
    }

    protected void _ebean_setni_comments(List _newValue) {
        this.comments = _newValue;
    }

    protected Set _ebean_get_labels() {
        this._ebean_intercept.preGetter("labels");
        if (this.labels == null) {
            this.labels = new BeanSet();
            ((BeanCollection)this.labels).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.labels;
    }

    protected void _ebean_set_labels(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "labels", (Object)this._ebean_get_labels(), (Object)newValue);
        this.labels = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_labels() {
        return this.labels;
    }

    protected void _ebean_setni_labels(Set _newValue) {
        this.labels = _newValue;
    }

    protected Posting _ebean_get_parent() {
        this._ebean_intercept.preGetter("parent");
        return this.parent;
    }

    protected void _ebean_set_parent(Posting newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "parent", (Object)this._ebean_get_parent(), (Object)newValue);
        this.parent = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Posting _ebean_getni_parent() {
        return this.parent;
    }

    protected void _ebean_setni_parent(Posting _newValue) {
        this.parent = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object _ebean_createCopy() {
        void p;
        Posting posting = new Posting();
        posting._ebean_setni_id(this._ebean_getni_id());
        posting._ebean_setni_title(this._ebean_getni_title());
        posting._ebean_setni_body(this._ebean_getni_body());
        posting._ebean_setni_history(this._ebean_getni_history());
        posting._ebean_setni_createdDate(this._ebean_getni_createdDate());
        posting._ebean_setni_updatedDate(this._ebean_getni_updatedDate());
        posting._ebean_setni_authorId(this._ebean_getni_authorId());
        posting._ebean_setni_authorLoginId(this._ebean_getni_authorLoginId());
        posting._ebean_setni_authorName(this._ebean_getni_authorName());
        posting._ebean_setni_updatedByAuthorId(this._ebean_getni_updatedByAuthorId());
        posting._ebean_setni_project(this._ebean_getni_project());
        posting._ebean_setni_number(this._ebean_getni_number());
        posting._ebean_setni_numOfComments(this._ebean_getni_numOfComments());
        posting.notice = this.notice;
        posting.readme = this.readme;
        posting.comments = this.comments;
        posting.labels = this.labels;
        posting.parent = this.parent;
        return p;
    }

    @Override
    public Object _ebean_getField(int index2, Object o) {
        Posting p = (Posting)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p._ebean_getni_id();
            }
            case 2: {
                return p._ebean_getni_title();
            }
            case 3: {
                return p._ebean_getni_body();
            }
            case 4: {
                return p._ebean_getni_history();
            }
            case 5: {
                return p._ebean_getni_createdDate();
            }
            case 6: {
                return p._ebean_getni_updatedDate();
            }
            case 7: {
                return p._ebean_getni_authorId();
            }
            case 8: {
                return p._ebean_getni_authorLoginId();
            }
            case 9: {
                return p._ebean_getni_authorName();
            }
            case 10: {
                return p._ebean_getni_updatedByAuthorId();
            }
            case 11: {
                return p._ebean_getni_author();
            }
            case 12: {
                return p._ebean_getni_project();
            }
            case 13: {
                return p._ebean_getni_number();
            }
            case 14: {
                return p._ebean_getni_numOfComments();
            }
            case 15: {
                return p._ebean_getni_isPublish();
            }
            case 16: {
                return p.notice;
            }
            case 17: {
                return p.readme;
            }
            case 18: {
                return p.issueTemplate;
            }
            case 19: {
                return p.path;
            }
            case 20: {
                return p.branch;
            }
            case 21: {
                return p.lineEnding;
            }
            case 22: {
                return p.comments;
            }
            case 23: {
                return p.labels;
            }
            case 24: {
                return p.parent;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Posting p = (Posting)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_title();
            }
            case 3: {
                return p._ebean_get_body();
            }
            case 4: {
                return p._ebean_get_history();
            }
            case 5: {
                return p._ebean_get_createdDate();
            }
            case 6: {
                return p._ebean_get_updatedDate();
            }
            case 7: {
                return p._ebean_get_authorId();
            }
            case 8: {
                return p._ebean_get_authorLoginId();
            }
            case 9: {
                return p._ebean_get_authorName();
            }
            case 10: {
                return p._ebean_get_updatedByAuthorId();
            }
            case 11: {
                return p._ebean_get_author();
            }
            case 12: {
                return p._ebean_get_project();
            }
            case 13: {
                return p._ebean_get_number();
            }
            case 14: {
                return p._ebean_get_numOfComments();
            }
            case 15: {
                return p._ebean_get_isPublish();
            }
            case 16: {
                return p._ebean_get_notice();
            }
            case 17: {
                return p._ebean_get_readme();
            }
            case 18: {
                return p._ebean_get_issueTemplate();
            }
            case 19: {
                return p._ebean_get_path();
            }
            case 20: {
                return p._ebean_get_branch();
            }
            case 21: {
                return p._ebean_get_lineEnding();
            }
            case 22: {
                return p._ebean_get_comments();
            }
            case 23: {
                return p._ebean_get_labels();
            }
            case 24: {
                return p._ebean_get_parent();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setField(int index2, Object o, Object arg) {
        Posting p = (Posting)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_setni_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_setni_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_setni_body((String)arg);
                return;
            }
            case 4: {
                p._ebean_setni_history((String)arg);
                return;
            }
            case 5: {
                p._ebean_setni_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_setni_updatedDate((Date)arg);
                return;
            }
            case 7: {
                p._ebean_setni_authorId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_setni_authorLoginId((String)arg);
                return;
            }
            case 9: {
                p._ebean_setni_authorName((String)arg);
                return;
            }
            case 10: {
                p._ebean_setni_updatedByAuthorId((Long)arg);
                return;
            }
            case 11: {
                p._ebean_setni_author((User)arg);
                return;
            }
            case 12: {
                p._ebean_setni_project((Project)arg);
                return;
            }
            case 13: {
                p._ebean_setni_number((Long)arg);
                return;
            }
            case 14: {
                p._ebean_setni_numOfComments((Integer)arg);
                return;
            }
            case 15: {
                p._ebean_setni_isPublish((Boolean)arg);
                return;
            }
            case 16: {
                p.notice = (Boolean)arg;
                return;
            }
            case 17: {
                p.readme = (Boolean)arg;
                return;
            }
            case 18: {
                p.issueTemplate = (String)arg;
                return;
            }
            case 19: {
                p.path = (String)arg;
                return;
            }
            case 20: {
                p.branch = (String)arg;
                return;
            }
            case 21: {
                p.lineEnding = (String)arg;
                return;
            }
            case 22: {
                p.comments = (List)arg;
                return;
            }
            case 23: {
                p.labels = (Set)arg;
                return;
            }
            case 24: {
                p.parent = (Posting)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Posting p = (Posting)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_body((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_history((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_updatedDate((Date)arg);
                return;
            }
            case 7: {
                p._ebean_set_authorId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_set_authorLoginId((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_authorName((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_updatedByAuthorId((Long)arg);
                return;
            }
            case 11: {
                p._ebean_set_author((User)arg);
                return;
            }
            case 12: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 13: {
                p._ebean_set_number((Long)arg);
                return;
            }
            case 14: {
                p._ebean_set_numOfComments((Integer)arg);
                return;
            }
            case 15: {
                p._ebean_set_isPublish((Boolean)arg);
                return;
            }
            case 16: {
                p._ebean_set_notice((Boolean)arg);
                return;
            }
            case 17: {
                p._ebean_set_readme((Boolean)arg);
                return;
            }
            case 18: {
                p._ebean_set_issueTemplate((String)arg);
                return;
            }
            case 19: {
                p._ebean_set_path((String)arg);
                return;
            }
            case 20: {
                p._ebean_set_branch((String)arg);
                return;
            }
            case 21: {
                p._ebean_set_lineEnding((String)arg);
                return;
            }
            case 22: {
                p._ebean_set_comments((List)arg);
                return;
            }
            case 23: {
                p._ebean_set_labels((Set)arg);
                return;
            }
            case 24: {
                p._ebean_set_parent((Posting)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "title", "body", "history", "createdDate", "updatedDate", "authorId", "authorLoginId", "authorName", "updatedByAuthorId", "author", "project", "number", "numOfComments", "isPublish", "notice", "readme", "issueTemplate", "path", "branch", "lineEnding", "comments", "labels", "parent"};
    }

    @Override
    public void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public Object _ebean_newInstance() {
        return new Posting();
    }
}

