/*
 * Decompiled with CFR 0.152.
 */
package models;

import actors.RelatedPullRequestMergingActor;
import akka.actor.Props;
import com.avaje.ebean.Expr;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import com.avaje.ebean.Page;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import com.avaje.ebean.common.BeanSet;
import controllers.PullRequestApp;
import controllers.UserApp;
import errors.PullRequestException;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Size;
import models.CodeCommentThread;
import models.CodeRange;
import models.CommentThread;
import models.CommitComment;
import models.Issue;
import models.IssueEvent;
import models.NotificationEvent;
import models.Organization;
import models.Project;
import models.PullRequestCommit;
import models.PullRequestEvent;
import models.PullRequestEventMessage;
import models.PullRequestMergeResult;
import models.PushedBranch;
import models.ReviewComment;
import models.User;
import models.UserIdent;
import models.Watch;
import models.enumeration.EventType;
import models.enumeration.ResourceType;
import models.enumeration.State;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.joda.time.Duration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.Akka;
import play.libs.F;
import playRepository.FileDiff;
import playRepository.GitCommit;
import playRepository.GitRepository;
import utils.Config;
import utils.JodaDateUtil;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PullRequest
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final String DELIMETER = ",";
    public static final Model.Finder<Long, PullRequest> finder = new Model.Finder(Long.class, PullRequest.class);
    public static final int ITEMS_PER_PAGE = 15;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @Size(max=255)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String title;
    @Lob
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String body;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long toProjectId;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long fromProjectId;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project toProject;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project fromProject;
    @Constraints.Required
    @Size(max=255)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String toBranch;
    @Constraints.Required
    @Size(max=255)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String fromBranch;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public User contributor;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public User receiver;
    @Temporal(value=TemporalType.TIMESTAMP)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date created;
    @Temporal(value=TemporalType.TIMESTAMP)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date updated;
    @Temporal(value=TemporalType.TIMESTAMP)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date received;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public State state;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Boolean isConflict;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Boolean isMerging;
    @OneToMany(cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<PullRequestCommit> pullRequestCommits;
    @OneToMany(cascade={CascadeType.ALL})
    @OrderBy(value="created ASC")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<PullRequestEvent> pullRequestEvents;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String lastCommitId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String mergedCommitIdFrom;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String mergedCommitIdTo;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long number;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="pull_request_reviewers", joinColumns={@JoinColumn(name="pull_request_id", unique=false)}, inverseJoinColumns={@JoinColumn(name="user_id", unique=false)}, uniqueConstraints={@UniqueConstraint(columnNames={"pull_request_id", "user_id"})})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<User> reviewers;
    @OneToMany(mappedBy="pullRequest")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<CommentThread> commentThreads;
    @Transient
    private Repository repository;
    private static String _EBEAN_MARKER = "models.PullRequest";

    public PullRequest() {
        Object object = State.OPEN;
        PullRequest pullRequest2 = this;
        pullRequest2.setState((State)((Object)object));
        object = new HashSet();
        pullRequest2 = this;
        pullRequest2.setReviewers((Set<User>)object);
        object = new ArrayList();
        pullRequest2 = this;
        pullRequest2.setCommentThreads((List<CommentThread>)object);
    }

    public static PullRequest createNewPullRequest(Project fromProject, Project toProject, String fromBranch, String toBranch) {
        PullRequest pullRequest2 = new PullRequest();
        Object object = toProject;
        PullRequest pullRequest3 = pullRequest2;
        pullRequest3.setToProject((Project)object);
        object = toBranch;
        pullRequest3 = pullRequest2;
        pullRequest3.setToBranch((String)object);
        object = fromProject;
        pullRequest3 = pullRequest2;
        pullRequest3.setFromProject((Project)object);
        object = fromBranch;
        pullRequest3 = pullRequest2;
        pullRequest3.setFromBranch((String)object);
        return pullRequest2;
    }

    public String toString() {
        PullRequest pullRequest2 = this;
        Object object = null;
        object = pullRequest2.getId();
        StringBuilder stringBuilder = new StringBuilder().append("PullRequest{id=").append(object).append(", title='");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getTitle();
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append('\'').append(", body='");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getBody();
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object).append('\'').append(", toProject=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getToProject();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", fromProject=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getFromProject();
        StringBuilder stringBuilder5 = stringBuilder4.append(object).append(", toBranch='");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getToBranch();
        StringBuilder stringBuilder6 = stringBuilder5.append((String)object).append('\'').append(", fromBranch='");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getFromBranch();
        StringBuilder stringBuilder7 = stringBuilder6.append((String)object).append('\'').append(", contributor=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getContributor();
        StringBuilder stringBuilder8 = stringBuilder7.append(object).append(", receiver=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getReceiver();
        StringBuilder stringBuilder9 = stringBuilder8.append(object).append(", created=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getCreated();
        StringBuilder stringBuilder10 = stringBuilder9.append(object).append(", updated=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getUpdated();
        StringBuilder stringBuilder11 = stringBuilder10.append(object).append(", received=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getReceived();
        StringBuilder stringBuilder12 = stringBuilder11.append(object).append(", state=");
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getState();
        return stringBuilder12.append(object).append('}').toString();
    }

    public static void onStart() {
        PullRequest.regulateNumbers();
        PullRequest.changeStateToClosed();
    }

    public Duration createdAgo() {
        PullRequest pullRequest2 = this;
        Date date = null;
        date = pullRequest2.getCreated();
        return JodaDateUtil.ago(date);
    }

    public Duration receivedAgo() {
        PullRequest pullRequest2 = this;
        Date date = null;
        date = pullRequest2.getReceived();
        return JodaDateUtil.ago(date);
    }

    public boolean isOpen() {
        PullRequest pullRequest2 = this;
        State state = null;
        state = pullRequest2.getState();
        return state == State.OPEN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAcceptable() {
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getIsConflict();
        if (((Boolean)object2).booleanValue()) return false;
        if (!this.isOpen()) return false;
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getIsMerging();
        if (((Boolean)object2).booleanValue()) return false;
        if (this.isReviewed()) return true;
        object = this;
        object2 = null;
        object = object2 = ((PullRequest)object).getToProject();
        boolean bl = false;
        bl = ((Project)object).getIsUsingReviewerCount();
        if (bl) return false;
        return true;
    }

    public static PullRequest findById(long id) {
        return (PullRequest)finder.byId((Object)id);
    }

    public static PullRequest findDuplicatedPullRequest(PullRequest pullRequest2) {
        PullRequest pullRequest3 = pullRequest2;
        Object object = null;
        object = pullRequest3.getFromBranch();
        ExpressionList expressionList = finder.where().eq("fromBranch", object);
        pullRequest3 = pullRequest2;
        object = null;
        object = pullRequest3.getToBranch();
        ExpressionList expressionList2 = expressionList.eq("toBranch", object);
        pullRequest3 = pullRequest2;
        object = null;
        object = pullRequest3.getFromProject();
        ExpressionList expressionList3 = expressionList2.eq("fromProject", object);
        pullRequest3 = pullRequest2;
        object = null;
        object = pullRequest3.getToProject();
        return (PullRequest)expressionList3.eq("toProject", object).eq("state", (Object)State.OPEN).findUnique();
    }

    public static List<PullRequest> findOpendPullRequests(Project project2) {
        return finder.where().eq("toProject", (Object)project2).eq("state", (Object)State.OPEN).order().desc("created").findList();
    }

    public static List<PullRequest> findOpendPullRequestsByDaysAgo(User user, int days) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        return finder.where().eq("contributor.id", (Object)l).ge("updated", (Object)JodaDateUtil.before(days)).order("updated desc, state asc").findList();
    }

    public static List<PullRequest> findClosedPullRequests(Project project2) {
        return finder.where().eq("toProject", (Object)project2).or(Expr.eq((String)"state", (Object)((Object)State.CLOSED)), Expr.eq((String)"state", (Object)((Object)State.MERGED))).order().desc("created").findList();
    }

    public static List<PullRequest> findSentPullRequests(Project project2) {
        return finder.where().eq("fromProject", (Object)project2).order().desc("created").findList();
    }

    public static List<PullRequest> findAcceptedPullRequests(Project project2) {
        return finder.where().eq("fromProject", (Object)project2).or(Expr.eq((String)"state", (Object)((Object)State.CLOSED)), Expr.eq((String)"state", (Object)((Object)State.MERGED))).order().desc("created").findList();
    }

    public static List<PullRequest> allReceivedRequests(Project project2) {
        return finder.where().eq("toProject", (Object)project2).order().desc("created").findList();
    }

    public static List<PullRequest> findRecentlyReceived(Project project2, int size) {
        return finder.where().eq("toProject", (Object)project2).order().desc("created").findPagingList(size).getPage(0).getList();
    }

    public static List<PullRequest> findRecentlyReceivedOpen(Project project2, int size) {
        return finder.where().eq("toProject", (Object)project2).eq("state", (Object)State.OPEN).order().desc("created").findPagingList(size).getPage(0).getList();
    }

    public static int countOpenedPullRequests(Project project2) {
        return finder.where().eq("toProject", (Object)project2).eq("state", (Object)State.OPEN).findRowCount();
    }

    public static List<PullRequest> findRelatedPullRequests(Project project2, String branch) {
        return finder.where().or(Expr.and((Expression)Expr.eq((String)"fromProject", (Object)project2), (Expression)Expr.eq((String)"fromBranch", (Object)branch)), Expr.and((Expression)Expr.eq((String)"toProject", (Object)project2), (Expression)Expr.eq((String)"toBranch", (Object)branch))).ne("state", (Object)State.CLOSED).ne("state", (Object)State.MERGED).findList();
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                PullRequest pullRequest2 = PullRequest.this;
                Long l = null;
                l = pullRequest2.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                PullRequest pullRequest2 = PullRequest.this;
                Project project2 = null;
                project2 = pullRequest2.getToProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.PULL_REQUEST;
            }

            @Override
            public Long getAuthorId() {
                Model model = PullRequest.this;
                Object object = null;
                object = model.getContributor();
                model = object;
                object = null;
                object = model.getId();
                return object;
            }
        };
    }

    public void updateWith(PullRequest newPullRequest2) {
        this.deleteIssueEvents();
        PullRequest pullRequest2 = newPullRequest2;
        String string = null;
        string = pullRequest2.getToBranch();
        pullRequest2 = this;
        pullRequest2.setToBranch(string);
        pullRequest2 = newPullRequest2;
        string = null;
        string = pullRequest2.getFromBranch();
        pullRequest2 = this;
        pullRequest2.setFromBranch(string);
        pullRequest2 = newPullRequest2;
        string = null;
        string = pullRequest2.getTitle();
        pullRequest2 = this;
        pullRequest2.setTitle(string);
        pullRequest2 = newPullRequest2;
        string = null;
        string = pullRequest2.getBody();
        pullRequest2 = this;
        pullRequest2.setBody(string);
        this.update();
        this.addNewIssueEvents();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameBranchesWith(PullRequest pullRequest2) {
        PullRequest pullRequest3 = this;
        String string = null;
        String string2 = string = pullRequest3.getToBranch();
        pullRequest3 = pullRequest2;
        string = null;
        string = pullRequest3.getToBranch();
        if (!string2.equals(string)) return false;
        pullRequest3 = this;
        string = null;
        String string3 = string = pullRequest3.getFromBranch();
        pullRequest3 = pullRequest2;
        string = null;
        string = pullRequest3.getFromBranch();
        if (!string3.equals(string)) return false;
        return true;
    }

    public boolean isClosed() {
        PullRequest pullRequest2 = this;
        State state = null;
        state = pullRequest2.getState();
        return state == State.CLOSED;
    }

    public boolean isMerged() {
        PullRequest pullRequest2 = this;
        State state = null;
        state = pullRequest2.getState();
        return state == State.MERGED;
    }

    public void deleteFromBranch() {
        String string = GitRepository.deleteFromBranch(this);
        PullRequest pullRequest2 = this;
        pullRequest2.setLastCommitId(string);
        this.update();
    }

    public void restoreFromBranch() {
        GitRepository.restoreBranch(this);
    }

    public void merge(PullRequestEventMessage message) throws IOException, GitAPIException, PullRequestException {
        Model model = this;
        String string = null;
        string = model.getToBranch();
        Merger.MergeResult result2 = new Merger(string, this.fetchSourceBranch()).merge();
        if (!result2.conflicts()) {
            User sender = message.getSender();
            model = sender;
            string = null;
            String string2 = string = model.getName();
            model = sender;
            string = null;
            string = model.getEmail();
            PersonIdent personIdent = new PersonIdent(string2, string);
            model = this;
            string = null;
            string = model.getToBranch();
            result2.createCommit(personIdent).updateRef(string);
            this.updateMergedCommitId(result2);
            this.changeState(State.MERGED, sender);
            NotificationEvent.afterPullRequestUpdated(sender, this, State.OPEN, State.MERGED);
            PullRequestEvent.addStateEvent(sender, this, State.MERGED);
            Akka.system().actorOf(Props.create(RelatedPullRequestMergingActor.class, (Object[])new Object[0])).tell((Object)message, null);
        }
    }

    public String fetchSourceBranch() throws IOException, GitAPIException {
        String destination = this.getRefNameToFetchedSource();
        this.fetchSourceBranchTo(destination);
        return destination;
    }

    public void updateMergedCommitId(Merger.MergeResult mergeResult2) {
        String string = mergeResult2.getLeftParentId().getName();
        PullRequest pullRequest2 = this;
        pullRequest2.setMergedCommitIdFrom(string);
        string = mergeResult2.getMergeCommitId().getName();
        pullRequest2 = this;
        pullRequest2.setMergedCommitIdTo(string);
        this.update();
    }

    public String getResourceKey() {
        PullRequest pullRequest2 = this;
        Long l = null;
        l = pullRequest2.getId();
        return ResourceType.PULL_REQUEST.resource() + "_" + l;
    }

    public Set<User> getWatchers() {
        return this.getWatchers(true);
    }

    public Set<User> getWatchers(boolean allowedWatchersOnly) {
        HashSet<User> actualWatchers = new HashSet<User>();
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getContributor();
        actualWatchers.add((User)object2);
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getCommentThreads();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            CommentThread thread = (CommentThread)iterator.next();
            object = thread;
            object2 = null;
            object2 = ((CommentThread)object).getReviewComments();
            Iterator<ReviewComment> iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                ReviewComment c = iterator2.next();
                object = c;
                object2 = null;
                object = object2 = ((ReviewComment)object).getAuthor();
                object2 = null;
                object2 = ((UserIdent)object).getId();
                User user = (User)User.find.byId(object2);
                if (user == null) continue;
                actualWatchers.add(user);
            }
        }
        return Watch.findActualWatchers(actualWatchers, this.asResource(), allowedWatchersOnly);
    }

    private String makeMergeCommitMessage(List<GitCommit> commits) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("Merge branch ");
        builder.append("'");
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getFromBranch();
        builder.append(Repository.shortenRefName((String)object2));
        builder.append("'");
        object = this;
        object2 = null;
        Object object3 = object2 = ((PullRequest)object).getFromProject();
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getToProject();
        if (!((Project)object3).equals(object2)) {
            builder.append(" of ");
            object = this;
            object2 = null;
            object = object2 = ((PullRequest)object).getFromProject();
            object2 = null;
            object2 = ((Project)object).getOwner();
            builder.append((String)object2);
            builder.append("/");
            object = this;
            object2 = null;
            object = object2 = ((PullRequest)object).getFromProject();
            object2 = null;
            object2 = ((Project)object).getName();
            builder.append((String)object2);
        }
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getToBranch();
        if (((String)object2).equals("refs/heads/master")) {
            builder.append("\n\n");
        } else {
            builder.append(" into ");
            builder.append("'");
            object = this;
            object2 = null;
            object2 = ((PullRequest)object).getToBranch();
            builder.append(Repository.shortenRefName((String)object2));
            builder.append("'");
            builder.append("\n\n");
        }
        builder.append("from pull-request ");
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getNumber();
        builder.append(object2);
        builder.append("\n\n");
        this.addCommitMessages(commits, builder);
        this.addReviewers(builder);
        return builder.toString();
    }

    private void addReviewers(StringBuilder builder) {
        Model model = this;
        Object object = null;
        object = model.getReviewers();
        Iterator<User> iterator = object.iterator();
        while (iterator.hasNext()) {
            User user = iterator.next();
            Object[] objectArray = new Object[2];
            model = user;
            object = null;
            objectArray[0] = object = model.getName();
            model = user;
            object = null;
            objectArray[1] = object = model.getEmail();
            builder.append(String.format("Reviewed-by: %s <%s>\n", objectArray));
        }
    }

    public List<String> getReviewerNames() {
        ArrayList<String> names = new ArrayList<String>();
        Model model = this;
        Object object = null;
        object = model.getReviewers();
        Iterator<User> iterator = object.iterator();
        while (iterator.hasNext()) {
            User user = iterator.next();
            model = user;
            object = null;
            object = model.getName();
            names.add((String)object);
        }
        return names;
    }

    private void addCommitMessages(List<GitCommit> commits, StringBuilder builder) {
        Object[] objectArray = new Object[1];
        PullRequest pullRequest2 = this;
        String string = null;
        string = pullRequest2.getFromBranch();
        objectArray[0] = Repository.shortenRefName((String)string);
        builder.append(String.format("* %s:\n", objectArray));
        for (GitCommit gitCommit : commits) {
            builder.append(String.format("  %s\n", gitCommit.getShortMessage()));
        }
        builder.append("\n");
    }

    private void changeState(State state) {
        this.changeState(state, UserApp.currentUser());
    }

    private void changeState(State state, User updater) {
        Object object = state;
        PullRequest pullRequest2 = this;
        pullRequest2.setState((State)((Object)object));
        object = JodaDateUtil.now();
        pullRequest2 = this;
        pullRequest2.setReceived((Date)object);
        object = updater;
        pullRequest2 = this;
        pullRequest2.setReceiver((User)object);
    }

    public void reopen() {
        this.changeState(State.OPEN);
        PushedBranch.removeByPullRequestFrom(this);
    }

    public void close() {
        this.changeState(State.CLOSED);
    }

    public static List<PullRequest> findByToProject(Project project2) {
        return finder.where().eq("toProject", (Object)project2).order().asc("created").findList();
    }

    public static List<PullRequest> findByFromProjectAndBranch(Project fromProject, String fromBranch) {
        return finder.where().eq("fromProject", (Object)fromProject).eq("fromBranch", (Object)fromBranch).or(Expr.eq((String)"state", (Object)((Object)State.OPEN)), Expr.eq((String)"state", (Object)((Object)State.REJECTED))).findList();
    }

    @Transactional
    public void save() {
        PullRequest pullRequest2 = this;
        Object object = null;
        object = pullRequest2.getToProject();
        object = PullRequest.nextPullRequestNumber((Project)object);
        pullRequest2 = this;
        pullRequest2.setNumber((Long)object);
        super.save();
        this.addNewIssueEvents();
    }

    public static long nextPullRequestNumber(Project project2) {
        PullRequest pullRequest2;
        Long l;
        PullRequest pullRequest3;
        PullRequest maxNumberedPullRequest;
        block3: {
            block2: {
                maxNumberedPullRequest = (PullRequest)finder.where().eq("toProject", (Object)project2).order().desc("number").setMaxRows(1).findUnique();
                if (maxNumberedPullRequest == null) break block2;
                pullRequest3 = maxNumberedPullRequest;
                l = null;
                l = pullRequest3.getNumber();
                if (l != null) break block3;
            }
            return 1L;
        }
        pullRequest3 = pullRequest2 = maxNumberedPullRequest;
        l = null;
        l = pullRequest3.getNumber();
        l = l + 1L;
        pullRequest3 = pullRequest2;
        pullRequest3.setNumber(l);
        return l;
    }

    public static PullRequest findOne(Project toProject, long number) {
        if (toProject == null || number <= 0L) {
            return null;
        }
        return (PullRequest)finder.where().eq("toProject", (Object)toProject).eq("number", (Object)number).findUnique();
    }

    @Transactional
    public static void regulateNumbers() {
        int nullNumberPullRequestCount = finder.where().eq("number", null).findRowCount();
        if (nullNumberPullRequestCount > 0) {
            List projects2 = Project.find.all();
            for (Project project2 : projects2) {
                List<PullRequest> pullRequests2 = PullRequest.findByToProject(project2);
                Iterator<PullRequest> iterator = pullRequests2.iterator();
                while (iterator.hasNext()) {
                    PullRequest pullRequest2;
                    PullRequest pullRequest3 = pullRequest2 = iterator.next();
                    Long l = null;
                    l = pullRequest3.getNumber();
                    if (l != null) continue;
                    l = PullRequest.nextPullRequestNumber(project2);
                    pullRequest3 = pullRequest2;
                    pullRequest3.setNumber(l);
                    pullRequest2.update();
                }
            }
        }
    }

    public List<FileDiff> getDiff() throws IOException {
        String string;
        PullRequest pullRequest2;
        block3: {
            block2: {
                pullRequest2 = this;
                string = null;
                string = pullRequest2.getMergedCommitIdFrom();
                if (string == null) break block2;
                pullRequest2 = this;
                string = null;
                string = pullRequest2.getMergedCommitIdTo();
                if (string != null) break block3;
            }
            throw new IllegalStateException("No mergedCommitIdFrom or mergedCommitIdTo");
        }
        pullRequest2 = this;
        string = null;
        String string2 = string = pullRequest2.getMergedCommitIdFrom();
        pullRequest2 = this;
        string = null;
        string = pullRequest2.getMergedCommitIdTo();
        return this.getDiff(string2, string);
    }

    public Repository getRepository() throws IOException {
        if (this.repository == null) {
            PullRequest pullRequest2 = this;
            Project project2 = null;
            project2 = pullRequest2.getToProject();
            this.repository = new GitRepository(project2).getRepository();
        }
        return this.repository;
    }

    @Transient
    public List<FileDiff> getDiff(String revA, String revB) throws IOException {
        Repository repository = this.getRepository();
        return GitRepository.getDiff(repository, revA, repository, revB);
    }

    public static Page<PullRequest> findPagingList(PullRequestApp.SearchCondition condition) {
        PullRequestApp.SearchCondition searchCondition = condition;
        PullRequestApp.Category category2 = null;
        category2 = searchCondition.getCategory();
        searchCondition = condition;
        int n = 0;
        n = searchCondition.getPageNum();
        return PullRequest.createSearchExpressionList(condition).order().desc(category2.order()).findPagingList(15).getPage(n - 1);
    }

    public static int count(PullRequestApp.SearchCondition condition) {
        return PullRequest.createSearchExpressionList(condition).findRowCount();
    }

    private static ExpressionList<PullRequest> createSearchExpressionList(PullRequestApp.SearchCondition condition) {
        ExpressionList el = finder.where();
        Object object = condition;
        Object object2 = null;
        object2 = ((PullRequestApp.SearchCondition)object).getProject();
        if (object2 != null) {
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getCategory();
            String string = ((PullRequestApp.Category)((Object)object2)).project();
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getProject();
            el.eq(string, object2);
        }
        object = condition;
        object2 = null;
        object2 = ((PullRequestApp.SearchCondition)object).getOrganization();
        if (object2 != null) {
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getOrganization();
            List<Project> projects2 = ((Organization)object2).getVisibleProjects(UserApp.currentUser());
            ArrayList<String> projectsIds = new ArrayList<String>();
            for (Project project2 : projects2) {
                object = project2;
                object2 = null;
                object2 = ((Project)object).getId();
                projectsIds.add(((Long)object2).toString());
            }
            el.in("to_project_id", projectsIds);
            el.in("from_project_id", projectsIds);
        }
        object = condition;
        object2 = null;
        object2 = ((PullRequestApp.SearchCondition)object).getCategory();
        Expression state = PullRequest.createStateSearchExpression(((PullRequestApp.Category)((Object)object2)).states());
        if (state != null) {
            el.add(state);
        }
        object = condition;
        object2 = null;
        object2 = ((PullRequestApp.SearchCondition)object).getContributorId();
        if (object2 != null) {
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getContributorId();
            el.eq("contributor.id", object2);
        }
        object = condition;
        object2 = null;
        object2 = ((PullRequestApp.SearchCondition)object).getFilter();
        if (StringUtils.isNotBlank((CharSequence)object2)) {
            HashSet ids = new HashSet();
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getFilter();
            ids.addAll(el.query().copy().where().icontains("commentThreads.reviewComments.contents", (String)object2).findIds());
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getFilter();
            Expression expression = Expr.icontains((String)"pullRequestCommits.commitMessage", (String)object2);
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getFilter();
            ids.addAll(el.query().copy().where().eq("pullRequestCommits.state", (Object)PullRequestCommit.State.CURRENT).or(expression, Expr.icontains((String)"pullRequestCommits.commitId", (String)object2)).findIds());
            Junction junction = el.disjunction();
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getFilter();
            ExpressionList expressionList = junction.icontains("title", (String)object2);
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getFilter();
            ExpressionList expressionList2 = expressionList.icontains("body", (String)object2);
            object = condition;
            object2 = null;
            object2 = ((PullRequestApp.SearchCondition)object).getFilter();
            expressionList2.icontains("mergedCommitIdTo", (String)object2);
            if (!ids.isEmpty()) {
                junction.in("id", ids);
            }
            junction.endJunction();
        }
        return el;
    }

    private static Expression createStateSearchExpression(State[] states) {
        int stateCount = ArrayUtils.getLength((Object)states);
        switch (stateCount) {
            case 0: {
                return null;
            }
            case 1: {
                return Expr.eq((String)"state", (Object)((Object)states[0]));
            }
        }
        return Expr.in((String)"state", (Object[])states);
    }

    private void addNewIssueEvents() {
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getTitle();
        StringBuilder stringBuilder = new StringBuilder().append((String)object2);
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getBody();
        String string = stringBuilder.append((String)object2).toString();
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getToProject();
        Set<Issue> referredIsseus = IssueEvent.findReferredIssue(string, (Project)object2);
        object = this;
        object2 = null;
        object2 = ((PullRequest)object).getId();
        String newValue = ((Long)object2).toString();
        for (Issue issue2 : referredIsseus) {
            IssueEvent issueEvent = new IssueEvent();
            object2 = issue2;
            object = issueEvent;
            ((IssueEvent)object).setIssue((Issue)object2);
            object = this;
            object2 = null;
            object = object2 = ((PullRequest)object).getContributor();
            object2 = null;
            object2 = ((User)object).getLoginId();
            object = issueEvent;
            ((IssueEvent)object).setSenderLoginId((String)object2);
            object2 = newValue;
            object = issueEvent;
            ((IssueEvent)object).setNewValue((String)object2);
            object2 = new Date();
            object = issueEvent;
            ((IssueEvent)object).setCreated((Date)object2);
            object2 = EventType.ISSUE_REFERRED_FROM_PULL_REQUEST;
            object = issueEvent;
            ((IssueEvent)object).setEventType((EventType)((Object)object2));
            issueEvent.save();
        }
    }

    public void deleteIssueEvents() {
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getId();
        String newValue = ((Long)object2).toString();
        object = this;
        object2 = null;
        object = object2 = ((PullRequest)object).getContributor();
        object2 = null;
        object2 = ((User)object).getLoginId();
        List oldEvents = IssueEvent.find.where().eq("newValue", (Object)newValue).eq("senderLoginId", object2).eq("eventType", (Object)EventType.ISSUE_REFERRED_FROM_PULL_REQUEST).findList();
        for (IssueEvent event : oldEvents) {
            event.delete();
        }
    }

    public void delete() {
        this.deleteIssueEvents();
        super.delete();
    }

    @Transient
    public List<CommitComment> getCommitComments() {
        PullRequest pullRequest2 = this;
        Object object = null;
        object = pullRequest2.getFromProject();
        Project project2 = object;
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getPullRequestCommits();
        return CommitComment.findByCommits(project2, (List<PullRequestCommit>)object);
    }

    @Transient
    public List<PullRequestCommit> getCurrentCommits() {
        return PullRequestCommit.getCurrentCommits(this);
    }

    private FetchResult fetchSourceBranchTo(String destination) throws IOException, GitAPIException {
        PullRequest pullRequest2 = this;
        Object object = null;
        object = pullRequest2.getFromProject();
        FetchCommand fetchCommand = new Git(this.getRepository()).fetch().setRemote(GitRepository.getGitDirectoryURL((Project)object));
        RefSpec[] refSpecArray = new RefSpec[1];
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getFromBranch();
        refSpecArray[0] = new RefSpec().setSource((String)object).setDestination(destination).setForceUpdate(true);
        return fetchCommand.setRefSpecs(refSpecArray).call();
    }

    public PullRequestMergeResult updateMerge() throws IOException, GitAPIException, PullRequestException {
        PullRequest pullRequest2 = this;
        Object object = null;
        object = pullRequest2.getId();
        if (object == null) {
            throw new IllegalStateException("id must not be null");
        }
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getToBranch();
        Merger.MergeResult mergeResult2 = new Merger((String)object, this.fetchSourceBranch()).merge();
        PullRequestMergeResult pullRequestMergeResult = new PullRequestMergeResult();
        pullRequestMergeResult.setPullRequest(this);
        if (mergeResult2 instanceof Merger.Conflict) {
            pullRequestMergeResult.setConflictStateOfPullRequest();
        } else {
            mergeResult2.createCommit().updateRef(this.getNameOfRefToMerged());
            pullRequestMergeResult.setResolvedStateOfPullRequest();
            this.updateMergedCommitId(mergeResult2);
        }
        pullRequestMergeResult.setGitCommits(GitRepository.diffCommits(this.getRepository(), mergeResult2.getLeftParentId(), mergeResult2.getRightParentId()));
        return pullRequestMergeResult;
    }

    public String getRefNameToFetchedSource() {
        PullRequest pullRequest2 = this;
        Long l = null;
        l = pullRequest2.getId();
        return "refs/yobi/pull/" + l + "/head";
    }

    public String getNameOfRefToMerged() {
        PullRequest pullRequest2 = this;
        Long l = null;
        l = pullRequest2.getId();
        return "refs/yobi/pull/" + l + "/merged";
    }

    public String fetchSourceTemporarilly() throws IOException, GitAPIException {
        Object[] objectArray = new Object[3];
        Object object = this;
        Object object2 = null;
        object = object2 = ((PullRequest)object).getFromProject();
        object2 = null;
        objectArray[0] = object2 = ((Project)object).getOwner();
        object = this;
        object2 = null;
        object = object2 = ((PullRequest)object).getFromProject();
        object2 = null;
        objectArray[1] = object2 = ((Project)object).getName();
        object = this;
        object2 = null;
        objectArray[2] = object2 = ((PullRequest)object).getFromBranch();
        String tempBranchToCheckConflict = String.format("refs/yobi/pull-check/%s/%s/%s", objectArray);
        this.fetchSourceBranchTo(tempBranchToCheckConflict);
        return tempBranchToCheckConflict;
    }

    public PullRequestMergeResult attemptMerge() throws IOException, GitAPIException {
        String tempBranchToCheckConflict = this.fetchSourceTemporarilly();
        PullRequest pullRequest2 = this;
        String string = null;
        string = pullRequest2.getToBranch();
        Merger.MergeResult mergeResult2 = new Merger(string, tempBranchToCheckConflict).merge();
        PullRequestMergeResult pullRequestMergeResult = new PullRequestMergeResult();
        pullRequestMergeResult.setPullRequest(this);
        if (mergeResult2.conflicts()) {
            pullRequestMergeResult.setConflictStateOfPullRequest();
        } else {
            pullRequestMergeResult.setResolvedStateOfPullRequest();
        }
        pullRequestMergeResult.setGitCommits(GitRepository.diffCommits(this.getRepository(), mergeResult2.getLeftParentId(), mergeResult2.getRightParentId()));
        RefUpdate refUpdate = this.getRepository().updateRef(tempBranchToCheckConflict);
        refUpdate.setForceUpdate(true);
        refUpdate.delete();
        return pullRequestMergeResult;
    }

    public void startMerge() {
        Boolean bl = true;
        PullRequest pullRequest2 = this;
        pullRequest2.setIsMerging(bl);
    }

    public void endMerge() {
        Boolean bl = false;
        PullRequest pullRequest2 = this;
        pullRequest2.setIsMerging(bl);
    }

    public PullRequestMergeResult getPullRequestMergeResult() throws IOException, GitAPIException {
        PullRequestMergeResult mergeResult2 = null;
        PullRequest pullRequest2 = this;
        String string = null;
        string = pullRequest2.getFromBranch();
        if (!StringUtils.isEmpty((CharSequence)string)) {
            pullRequest2 = this;
            string = null;
            string = pullRequest2.getToBranch();
            if (!StringUtils.isEmpty((CharSequence)string)) {
                mergeResult2 = this.attemptMerge();
                Map<String, String> suggestText = this.suggestTitleAndBodyFromDiffCommit(mergeResult2.getGitCommits());
                string = suggestText.get("title");
                pullRequest2 = this;
                pullRequest2.setTitle(string);
                string = suggestText.get("body");
                pullRequest2 = this;
                pullRequest2.setBody(string);
            }
        }
        return mergeResult2;
    }

    private Map<String, String> suggestTitleAndBodyFromDiffCommit(List<GitCommit> commits) {
        HashMap<String, String> messageMap = new HashMap<String, String>();
        if (commits.isEmpty()) {
            return messageMap;
        }
        if (commits.size() == 1) {
            String message = commits.get(0).getMessage();
            String[] messages = message.split("\n");
            if (messages.length > 1) {
                Object[] msgs = Arrays.copyOfRange(messages, 1, messages.length);
                messageMap.put("title", messages[0]);
                messageMap.put("body", StringUtils.join((Object[])msgs, (String)"\n").trim());
            } else {
                messageMap.put("title", messages[0]);
                messageMap.put("body", "");
            }
        } else {
            Object[] firstMessages = new String[commits.size()];
            for (int i = 0; i < commits.size(); ++i) {
                String[] messages = commits.get(i).getMessage().split("\n");
                firstMessages[i] = messages[0];
            }
            messageMap.put("body", StringUtils.join((Object[])firstMessages, (String)"\n"));
        }
        return messageMap;
    }

    public static PullRequest findTheLatestOneFrom(Project fromProject, String fromBranch) {
        ExpressionList el = finder.where().eq("fromProject", (Object)fromProject).eq("fromBranch", (Object)fromBranch);
        if (fromProject.isForkedFromOrigin()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = fromProject;
            Project project2 = fromProject;
            Project project3 = null;
            project3 = project2.getOriginalProject();
            objectArray[1] = project3;
            el.in("toProject", objectArray);
        } else {
            el.eq("toProject", (Object)fromProject);
        }
        return (PullRequest)el.order().desc("number").setMaxRows(1).findUnique();
    }

    public static void changeStateToClosed() {
        List rejectedPullRequests = finder.where().eq("state", (Object)State.REJECTED).findList();
        for (PullRequest rejectedPullRequest : rejectedPullRequests) {
            Object object = State.CLOSED;
            PullRequest pullRequest2 = rejectedPullRequest;
            pullRequest2.setState((State)((Object)object));
            object = JodaDateUtil.now();
            pullRequest2 = rejectedPullRequest;
            pullRequest2.setReceived((Date)object);
            rejectedPullRequest.update();
        }
    }

    public void clearReviewers() {
        HashSet<User> hashSet = new HashSet<User>();
        PullRequest pullRequest2 = this;
        pullRequest2.setReviewers(hashSet);
        this.update();
    }

    public int getRequiredReviewerCount() {
        Model model = this;
        Object object = null;
        object = model.getToProject();
        model = object;
        object = null;
        object = model.getDefaultReviewerCount();
        return (Integer)object;
    }

    public void addReviewer(User user) {
        PullRequest pullRequest2 = this;
        Set<User> set = null;
        set = pullRequest2.getReviewers();
        if (set.add(user)) {
            this.update();
        }
    }

    public void removeReviewer(User user) {
        PullRequest pullRequest2 = this;
        Set<User> set = null;
        set = pullRequest2.getReviewers();
        set.remove(user);
        this.update();
    }

    public boolean isReviewedBy(User user) {
        PullRequest pullRequest2 = this;
        Set<User> set = null;
        set = pullRequest2.getReviewers();
        return set.contains(user);
    }

    public boolean isReviewed() {
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getReviewers();
        int n = object2.size();
        object = this;
        object2 = null;
        object = object2 = ((PullRequest)object).getToProject();
        object2 = null;
        object2 = ((Project)object).getDefaultReviewerCount();
        return n >= (Integer)object2;
    }

    public int getLackingReviewerCount() {
        Model model = this;
        Set<User> set = null;
        set = model.getToProject();
        model = set;
        set = null;
        set = model.getDefaultReviewerCount();
        int n = (Integer)((Object)set);
        model = this;
        set = null;
        set = model.getReviewers();
        return n - set.size();
    }

    public List<CodeCommentThread> getCodeCommentThreadsForChanges(String commitId) throws IOException, GitAPIException {
        ArrayList<CodeCommentThread> result2 = new ArrayList<CodeCommentThread>();
        Object object = this;
        Object object2 = null;
        object2 = ((PullRequest)object).getCommentThreads();
        Iterator<CommentThread> iterator = object2.iterator();
        while (iterator.hasNext()) {
            CommentThread commentThread = iterator.next();
            if (!(commentThread instanceof CodeCommentThread)) continue;
            CodeCommentThread codeCommentThread = (CodeCommentThread)commentThread;
            if (commitId != null) {
                object = codeCommentThread;
                object2 = null;
                object2 = ((CodeCommentThread)object).getCommitId();
                if (!((String)object2).equals(commitId)) continue;
                result2.add(codeCommentThread);
                continue;
            }
            if (codeCommentThread.isCommitComment()) continue;
            object = this;
            object2 = null;
            Object object3 = object2 = ((PullRequest)object).getMergedCommitIdFrom();
            object = codeCommentThread;
            object2 = null;
            object2 = ((CodeCommentThread)object).getPrevCommitId();
            if (((String)object3).equals(object2)) {
                object = this;
                object2 = null;
                Object object4 = object2 = ((PullRequest)object).getMergedCommitIdTo();
                object = codeCommentThread;
                object2 = null;
                object2 = ((CodeCommentThread)object).getCommitId();
                if (((String)object4).equals(object2)) {
                    result2.add(codeCommentThread);
                    continue;
                }
            }
            Repository repository = this.getRepository();
            object = this;
            object2 = null;
            Object object5 = object2 = ((PullRequest)object).getMergedCommitIdFrom();
            object = codeCommentThread;
            object2 = null;
            Object object6 = object2 = ((CodeCommentThread)object).getPrevCommitId();
            object = codeCommentThread;
            object2 = null;
            object = object2 = ((CodeCommentThread)object).getCodeRange();
            object2 = null;
            object2 = ((CodeRange)object).getPath();
            if (!PullRequest.noChangesBetween(repository, (String)object5, repository, (String)object6, (String)object2)) continue;
            object = this;
            object2 = null;
            Object object7 = object2 = ((PullRequest)object).getMergedCommitIdTo();
            object = codeCommentThread;
            object2 = null;
            Object object8 = object2 = ((CodeCommentThread)object).getCommitId();
            object = codeCommentThread;
            object2 = null;
            object = object2 = ((CodeCommentThread)object).getCodeRange();
            object2 = null;
            object2 = ((CodeRange)object).getPath();
            if (!PullRequest.noChangesBetween(repository, (String)object7, repository, (String)object8, (String)object2)) continue;
            result2.add(codeCommentThread);
        }
        return result2;
    }

    public List<CommentThread> getCommentThreadsByState(CommentThread.ThreadState state) {
        ArrayList<CommentThread> result2 = new ArrayList<CommentThread>();
        Model model = this;
        Object object = null;
        object = model.getCommentThreads();
        for (CommentThread commentThread : object) {
            model = commentThread;
            object = null;
            object = model.getState();
            if (object != state) continue;
            result2.add(commentThread);
        }
        return result2;
    }

    public int countCommentThreadsByState(CommentThread.ThreadState state) {
        Integer count = 0;
        Model model = this;
        Object object = null;
        object = model.getCommentThreads();
        for (CommentThread commentThread : object) {
            model = commentThread;
            object = null;
            object = model.getState();
            if (object != state) continue;
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    public List<FileDiff> getDiff(String commitId) throws IOException {
        if (commitId == null) {
            return this.getDiff();
        }
        return GitRepository.getDiff(this.getRepository(), commitId);
    }

    public void removeCommentThread(CommentThread commentThread) {
        Model model = this;
        List<CommentThread> list2 = null;
        list2 = model.getCommentThreads();
        list2.remove(commentThread);
        list2 = null;
        model = commentThread;
        model.setPullRequest((PullRequest)((Object)list2));
    }

    public void addCommentThread(CommentThread thread) {
        Model model = this;
        Object object = null;
        object = model.getCommentThreads();
        object.add((CommentThread)thread);
        object = this;
        model = thread;
        model.setPullRequest((PullRequest)object);
    }

    public static boolean noChangesBetween(Repository repoA, String rev1, Repository repoB, String rev2, String path) throws IOException {
        ObjectId a = PullRequest.getBlobId(repoA, rev1, path);
        ObjectId b = PullRequest.getBlobId(repoB, rev2, path);
        return ObjectUtils.equals((Object)a, (Object)b);
    }

    private static ObjectId getBlobId(Repository repo, String rev, String path) throws IOException {
        if (StringUtils.isEmpty((CharSequence)rev)) {
            throw new IllegalArgumentException("rev must not be empty");
        }
        RevTree tree = new RevWalk(repo).parseTree((AnyObjectId)repo.resolve(rev));
        TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)path, (RevTree)tree);
        if (tw == null) {
            return null;
        }
        return tw.getObjectId(0);
    }

    public String getMessageForDisabledAcceptButton() {
        PullRequest pullRequest2 = this;
        Boolean bl = null;
        bl = pullRequest2.getIsMerging();
        if (bl.booleanValue()) {
            return Messages.get((String)"pullRequest.not.acceptable.because.is.merging", (Object[])new Object[0]);
        }
        pullRequest2 = this;
        bl = null;
        bl = pullRequest2.getIsConflict();
        if (bl.booleanValue()) {
            return Messages.get((String)"pullRequest.not.acceptable.because.is.conflict", (Object[])new Object[0]);
        }
        if (!this.isOpen()) {
            return Messages.get((String)"pullRequest.not.acceptable.because.is.not.open", (Object[])new Object[0]);
        }
        return Messages.get((String)"pullRequest.not.acceptable.because.is.not.enough.review.point", (Object[])new Object[]{this.getLackingReviewerCount()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDiffable() {
        PullRequest pullRequest2 = this;
        Object object = null;
        object = pullRequest2.getIsConflict();
        if (((Boolean)object).booleanValue()) return false;
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getMergedCommitIdFrom();
        if (object == null) return false;
        pullRequest2 = this;
        object = null;
        object = pullRequest2.getMergedCommitIdTo();
        if (object == null) return false;
        return true;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getTitle() {
        return this._ebean_get_title();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTitle(String string) {
        this._ebean_set_title(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getBody() {
        return this._ebean_get_body();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setBody(String string) {
        this._ebean_set_body(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getToProjectId() {
        return this.toProjectId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setToProjectId(Long l) {
        this.toProjectId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getFromProjectId() {
        return this.fromProjectId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFromProjectId(Long l) {
        this.fromProjectId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getToProject() {
        return this._ebean_get_toProject();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setToProject(Project project2) {
        this._ebean_set_toProject(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getFromProject() {
        return this._ebean_get_fromProject();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFromProject(Project project2) {
        this._ebean_set_fromProject(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getToBranch() {
        return this._ebean_get_toBranch();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setToBranch(String string) {
        this._ebean_set_toBranch(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getFromBranch() {
        return this._ebean_get_fromBranch();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFromBranch(String string) {
        this._ebean_set_fromBranch(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public User getContributor() {
        return this._ebean_get_contributor();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setContributor(User user) {
        this._ebean_set_contributor(user);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public User getReceiver() {
        return this._ebean_get_receiver();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setReceiver(User user) {
        this._ebean_set_receiver(user);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreated() {
        return this._ebean_get_created();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreated(Date date) {
        this._ebean_set_created(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getUpdated() {
        return this._ebean_get_updated();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUpdated(Date date) {
        this._ebean_set_updated(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getReceived() {
        return this._ebean_get_received();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setReceived(Date date) {
        this._ebean_set_received(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public State getState() {
        return this._ebean_get_state();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setState(State state) {
        this._ebean_set_state(state);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Boolean getIsConflict() {
        return this._ebean_get_isConflict();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsConflict(Boolean bl) {
        this._ebean_set_isConflict(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Boolean getIsMerging() {
        return this._ebean_get_isMerging();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsMerging(Boolean bl) {
        this._ebean_set_isMerging(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<PullRequestCommit> getPullRequestCommits() {
        return this._ebean_get_pullRequestCommits();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPullRequestCommits(List<PullRequestCommit> list2) {
        this._ebean_set_pullRequestCommits(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<PullRequestEvent> getPullRequestEvents() {
        return this._ebean_get_pullRequestEvents();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPullRequestEvents(List<PullRequestEvent> list2) {
        this._ebean_set_pullRequestEvents(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getLastCommitId() {
        return this._ebean_get_lastCommitId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLastCommitId(String string) {
        this._ebean_set_lastCommitId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getMergedCommitIdFrom() {
        return this._ebean_get_mergedCommitIdFrom();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMergedCommitIdFrom(String string) {
        this._ebean_set_mergedCommitIdFrom(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getMergedCommitIdTo() {
        return this._ebean_get_mergedCommitIdTo();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMergedCommitIdTo(String string) {
        this._ebean_set_mergedCommitIdTo(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getNumber() {
        return this._ebean_get_number();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNumber(Long l) {
        this._ebean_set_number(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<User> getReviewers() {
        return this._ebean_get_reviewers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setReviewers(Set<User> set) {
        this._ebean_set_reviewers(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<CommentThread> getCommentThreads() {
        return this._ebean_get_commentThreads();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCommentThreads(List<CommentThread> list2) {
        this._ebean_set_commentThreads(list2);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_title() {
        this._ebean_intercept.preGetter("title");
        return this.title;
    }

    protected void _ebean_set_title(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "title", (Object)this._ebean_get_title(), (Object)newValue);
        this.title = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_title() {
        return this.title;
    }

    protected void _ebean_setni_title(String _newValue) {
        this.title = _newValue;
    }

    protected String _ebean_get_body() {
        this._ebean_intercept.preGetter("body");
        return this.body;
    }

    protected void _ebean_set_body(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "body", (Object)this._ebean_get_body(), (Object)newValue);
        this.body = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_body() {
        return this.body;
    }

    protected void _ebean_setni_body(String _newValue) {
        this.body = _newValue;
    }

    protected Long _ebean_get_toProjectId() {
        return this.toProjectId;
    }

    protected void _ebean_set_toProjectId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "toProjectId", (Object)this._ebean_get_toProjectId(), (Object)newValue);
        this.toProjectId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_toProjectId() {
        return this.toProjectId;
    }

    protected void _ebean_setni_toProjectId(Long _newValue) {
        this.toProjectId = _newValue;
    }

    protected Long _ebean_get_fromProjectId() {
        return this.fromProjectId;
    }

    protected void _ebean_set_fromProjectId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "fromProjectId", (Object)this._ebean_get_fromProjectId(), (Object)newValue);
        this.fromProjectId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_fromProjectId() {
        return this.fromProjectId;
    }

    protected void _ebean_setni_fromProjectId(Long _newValue) {
        this.fromProjectId = _newValue;
    }

    protected Project _ebean_get_toProject() {
        this._ebean_intercept.preGetter("toProject");
        return this.toProject;
    }

    protected void _ebean_set_toProject(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "toProject", (Object)this._ebean_get_toProject(), (Object)newValue);
        this.toProject = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_toProject() {
        return this.toProject;
    }

    protected void _ebean_setni_toProject(Project _newValue) {
        this.toProject = _newValue;
    }

    protected Project _ebean_get_fromProject() {
        this._ebean_intercept.preGetter("fromProject");
        return this.fromProject;
    }

    protected void _ebean_set_fromProject(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "fromProject", (Object)this._ebean_get_fromProject(), (Object)newValue);
        this.fromProject = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_fromProject() {
        return this.fromProject;
    }

    protected void _ebean_setni_fromProject(Project _newValue) {
        this.fromProject = _newValue;
    }

    protected String _ebean_get_toBranch() {
        this._ebean_intercept.preGetter("toBranch");
        return this.toBranch;
    }

    protected void _ebean_set_toBranch(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "toBranch", (Object)this._ebean_get_toBranch(), (Object)newValue);
        this.toBranch = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_toBranch() {
        return this.toBranch;
    }

    protected void _ebean_setni_toBranch(String _newValue) {
        this.toBranch = _newValue;
    }

    protected String _ebean_get_fromBranch() {
        this._ebean_intercept.preGetter("fromBranch");
        return this.fromBranch;
    }

    protected void _ebean_set_fromBranch(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "fromBranch", (Object)this._ebean_get_fromBranch(), (Object)newValue);
        this.fromBranch = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_fromBranch() {
        return this.fromBranch;
    }

    protected void _ebean_setni_fromBranch(String _newValue) {
        this.fromBranch = _newValue;
    }

    protected User _ebean_get_contributor() {
        this._ebean_intercept.preGetter("contributor");
        return this.contributor;
    }

    protected void _ebean_set_contributor(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "contributor", (Object)this._ebean_get_contributor(), (Object)newValue);
        this.contributor = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_contributor() {
        return this.contributor;
    }

    protected void _ebean_setni_contributor(User _newValue) {
        this.contributor = _newValue;
    }

    protected User _ebean_get_receiver() {
        this._ebean_intercept.preGetter("receiver");
        return this.receiver;
    }

    protected void _ebean_set_receiver(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "receiver", (Object)this._ebean_get_receiver(), (Object)newValue);
        this.receiver = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_receiver() {
        return this.receiver;
    }

    protected void _ebean_setni_receiver(User _newValue) {
        this.receiver = _newValue;
    }

    protected Date _ebean_get_created() {
        this._ebean_intercept.preGetter("created");
        return this.created;
    }

    protected void _ebean_set_created(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "created", (Object)this._ebean_get_created(), (Object)newValue);
        this.created = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_created() {
        return this.created;
    }

    protected void _ebean_setni_created(Date _newValue) {
        this.created = _newValue;
    }

    protected Date _ebean_get_updated() {
        this._ebean_intercept.preGetter("updated");
        return this.updated;
    }

    protected void _ebean_set_updated(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "updated", (Object)this._ebean_get_updated(), (Object)newValue);
        this.updated = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_updated() {
        return this.updated;
    }

    protected void _ebean_setni_updated(Date _newValue) {
        this.updated = _newValue;
    }

    protected Date _ebean_get_received() {
        this._ebean_intercept.preGetter("received");
        return this.received;
    }

    protected void _ebean_set_received(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "received", (Object)this._ebean_get_received(), (Object)newValue);
        this.received = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_received() {
        return this.received;
    }

    protected void _ebean_setni_received(Date _newValue) {
        this.received = _newValue;
    }

    protected State _ebean_get_state() {
        this._ebean_intercept.preGetter("state");
        return this.state;
    }

    protected void _ebean_set_state(State newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "state", (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected State _ebean_getni_state() {
        return this.state;
    }

    protected void _ebean_setni_state(State _newValue) {
        this.state = _newValue;
    }

    protected Boolean _ebean_get_isConflict() {
        this._ebean_intercept.preGetter("isConflict");
        return this.isConflict;
    }

    protected void _ebean_set_isConflict(Boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "isConflict", (Object)this._ebean_get_isConflict(), (Object)newValue);
        this.isConflict = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Boolean _ebean_getni_isConflict() {
        return this.isConflict;
    }

    protected void _ebean_setni_isConflict(Boolean _newValue) {
        this.isConflict = _newValue;
    }

    protected Boolean _ebean_get_isMerging() {
        this._ebean_intercept.preGetter("isMerging");
        return this.isMerging;
    }

    protected void _ebean_set_isMerging(Boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "isMerging", (Object)this._ebean_get_isMerging(), (Object)newValue);
        this.isMerging = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Boolean _ebean_getni_isMerging() {
        return this.isMerging;
    }

    protected void _ebean_setni_isMerging(Boolean _newValue) {
        this.isMerging = _newValue;
    }

    protected List _ebean_get_pullRequestCommits() {
        this._ebean_intercept.preGetter("pullRequestCommits");
        if (this.pullRequestCommits == null) {
            this.pullRequestCommits = new BeanList();
        }
        return this.pullRequestCommits;
    }

    protected void _ebean_set_pullRequestCommits(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "pullRequestCommits", (Object)this._ebean_get_pullRequestCommits(), (Object)newValue);
        this.pullRequestCommits = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_pullRequestCommits() {
        return this.pullRequestCommits;
    }

    protected void _ebean_setni_pullRequestCommits(List _newValue) {
        this.pullRequestCommits = _newValue;
    }

    protected List _ebean_get_pullRequestEvents() {
        this._ebean_intercept.preGetter("pullRequestEvents");
        if (this.pullRequestEvents == null) {
            this.pullRequestEvents = new BeanList();
        }
        return this.pullRequestEvents;
    }

    protected void _ebean_set_pullRequestEvents(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "pullRequestEvents", (Object)this._ebean_get_pullRequestEvents(), (Object)newValue);
        this.pullRequestEvents = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_pullRequestEvents() {
        return this.pullRequestEvents;
    }

    protected void _ebean_setni_pullRequestEvents(List _newValue) {
        this.pullRequestEvents = _newValue;
    }

    protected String _ebean_get_lastCommitId() {
        this._ebean_intercept.preGetter("lastCommitId");
        return this.lastCommitId;
    }

    protected void _ebean_set_lastCommitId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "lastCommitId", (Object)this._ebean_get_lastCommitId(), (Object)newValue);
        this.lastCommitId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_lastCommitId() {
        return this.lastCommitId;
    }

    protected void _ebean_setni_lastCommitId(String _newValue) {
        this.lastCommitId = _newValue;
    }

    protected String _ebean_get_mergedCommitIdFrom() {
        this._ebean_intercept.preGetter("mergedCommitIdFrom");
        return this.mergedCommitIdFrom;
    }

    protected void _ebean_set_mergedCommitIdFrom(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "mergedCommitIdFrom", (Object)this._ebean_get_mergedCommitIdFrom(), (Object)newValue);
        this.mergedCommitIdFrom = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_mergedCommitIdFrom() {
        return this.mergedCommitIdFrom;
    }

    protected void _ebean_setni_mergedCommitIdFrom(String _newValue) {
        this.mergedCommitIdFrom = _newValue;
    }

    protected String _ebean_get_mergedCommitIdTo() {
        this._ebean_intercept.preGetter("mergedCommitIdTo");
        return this.mergedCommitIdTo;
    }

    protected void _ebean_set_mergedCommitIdTo(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "mergedCommitIdTo", (Object)this._ebean_get_mergedCommitIdTo(), (Object)newValue);
        this.mergedCommitIdTo = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_mergedCommitIdTo() {
        return this.mergedCommitIdTo;
    }

    protected void _ebean_setni_mergedCommitIdTo(String _newValue) {
        this.mergedCommitIdTo = _newValue;
    }

    protected Long _ebean_get_number() {
        this._ebean_intercept.preGetter("number");
        return this.number;
    }

    protected void _ebean_set_number(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "number", (Object)this._ebean_get_number(), (Object)newValue);
        this.number = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_number() {
        return this.number;
    }

    protected void _ebean_setni_number(Long _newValue) {
        this.number = _newValue;
    }

    protected Set _ebean_get_reviewers() {
        this._ebean_intercept.preGetter("reviewers");
        if (this.reviewers == null) {
            this.reviewers = new BeanSet();
            ((BeanCollection)this.reviewers).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.reviewers;
    }

    protected void _ebean_set_reviewers(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "reviewers", (Object)this._ebean_get_reviewers(), (Object)newValue);
        this.reviewers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_reviewers() {
        return this.reviewers;
    }

    protected void _ebean_setni_reviewers(Set _newValue) {
        this.reviewers = _newValue;
    }

    protected List _ebean_get_commentThreads() {
        this._ebean_intercept.preGetter("commentThreads");
        if (this.commentThreads == null) {
            this.commentThreads = new BeanList();
        }
        return this.commentThreads;
    }

    protected void _ebean_set_commentThreads(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "commentThreads", (Object)this._ebean_get_commentThreads(), (Object)newValue);
        this.commentThreads = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_commentThreads() {
        return this.commentThreads;
    }

    protected void _ebean_setni_commentThreads(List _newValue) {
        this.commentThreads = _newValue;
    }

    protected Repository _ebean_get_repository() {
        return this.repository;
    }

    protected void _ebean_set_repository(Repository newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "repository", (Object)this._ebean_get_repository(), (Object)newValue);
        this.repository = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Repository _ebean_getni_repository() {
        return this.repository;
    }

    protected void _ebean_setni_repository(Repository _newValue) {
        this.repository = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        PullRequest pullRequest2 = new PullRequest();
        pullRequest2.id = this.id;
        pullRequest2.title = this.title;
        pullRequest2.body = this.body;
        pullRequest2.toProject = this.toProject;
        pullRequest2.fromProject = this.fromProject;
        pullRequest2.toBranch = this.toBranch;
        pullRequest2.fromBranch = this.fromBranch;
        pullRequest2.contributor = this.contributor;
        pullRequest2.receiver = this.receiver;
        pullRequest2.created = this.created;
        pullRequest2.updated = this.updated;
        pullRequest2.received = this.received;
        pullRequest2.state = this.state;
        pullRequest2.isConflict = this.isConflict;
        pullRequest2.isMerging = this.isMerging;
        pullRequest2.pullRequestCommits = this.pullRequestCommits;
        pullRequest2.pullRequestEvents = this.pullRequestEvents;
        pullRequest2.lastCommitId = this.lastCommitId;
        pullRequest2.mergedCommitIdFrom = this.mergedCommitIdFrom;
        pullRequest2.mergedCommitIdTo = this.mergedCommitIdTo;
        pullRequest2.number = this.number;
        pullRequest2.reviewers = this.reviewers;
        pullRequest2.commentThreads = this.commentThreads;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        PullRequest p = (PullRequest)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.title;
            }
            case 3: {
                return p.body;
            }
            case 4: {
                return p.toProjectId;
            }
            case 5: {
                return p.fromProjectId;
            }
            case 6: {
                return p.toProject;
            }
            case 7: {
                return p.fromProject;
            }
            case 8: {
                return p.toBranch;
            }
            case 9: {
                return p.fromBranch;
            }
            case 10: {
                return p.contributor;
            }
            case 11: {
                return p.receiver;
            }
            case 12: {
                return p.created;
            }
            case 13: {
                return p.updated;
            }
            case 14: {
                return p.received;
            }
            case 15: {
                return p.state;
            }
            case 16: {
                return p.isConflict;
            }
            case 17: {
                return p.isMerging;
            }
            case 18: {
                return p.pullRequestCommits;
            }
            case 19: {
                return p.pullRequestEvents;
            }
            case 20: {
                return p.lastCommitId;
            }
            case 21: {
                return p.mergedCommitIdFrom;
            }
            case 22: {
                return p.mergedCommitIdTo;
            }
            case 23: {
                return p.number;
            }
            case 24: {
                return p.reviewers;
            }
            case 25: {
                return p.commentThreads;
            }
            case 26: {
                return p.repository;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        PullRequest p = (PullRequest)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_title();
            }
            case 3: {
                return p._ebean_get_body();
            }
            case 4: {
                return p._ebean_get_toProjectId();
            }
            case 5: {
                return p._ebean_get_fromProjectId();
            }
            case 6: {
                return p._ebean_get_toProject();
            }
            case 7: {
                return p._ebean_get_fromProject();
            }
            case 8: {
                return p._ebean_get_toBranch();
            }
            case 9: {
                return p._ebean_get_fromBranch();
            }
            case 10: {
                return p._ebean_get_contributor();
            }
            case 11: {
                return p._ebean_get_receiver();
            }
            case 12: {
                return p._ebean_get_created();
            }
            case 13: {
                return p._ebean_get_updated();
            }
            case 14: {
                return p._ebean_get_received();
            }
            case 15: {
                return p._ebean_get_state();
            }
            case 16: {
                return p._ebean_get_isConflict();
            }
            case 17: {
                return p._ebean_get_isMerging();
            }
            case 18: {
                return p._ebean_get_pullRequestCommits();
            }
            case 19: {
                return p._ebean_get_pullRequestEvents();
            }
            case 20: {
                return p._ebean_get_lastCommitId();
            }
            case 21: {
                return p._ebean_get_mergedCommitIdFrom();
            }
            case 22: {
                return p._ebean_get_mergedCommitIdTo();
            }
            case 23: {
                return p._ebean_get_number();
            }
            case 24: {
                return p._ebean_get_reviewers();
            }
            case 25: {
                return p._ebean_get_commentThreads();
            }
            case 26: {
                return p._ebean_get_repository();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        PullRequest p = (PullRequest)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.title = (String)arg;
                return;
            }
            case 3: {
                p.body = (String)arg;
                return;
            }
            case 4: {
                p.toProjectId = (Long)arg;
                return;
            }
            case 5: {
                p.fromProjectId = (Long)arg;
                return;
            }
            case 6: {
                p.toProject = (Project)arg;
                return;
            }
            case 7: {
                p.fromProject = (Project)arg;
                return;
            }
            case 8: {
                p.toBranch = (String)arg;
                return;
            }
            case 9: {
                p.fromBranch = (String)arg;
                return;
            }
            case 10: {
                p.contributor = (User)arg;
                return;
            }
            case 11: {
                p.receiver = (User)arg;
                return;
            }
            case 12: {
                p.created = (Date)arg;
                return;
            }
            case 13: {
                p.updated = (Date)arg;
                return;
            }
            case 14: {
                p.received = (Date)arg;
                return;
            }
            case 15: {
                p.state = (State)((Object)arg);
                return;
            }
            case 16: {
                p.isConflict = (Boolean)arg;
                return;
            }
            case 17: {
                p.isMerging = (Boolean)arg;
                return;
            }
            case 18: {
                p.pullRequestCommits = (List)arg;
                return;
            }
            case 19: {
                p.pullRequestEvents = (List)arg;
                return;
            }
            case 20: {
                p.lastCommitId = (String)arg;
                return;
            }
            case 21: {
                p.mergedCommitIdFrom = (String)arg;
                return;
            }
            case 22: {
                p.mergedCommitIdTo = (String)arg;
                return;
            }
            case 23: {
                p.number = (Long)arg;
                return;
            }
            case 24: {
                p.reviewers = (Set)arg;
                return;
            }
            case 25: {
                p.commentThreads = (List)arg;
                return;
            }
            case 26: {
                p.repository = (Repository)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        PullRequest p = (PullRequest)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_body((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_toProjectId((Long)arg);
                return;
            }
            case 5: {
                p._ebean_set_fromProjectId((Long)arg);
                return;
            }
            case 6: {
                p._ebean_set_toProject((Project)arg);
                return;
            }
            case 7: {
                p._ebean_set_fromProject((Project)arg);
                return;
            }
            case 8: {
                p._ebean_set_toBranch((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_fromBranch((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_contributor((User)arg);
                return;
            }
            case 11: {
                p._ebean_set_receiver((User)arg);
                return;
            }
            case 12: {
                p._ebean_set_created((Date)arg);
                return;
            }
            case 13: {
                p._ebean_set_updated((Date)arg);
                return;
            }
            case 14: {
                p._ebean_set_received((Date)arg);
                return;
            }
            case 15: {
                p._ebean_set_state((State)((Object)arg));
                return;
            }
            case 16: {
                p._ebean_set_isConflict((Boolean)arg);
                return;
            }
            case 17: {
                p._ebean_set_isMerging((Boolean)arg);
                return;
            }
            case 18: {
                p._ebean_set_pullRequestCommits((List)arg);
                return;
            }
            case 19: {
                p._ebean_set_pullRequestEvents((List)arg);
                return;
            }
            case 20: {
                p._ebean_set_lastCommitId((String)arg);
                return;
            }
            case 21: {
                p._ebean_set_mergedCommitIdFrom((String)arg);
                return;
            }
            case 22: {
                p._ebean_set_mergedCommitIdTo((String)arg);
                return;
            }
            case 23: {
                p._ebean_set_number((Long)arg);
                return;
            }
            case 24: {
                p._ebean_set_reviewers((Set)arg);
                return;
            }
            case 25: {
                p._ebean_set_commentThreads((List)arg);
                return;
            }
            case 26: {
                p._ebean_set_repository((Repository)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "title", "body", "toProjectId", "fromProjectId", "toProject", "fromProject", "toBranch", "fromBranch", "contributor", "receiver", "created", "updated", "received", "state", "isConflict", "isMerging", "pullRequestCommits", "pullRequestEvents", "lastCommitId", "mergedCommitIdFrom", "mergedCommitIdTo", "number", "reviewers", "commentThreads", "repository"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        PullRequest pullRequest2 = this;
        synchronized (pullRequest2) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PullRequest)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new PullRequest();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public class Merger {
        private ThreeWayMerger merger;
        private String leftRef;
        private String rightRef;

        public Merger(String leftRef, String rightRef) throws IOException {
            this.leftRef = Objects.requireNonNull(leftRef);
            this.rightRef = Objects.requireNonNull(rightRef);
        }

        public MergeResult merge() throws IOException {
            this.merger = MergeStrategy.RECURSIVE.newMerger(PullRequest.this.getRepository(), true);
            String refNotExistMessageFormat = "Ref '%s' does not exist in Git repository '%s'";
            ObjectId leftParent = Objects.requireNonNull(PullRequest.this.getRepository().resolve(this.leftRef), String.format(refNotExistMessageFormat, this.leftRef, PullRequest.this.getRepository()));
            ObjectId rightParent = Objects.requireNonNull(PullRequest.this.getRepository().resolve(this.rightRef), String.format(refNotExistMessageFormat, this.rightRef, PullRequest.this.getRepository()));
            if (this.merger.merge(new AnyObjectId[]{leftParent, rightParent})) {
                return new Success(this.merger.getResultTreeId(), leftParent, rightParent);
            }
            return new Conflict(leftParent, rightParent);
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public class MergeRefUpdate {
            private ObjectId mergeCommitId;
            private PersonIdent whoMerges;

            private MergeRefUpdate(ObjectId mergeCommitId, PersonIdent whoMerges) {
                this.mergeCommitId = Objects.requireNonNull(mergeCommitId);
                this.whoMerges = Objects.requireNonNull(whoMerges);
            }

            public void updateRef(String ref2) throws IOException, ConcurrentRefUpdateException, PullRequestException {
                RefUpdate refUpdate = PullRequest.this.getRepository().updateRef(ref2);
                refUpdate.setNewObjectId((AnyObjectId)this.mergeCommitId);
                refUpdate.setForceUpdate(true);
                refUpdate.setRefLogIdent(this.whoMerges);
                refUpdate.setRefLogMessage("merged", true);
                RefUpdate.Result rc = refUpdate.update();
                switch (rc) {
                    case NEW: 
                    case FAST_FORWARD: 
                    case FORCED: {
                        return;
                    }
                    case REJECTED: 
                    case LOCK_FAILURE: {
                        throw new ConcurrentRefUpdateException("Could not lock '" + refUpdate.getRef() + "'", refUpdate.getRef(), rc);
                    }
                }
                throw new PullRequestException(MessageFormat.format(JGitText.get().updatingRefFailed, refUpdate.getRef(), this.mergeCommitId, rc));
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public abstract class MergeResult {
            protected ObjectId leftParent;
            protected ObjectId rightParent;

            public abstract MergeRefUpdate createCommit() throws IOException, GitAPIException;

            public abstract MergeRefUpdate createCommit(PersonIdent var1) throws IOException, GitAPIException;

            @Nullable
            public abstract ObjectId getMergeCommitId();

            public ObjectId getLeftParentId() {
                return this.leftParent;
            }

            public ObjectId getRightParentId() {
                return this.rightParent;
            }

            boolean conflicts() {
                return this instanceof Conflict;
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public class Success
        extends MergeResult {
            private ObjectId mergeCommitId;
            protected ObjectId treeId;

            private Success(ObjectId treeId, ObjectId leftParent, ObjectId rightParent) {
                this.treeId = Objects.requireNonNull(treeId);
                this.leftParent = Objects.requireNonNull(leftParent);
                this.rightParent = Objects.requireNonNull(rightParent);
            }

            @Override
            public MergeRefUpdate createCommit() throws IOException, GitAPIException {
                return this.createCommit(new PersonIdent(Config.getSiteName(), Config.getSystemEmailAddress()));
            }

            private ObjectId getMergedTreeIfReusable() {
                String refName = PullRequest.this.getNameOfRefToMerged();
                RevCommit commit = null;
                try {
                    ObjectId objectId = PullRequest.this.getRepository().findRef(refName).getObjectId();
                    commit = new RevWalk(PullRequest.this.getRepository()).parseCommit((AnyObjectId)objectId);
                }
                catch (Exception e) {
                    Logger.info((String)"Failed to get the merged branch", (Throwable)e);
                }
                if (commit != null && commit.getParentCount() == 2 && commit.getParent(0).equals((AnyObjectId)this.leftParent) && commit.getParent(1).equals((AnyObjectId)this.rightParent)) {
                    return commit.getTree().toObjectId();
                }
                return null;
            }

            @Override
            public MergeRefUpdate createCommit(PersonIdent whoMerges) throws IOException, GitAPIException {
                CommitBuilder mergeCommit = new CommitBuilder();
                ObjectId reusableMergedTreeId = this.getMergedTreeIfReusable();
                if (reusableMergedTreeId != null) {
                    mergeCommit.setTreeId((AnyObjectId)reusableMergedTreeId);
                } else {
                    mergeCommit.setTreeId((AnyObjectId)this.treeId);
                }
                mergeCommit.setParentIds((AnyObjectId)this.leftParent, (AnyObjectId)this.rightParent);
                mergeCommit.setAuthor(whoMerges);
                mergeCommit.setCommitter(whoMerges);
                List<GitCommit> commitList = GitRepository.diffCommits(PullRequest.this.getRepository(), this.leftParent, this.rightParent);
                mergeCommit.setMessage(PullRequest.this.makeMergeCommitMessage(commitList));
                ObjectInserter inserter = PullRequest.this.getRepository().newObjectInserter();
                this.mergeCommitId = inserter.insert(mergeCommit);
                inserter.flush();
                inserter.close();
                return new MergeRefUpdate(this.mergeCommitId, whoMerges);
            }

            @Override
            @Nullable
            public ObjectId getMergeCommitId() {
                return this.mergeCommitId;
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public class Conflict
        extends MergeResult {
            private Conflict(ObjectId leftParent, ObjectId rightParent) {
                this.leftParent = Objects.requireNonNull(leftParent);
                this.rightParent = Objects.requireNonNull(rightParent);
            }

            @Override
            public MergeRefUpdate createCommit() throws IOException, GitAPIException {
                throw new UnsupportedOperationException();
            }

            @Override
            public MergeRefUpdate createCommit(PersonIdent whoMerges) throws IOException, GitAPIException {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public ObjectId getMergeCommitId() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

