/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import controllers.routes;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.Id;
import models.AbstractPosting;
import models.Issue;
import models.Posting;
import models.Project;
import models.User;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RecentIssue
extends Model
implements EntityBean {
    private static final long serialVersionUID = 2888713013271878179L;
    public static int MAX_RECENT_LIST_PER_USER = 100;
    public static Model.Finder<Long, RecentIssue> find = new Model.Finder(Long.class, RecentIssue.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long userId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long issueId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long postingId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String title;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String url;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    private static String _EBEAN_MARKER = "models.RecentIssue";

    public RecentIssue(User user, String title, Issue issue2, Posting posting) {
        Object object = "";
        Object object2 = this;
        ((RecentIssue)((Object)object2)).setUrl((String)object);
        object2 = user;
        object = null;
        object = ((User)object2).getId();
        object2 = this;
        ((RecentIssue)((Object)object2)).setUserId((Long)object);
        object = title;
        object2 = this;
        ((RecentIssue)((Object)object2)).setTitle((String)object);
        if (issue2 != null) {
            object2 = issue2;
            object = null;
            object = ((AbstractPosting)object2).getId();
            object2 = this;
            ((RecentIssue)((Object)object2)).setIssueId((Long)object);
        }
        if (posting != null) {
            object2 = posting;
            object = null;
            object = ((AbstractPosting)object2).getId();
            object2 = this;
            ((RecentIssue)((Object)object2)).setPostingId((Long)object);
        }
        if (issue2 != null) {
            object2 = issue2;
            object = null;
            object2 = object = ((AbstractPosting)object2).getProject();
            object = null;
            Object object3 = object = ((Project)object2).getOwner();
            object2 = issue2;
            object = null;
            object2 = object = ((AbstractPosting)object2).getProject();
            object = null;
            object = ((Project)object2).getName();
            object = routes.IssueApp.issue((String)object3, (String)object, issue2.getNumber()).url();
            object2 = this;
            ((RecentIssue)((Object)object2)).setUrl((String)object);
        } else if (posting != null) {
            object2 = posting;
            object = null;
            object2 = object = ((AbstractPosting)object2).getProject();
            object = null;
            Object object4 = object = ((Project)object2).getOwner();
            object2 = posting;
            object = null;
            object2 = object = ((AbstractPosting)object2).getProject();
            object = null;
            object = ((Project)object2).getName();
            object = routes.BoardApp.post((String)object4, (String)object, posting.getNumber()).url();
            object2 = this;
            ((RecentIssue)((Object)object2)).setUrl((String)object);
        }
        object = new Date();
        object2 = this;
        ((RecentIssue)((Object)object2)).setCreatedDate((Date)object);
    }

    public static List<RecentIssue> getRecentIssues(@Nonnull User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        return find.where().eq("userId", (Object)l).orderBy("id desc").findList();
    }

    public static void addNewIssue(final User user, final Issue issue2) {
        F.Promise promise = F.Promise.promise((F.Function0)new F.Function0<Void>(){

            public Void apply() {
                RecentIssue.addVisitIssueHistory(user, issue2);
                return null;
            }
        });
    }

    public static void addNewPosting(final User user, final Posting posting) {
        F.Promise promise = F.Promise.promise((F.Function0)new F.Function0<Void>(){

            public Void apply() {
                RecentIssue.addVisitPostingHistory(user, posting);
                return null;
            }
        });
    }

    @Transactional
    private static void addVisitIssueHistory(User user, Issue issue2) {
        try {
            Issue issue3 = issue2;
            Object object = null;
            object = issue3.getId();
            RecentIssue.deletePreviousIssue(user, (Long)object);
            issue3 = issue2;
            object = null;
            object = issue3.getTitle();
            RecentIssue recentIssue = new RecentIssue(user, (String)object, issue2, null);
            recentIssue.save();
            RecentIssue.deleteOldestIfOverflow(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    private static void addVisitPostingHistory(User user, Posting posting) {
        try {
            Posting posting2 = posting;
            Object object = null;
            object = posting2.getId();
            RecentIssue.deletePreviousPosting(user, (Long)object);
            posting2 = posting;
            object = null;
            object = posting2.getTitle();
            RecentIssue recentIssue = new RecentIssue(user, (String)object, null, posting);
            recentIssue.save();
            RecentIssue.deleteOldestIfOverflow(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deletePreviousIssue(User user, Long issueId) {
        try {
            User user2 = user;
            Long l = null;
            l = user2.getId();
            RecentIssue existed = (RecentIssue)((Object)find.where().eq("userId", (Object)l).eq("issueId", (Object)issueId).findUnique());
            Logger.debug((String)"deletePreviousIssue {}", (Object[])new Object[]{existed});
            if (existed != null) {
                existed.delete();
            }
        }
        catch (Exception e) {
            Logger.debug((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void deletePreviousPosting(User user, Long postingId) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        RecentIssue existed = (RecentIssue)((Object)find.where().eq("userId", (Object)l).eq("postingId", (Object)postingId).findUnique());
        if (existed != null) {
            existed.delete();
        }
    }

    private static void deleteOldestIfOverflow(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        List recentProjects = find.where().eq("userId", (Object)l).findList();
        while (recentProjects.size() > MAX_RECENT_LIST_PER_USER) {
            Comparator<RecentIssue> comparator = new Comparator<RecentIssue>(){

                @Override
                public int compare(RecentIssue p1, RecentIssue p2) {
                    RecentIssue recentIssue = p1;
                    Long l = null;
                    l = recentIssue.getId();
                    long l2 = l;
                    recentIssue = p2;
                    l = null;
                    l = recentIssue.getId();
                    return Long.compare(l2, l);
                }
            };
            RecentIssue oldest = Collections.min(recentProjects, comparator);
            oldest.refresh();
            oldest.delete();
        }
    }

    public static void deleteAll(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        List recentIssues = find.where().eq("userId", (Object)l).findList();
        for (RecentIssue ri : recentIssues) {
            ri.delete();
        }
    }

    public String getNumber() {
        RecentIssue recentIssue = this;
        String string = null;
        string = recentIssue.getUrl();
        String[] paths = string.split("/");
        if (paths.length < 5) {
            recentIssue = this;
            string = null;
            string = recentIssue.getUrl();
            return string;
        }
        return paths[2] + " #" + paths[4];
    }

    public String toString() {
        RecentIssue recentIssue = this;
        Object object = null;
        object = recentIssue.getId();
        StringBuilder stringBuilder = new StringBuilder().append("RecentIssue{id=").append(object).append(", userId=");
        recentIssue = this;
        object = null;
        object = recentIssue.getUserId();
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", issueId=");
        recentIssue = this;
        object = null;
        object = recentIssue.getIssueId();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", postingId=");
        recentIssue = this;
        object = null;
        object = recentIssue.getPostingId();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", title='");
        recentIssue = this;
        object = null;
        object = recentIssue.getTitle();
        StringBuilder stringBuilder5 = stringBuilder4.append((String)object).append('\'').append(", url='");
        recentIssue = this;
        object = null;
        object = recentIssue.getUrl();
        StringBuilder stringBuilder6 = stringBuilder5.append((String)object).append('\'').append(", createdDate=");
        recentIssue = this;
        object = null;
        object = recentIssue.getCreatedDate();
        return stringBuilder6.append(object).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getUserId() {
        return this._ebean_get_userId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUserId(Long l) {
        this._ebean_set_userId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getIssueId() {
        return this._ebean_get_issueId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssueId(Long l) {
        this._ebean_set_issueId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getPostingId() {
        return this._ebean_get_postingId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPostingId(Long l) {
        this._ebean_set_postingId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getTitle() {
        return this._ebean_get_title();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTitle(String string) {
        this._ebean_set_title(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getUrl() {
        return this._ebean_get_url();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUrl(String string) {
        this._ebean_set_url(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
    }

    public RecentIssue() {
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected Long _ebean_get_userId() {
        this._ebean_intercept.preGetter("userId");
        return this.userId;
    }

    protected void _ebean_set_userId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "userId", (Object)this._ebean_get_userId(), (Object)newValue);
        this.userId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_userId() {
        return this.userId;
    }

    protected void _ebean_setni_userId(Long _newValue) {
        this.userId = _newValue;
    }

    protected Long _ebean_get_issueId() {
        this._ebean_intercept.preGetter("issueId");
        return this.issueId;
    }

    protected void _ebean_set_issueId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "issueId", (Object)this._ebean_get_issueId(), (Object)newValue);
        this.issueId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_issueId() {
        return this.issueId;
    }

    protected void _ebean_setni_issueId(Long _newValue) {
        this.issueId = _newValue;
    }

    protected Long _ebean_get_postingId() {
        this._ebean_intercept.preGetter("postingId");
        return this.postingId;
    }

    protected void _ebean_set_postingId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "postingId", (Object)this._ebean_get_postingId(), (Object)newValue);
        this.postingId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_postingId() {
        return this.postingId;
    }

    protected void _ebean_setni_postingId(Long _newValue) {
        this.postingId = _newValue;
    }

    protected String _ebean_get_title() {
        this._ebean_intercept.preGetter("title");
        return this.title;
    }

    protected void _ebean_set_title(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "title", (Object)this._ebean_get_title(), (Object)newValue);
        this.title = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_title() {
        return this.title;
    }

    protected void _ebean_setni_title(String _newValue) {
        this.title = _newValue;
    }

    protected String _ebean_get_url() {
        this._ebean_intercept.preGetter("url");
        return this.url;
    }

    protected void _ebean_set_url(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "url", (Object)this._ebean_get_url(), (Object)newValue);
        this.url = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_url() {
        return this.url;
    }

    protected void _ebean_setni_url(String _newValue) {
        this.url = _newValue;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        RecentIssue recentIssue = new RecentIssue();
        recentIssue.id = this.id;
        recentIssue.userId = this.userId;
        recentIssue.issueId = this.issueId;
        recentIssue.postingId = this.postingId;
        recentIssue.title = this.title;
        recentIssue.url = this.url;
        recentIssue.createdDate = this.createdDate;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        RecentIssue p = (RecentIssue)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.userId;
            }
            case 3: {
                return p.issueId;
            }
            case 4: {
                return p.postingId;
            }
            case 5: {
                return p.title;
            }
            case 6: {
                return p.url;
            }
            case 7: {
                return p.createdDate;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        RecentIssue p = (RecentIssue)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_userId();
            }
            case 3: {
                return p._ebean_get_issueId();
            }
            case 4: {
                return p._ebean_get_postingId();
            }
            case 5: {
                return p._ebean_get_title();
            }
            case 6: {
                return p._ebean_get_url();
            }
            case 7: {
                return p._ebean_get_createdDate();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        RecentIssue p = (RecentIssue)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.userId = (Long)arg;
                return;
            }
            case 3: {
                p.issueId = (Long)arg;
                return;
            }
            case 4: {
                p.postingId = (Long)arg;
                return;
            }
            case 5: {
                p.title = (String)arg;
                return;
            }
            case 6: {
                p.url = (String)arg;
                return;
            }
            case 7: {
                p.createdDate = (Date)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        RecentIssue p = (RecentIssue)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_userId((Long)arg);
                return;
            }
            case 3: {
                p._ebean_set_issueId((Long)arg);
                return;
            }
            case 4: {
                p._ebean_set_postingId((Long)arg);
                return;
            }
            case 5: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_url((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "userId", "issueId", "postingId", "title", "url", "createdDate"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        RecentIssue recentIssue = this;
        synchronized (recentIssue) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((RecentIssue)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new RecentIssue();
    }
}

