/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import controllers.UserApp;
import controllers.routes;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import models.Assignee;
import models.Attachment;
import models.Email;
import models.FavoriteIssue;
import models.FavoriteOrganization;
import models.FavoriteProject;
import models.Issue;
import models.Mention;
import models.NotificationEvent;
import models.NullUser;
import models.Organization;
import models.OrganizationUser;
import models.Posting;
import models.Project;
import models.ProjectUser;
import models.RecentIssue;
import models.RecentProject;
import models.Role;
import models.SiteAdmin;
import models.Watch;
import models.enumeration.ResourceType;
import models.enumeration.RoleType;
import models.enumeration.UserState;
import models.resource.GlobalResource;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import models.support.UserComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.util.ByteSource;
import play.core.enhancers.PropertiesEnhancer;
import play.data.format.Formats;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.F;
import play.mvc.Http;
import utils.CacheStore;
import utils.GravatarUtil;
import utils.HtmlUtil;
import utils.JodaDateUtil;
import utils.ReservedWordsValidator;

@Table(name="n4user")
@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class User
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, User> find = new Model.Finder(Long.class, User.class);
    public static final Comparator<User> USER_NAME_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User u1, User u2) {
            User user = u1;
            String string = null;
            String string2 = string = user.getName();
            user = u2;
            string = null;
            string = user.getName();
            return string2.compareTo(string);
        }
    };
    public static final int USER_COUNT_PER_PAGE = 30;
    public static final Long SITE_MANAGER_ID = 1L;
    public static final String LOGIN_ID_PATTERN = "[a-zA-Z0-9\uac00-\ud7a3-]+([_.][a-z_.A-Z0-9\uac00-\ud7a3-]+)*";
    public static final String LOGIN_ID_PATTERN_ALLOW_FORWARD_SLASH = "[a-zA-Z0-9-/]+([_.][a-z_.A-Z0-9-/]+)*";
    public static final User anonymous = new NullUser();
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String englishName;
    @Constraints.Pattern(value="^[a-zA-Z0-9\uac00-\ud7a3-]+([_.][a-z_.A-Z0-9\uac00-\ud7a3-]+)*$", message="user.wrongloginId.alert")
    @Constraints.Required
    @Constraints.ValidateWith(value=ReservedWordsValidator.class, message="validation.reservedWord")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String loginId;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String oldPassword;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String password;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String passwordSalt;
    @Constraints.Email(message="user.wrongEmail.alert")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String email;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String token;
    @Transient
    private Boolean siteManager;
    @Transient
    private Map<Long, Boolean> projectManagerMemo = new HashMap<Long, Boolean>();
    @Transient
    private Map<Long, Boolean> projectMembersMemo = new HashMap<Long, Boolean>();
    @Transient
    private Map<String, Boolean> orgMembersMemo = new HashMap<String, Boolean>();
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean rememberMe;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public UserState state;
    @Formats.DateTime(pattern="yyyy-MM-dd")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date lastStateModifiedDate;
    @Formats.DateTime(pattern="yyyy-MM-dd")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<ProjectUser> projectUser;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<OrganizationUser> groupUser;
    @OneToMany(mappedBy="user")
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<FavoriteIssue> favoriteIssues;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="user_enrolled_project", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="project_id")})
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Project> enrolledProjects;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="user_enrolled_organization", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="organization_id")})
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Organization> enrolledOrganizations;
    @ManyToMany(mappedBy="receivers")
    @OrderBy(value="created DESC")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<NotificationEvent> notificationEvents;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Email> emails;
    @OneToMany(mappedBy="user")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Mention> mentions;
    @OneToMany(mappedBy="user")
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<FavoriteProject> favoriteProjects;
    @OneToMany(mappedBy="user")
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<FavoriteOrganization> favoriteOrganizations;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String lang;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long lastVisitedProjectId;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long lastVisitedIssueId;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<OrganizationUser> organizationUsers;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean isGuest;
    private static String _EBEAN_MARKER = "models.User";

    public User() {
        boolean bl = false;
        User user = this;
        user.setIsGuest(bl);
    }

    public User(Long id) {
        boolean bl = false;
        User user = this;
        user.setIsGuest(bl);
        Long l = id;
        user = this;
        user.setId(l);
    }

    public boolean isMemberOf(Organization organization2) {
        return this.isMemberOf(organization2, RoleType.ORG_MEMBER);
    }

    public boolean isAdminOf(Organization organization2) {
        return this.isMemberOf(organization2, RoleType.ORG_ADMIN);
    }

    public boolean isMemberOf(Organization org, RoleType roleType) {
        if (org == null) {
            return false;
        }
        Model model = org;
        Long l = null;
        l = model.getId();
        String key = l + ":" + roleType.toString();
        Boolean value = this.orgMembersMemo.get(key);
        if (value == null) {
            model = org;
            l = null;
            l = model.getId();
            ExpressionList expressionList = OrganizationUser.find.where().eq("organization.id", (Object)l);
            model = this;
            l = null;
            l = model.getId();
            ExpressionList expressionList2 = expressionList.eq("user.id", (Object)l);
            model = Role.findByRoleType(roleType);
            l = null;
            l = model.getId();
            int rowCount = expressionList2.eq("role.id", (Object)l).findRowCount();
            value = rowCount > 0;
            this.orgMembersMemo.put(key, value);
        }
        return value;
    }

    public String getPreferredLanguage() {
        User user = this;
        String string = null;
        string = user.getLang();
        if (string != null) {
            user = this;
            string = null;
            string = user.getLang();
            return string;
        }
        return Locale.getDefault().getLanguage();
    }

    public String getDateString() {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy", Locale.US);
        User user = this;
        Date date = null;
        date = user.getCreatedDate();
        return sdf.format(date);
    }

    public List<Project> myProjects(String orderString) {
        User user = this;
        Long l = null;
        l = user.getId();
        return Project.findProjectsByMemberWithFilter(l, orderString);
    }

    public List<Project> ownProjects() {
        User user = this;
        String string = null;
        string = user.getLoginId();
        return Project.findByOwner(string);
    }

    public static Long create(User user) {
        Object object = JodaDateUtil.now();
        User user2 = user;
        user2.setCreatedDate((Date)object);
        user2 = user;
        object = null;
        object = user2.getName();
        object = HtmlUtil.defaultSanitize((String)object);
        user2 = user;
        user2.setName((String)object);
        user.save();
        user2 = user;
        object = null;
        object = user2.getId();
        CacheStore.yonaUsers.put(object, (Object)user);
        user2 = user;
        object = null;
        object = user2.getId();
        return object;
    }

    public static User findByLoginId(String loginId) {
        User user = (User)find.where().eq("loginId", (Object)loginId).findUnique();
        if (user == null) {
            return anonymous;
        }
        return user;
    }

    public static User findByUserToken(String token) {
        User user = null;
        if (token != null) {
            user = (User)find.where().eq("token", (Object)token).findUnique();
        }
        if (user != null) {
            return user;
        }
        return anonymous;
    }

    public static User findUserIfTokenExist(User user) {
        if (!user.isAnonymous()) {
            return user;
        }
        String userToken = User.extractUserTokenFromRequestHeader(Http.Context.current().request());
        if (userToken != null) {
            return User.findByUserToken(userToken);
        }
        return anonymous;
    }

    public static String extractUserTokenFromRequestHeader(Http.Request request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.contains("token ")) {
            return authHeader.split("token ")[1];
        }
        return request.getHeader("Yona-Token");
    }

    public static User findByEmail(String email) {
        User user = (User)find.where().eq("email", (Object)email).findUnique();
        if (user != null) {
            return user;
        }
        Email subEmail = Email.findByEmail(email, true);
        if (subEmail != null) {
            Email email2 = subEmail;
            User user2 = null;
            user2 = email2.getUser();
            return user2;
        }
        User fallback = (User)find.where().ieq("email", email).findUnique();
        if (fallback != null) {
            return fallback;
        }
        NullUser anonymous = new NullUser();
        String string = email;
        NullUser nullUser = anonymous;
        nullUser.setEmail(string);
        return anonymous;
    }

    public static User findByLoginKey(String loginIdOrEmail) {
        User user = (User)find.where().ieq("loginId", loginIdOrEmail).findUnique();
        if (user == null) {
            user = (User)find.where().eq("email", (Object)loginIdOrEmail).findUnique();
        }
        return user == null ? anonymous : user;
    }

    public static boolean isLoginIdExist(String loginId) {
        int findRowCount = find.where().ieq("loginId", loginId).findRowCount();
        return findRowCount != 0;
    }

    public static Map<String, String> options() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Iterator iterator = find.orderBy("name").findList().iterator();
        while (iterator.hasNext()) {
            User user;
            User user2 = user = (User)iterator.next();
            Object object = null;
            object = user2.getId();
            String string = ((Long)object).toString();
            user2 = user;
            object = null;
            object = user2.getName();
            options.put(string, (String)object);
        }
        return options;
    }

    public static Page<User> findUsers(int pageNum, String query, UserState state) {
        ExpressionList el = find.where();
        el.ne("id", (Object)SITE_MANAGER_ID);
        User user = anonymous;
        String string = null;
        string = user.getLoginId();
        el.ne("loginId", (Object)string);
        if (state == UserState.GUEST) {
            el.eq("isGuest", (Object)true);
        } else if (state == UserState.SITE_ADMIN) {
            el.in("id", User.getAdminUserIds());
        } else {
            el.eq("state", (Object)state);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            el = el.disjunction();
            el = el.icontains("loginId", query).icontains("name", query).icontains("englishName", query).icontains("email", query);
            el.endJunction();
        }
        return el.order().desc("createdDate").findPagingList(30).getPage(pageNum);
    }

    private static Set<Long> getAdminUserIds() {
        List admins = SiteAdmin.find.all();
        HashSet<Long> adminUserIds = new HashSet<Long>();
        for (SiteAdmin admin : admins) {
            Object object = admin;
            Object object2 = null;
            object2 = ((SiteAdmin)((Object)object)).getId();
            if (object2 == SITE_MANAGER_ID) continue;
            object = admin;
            object2 = null;
            object = object2 = ((SiteAdmin)((Object)object)).getAdmin();
            object2 = null;
            object2 = ((User)object).getId();
            adminUserIds.add((Long)object2);
        }
        return adminUserIds;
    }

    public static List<User> findUsersByProject(Long projectId) {
        return find.where().eq("projectUser.project.id", (Object)projectId).ne("projectUser.role.id", (Object)RoleType.SITEMANAGER.roleType()).orderBy().asc("name").findList();
    }

    public static List<User> findUsersByProjectAndOrganization(Project project2) {
        Object object;
        Object object2;
        HashSet<Object> userIds = new HashSet<Object>();
        List<ProjectUser> pus = project2.members();
        for (ProjectUser pu : pus) {
            object2 = pu;
            object = null;
            object2 = object = ((ProjectUser)((Object)object2)).getUser();
            object = null;
            object = ((User)object2).getId();
            userIds.add(object);
        }
        if (project2.hasGroup()) {
            List ous = null;
            if (project2.isPrivate()) {
                object2 = project2;
                object = null;
                object = ((Project)object2).getOrganization();
                ous = ((Organization)object).getAdmins();
            } else {
                object2 = project2;
                object = null;
                object = ((Project)object2).getOrganization();
                ous = OrganizationUser.find.fetch("user").where().eq("organization", object).findList();
            }
            for (OrganizationUser ou : ous) {
                object2 = ou;
                object = null;
                object2 = object = ((OrganizationUser)((Object)object2)).getUser();
                object = null;
                object = ((User)object2).getId();
                userIds.add(object);
            }
        }
        if (UserApp.currentUser().isSiteManager()) {
            object2 = UserApp.currentUser();
            object = null;
            object = ((User)object2).getId();
            userIds.add(object);
        }
        List users2 = find.where().in("id", userIds).orderBy().asc("name").findList();
        return users2;
    }

    @Transient
    public Long avatarId() {
        List<Attachment> attachments = Attachment.findByContainer(this.avatarAsResource());
        if (attachments.size() > 0) {
            Attachment attachment = attachments.get(attachments.size() - 1);
            Long l = null;
            l = attachment.getId();
            return l;
        }
        return null;
    }

    public static boolean isEmailExist(String emailAddress) {
        User user = (User)find.where().ieq("email", emailAddress).findUnique();
        return user != null || Email.exists(emailAddress, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAnonymous() {
        User user = this;
        Long l = null;
        l = user.getId();
        if (l == null) return true;
        user = this;
        l = null;
        Long l2 = l = user.getId();
        user = anonymous;
        l = null;
        l = user.getId();
        if (!l2.equals(l)) return false;
        return true;
    }

    public static void resetPassword(String loginId, String newPassword) {
        User user;
        User user2 = user = User.findByLoginId(loginId);
        Object object = null;
        object = user2.getPasswordSalt();
        object = User.getHashedStringForPassword(newPassword, (String)object);
        user2 = user;
        user2.setPassword((String)object);
        user2 = user;
        object = null;
        object = user2.getId();
        CacheStore.yonaUsers.put(object, (Object)user);
        user.save();
    }

    public boolean isSamePassword(String newPassword) {
        User user = this;
        String string = null;
        String string2 = string = user.getPassword();
        user = this;
        string = null;
        string = user.getPasswordSalt();
        return string2.equals(User.getHashedStringForPassword(newPassword, string));
    }

    private static String getHashedStringForPassword(String newPassword, String salt) {
        return new Sha256Hash((Object)newPassword, (Object)ByteSource.Util.bytes((String)salt), 1024).toBase64();
    }

    @Override
    public Resource asResource() {
        return new GlobalResource(){

            @Override
            public String getId() {
                User user = User.this;
                Long l = null;
                l = user.getId();
                return l.toString();
            }

            @Override
            public ResourceType getType() {
                return ResourceType.USER;
            }
        };
    }

    public Resource avatarAsResource() {
        return new GlobalResource(){

            @Override
            public String getId() {
                User user = User.this;
                Long l = null;
                l = user.getId();
                return l.toString();
            }

            @Override
            public ResourceType getType() {
                return ResourceType.USER_AVATAR;
            }
        };
    }

    public boolean isSiteManager() {
        if (this.siteManager == null) {
            this.siteManager = SiteAdmin.exists(this);
        }
        return this.siteManager;
    }

    public boolean isManagerOf(Project project2) {
        Model model = project2;
        Long l = null;
        l = model.getId();
        if (!this.projectManagerMemo.containsKey(l)) {
            model = project2;
            l = null;
            Long l2 = l = model.getId();
            model = this;
            l = null;
            Long l3 = l = model.getId();
            model = project2;
            l = null;
            l = model.getId();
            this.projectManagerMemo.put(l2, ProjectUser.isManager(l3, l));
        }
        model = project2;
        l = null;
        l = model.getId();
        return this.projectManagerMemo.get(l);
    }

    public boolean isMemberOf(Project project2) {
        Model model = this;
        Long l = null;
        Long l2 = l = model.getId();
        model = project2;
        l = null;
        l = model.getId();
        return ProjectUser.isMember(l2, l);
    }

    public List<Project> getEnrolledProjects() {
        if (this._ebean_get_enrolledProjects() == null) {
            this._ebean_set_enrolledProjects(new ArrayList());
        }
        return this._ebean_get_enrolledProjects();
    }

    public List<Organization> getEnrolledOrganizations() {
        if (this._ebean_get_enrolledOrganizations() == null) {
            this._ebean_set_enrolledOrganizations(new ArrayList());
        }
        return this._ebean_get_enrolledOrganizations();
    }

    @Transactional
    public void addWatching(Project project2) {
        Watch.watch(this, project2.asResource());
    }

    @Transactional
    public void removeWatching(Project project2) {
        Watch.unwatch(this, project2.asResource());
    }

    public static boolean isWatching(Project project2) {
        return Watch.isWatching(project2.asResource());
    }

    public List<Project> getWatchingProjects() {
        return this.getWatchingProjects(null);
    }

    public List<Project> getWatchingProjects(String orderString) {
        List<String> projectIds = Watch.findWatchedResourceIds(this, ResourceType.PROJECT);
        ArrayList<Project> projects2 = new ArrayList<Project>();
        for (String id : projectIds) {
            projects2.add((Project)Project.find.byId((Object)Long.valueOf(id)));
        }
        if (StringUtils.isBlank((CharSequence)orderString)) {
            return projects2;
        }
        return Ebean.filter(Project.class).sort(orderString).filter(projects2);
    }

    public void enroll(Project project2) {
        this.getEnrolledProjects().add(project2);
        this.update();
        User user = this;
        Long l = null;
        l = user.getId();
        CacheStore.yonaUsers.put((Object)l, (Object)this);
    }

    public void enroll(Organization organization2) {
        this.getEnrolledOrganizations().add(organization2);
        this.update();
        User user = this;
        Long l = null;
        l = user.getId();
        CacheStore.yonaUsers.put((Object)l, (Object)this);
    }

    public void cancelEnroll(Project project2) {
        this.getEnrolledProjects().remove(project2);
        this.update();
        User user = this;
        Long l = null;
        l = user.getId();
        CacheStore.yonaUsers.put((Object)l, (Object)this);
    }

    public void cancelEnroll(Organization organization2) {
        this.getEnrolledOrganizations().remove(organization2);
        this.update();
        User user = this;
        Long l = null;
        l = user.getId();
        CacheStore.yonaUsers.put((Object)l, (Object)this);
    }

    public static boolean enrolled(Project project2) {
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return false;
        }
        return user.getEnrolledProjects().contains(project2);
    }

    public static boolean enrolled(Organization organization2) {
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return false;
        }
        return user.getEnrolledOrganizations().contains(organization2);
    }

    public void delete() {
        User user = this;
        Long l = null;
        l = user.getId();
        for (Assignee assignee : Assignee.finder.where().eq("user.id", (Object)l).findList()) {
            assignee.delete();
        }
        user = this;
        l = null;
        l = user.getId();
        CacheStore.yonaUsers.invalidate((Object)l);
        super.delete();
    }

    public void changeState(UserState state) {
        this.refresh();
        Object object = state;
        Model model = this;
        model.setState((UserState)((Object)object));
        object = new Date();
        model = this;
        model.setLastStateModifiedDate((Date)object);
        model = this;
        object = null;
        object = model.getState();
        if (object == UserState.DELETED) {
            model = this;
            object = null;
            object = model.getName();
            object = "[DELETED]" + (String)object;
            model = this;
            model.setName((String)object);
            object = "";
            model = this;
            model.setOldPassword((String)object);
            object = "";
            model = this;
            model.setPassword((String)object);
            object = "";
            model = this;
            model.setPasswordSalt((String)object);
            model = this;
            object = null;
            object = model.getLoginId();
            object = "deleted-" + (String)object + "@noreply.yona.io";
            model = this;
            model.setEmail((String)object);
            boolean bl = false;
            model = this;
            model.setRememberMe(bl);
            model = this;
            object = null;
            object = model.getProjectUser();
            object.clear();
            this._ebean_get_enrolledProjects().clear();
            model = this;
            object = null;
            object = model.getNotificationEvents();
            object.clear();
            model = this;
            object = null;
            object = model.getId();
            for (Assignee assignee : Assignee.finder.where().eq("user.id", object).findList()) {
                model = assignee;
                object = null;
                object = model.getIssues();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Issue issue2 = (Issue)iterator.next();
                    object = null;
                    model = issue2;
                    model.setAssignee((Assignee)((Object)object));
                    issue2.update();
                }
                assignee.delete();
            }
        }
        this.update();
        model = this;
        object = null;
        object = model.getId();
        CacheStore.yonaUsers.put(object, (Object)this);
    }

    public String avatarUrl() {
        Long avatarId = this.avatarId();
        if (avatarId == null) {
            User user = this;
            String string = null;
            string = user.getEmail();
            return GravatarUtil.getAvatar(string, 64);
        }
        return routes.AttachmentApp.getFile(avatarId).url();
    }

    public String avatarUrl(int size) {
        Long avatarId = this.avatarId();
        if (avatarId == null) {
            User user = this;
            String string = null;
            string = user.getEmail();
            return GravatarUtil.getAvatar(string, size);
        }
        return routes.AttachmentApp.getFile(avatarId).url();
    }

    public static List<User> findIssueAuthorsByProjectIdAndMe(User currentUser, long projectId) {
        String sql = "SELECT DISTINCT t0.id AS id, t0.name AS name, t0.login_id AS loginId FROM n4user t0 JOIN issue t1 ON t0.id = t1.author_id";
        List users2 = find.setRawSql(RawSqlBuilder.parse((String)sql).create()).where().eq("t1.project_id", (Object)projectId).orderBy().asc("t0.name").findList();
        if (!users2.contains(currentUser) && currentUser != anonymous) {
            users2.add(currentUser);
            Collections.sort(users2, new UserComparator());
        }
        return users2;
    }

    public static List<User> findIssueAssigneeByProjectIdAndMe(User currentUser, long projectId) {
        String sql = "SELECT DISTINCT t0.id AS id, t0.name AS name, t0.login_id AS loginId FROM n4user t0 JOIN assignee t1 ON t0.id = t1.user_id";
        List users2 = find.setRawSql(RawSqlBuilder.parse((String)sql).create()).where().eq("t1.project_id", (Object)projectId).orderBy().asc("t0.name").findList();
        if (!users2.contains(currentUser) && currentUser != anonymous) {
            users2.add(currentUser);
            Collections.sort(users2, new UserComparator());
        }
        return users2;
    }

    public static List<User> findPullRequestContributorsByProjectId(long projectId) {
        String sql = "SELECT DISTINCT t0.id AS id, t0.name AS name, t0.login_id AS loginId FROM n4user t0 JOIN pull_request t1 ON t0.id = t1.contributor_id";
        return find.setRawSql(RawSqlBuilder.parse((String)sql).create()).where().eq("t1.to_project_id", (Object)projectId).orderBy().asc("t0.name").findList();
    }

    public static List<User> findUsersByProject(Long projectId, RoleType roleType) {
        return find.where().eq("projectUser.project.id", (Object)projectId).eq("projectUser.role.id", (Object)roleType.roleType()).orderBy().asc("name").findList();
    }

    public static List<User> findUsersByOrganization(Long organizationId, RoleType roleType) {
        return find.where().eq("organizationUsers.organization.id", (Object)organizationId).eq("organizationUsers.role.id", (Object)roleType.roleType()).orderBy().asc("name").findList();
    }

    public void addEmail(Email email) {
        email.save();
        User user = this;
        List<Email> list2 = null;
        list2 = user.getEmails();
        list2.add(email);
    }

    public boolean has(String newEmail) {
        Model model = this;
        Object object = null;
        object = model.getEmails();
        Iterator<Email> iterator = object.iterator();
        while (iterator.hasNext()) {
            Email email = iterator.next();
            model = email;
            object = null;
            object = model.getEmail();
            if (!((String)object).equals(newEmail)) continue;
            return true;
        }
        return false;
    }

    public void removeEmail(Email email) {
        User user = this;
        Object object = null;
        object = user.getEmails();
        object.remove((Object)email);
        email.delete();
        user = this;
        object = null;
        object = user.getId();
        CacheStore.yonaUsers.put(object, (Object)this);
    }

    public void visits(Project project2) {
        if (this.isAnonymous()) {
            return;
        }
        Model model = project2;
        Long l = null;
        Long l2 = l = model.getId();
        model = this;
        l = null;
        l = model.getLastVisitedProjectId();
        if (!Objects.equals(l2, l)) {
            model = project2;
            l = null;
            l = model.getId();
            model = this;
            model.setLastVisitedProjectId(l);
            RecentProject.addNew(this, project2);
        }
    }

    public void visits(Issue issue2) {
        if (this.isAnonymous()) {
            return;
        }
        Model model = issue2;
        Long l = null;
        Long l2 = l = model.getId();
        model = this;
        l = null;
        l = model.getLastVisitedIssueId();
        if (!Objects.equals(l2, l)) {
            model = issue2;
            l = null;
            l = model.getId();
            model = this;
            model.setLastVisitedProjectId(l);
            RecentIssue.addNewIssue(this, issue2);
        }
    }

    public void visits(Posting posting) {
        if (this.isAnonymous()) {
            return;
        }
        Model model = posting;
        Long l = null;
        Long l2 = l = model.getId();
        model = this;
        l = null;
        l = model.getLastVisitedIssueId();
        if (!Objects.equals(l2, l)) {
            model = posting;
            l = null;
            l = model.getId();
            model = this;
            model.setLastVisitedProjectId(l);
            RecentIssue.addNewPosting(this, posting);
        }
    }

    public List<Project> getVisitedProjects() {
        List<Project> projects2 = RecentProject.getRecentProjects(this);
        if (projects2 == null || projects2.size() == 0) {
            return new ArrayList<Project>();
        }
        return projects2;
    }

    public List<RecentIssue> getVisitedIssues() {
        List<RecentIssue> issues2 = RecentIssue.getRecentIssues(this);
        if (issues2 == null || issues2.size() == 0) {
            return new ArrayList<RecentIssue>();
        }
        return issues2;
    }

    public List<Organization> getOrganizations(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("the size should be bigger then 0");
        }
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        Iterator<OrganizationUser> iterator = OrganizationUser.findByUser(this, size).iterator();
        while (iterator.hasNext()) {
            OrganizationUser ou;
            OrganizationUser organizationUser = ou = iterator.next();
            Organization organization2 = null;
            organization2 = organizationUser.getOrganization();
            orgs.add(organization2);
        }
        return orgs;
    }

    public void createOrganization(Organization organization2) {
        OrganizationUser ou = new OrganizationUser();
        Object object = this;
        Model model = ou;
        model.setUser((User)object);
        object = organization2;
        model = ou;
        model.setOrganization((Organization)object);
        object = Role.findByRoleType(RoleType.ORG_ADMIN);
        model = ou;
        model.setRole((Role)((Object)object));
        ou.save();
        this.add(ou);
        organization2.add(ou);
        this.update();
        model = this;
        object = null;
        object = model.getId();
        CacheStore.yonaUsers.put(object, (Object)this);
    }

    private void add(OrganizationUser ou) {
        User user = this;
        List<OrganizationUser> list2 = null;
        list2 = user.getOrganizationUsers();
        list2.add(ou);
    }

    public String toString() {
        if (this.isAnonymous()) {
            return Messages.get((String)"user.role.anonymous", (Object[])new Object[0]);
        }
        User user = this;
        String string = null;
        string = user.getName();
        StringBuilder stringBuilder = new StringBuilder().append(string).append("(");
        user = this;
        string = null;
        string = user.getLoginId();
        return stringBuilder.append(string).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        User user2 = this;
        Long l = null;
        l = user2.getId();
        if (l == null) {
            user2 = user;
            l = null;
            l = user2.getId();
            if (l != null) return false;
            return true;
        }
        user2 = this;
        l = null;
        Long l2 = l = user2.getId();
        user2 = user;
        l = null;
        l = user2.getId();
        if (l2.equals(l)) return true;
        return false;
    }

    public int hashCode() {
        int n;
        User user = this;
        Long l = null;
        l = user.getId();
        if (l != null) {
            user = this;
            l = null;
            l = user.getId();
            n = l.hashCode();
        } else {
            n = 0;
        }
        return n;
    }

    public List<Project> getFavoriteProjects() {
        final User user = this;
        this._ebean_get_favoriteProjects().sort(new Comparator<FavoriteProject>(){

            @Override
            public int compare(FavoriteProject o1, FavoriteProject o2) {
                String string;
                Model model;
                block5: {
                    block4: {
                        model = o1;
                        string = null;
                        String string2 = string = model.getOwner();
                        model = user;
                        string = null;
                        string = model.getLoginId();
                        if (string2.equals(string)) break block4;
                        model = o2;
                        string = null;
                        String string3 = string = model.getOwner();
                        model = user;
                        string = null;
                        string = model.getLoginId();
                        if (!string3.equals(string)) break block5;
                    }
                    return Integer.MIN_VALUE;
                }
                model = o1;
                string = null;
                String string4 = string = model.getOwner();
                model = o2;
                string = null;
                string = model.getOwner();
                if (string4.equals(string)) {
                    model = o1;
                    string = null;
                    String string5 = string = model.getProjectName();
                    model = o2;
                    string = null;
                    string = model.getProjectName();
                    return string5.compareToIgnoreCase(string);
                }
                model = o1;
                string = null;
                String string6 = string = model.getOwner();
                model = o2;
                string = null;
                string = model.getOwner();
                return string6.compareToIgnoreCase(string);
            }
        });
        ArrayList<Project> projects2 = new ArrayList<Project>();
        Iterator iterator = this._ebean_get_favoriteProjects().iterator();
        while (iterator.hasNext()) {
            FavoriteProject favoriteProject;
            FavoriteProject favoriteProject2 = favoriteProject = (FavoriteProject)((Object)iterator.next());
            Project project2 = null;
            project2 = favoriteProject2.getProject();
            project2.refresh();
            favoriteProject2 = favoriteProject;
            project2 = null;
            project2 = favoriteProject2.getProject();
            projects2.add(project2);
        }
        return projects2;
    }

    public void updateFavoriteProject(@Nonnull Project project2) {
        for (FavoriteProject favoriteProject : this._ebean_get_favoriteProjects()) {
            Model model = favoriteProject;
            Object object = null;
            object = model.getProject();
            model = object;
            object = null;
            Object object2 = object = model.getId();
            model = project2;
            object = null;
            object = model.getId();
            if (!((Long)object2).equals(object)) continue;
            model = favoriteProject;
            object = null;
            object = model.getProject();
            object.refresh();
        }
    }

    public void updateFavoriteOrganization(@Nonnull Organization organization2) {
        for (FavoriteOrganization favoriteOrganization : this._ebean_get_favoriteOrganizations()) {
            Model model = favoriteOrganization;
            Object object = null;
            object = model.getOrganization();
            model = object;
            object = null;
            Object object2 = object = model.getId();
            model = organization2;
            object = null;
            object = model.getId();
            if (!((Long)object2).equals(object)) continue;
            model = favoriteOrganization;
            object = null;
            object = model.getOrganization();
            object.refresh();
        }
    }

    public boolean toggleFavoriteProject(Long projectId) {
        for (FavoriteProject favoriteProject : this._ebean_get_favoriteProjects()) {
            Model model = favoriteProject;
            Object object = null;
            object = model.getProject();
            model = object;
            object = null;
            object = model.getId();
            if (!((Long)object).equals(projectId)) continue;
            this.removeFavoriteProject(projectId);
            this._ebean_get_favoriteProjects().remove((Object)favoriteProject);
            model = favoriteProject;
            object = null;
            object = model.getProject();
            RecentProject.deletePrevious(this, (Project)object);
            return false;
        }
        FavoriteProject favoriteProject = new FavoriteProject(this, (Project)Project.find.byId((Object)projectId));
        this._ebean_get_favoriteProjects().add(favoriteProject);
        favoriteProject.save();
        return true;
    }

    public void removeFavoriteProject(Long projectId) {
        User user = this;
        Long l = null;
        l = user.getId();
        List list2 = FavoriteProject.finder.where().eq("user.id", (Object)l).eq("project.id", (Object)projectId).findList();
        if (list2 != null && list2.size() > 0) {
            this._ebean_get_favoriteProjects().remove(list2.get(0));
            ((FavoriteProject)((Object)list2.get(0))).delete();
        }
    }

    public List<Organization> getFavoriteOrganizations() {
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        Iterator iterator = this._ebean_get_favoriteOrganizations().iterator();
        while (iterator.hasNext()) {
            FavoriteOrganization favoriteOrganization;
            FavoriteOrganization favoriteOrganization2 = favoriteOrganization = (FavoriteOrganization)((Object)iterator.next());
            Organization organization2 = null;
            organization2 = favoriteOrganization2.getOrganization();
            organization2.refresh();
            favoriteOrganization2 = favoriteOrganization;
            organization2 = null;
            organization2 = favoriteOrganization2.getOrganization();
            organizations.add(0, organization2);
        }
        return organizations;
    }

    public boolean toggleFavoriteOrganization(Long organizationId) {
        for (FavoriteOrganization favoriteOrganization : this._ebean_get_favoriteOrganizations()) {
            Model model = favoriteOrganization;
            Object object = null;
            object = model.getOrganization();
            model = object;
            object = null;
            object = model.getId();
            if (!((Long)object).equals(organizationId)) continue;
            this.removeFavoriteOrganization(organizationId);
            this._ebean_get_favoriteOrganizations().remove((Object)favoriteOrganization);
            return false;
        }
        FavoriteOrganization favoriteOrganization = new FavoriteOrganization(this, (Organization)Organization.find.byId((Object)organizationId));
        this._ebean_get_favoriteOrganizations().add(favoriteOrganization);
        favoriteOrganization.save();
        return true;
    }

    private void removeFavoriteOrganization(Long organizationId) {
        User user = this;
        Long l = null;
        l = user.getId();
        List list2 = FavoriteOrganization.finder.where().eq("user.id", (Object)l).eq("organization.id", (Object)organizationId).findList();
        if (list2 != null && list2.size() > 0) {
            this._ebean_get_favoriteOrganizations().remove(list2.get(0));
            ((FavoriteOrganization)((Object)list2.get(0))).delete();
        }
    }

    public List<Issue> getFavoriteIssues() {
        ArrayList<Issue> issues2 = new ArrayList<Issue>();
        Iterator iterator = this._ebean_get_favoriteIssues().iterator();
        while (iterator.hasNext()) {
            FavoriteIssue favoriteIssue;
            FavoriteIssue favoriteIssue2 = favoriteIssue = (FavoriteIssue)((Object)iterator.next());
            Issue issue2 = null;
            issue2 = favoriteIssue2.getIssue();
            issue2.refresh();
            favoriteIssue2 = favoriteIssue;
            issue2 = null;
            issue2 = favoriteIssue2.getIssue();
            issues2.add(0, issue2);
        }
        return issues2;
    }

    public void updateFavoriteIssue(@Nonnull Issue issue2) {
        for (FavoriteIssue favoriteIssue : this._ebean_get_favoriteIssues()) {
            Model model = favoriteIssue;
            Object object = null;
            object = model.getIssue();
            model = object;
            object = null;
            Object object2 = object = model.getId();
            model = issue2;
            object = null;
            object = model.getId();
            if (!((Long)object2).equals(object)) continue;
            model = favoriteIssue;
            object = null;
            object = model.getIssue();
            object.refresh();
        }
    }

    public boolean toggleFavoriteIssue(Long issueId) {
        for (FavoriteIssue favoriteIssue : this._ebean_get_favoriteIssues()) {
            Model model = favoriteIssue;
            Object object = null;
            object = model.getIssue();
            model = object;
            object = null;
            object = model.getId();
            if (!((Long)object).equals(issueId)) continue;
            this.removeFavoriteIssue(issueId);
            this._ebean_get_favoriteIssues().remove((Object)favoriteIssue);
            return false;
        }
        FavoriteIssue favoriteIssue = new FavoriteIssue(this, (Issue)Issue.finder.byId((Object)issueId));
        this._ebean_get_favoriteIssues().add(favoriteIssue);
        favoriteIssue.save();
        return true;
    }

    public void removeFavoriteIssue(Long issueId) {
        User user = this;
        Long l = null;
        l = user.getId();
        List list2 = FavoriteIssue.find.where().eq("user.id", (Object)l).eq("issue.id", (Object)issueId).findList();
        if (list2 != null && list2.size() > 0) {
            this._ebean_get_favoriteIssues().remove(list2.get(0));
            ((FavoriteIssue)((Object)list2.get(0))).delete();
        }
    }

    public List<Project> getIssueMovableProject() {
        LinkedHashSet<Project> projects2 = new LinkedHashSet<Project>();
        projects2.addAll(this.getFavoriteProjects());
        projects2.addAll(this.getVisitedProjects());
        User user = this;
        Long l = null;
        l = user.getId();
        projects2.addAll(Project.findProjectsByMember(l));
        ArrayList<Project> list2 = new ArrayList<Project>();
        list2.addAll(projects2);
        Collections.sort(list2, new Comparator<Project>(){

            @Override
            public int compare(Project lhs, Project rhs) {
                Project project2 = lhs;
                String string = null;
                String string2 = string = project2.getOwner();
                project2 = rhs;
                string = null;
                string = project2.getOwner();
                if (string2.compareToIgnoreCase(string) == 0) {
                    project2 = lhs;
                    string = null;
                    String string3 = string = project2.getName();
                    project2 = rhs;
                    string = null;
                    string = project2.getName();
                    return string3.compareToIgnoreCase(string);
                }
                project2 = lhs;
                string = null;
                String string4 = string = project2.getOwner();
                project2 = rhs;
                string = null;
                string = project2.getOwner();
                return string4.compareToIgnoreCase(string);
            }
        });
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLocked() {
        User user = this;
        UserState userState = null;
        userState = user.getState();
        if (userState == UserState.LOCKED) return true;
        user = this;
        userState = null;
        userState = user.getState();
        if (userState != UserState.DELETED) return false;
        return true;
    }

    public String getPureNameOnly() {
        String[] spliters;
        User user = UserApp.currentUser();
        String string = null;
        string = user.getLang();
        String currentUserLanguage = StringUtils.defaultString((String)string, (String)"ko-KR");
        user = this;
        string = null;
        string = user.getEnglishName();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            user = this;
            string = null;
            string = user.getLang();
            if (string != null && currentUserLanguage.startsWith("en")) {
                user = this;
                string = null;
                string = user.getEnglishName();
                return string;
            }
        }
        user = this;
        string = null;
        String pureName = string = user.getName();
        for (String spliter : spliters = new String[]{"[", "("}) {
            if (pureName == null) {
                this.refresh();
                user = this;
                string = null;
                pureName = string = user.getName();
            }
            if (!pureName.contains(spliter)) continue;
            user = this;
            string = null;
            String string2 = string = user.getName();
            user = this;
            string = null;
            string = user.getName();
            pureName = string2.substring(0, string.indexOf(spliter)).trim();
        }
        return pureName;
    }

    public String getPureNameOnly(String targetLang) {
        String[] spliters;
        User user = this;
        String string = null;
        string = user.getEnglishName();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            user = this;
            string = null;
            string = user.getLang();
            if (string != null && StringUtils.isNotBlank((CharSequence)targetLang) && targetLang.startsWith("en")) {
                user = this;
                string = null;
                string = user.getEnglishName();
                return string;
            }
        }
        user = this;
        string = null;
        String pureName = string = user.getName();
        for (String spliter : spliters = new String[]{"[", "("}) {
            if (!pureName.contains(spliter)) continue;
            user = this;
            string = null;
            String string2 = string = user.getName();
            user = this;
            string = null;
            string = user.getName();
            pureName = string2.substring(0, string.indexOf(spliter));
        }
        return pureName;
    }

    public String extractDepartmentPart() {
        String[] spliters;
        User user = this;
        String string = null;
        String departmentName = string = user.getName();
        for (String spliter : spliters = new String[]{"[", "("}) {
            if (!departmentName.contains(spliter)) continue;
            user = this;
            string = null;
            String string2 = string = user.getName();
            user = this;
            string = null;
            string = user.getName();
            departmentName = string2.substring(string.indexOf(spliter));
        }
        return departmentName;
    }

    public String getDisplayName() {
        if (UserApp.currentUser().isAnonymous()) {
            User user = this;
            String string = null;
            string = user.getName();
            return string;
        }
        User user = this;
        String string = null;
        string = user.getEnglishName();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            user = this;
            string = null;
            string = user.getLang();
            if (string != null) {
                user = UserApp.currentUser();
                string = null;
                string = user.getLang();
                if (string.startsWith("en")) {
                    user = this;
                    string = null;
                    string = user.getEnglishName();
                    return string + " " + this.extractDepartmentPart();
                }
            }
        }
        user = this;
        string = null;
        string = user.getName();
        return string;
    }

    public String getDisplayName(User forCurrentUser) {
        User user = this;
        String string = null;
        string = user.getEnglishName();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            user = this;
            string = null;
            string = user.getLang();
            if (string != null) {
                user = forCurrentUser;
                string = null;
                string = user.getLang();
                if (string.startsWith("en")) {
                    user = this;
                    string = null;
                    string = user.getEnglishName();
                    return string + " " + this.extractDepartmentPart();
                }
            }
        }
        user = this;
        string = null;
        string = user.getName();
        return string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getEnglishName() {
        return this._ebean_get_englishName();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEnglishName(String string) {
        this._ebean_set_englishName(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getLoginId() {
        return this._ebean_get_loginId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLoginId(String string) {
        this._ebean_set_loginId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getOldPassword() {
        return this.oldPassword;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOldPassword(String string) {
        this.oldPassword = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPassword() {
        return this._ebean_get_password();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPassword(String string) {
        this._ebean_set_password(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPasswordSalt() {
        return this._ebean_get_passwordSalt();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPasswordSalt(String string) {
        this._ebean_set_passwordSalt(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getEmail() {
        return this._ebean_get_email();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEmail(String string) {
        this._ebean_set_email(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getToken() {
        return this._ebean_get_token();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setToken(String string) {
        this._ebean_set_token(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getRememberMe() {
        return this._ebean_get_rememberMe();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRememberMe(boolean bl) {
        this._ebean_set_rememberMe(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public UserState getState() {
        return this._ebean_get_state();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setState(UserState userState) {
        this._ebean_set_state(userState);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getLastStateModifiedDate() {
        return this._ebean_get_lastStateModifiedDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLastStateModifiedDate(Date date) {
        this._ebean_set_lastStateModifiedDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<ProjectUser> getProjectUser() {
        return this._ebean_get_projectUser();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectUser(List<ProjectUser> list2) {
        this._ebean_set_projectUser(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<OrganizationUser> getGroupUser() {
        return this._ebean_get_groupUser();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setGroupUser(List<OrganizationUser> list2) {
        this._ebean_set_groupUser(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFavoriteIssues(List<FavoriteIssue> list2) {
        this._ebean_set_favoriteIssues(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEnrolledProjects(List<Project> list2) {
        this._ebean_set_enrolledProjects(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEnrolledOrganizations(List<Organization> list2) {
        this._ebean_set_enrolledOrganizations(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<NotificationEvent> getNotificationEvents() {
        return this._ebean_get_notificationEvents();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNotificationEvents(List<NotificationEvent> list2) {
        this._ebean_set_notificationEvents(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<Email> getEmails() {
        return this._ebean_get_emails();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEmails(List<Email> list2) {
        this._ebean_set_emails(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<Mention> getMentions() {
        return this._ebean_get_mentions();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMentions(List<Mention> list2) {
        this._ebean_set_mentions(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFavoriteProjects(List<FavoriteProject> list2) {
        this._ebean_set_favoriteProjects(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFavoriteOrganizations(List<FavoriteOrganization> list2) {
        this._ebean_set_favoriteOrganizations(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getLang() {
        return this._ebean_get_lang();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLang(String string) {
        this._ebean_set_lang(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getLastVisitedProjectId() {
        return this.lastVisitedProjectId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLastVisitedProjectId(Long l) {
        this.lastVisitedProjectId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getLastVisitedIssueId() {
        return this.lastVisitedIssueId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLastVisitedIssueId(Long l) {
        this.lastVisitedIssueId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<OrganizationUser> getOrganizationUsers() {
        return this._ebean_get_organizationUsers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOrganizationUsers(List<OrganizationUser> list2) {
        this._ebean_set_organizationUsers(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getIsGuest() {
        return this._ebean_get_isGuest();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsGuest(boolean bl) {
        this._ebean_set_isGuest(bl);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected String _ebean_get_englishName() {
        this._ebean_intercept.preGetter("englishName");
        return this.englishName;
    }

    protected void _ebean_set_englishName(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "englishName", (Object)this._ebean_get_englishName(), (Object)newValue);
        this.englishName = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_englishName() {
        return this.englishName;
    }

    protected void _ebean_setni_englishName(String _newValue) {
        this.englishName = _newValue;
    }

    protected String _ebean_get_loginId() {
        this._ebean_intercept.preGetter("loginId");
        return this.loginId;
    }

    protected void _ebean_set_loginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "loginId", (Object)this._ebean_get_loginId(), (Object)newValue);
        this.loginId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_loginId() {
        return this.loginId;
    }

    protected void _ebean_setni_loginId(String _newValue) {
        this.loginId = _newValue;
    }

    protected String _ebean_get_oldPassword() {
        return this.oldPassword;
    }

    protected void _ebean_set_oldPassword(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "oldPassword", (Object)this._ebean_get_oldPassword(), (Object)newValue);
        this.oldPassword = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_oldPassword() {
        return this.oldPassword;
    }

    protected void _ebean_setni_oldPassword(String _newValue) {
        this.oldPassword = _newValue;
    }

    protected String _ebean_get_password() {
        this._ebean_intercept.preGetter("password");
        return this.password;
    }

    protected void _ebean_set_password(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "password", (Object)this._ebean_get_password(), (Object)newValue);
        this.password = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_password() {
        return this.password;
    }

    protected void _ebean_setni_password(String _newValue) {
        this.password = _newValue;
    }

    protected String _ebean_get_passwordSalt() {
        this._ebean_intercept.preGetter("passwordSalt");
        return this.passwordSalt;
    }

    protected void _ebean_set_passwordSalt(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "passwordSalt", (Object)this._ebean_get_passwordSalt(), (Object)newValue);
        this.passwordSalt = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_passwordSalt() {
        return this.passwordSalt;
    }

    protected void _ebean_setni_passwordSalt(String _newValue) {
        this.passwordSalt = _newValue;
    }

    protected String _ebean_get_email() {
        this._ebean_intercept.preGetter("email");
        return this.email;
    }

    protected void _ebean_set_email(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "email", (Object)this._ebean_get_email(), (Object)newValue);
        this.email = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_email() {
        return this.email;
    }

    protected void _ebean_setni_email(String _newValue) {
        this.email = _newValue;
    }

    protected String _ebean_get_token() {
        this._ebean_intercept.preGetter("token");
        return this.token;
    }

    protected void _ebean_set_token(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "token", (Object)this._ebean_get_token(), (Object)newValue);
        this.token = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_token() {
        return this.token;
    }

    protected void _ebean_setni_token(String _newValue) {
        this.token = _newValue;
    }

    protected Boolean _ebean_get_siteManager() {
        return this.siteManager;
    }

    protected void _ebean_set_siteManager(Boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "siteManager", (Object)this._ebean_get_siteManager(), (Object)newValue);
        this.siteManager = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Boolean _ebean_getni_siteManager() {
        return this.siteManager;
    }

    protected void _ebean_setni_siteManager(Boolean _newValue) {
        this.siteManager = _newValue;
    }

    protected Map _ebean_get_projectManagerMemo() {
        return this.projectManagerMemo;
    }

    protected void _ebean_set_projectManagerMemo(Map newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "projectManagerMemo", (Object)this._ebean_get_projectManagerMemo(), (Object)newValue);
        this.projectManagerMemo = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Map _ebean_getni_projectManagerMemo() {
        return this.projectManagerMemo;
    }

    protected void _ebean_setni_projectManagerMemo(Map _newValue) {
        this.projectManagerMemo = _newValue;
    }

    protected Map _ebean_get_projectMembersMemo() {
        return this.projectMembersMemo;
    }

    protected void _ebean_set_projectMembersMemo(Map newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "projectMembersMemo", (Object)this._ebean_get_projectMembersMemo(), (Object)newValue);
        this.projectMembersMemo = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Map _ebean_getni_projectMembersMemo() {
        return this.projectMembersMemo;
    }

    protected void _ebean_setni_projectMembersMemo(Map _newValue) {
        this.projectMembersMemo = _newValue;
    }

    protected Map _ebean_get_orgMembersMemo() {
        return this.orgMembersMemo;
    }

    protected void _ebean_set_orgMembersMemo(Map newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "orgMembersMemo", (Object)this._ebean_get_orgMembersMemo(), (Object)newValue);
        this.orgMembersMemo = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Map _ebean_getni_orgMembersMemo() {
        return this.orgMembersMemo;
    }

    protected void _ebean_setni_orgMembersMemo(Map _newValue) {
        this.orgMembersMemo = _newValue;
    }

    protected boolean _ebean_get_rememberMe() {
        this._ebean_intercept.preGetter("rememberMe");
        return this.rememberMe;
    }

    protected void _ebean_set_rememberMe(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "rememberMe", this._ebean_get_rememberMe(), newValue);
        this.rememberMe = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_rememberMe() {
        return this.rememberMe;
    }

    protected void _ebean_setni_rememberMe(boolean _newValue) {
        this.rememberMe = _newValue;
    }

    protected UserState _ebean_get_state() {
        this._ebean_intercept.preGetter("state");
        return this.state;
    }

    protected void _ebean_set_state(UserState newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "state", (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected UserState _ebean_getni_state() {
        return this.state;
    }

    protected void _ebean_setni_state(UserState _newValue) {
        this.state = _newValue;
    }

    protected Date _ebean_get_lastStateModifiedDate() {
        this._ebean_intercept.preGetter("lastStateModifiedDate");
        return this.lastStateModifiedDate;
    }

    protected void _ebean_set_lastStateModifiedDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "lastStateModifiedDate", (Object)this._ebean_get_lastStateModifiedDate(), (Object)newValue);
        this.lastStateModifiedDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_lastStateModifiedDate() {
        return this.lastStateModifiedDate;
    }

    protected void _ebean_setni_lastStateModifiedDate(Date _newValue) {
        this.lastStateModifiedDate = _newValue;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
    }

    protected List _ebean_get_projectUser() {
        this._ebean_intercept.preGetter("projectUser");
        if (this.projectUser == null) {
            this.projectUser = new BeanList();
        }
        return this.projectUser;
    }

    protected void _ebean_set_projectUser(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "projectUser", (Object)this._ebean_get_projectUser(), (Object)newValue);
        this.projectUser = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_projectUser() {
        return this.projectUser;
    }

    protected void _ebean_setni_projectUser(List _newValue) {
        this.projectUser = _newValue;
    }

    protected List _ebean_get_groupUser() {
        this._ebean_intercept.preGetter("groupUser");
        if (this.groupUser == null) {
            this.groupUser = new BeanList();
        }
        return this.groupUser;
    }

    protected void _ebean_set_groupUser(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "groupUser", (Object)this._ebean_get_groupUser(), (Object)newValue);
        this.groupUser = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_groupUser() {
        return this.groupUser;
    }

    protected void _ebean_setni_groupUser(List _newValue) {
        this.groupUser = _newValue;
    }

    protected List _ebean_get_favoriteIssues() {
        this._ebean_intercept.preGetter("favoriteIssues");
        if (this.favoriteIssues == null) {
            this.favoriteIssues = new BeanList();
        }
        return this.favoriteIssues;
    }

    protected void _ebean_set_favoriteIssues(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "favoriteIssues", (Object)this._ebean_get_favoriteIssues(), (Object)newValue);
        this.favoriteIssues = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_favoriteIssues() {
        return this.favoriteIssues;
    }

    protected void _ebean_setni_favoriteIssues(List _newValue) {
        this.favoriteIssues = _newValue;
    }

    protected List _ebean_get_enrolledProjects() {
        this._ebean_intercept.preGetter("enrolledProjects");
        if (this.enrolledProjects == null) {
            this.enrolledProjects = new BeanList();
            ((BeanCollection)this.enrolledProjects).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.enrolledProjects;
    }

    protected void _ebean_set_enrolledProjects(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "enrolledProjects", (Object)this._ebean_get_enrolledProjects(), (Object)newValue);
        this.enrolledProjects = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_enrolledProjects() {
        return this.enrolledProjects;
    }

    protected void _ebean_setni_enrolledProjects(List _newValue) {
        this.enrolledProjects = _newValue;
    }

    protected List _ebean_get_enrolledOrganizations() {
        this._ebean_intercept.preGetter("enrolledOrganizations");
        if (this.enrolledOrganizations == null) {
            this.enrolledOrganizations = new BeanList();
            ((BeanCollection)this.enrolledOrganizations).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.enrolledOrganizations;
    }

    protected void _ebean_set_enrolledOrganizations(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "enrolledOrganizations", (Object)this._ebean_get_enrolledOrganizations(), (Object)newValue);
        this.enrolledOrganizations = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_enrolledOrganizations() {
        return this.enrolledOrganizations;
    }

    protected void _ebean_setni_enrolledOrganizations(List _newValue) {
        this.enrolledOrganizations = _newValue;
    }

    protected List _ebean_get_notificationEvents() {
        this._ebean_intercept.preGetter("notificationEvents");
        if (this.notificationEvents == null) {
            this.notificationEvents = new BeanList();
            ((BeanCollection)this.notificationEvents).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.notificationEvents;
    }

    protected void _ebean_set_notificationEvents(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "notificationEvents", (Object)this._ebean_get_notificationEvents(), (Object)newValue);
        this.notificationEvents = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_notificationEvents() {
        return this.notificationEvents;
    }

    protected void _ebean_setni_notificationEvents(List _newValue) {
        this.notificationEvents = _newValue;
    }

    protected List _ebean_get_emails() {
        this._ebean_intercept.preGetter("emails");
        if (this.emails == null) {
            this.emails = new BeanList();
        }
        return this.emails;
    }

    protected void _ebean_set_emails(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "emails", (Object)this._ebean_get_emails(), (Object)newValue);
        this.emails = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_emails() {
        return this.emails;
    }

    protected void _ebean_setni_emails(List _newValue) {
        this.emails = _newValue;
    }

    protected List _ebean_get_mentions() {
        this._ebean_intercept.preGetter("mentions");
        if (this.mentions == null) {
            this.mentions = new BeanList();
        }
        return this.mentions;
    }

    protected void _ebean_set_mentions(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "mentions", (Object)this._ebean_get_mentions(), (Object)newValue);
        this.mentions = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_mentions() {
        return this.mentions;
    }

    protected void _ebean_setni_mentions(List _newValue) {
        this.mentions = _newValue;
    }

    protected List _ebean_get_favoriteProjects() {
        this._ebean_intercept.preGetter("favoriteProjects");
        if (this.favoriteProjects == null) {
            this.favoriteProjects = new BeanList();
        }
        return this.favoriteProjects;
    }

    protected void _ebean_set_favoriteProjects(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "favoriteProjects", (Object)this._ebean_get_favoriteProjects(), (Object)newValue);
        this.favoriteProjects = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_favoriteProjects() {
        return this.favoriteProjects;
    }

    protected void _ebean_setni_favoriteProjects(List _newValue) {
        this.favoriteProjects = _newValue;
    }

    protected List _ebean_get_favoriteOrganizations() {
        this._ebean_intercept.preGetter("favoriteOrganizations");
        if (this.favoriteOrganizations == null) {
            this.favoriteOrganizations = new BeanList();
        }
        return this.favoriteOrganizations;
    }

    protected void _ebean_set_favoriteOrganizations(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "favoriteOrganizations", (Object)this._ebean_get_favoriteOrganizations(), (Object)newValue);
        this.favoriteOrganizations = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_favoriteOrganizations() {
        return this.favoriteOrganizations;
    }

    protected void _ebean_setni_favoriteOrganizations(List _newValue) {
        this.favoriteOrganizations = _newValue;
    }

    protected String _ebean_get_lang() {
        this._ebean_intercept.preGetter("lang");
        return this.lang;
    }

    protected void _ebean_set_lang(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "lang", (Object)this._ebean_get_lang(), (Object)newValue);
        this.lang = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_lang() {
        return this.lang;
    }

    protected void _ebean_setni_lang(String _newValue) {
        this.lang = _newValue;
    }

    protected Long _ebean_get_lastVisitedProjectId() {
        return this.lastVisitedProjectId;
    }

    protected void _ebean_set_lastVisitedProjectId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "lastVisitedProjectId", (Object)this._ebean_get_lastVisitedProjectId(), (Object)newValue);
        this.lastVisitedProjectId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_lastVisitedProjectId() {
        return this.lastVisitedProjectId;
    }

    protected void _ebean_setni_lastVisitedProjectId(Long _newValue) {
        this.lastVisitedProjectId = _newValue;
    }

    protected Long _ebean_get_lastVisitedIssueId() {
        return this.lastVisitedIssueId;
    }

    protected void _ebean_set_lastVisitedIssueId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "lastVisitedIssueId", (Object)this._ebean_get_lastVisitedIssueId(), (Object)newValue);
        this.lastVisitedIssueId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_lastVisitedIssueId() {
        return this.lastVisitedIssueId;
    }

    protected void _ebean_setni_lastVisitedIssueId(Long _newValue) {
        this.lastVisitedIssueId = _newValue;
    }

    protected List _ebean_get_organizationUsers() {
        this._ebean_intercept.preGetter("organizationUsers");
        if (this.organizationUsers == null) {
            this.organizationUsers = new BeanList();
        }
        return this.organizationUsers;
    }

    protected void _ebean_set_organizationUsers(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "organizationUsers", (Object)this._ebean_get_organizationUsers(), (Object)newValue);
        this.organizationUsers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_organizationUsers() {
        return this.organizationUsers;
    }

    protected void _ebean_setni_organizationUsers(List _newValue) {
        this.organizationUsers = _newValue;
    }

    protected boolean _ebean_get_isGuest() {
        this._ebean_intercept.preGetter("isGuest");
        return this.isGuest;
    }

    protected void _ebean_set_isGuest(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "isGuest", this._ebean_get_isGuest(), newValue);
        this.isGuest = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_isGuest() {
        return this.isGuest;
    }

    protected void _ebean_setni_isGuest(boolean _newValue) {
        this.isGuest = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        User user = new User();
        user.id = this.id;
        user.name = this.name;
        user.englishName = this.englishName;
        user.loginId = this.loginId;
        user.password = this.password;
        user.passwordSalt = this.passwordSalt;
        user.email = this.email;
        user.token = this.token;
        user.rememberMe = this.rememberMe;
        user.state = this.state;
        user.lastStateModifiedDate = this.lastStateModifiedDate;
        user.createdDate = this.createdDate;
        user.projectUser = this.projectUser;
        user.groupUser = this.groupUser;
        user.favoriteIssues = this.favoriteIssues;
        user.enrolledProjects = this.enrolledProjects;
        user.enrolledOrganizations = this.enrolledOrganizations;
        user.notificationEvents = this.notificationEvents;
        user.emails = this.emails;
        user.mentions = this.mentions;
        user.favoriteProjects = this.favoriteProjects;
        user.favoriteOrganizations = this.favoriteOrganizations;
        user.lang = this.lang;
        user.organizationUsers = this.organizationUsers;
        user.isGuest = this.isGuest;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        User p = (User)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.name;
            }
            case 3: {
                return p.englishName;
            }
            case 4: {
                return p.loginId;
            }
            case 5: {
                return p.oldPassword;
            }
            case 6: {
                return p.password;
            }
            case 7: {
                return p.passwordSalt;
            }
            case 8: {
                return p.email;
            }
            case 9: {
                return p.token;
            }
            case 10: {
                return p.siteManager;
            }
            case 11: {
                return p.projectManagerMemo;
            }
            case 12: {
                return p.projectMembersMemo;
            }
            case 13: {
                return p.orgMembersMemo;
            }
            case 14: {
                return p.rememberMe;
            }
            case 15: {
                return p.state;
            }
            case 16: {
                return p.lastStateModifiedDate;
            }
            case 17: {
                return p.createdDate;
            }
            case 18: {
                return p.projectUser;
            }
            case 19: {
                return p.groupUser;
            }
            case 20: {
                return p.favoriteIssues;
            }
            case 21: {
                return p.enrolledProjects;
            }
            case 22: {
                return p.enrolledOrganizations;
            }
            case 23: {
                return p.notificationEvents;
            }
            case 24: {
                return p.emails;
            }
            case 25: {
                return p.mentions;
            }
            case 26: {
                return p.favoriteProjects;
            }
            case 27: {
                return p.favoriteOrganizations;
            }
            case 28: {
                return p.lang;
            }
            case 29: {
                return p.lastVisitedProjectId;
            }
            case 30: {
                return p.lastVisitedIssueId;
            }
            case 31: {
                return p.organizationUsers;
            }
            case 32: {
                return p.isGuest;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        User p = (User)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_name();
            }
            case 3: {
                return p._ebean_get_englishName();
            }
            case 4: {
                return p._ebean_get_loginId();
            }
            case 5: {
                return p._ebean_get_oldPassword();
            }
            case 6: {
                return p._ebean_get_password();
            }
            case 7: {
                return p._ebean_get_passwordSalt();
            }
            case 8: {
                return p._ebean_get_email();
            }
            case 9: {
                return p._ebean_get_token();
            }
            case 10: {
                return p._ebean_get_siteManager();
            }
            case 11: {
                return p._ebean_get_projectManagerMemo();
            }
            case 12: {
                return p._ebean_get_projectMembersMemo();
            }
            case 13: {
                return p._ebean_get_orgMembersMemo();
            }
            case 14: {
                return p._ebean_get_rememberMe();
            }
            case 15: {
                return p._ebean_get_state();
            }
            case 16: {
                return p._ebean_get_lastStateModifiedDate();
            }
            case 17: {
                return p._ebean_get_createdDate();
            }
            case 18: {
                return p._ebean_get_projectUser();
            }
            case 19: {
                return p._ebean_get_groupUser();
            }
            case 20: {
                return p._ebean_get_favoriteIssues();
            }
            case 21: {
                return p._ebean_get_enrolledProjects();
            }
            case 22: {
                return p._ebean_get_enrolledOrganizations();
            }
            case 23: {
                return p._ebean_get_notificationEvents();
            }
            case 24: {
                return p._ebean_get_emails();
            }
            case 25: {
                return p._ebean_get_mentions();
            }
            case 26: {
                return p._ebean_get_favoriteProjects();
            }
            case 27: {
                return p._ebean_get_favoriteOrganizations();
            }
            case 28: {
                return p._ebean_get_lang();
            }
            case 29: {
                return p._ebean_get_lastVisitedProjectId();
            }
            case 30: {
                return p._ebean_get_lastVisitedIssueId();
            }
            case 31: {
                return p._ebean_get_organizationUsers();
            }
            case 32: {
                return p._ebean_get_isGuest();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        User p = (User)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.name = (String)arg;
                return;
            }
            case 3: {
                p.englishName = (String)arg;
                return;
            }
            case 4: {
                p.loginId = (String)arg;
                return;
            }
            case 5: {
                p.oldPassword = (String)arg;
                return;
            }
            case 6: {
                p.password = (String)arg;
                return;
            }
            case 7: {
                p.passwordSalt = (String)arg;
                return;
            }
            case 8: {
                p.email = (String)arg;
                return;
            }
            case 9: {
                p.token = (String)arg;
                return;
            }
            case 10: {
                p.siteManager = (Boolean)arg;
                return;
            }
            case 11: {
                p.projectManagerMemo = (Map)arg;
                return;
            }
            case 12: {
                p.projectMembersMemo = (Map)arg;
                return;
            }
            case 13: {
                p.orgMembersMemo = (Map)arg;
                return;
            }
            case 14: {
                p.rememberMe = (Boolean)arg;
                return;
            }
            case 15: {
                p.state = (UserState)((Object)arg);
                return;
            }
            case 16: {
                p.lastStateModifiedDate = (Date)arg;
                return;
            }
            case 17: {
                p.createdDate = (Date)arg;
                return;
            }
            case 18: {
                p.projectUser = (List)arg;
                return;
            }
            case 19: {
                p.groupUser = (List)arg;
                return;
            }
            case 20: {
                p.favoriteIssues = (List)arg;
                return;
            }
            case 21: {
                p.enrolledProjects = (List)arg;
                return;
            }
            case 22: {
                p.enrolledOrganizations = (List)arg;
                return;
            }
            case 23: {
                p.notificationEvents = (List)arg;
                return;
            }
            case 24: {
                p.emails = (List)arg;
                return;
            }
            case 25: {
                p.mentions = (List)arg;
                return;
            }
            case 26: {
                p.favoriteProjects = (List)arg;
                return;
            }
            case 27: {
                p.favoriteOrganizations = (List)arg;
                return;
            }
            case 28: {
                p.lang = (String)arg;
                return;
            }
            case 29: {
                p.lastVisitedProjectId = (Long)arg;
                return;
            }
            case 30: {
                p.lastVisitedIssueId = (Long)arg;
                return;
            }
            case 31: {
                p.organizationUsers = (List)arg;
                return;
            }
            case 32: {
                p.isGuest = (Boolean)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        User p = (User)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_englishName((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_loginId((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_oldPassword((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_password((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_passwordSalt((String)arg);
                return;
            }
            case 8: {
                p._ebean_set_email((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_token((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_siteManager((Boolean)arg);
                return;
            }
            case 11: {
                p._ebean_set_projectManagerMemo((Map)arg);
                return;
            }
            case 12: {
                p._ebean_set_projectMembersMemo((Map)arg);
                return;
            }
            case 13: {
                p._ebean_set_orgMembersMemo((Map)arg);
                return;
            }
            case 14: {
                p._ebean_set_rememberMe((Boolean)arg);
                return;
            }
            case 15: {
                p._ebean_set_state((UserState)((Object)arg));
                return;
            }
            case 16: {
                p._ebean_set_lastStateModifiedDate((Date)arg);
                return;
            }
            case 17: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 18: {
                p._ebean_set_projectUser((List)arg);
                return;
            }
            case 19: {
                p._ebean_set_groupUser((List)arg);
                return;
            }
            case 20: {
                p._ebean_set_favoriteIssues((List)arg);
                return;
            }
            case 21: {
                p._ebean_set_enrolledProjects((List)arg);
                return;
            }
            case 22: {
                p._ebean_set_enrolledOrganizations((List)arg);
                return;
            }
            case 23: {
                p._ebean_set_notificationEvents((List)arg);
                return;
            }
            case 24: {
                p._ebean_set_emails((List)arg);
                return;
            }
            case 25: {
                p._ebean_set_mentions((List)arg);
                return;
            }
            case 26: {
                p._ebean_set_favoriteProjects((List)arg);
                return;
            }
            case 27: {
                p._ebean_set_favoriteOrganizations((List)arg);
                return;
            }
            case 28: {
                p._ebean_set_lang((String)arg);
                return;
            }
            case 29: {
                p._ebean_set_lastVisitedProjectId((Long)arg);
                return;
            }
            case 30: {
                p._ebean_set_lastVisitedIssueId((Long)arg);
                return;
            }
            case 31: {
                p._ebean_set_organizationUsers((List)arg);
                return;
            }
            case 32: {
                p._ebean_set_isGuest((Boolean)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "name", "englishName", "loginId", "oldPassword", "password", "passwordSalt", "email", "token", "siteManager", "projectManagerMemo", "projectMembersMemo", "orgMembersMemo", "rememberMe", "state", "lastStateModifiedDate", "createdDate", "projectUser", "groupUser", "favoriteIssues", "enrolledProjects", "enrolledOrganizations", "notificationEvents", "emails", "mentions", "favoriteProjects", "favoriteOrganizations", "lang", "lastVisitedProjectId", "lastVisitedIssueId", "organizationUsers", "isGuest"};
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new User();
    }
}

