/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.TxScope;
import com.avaje.ebean.annotation.Transactional;
import com.avaje.ebean.bean.EnhancedTransactional;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.HelpScopeTrans;
import com.avaje.ebeaninternal.api.ScopeTrans;
import controllers.UserApp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import models.Project;
import models.Unwatch;
import models.User;
import models.UserAction;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import models.resource.GlobalResource;
import models.resource.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import utils.AccessControl;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Watch
extends UserAction
implements EntityBean,
EnhancedTransactional {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, Watch> find = new Model.Finder(Long.class, Watch.class);
    private static String _EBEAN_MARKER = "models.Watch";

    public static List<Watch> findBy(ResourceType resourceType, String resourceId) {
        return Watch.findBy(find, resourceType, resourceId);
    }

    public static Watch findBy(User watcher, ResourceType resourceType, String resourceId) {
        return Watch.findBy(find, watcher, resourceType, resourceId);
    }

    public static List<Watch> findBy(User user, ResourceType resourceType) {
        return Watch.findBy(find, user, resourceType);
    }

    public static int countBy(ResourceType type, String id) {
        return Watch.countBy(find, type, id);
    }

    public static void watch(Resource resource) {
        Watch.watch(UserApp.currentUser(), resource);
        return;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public static void watch(User user, Resource resource) {
        TxScope txScope = new TxScope();
        ScopeTrans scopeTrans = HelpScopeTrans.createScopeTrans((TxScope)txScope);
        try {
            void resource2;
            User user2;
            Watch.watch(user2, resource2.getType(), resource2.getId());
            HelpScopeTrans.onExitScopeTrans(null, (int)177, (ScopeTrans)scopeTrans);
            return;
        }
        catch (Throwable throwable) {
            HelpScopeTrans.onExitScopeTrans((Object)throwable, (int)191, (ScopeTrans)scopeTrans);
            throw throwable;
        }
    }

    public static void watch(User user, ResourceType resourceType, String resourceId) {
        Unwatch unwatch2;
        Watch watch2 = Watch.findBy(user, resourceType, resourceId);
        if (watch2 == null) {
            watch2 = new Watch();
            Object object = user;
            Watch watch3 = watch2;
            watch3.setUser((User)object);
            object = resourceId;
            watch3 = watch2;
            watch3.setResourceId((String)object);
            object = resourceType;
            watch3 = watch2;
            watch3.setResourceType((ResourceType)((Object)object));
            watch2.save();
        }
        if ((unwatch2 = Unwatch.findBy(user, resourceType, resourceId)) != null) {
            unwatch2.delete();
        }
        return;
    }

    public static void unwatch(Resource resource) {
        Watch.unwatch(UserApp.currentUser(), resource);
        return;
    }

    public static void unwatch(User user, Resource resource) {
        Watch.unwatch(user, resource.getType(), resource.getId());
        return;
    }

    public static void unwatch(User user, ResourceType resourceType, String resourceId) {
        Watch watch2;
        Unwatch unwatch2 = Unwatch.findBy(user, resourceType, resourceId);
        if (unwatch2 == null) {
            unwatch2 = new Unwatch();
            Object object = user;
            Unwatch unwatch3 = unwatch2;
            unwatch3.setUser((User)object);
            object = resourceId;
            unwatch3 = unwatch2;
            unwatch3.setResourceId((String)object);
            object = resourceType;
            unwatch3 = unwatch2;
            unwatch3.setResourceType((ResourceType)((Object)object));
            unwatch2.save();
        }
        if ((watch2 = Watch.findBy(user, resourceType, resourceId)) != null) {
            watch2.delete();
        }
        return;
    }

    public static Set<User> findWatchers(Resource target) {
        return Watch.findWatchers(target.getType(), target.getId());
    }

    public static Set<User> findWatchers(ResourceType resourceType, String resourceId) {
        HashSet<User> users2 = new HashSet<User>();
        Iterator<Watch> iterator = Watch.findBy(resourceType, resourceId).iterator();
        while (iterator.hasNext()) {
            Watch watch2;
            Watch watch3 = watch2 = iterator.next();
            User user = null;
            user = watch3.getUser();
            users2.add(user);
        }
        return users2;
    }

    public static Set<User> findUnwatchers(Resource target) {
        return Watch.findUnwatchers(target.getType(), target.getId());
    }

    public static Set<User> findUnwatchers(ResourceType resourceType, String resourceId) {
        HashSet<User> users2 = new HashSet<User>();
        Iterator<Unwatch> iterator = Unwatch.findBy(resourceType, resourceId).iterator();
        while (iterator.hasNext()) {
            Unwatch unwatch2;
            Unwatch unwatch3 = unwatch2 = iterator.next();
            User user = null;
            user = unwatch3.getUser();
            users2.add(user);
        }
        return users2;
    }

    public static List<String> findWatchedResourceIds(User user, ResourceType resourceType) {
        String string;
        UserAction userAction;
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (Watch watch2 : Watch.findBy(user, resourceType)) {
            userAction = watch2;
            string = null;
            string = userAction.getResourceId();
            resourceIds.add(string);
        }
        for (Unwatch unwatch2 : Unwatch.findBy(user, resourceType)) {
            userAction = unwatch2;
            string = null;
            string = userAction.getResourceId();
            resourceIds.remove(string);
        }
        return resourceIds;
    }

    public static boolean isWatching(User user, ResourceType resourceType, String resourceId) {
        Watch watch2 = Watch.findBy(user, resourceType, resourceId);
        Unwatch unwatch2 = Unwatch.findBy(user, resourceType, resourceId);
        return watch2 != null && unwatch2 == null;
    }

    public static boolean isWatching(User user, Resource resource) {
        return Watch.isWatching(user, resource.getType(), resource.getId());
    }

    public static boolean isWatching(Resource resource) {
        return Watch.isWatching(UserApp.currentUser(), resource.getType(), resource.getId());
    }

    public static Set<User> findActualWatchers(Set<User> baseWatchers, final Resource resource, boolean allowedWatchersOnly) {
        HashSet<User> actualWatchers = new HashSet<User>();
        actualWatchers.addAll(baseWatchers);
        if (!(resource instanceof GlobalResource)) {
            Project project2 = resource.getProject();
            actualWatchers.addAll(Watch.findWatchers(project2.asResource()));
        }
        actualWatchers.addAll(Watch.findWatchers(resource));
        actualWatchers.removeAll(Watch.findUnwatchers(resource));
        if (allowedWatchersOnly) {
            CollectionUtils.filter(actualWatchers, (Predicate)new Predicate(){

                public boolean evaluate(Object watcher) {
                    return AccessControl.isAllowed((User)watcher, resource, Operation.READ);
                }
            });
        }
        return actualWatchers;
    }

    static {
        return;
    }

    @Override
    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object _ebean_createCopy() {
        void p;
        Watch watch2 = new Watch();
        watch2._ebean_setni_id(this._ebean_getni_id());
        watch2._ebean_setni_user(this._ebean_getni_user());
        watch2._ebean_setni_resourceType(this._ebean_getni_resourceType());
        watch2._ebean_setni_resourceId(this._ebean_getni_resourceId());
        return p;
    }

    @Override
    public Object _ebean_getField(int index2, Object o) {
        Watch p = (Watch)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p._ebean_getni_id();
            }
            case 2: {
                return p._ebean_getni_user();
            }
            case 3: {
                return p._ebean_getni_resourceType();
            }
            case 4: {
                return p._ebean_getni_resourceId();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Watch p = (Watch)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_user();
            }
            case 3: {
                return p._ebean_get_resourceType();
            }
            case 4: {
                return p._ebean_get_resourceId();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setField(int index2, Object o, Object arg) {
        Watch p = (Watch)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_setni_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_setni_user((User)arg);
                return;
            }
            case 3: {
                p._ebean_setni_resourceType((ResourceType)((Object)arg));
                return;
            }
            case 4: {
                p._ebean_setni_resourceId((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Watch p = (Watch)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_user((User)arg);
                return;
            }
            case 3: {
                p._ebean_set_resourceType((ResourceType)((Object)arg));
                return;
            }
            case 4: {
                p._ebean_set_resourceId((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "user", "resourceType", "resourceId"};
    }

    @Override
    public void _ebean_setEmbeddedLoaded() {
        return;
    }

    @Override
    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public Object _ebean_newInstance() {
        return new Watch();
    }
}

