/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.util.UnexpectedElementTypeException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import utils.Config;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class YobiUpdate {
    private static final Long UPDATE_NOTIFICATION_INITDELAY_IN_MILLIS = Configuration.root().getMilliseconds("application.update.notification.initdelay", Long.valueOf(5000L));
    private static final Long UPDATE_NOTIFICATION_INTERVAL_IN_MILLIS = Configuration.root().getMilliseconds("application.update.notification.interval", Long.valueOf(3600000L));
    private static final String UPDATE_REPOSITORY_URL = Configuration.root().getString("application.update.repositoryUrl", "http://repo.yona.io/yona/yona");
    private static final String RELEASE_URL_FORMAT = Configuration.root().getString("application.update.releaseUrlFormat", "https://github.com/yona-projects/yona/releases/tag/v%s");
    public static String versionToUpdate = null;
    public static boolean isWatched = true;

    public static void onStart() {
        if (UPDATE_NOTIFICATION_INTERVAL_IN_MILLIS <= 0L) {
            return;
        }
        Akka.system().scheduler().schedule(Duration.create((long)UPDATE_NOTIFICATION_INITDELAY_IN_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS), Duration.create((long)UPDATE_NOTIFICATION_INTERVAL_IN_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable(){

            @Override
            public void run() {
                try {
                    YobiUpdate.refreshVersionToUpdate();
                }
                catch (Exception e) {
                    Logger.warn((String)"Failed to fetch the latest Yobi version to update", (Throwable)e);
                }
            }
        }, (ExecutionContext)Akka.system().dispatcher());
    }

    public static String getReleaseUrl() throws GitAPIException {
        return YobiUpdate.getReleaseUrl(versionToUpdate);
    }

    public static String getReleaseUrl(String version) throws GitAPIException {
        return String.format(RELEASE_URL_FORMAT, version);
    }

    public static void refreshVersionToUpdate() throws GitAPIException {
        versionToUpdate = YobiUpdate.fetchVersionToUpdate();
    }

    public static String fetchVersionToUpdate() throws GitAPIException {
        Version current;
        Version latest = current = Version.valueOf((String)Config.semverize(Config.getCurrentVersion()));
        boolean isUpdateRequired = false;
        Collection refs = Git.lsRemoteRepository().setRemote(UPDATE_REPOSITORY_URL).setHeads(false).setTags(true).call();
        for (Ref ref2 : refs) {
            String tag = ref2.getName().replaceFirst("^refs/tags/", "");
            if (tag.charAt(0) != 'v') continue;
            String versionString = Config.semverize(tag);
            try {
                Version ver = Version.valueOf((String)versionString);
                if (!ver.greaterThan(latest)) continue;
                isUpdateRequired = true;
                latest = ver;
            }
            catch (UnexpectedElementTypeException e) {
                Logger.warn((String)("Failed to parse a version: " + versionString));
            }
        }
        if (isUpdateRequired) {
            return latest.toString();
        }
        return null;
    }
}

