/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import models.PullRequest;
import models.User;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.GitCommit;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GitBranch {
    private String name;
    private String shortName;
    private GitCommit headCommit;
    private User user;
    private PullRequest pullRequest;

    public GitBranch(String name, GitCommit headCommit) {
        this.name = name;
        this.shortName = StringUtils.removeStart((String)name, (String)"refs/heads/");
        this.headCommit = headCommit;
        this.user = User.findByEmail(headCommit.getCommitterEmail());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GitCommit getHeadCommit() {
        return this.headCommit;
    }

    public void setHeadCommit(GitCommit headCommit) {
        this.headCommit = headCommit;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(PullRequest pullRequest2) {
        this.pullRequest = pullRequest2;
    }
}

