/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.TimeZone;
import models.User;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.Commit;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GitCommit
extends Commit {
    private final RevCommit revCommit;
    private PersonIdent authorIdent;
    private PersonIdent committerIdent;
    private String fullMessage;
    private String shortMessage;

    public GitCommit(RevCommit revCommit) {
        this.revCommit = revCommit;
    }

    @Override
    public String getId() {
        return this.revCommit.getName();
    }

    @Override
    public String getMessage() {
        if (this.fullMessage == null) {
            byte[] raw = this.revCommit.getRawBuffer();
            int msgB = RawParseUtils.commitMessage((byte[])raw, (int)0);
            if (msgB < 0) {
                return "";
            }
            Charset enc = GitCommit.parseEncoding(raw, Charset.defaultCharset());
            this.fullMessage = RawParseUtils.decode((Charset)enc, (byte[])raw, (int)msgB, (int)raw.length);
        }
        return this.fullMessage;
    }

    @Override
    public User getAuthor() {
        return User.findByEmail(this.getAuthorEmail());
    }

    @Override
    public String getAuthorName() {
        return this.getAuthorIdent().getName();
    }

    @Override
    public String getShortMessage() {
        if (this.shortMessage == null) {
            byte[] raw = this.revCommit.getRawBuffer();
            int msgB = RawParseUtils.commitMessage((byte[])raw, (int)0);
            if (msgB < 0) {
                return "";
            }
            Charset enc = GitCommit.parseEncoding(raw, Charset.defaultCharset());
            int msgE = RawParseUtils.endOfParagraph((byte[])raw, (int)msgB);
            String str = RawParseUtils.decode((Charset)enc, (byte[])raw, (int)msgB, (int)msgE);
            if (GitCommit.hasLF(raw, msgB, msgE)) {
                str = StringUtils.replaceLineBreaksWithSpace((String)str);
            }
            this.shortMessage = str;
        }
        return this.shortMessage;
    }

    @Override
    public String getAuthorEmail() {
        return this.getAuthorIdent().getEmailAddress();
    }

    @Override
    public Date getAuthorDate() {
        return this.getAuthorIdent().getWhen();
    }

    @Override
    public TimeZone getAuthorTimezone() {
        return this.getAuthorIdent().getTimeZone();
    }

    @Override
    public String getCommitterName() {
        return this.getCommitterIdent().getName();
    }

    @Override
    public String getCommitterEmail() {
        return this.getCommitterIdent().getEmailAddress();
    }

    @Override
    public Date getCommitterDate() {
        return this.getCommitterIdent().getWhen();
    }

    public long getCommitTime() {
        return this.revCommit.getCommitTime();
    }

    @Override
    public TimeZone getCommitterTimezone() {
        return this.getCommitterIdent().getTimeZone();
    }

    @Override
    public int getParentCount() {
        return this.revCommit.getParentCount();
    }

    @Override
    public String getShortId() {
        return this.revCommit.abbreviate(7).name();
    }

    public String getFullId() {
        return this.revCommit.name();
    }

    public final PersonIdent getAuthorIdent() {
        if (this.authorIdent == null) {
            byte[] raw = this.revCommit.getRawBuffer();
            int nameB = RawParseUtils.author((byte[])raw, (int)0);
            if (nameB < 0) {
                return null;
            }
            this.authorIdent = GitCommit.parsePersonIdent(raw, nameB, Charset.defaultCharset());
        }
        return this.authorIdent;
    }

    public final PersonIdent getCommitterIdent() {
        if (this.committerIdent == null) {
            byte[] raw = this.revCommit.getRawBuffer();
            int nameB = RawParseUtils.committer((byte[])raw, (int)0);
            if (nameB < 0) {
                return null;
            }
            this.committerIdent = GitCommit.parsePersonIdent(raw, nameB, Charset.defaultCharset());
        }
        return this.committerIdent;
    }

    public static Charset parseEncoding(byte[] b, Charset fallback) {
        try {
            return RawParseUtils.parseEncoding((byte[])b);
        }
        catch (UnsupportedCharsetException badName) {
            return fallback;
        }
    }

    public static PersonIdent parsePersonIdent(byte[] raw, int nameB, Charset fallback) {
        Charset cs = fallback == null ? RawParseUtils.parseEncoding((byte[])raw) : GitCommit.parseEncoding(raw, fallback);
        int emailB = RawParseUtils.nextLF((byte[])raw, (int)nameB, (char)'<');
        int emailE = RawParseUtils.nextLF((byte[])raw, (int)emailB, (char)'>');
        if (emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 && raw[emailE - 1] != 62) {
            return null;
        }
        int nameEnd = emailB - 2 >= nameB && raw[emailB - 2] == 32 ? emailB - 2 : emailB - 1;
        String name = RawParseUtils.decode((Charset)cs, (byte[])raw, (int)nameB, (int)nameEnd);
        String email = RawParseUtils.decode((Charset)cs, (byte[])raw, (int)emailB, (int)(emailE - 1));
        int tzBegin = GitCommit.lastIndexOfTrim(raw, ' ', RawParseUtils.nextLF((byte[])raw, (int)(emailE - 1)) - 2) + 1;
        if (tzBegin <= emailE) {
            return new PersonIdent(name, email, 0L, 0);
        }
        int whenBegin = Math.max(emailE, GitCommit.lastIndexOfTrim(raw, ' ', tzBegin - 1) + 1);
        if (whenBegin >= tzBegin - 1) {
            return new PersonIdent(name, email, 0L, 0);
        }
        long when = RawParseUtils.parseLongBase10((byte[])raw, (int)whenBegin, null);
        int tz = RawParseUtils.parseTimeZoneOffset((byte[])raw, (int)tzBegin);
        return new PersonIdent(name, email, when * 1000L, tz);
    }

    static boolean hasLF(byte[] r, int b, int e) {
        while (b < e) {
            if (r[b++] != 10) continue;
            return true;
        }
        return false;
    }

    private static int lastIndexOfTrim(byte[] raw, char ch, int pos) {
        while (pos >= 0 && raw[pos] == 32) {
            --pos;
        }
        while (pos >= 0 && raw[pos] != ch) {
            --pos;
        }
        return pos;
    }
}

