/*
 * Decompiled with CFR 0.152.
 */
package playRepository.hooks;

import actors.RelatedPullRequestMergingActor;
import akka.actor.Props;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import models.Project;
import models.PullRequest;
import models.PullRequestEventMessage;
import models.User;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import play.mvc.Http;
import playRepository.hooks.ReceiveCommandUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PullRequestCheck
implements PostReceiveHook {
    private User user;
    private Http.Request request;
    private Project project;

    public PullRequestCheck(User user, Http.Request request, Project project2) {
        this.user = user;
        this.request = request;
        this.project = project2;
    }

    public void onPostReceive(ReceivePack receivePack, Collection<ReceiveCommand> commands) {
        Set<String> branches2 = ReceiveCommandUtil.getUpdatedBranches(commands);
        for (String branch : branches2) {
            PullRequestEventMessage message = new PullRequestEventMessage(this.user, this.request, this.project, branch);
            Akka.system().actorOf(Props.create(RelatedPullRequestMergingActor.class, (Object[])new Object[0])).tell((Object)message, null);
        }
        Set<String> deletedBranches = ReceiveCommandUtil.getDeletedBranches(commands);
        for (String branch : deletedBranches) {
            List<PullRequest> pullRequests2 = PullRequest.findRelatedPullRequests(this.project, branch);
            for (PullRequest pullRequest2 : pullRequests2) {
                pullRequest2.delete();
            }
        }
    }
}

