/*
 * Decompiled with CFR 0.152.
 */
package playRepository.hooks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jgit.transport.ReceiveCommand;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ReceiveCommandUtil {
    public static Set<String> getRefNamesByCommandType(Collection<ReceiveCommand> commands, ReceiveCommand.Type ... types) {
        HashSet<String> branches2 = new HashSet<String>();
        for (ReceiveCommand command : commands) {
            if (!ReceiveCommandUtil.isTypeMatching(command, types)) continue;
            branches2.add(command.getRefName());
        }
        return branches2;
    }

    public static boolean isTypeMatching(ReceiveCommand command, ReceiveCommand.Type ... types) {
        return ArrayUtils.contains((Object[])types, (Object)command.getType());
    }

    public static Set<String> getUpdatedBranches(Collection<ReceiveCommand> commands) {
        return ReceiveCommandUtil.getRefNamesByCommandType(commands, ReceiveCommand.Type.UPDATE, ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
    }

    public static Set<String> getDeletedBranches(Collection<ReceiveCommand> commands) {
        return ReceiveCommandUtil.getRefNamesByCommandType(commands, ReceiveCommand.Type.DELETE);
    }

    public static Set<String> getPushedBranches(Collection<ReceiveCommand> commands) {
        return ReceiveCommandUtil.getRefNamesByCommandType(commands, ReceiveCommand.Type.CREATE, ReceiveCommand.Type.UPDATE, ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
    }
}

