/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import models.Issue;
import models.Organization;
import models.Project;
import models.User;
import models.enumeration.State;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.tmatesoft.svn.core.SVNException;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import playRepository.Commit;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.RouteUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AutoLinkRenderer {
    private static final String PATH_PATTERN_STR = "[a-zA-Z0-9-_.\uac00-\ud7a3/]+";
    private static final String ISSUE_PATTERN_STR = "\\d+";
    private static final String SHA_PATTERN_STR = "[a-f0-9]{7,40}";
    private static final Pattern PATH_WITH_ISSUE_PATTERN = Pattern.compile("@?([a-zA-Z0-9-_.\uac00-\ud7a3/]+)#(\\d+)");
    private static final Pattern ISSUE_PATTERN = Pattern.compile("#(\\d+)");
    private static final Pattern PATH_WITH_SHA_PATTERN = Pattern.compile("([a-zA-Z0-9-_.\uac00-\ud7a3/]+)@?([a-f0-9]{7,40})");
    private static final Pattern SHA_PATTERN = Pattern.compile("@?([a-f0-9]{7,40})");
    private static final Pattern LOGIN_ID_PATTERN_ALLOW_FORWARD_SLASH_PATTERN = Pattern.compile("@([a-zA-Z0-9-_.\uac00-\ud7a3/]+)");
    private static final String[] IGNORE_TAGNAME = new String[]{"CODE", "A"};
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w");
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String body;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;

    public AutoLinkRenderer(String body, Project project2) {
        Object object = body;
        AutoLinkRenderer autoLinkRenderer = this;
        autoLinkRenderer.setBody((String)object);
        object = project2;
        autoLinkRenderer = this;
        autoLinkRenderer.setProject((Project)object);
    }

    public String render(final String lang) {
        this.parse(PATH_WITH_ISSUE_PATTERN, new ToLink(){

            @Override
            public Link toLink(Matcher matcher) {
                String path = matcher.group(1);
                String issueNumber = matcher.group(2);
                Project project2 = AutoLinkRenderer.this.getProjectFromPath(path);
                return AutoLinkRenderer.this.toValidIssueLink(path, project2, issueNumber);
            }
        });
        this.parse(ISSUE_PATTERN, new ToLink(){

            @Override
            public Link toLink(Matcher matcher) {
                AutoLinkRenderer autoLinkRenderer = AutoLinkRenderer.this;
                Project project2 = null;
                project2 = autoLinkRenderer.getProject();
                return AutoLinkRenderer.this.toValidIssueLink("", project2, matcher.group(1));
            }
        });
        this.parse(PATH_WITH_SHA_PATTERN, new ToLink(){

            @Override
            public Link toLink(Matcher matcher) {
                String path = matcher.group(1);
                String SHA = matcher.group(2);
                Project project2 = AutoLinkRenderer.this.getProjectFromPath(path);
                return AutoLinkRenderer.this.toValidSHALink(path, project2, SHA);
            }
        });
        this.parse(SHA_PATTERN, new ToLink(){

            @Override
            public Link toLink(Matcher matcher) {
                AutoLinkRenderer autoLinkRenderer = AutoLinkRenderer.this;
                Project project2 = null;
                project2 = autoLinkRenderer.getProject();
                return AutoLinkRenderer.this.toValidSHALink(project2, matcher.group(1));
            }
        });
        this.parse(LOGIN_ID_PATTERN_ALLOW_FORWARD_SLASH_PATTERN, new ToLink(){

            @Override
            public Link toLink(Matcher matcher) {
                String path = matcher.group(1);
                int slashIndex = path.indexOf("/");
                if (slashIndex > -1) {
                    return AutoLinkRenderer.toValidProjectLink(path.substring(0, slashIndex), path.substring(slashIndex + 1));
                }
                return AutoLinkRenderer.toValidUserLink(path, lang);
            }
        });
        AutoLinkRenderer autoLinkRenderer = this;
        String string = null;
        string = autoLinkRenderer.getBody();
        return string;
    }

    private AutoLinkRenderer parse(Pattern pattern, ToLink toLink) {
        AutoLinkRenderer autoLinkRenderer = this;
        String string = null;
        string = autoLinkRenderer.getBody();
        Document doc = Jsoup.parse((String)string);
        Document.OutputSettings settings = doc.outputSettings();
        settings.prettyPrint(false);
        Elements elements = doc.getElementsMatchingOwnText(pattern);
        for (Element el : elements) {
            if (this.isIgnoreElement(el)) continue;
            List textNodeList = el.textNodes();
            for (TextNode node : textNodeList) {
                String result2 = this.convertLink(node.toString(), pattern, toLink);
                node.text("");
                node.after(result2);
            }
        }
        string = doc.body().html();
        autoLinkRenderer = this;
        autoLinkRenderer.setBody(string);
        return this;
    }

    private String convertLink(String text, Pattern pattern, ToLink toLink) {
        Matcher matcher = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            Link link;
            if (AutoLinkRenderer.isWrappedNonCharacter(text, matcher) || !(link = toLink.toLink(matcher)).isValid()) continue;
            matcher.appendReplacement(sb, link.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private Project getProjectFromPath(String path) {
        int slashIndex = path.indexOf("/");
        if (slashIndex > -1) {
            return Project.findByOwnerAndProjectName(path.substring(0, slashIndex), path.substring(slashIndex + 1));
        }
        Object object = this;
        Object object2 = null;
        object = object2 = ((AutoLinkRenderer)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        return Project.findByOwnerAndProjectName(path, (String)object2);
    }

    private Link toValidIssueLink(String prefix, Project project2, String issueNumber) {
        Issue issue2;
        if (project2 != null && (issue2 = Issue.findByNumber(project2, Long.parseLong(issueNumber))) != null) {
            Issue issue3 = issue2;
            Object object = null;
            object = issue3.getTitle();
            String linkText = "#" + issueNumber + "." + (String)object;
            if (StringUtils.isNotEmpty((String)prefix)) {
                linkText = linkText + prefix + linkText;
            }
            issue3 = issue2;
            object = null;
            object = issue3.getState();
            StringBuilder stringBuilder = new StringBuilder().append(linkText).append("<span class='issue-state ").append(((State)((Object)object)).state().toLowerCase()).append("'>");
            issue3 = issue2;
            object = null;
            object = issue3.getState();
            linkText = stringBuilder.append(Messages.get((String)("issue.state." + ((State)((Object)object)).state()), (Object[])new Object[0])).append("</span>").toString();
            return new Link(RouteUtil.getUrl(issue2), "issueLink", prefix + linkText);
        }
        return Link.EMPTY_LINK;
    }

    private Link toValidSHALink(Project project2, String SHA) {
        return this.toValidSHALink("", project2, SHA);
    }

    private Link toValidSHALink(String prefix, Project project2, String sha) {
        if (project2 != null) {
            try {
                Commit commit;
                if (!project2.isCodeAvailable() || !project2.isGit()) {
                    return Link.EMPTY_LINK;
                }
                PlayRepository repository = RepositoryService.getRepository(project2);
                if (repository != null && (commit = repository.getCommit(sha)) != null) {
                    if (StringUtils.isEmpty((String)prefix)) {
                        return new Link(RouteUtil.getUrl(commit, project2), commit.getShortId());
                    }
                    return new Link(RouteUtil.getUrl(commit, project2), prefix + "@" + commit.getShortId());
                }
            }
            catch (SVNException svnException) {
                return Link.EMPTY_LINK;
            }
            catch (IOException ioException) {
                return Link.EMPTY_LINK;
            }
            catch (ServletException servletException) {
                return Link.EMPTY_LINK;
            }
        }
        return Link.EMPTY_LINK;
    }

    private static Link toValidUserLink(String userId, String lang) {
        String string;
        User user;
        String avatarImage;
        User user2 = User.findByLoginId(userId);
        Organization org = Organization.findByName(userId);
        if (org != null) {
            Organization organization2 = org;
            String string2 = null;
            string2 = organization2.getName();
            return new Link(RouteUtil.getUrl(org), "<span class='org-link'>@" + string2 + "</span>");
        }
        if (user2.isAnonymous()) {
            return Link.EMPTY_LINK;
        }
        if (user2.avatarUrl().equals(UserApp.DEFAULT_AVATAR_URL)) {
            avatarImage = "";
        } else {
            user = user2;
            string = null;
            string = user.getName();
            StringBuilder stringBuilder = new StringBuilder().append("<img src='").append(user2.avatarUrl()).append("' class='avatar-wrap smaller no-margin-no-padding vertical-top' alt='@").append(string).append(" ");
            user = user2;
            string = null;
            string = user.getLoginId();
            avatarImage = stringBuilder.append(string).append("'> ").toString();
        }
        String userName = null;
        userName = StringUtils.isBlank((String)lang) ? user2.getPureNameOnly() : user2.getPureNameOnly(lang);
        user = user2;
        string = null;
        string = user.getName();
        StringBuilder stringBuilder = new StringBuilder().append(avatarImage).append(string).append(" ");
        user = user2;
        string = null;
        string = user.getLoginId();
        return new Link(RouteUtil.getUrl(user2), "no-text-decoration user-link", "<span data-toggle='popover' data-placement='top' data-trigger='hover' data-html='true' data-content=\"" + StringEscapeUtils.escapeHtml4((String)stringBuilder.append(string).toString()) + "\">@" + userName + "</span>");
    }

    private static Link toValidProjectLink(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (project2 != null) {
            return new Link(RouteUtil.getUrl(project2), "<span class='project-link'>@" + project2.toString() + "</span>");
        }
        return Link.EMPTY_LINK;
    }

    private boolean isIgnoreElement(Element el) {
        return ArrayUtils.contains((Object[])IGNORE_TAGNAME, (Object)el.tagName().toUpperCase());
    }

    private static boolean isWrappedNonCharacter(String body, Matcher matcher) {
        return matcher.start() != 0 && WORD_PATTERN.matcher(body.substring(matcher.start() - 1, matcher.start())).find() || matcher.end() != body.length() && WORD_PATTERN.matcher(body.substring(matcher.end(), matcher.end() + 1)).find();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getBody() {
        return this.body;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setBody(String string) {
        this.body = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this.project;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this.project = project2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static interface ToLink {
        public Link toLink(Matcher var1);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class Link {
        private static final String DEFAULT_LINK_FORMAT = "<a href='%s' class='%s'>%s</a>";
        public static final Link EMPTY_LINK = new Link();
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String href;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String className;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String displayName;

        private Link() {
        }

        public Link(String href, String displayName) {
            String string = href;
            Link link = this;
            link.setHref(string);
            string = displayName;
            link = this;
            link.setDisplayName(string);
        }

        public Link(String href, String className, String displayName) {
            String string = href;
            Link link = this;
            link.setHref(string);
            string = className;
            link = this;
            link.setClassName(string);
            string = displayName;
            link = this;
            link.setDisplayName(string);
        }

        public String toString() {
            Object[] objectArray = new Object[3];
            Link link = this;
            String string = null;
            string = link.getHref();
            objectArray[0] = StringUtils.defaultIfEmpty((String)string, (String)"");
            link = this;
            string = null;
            string = link.getClassName();
            objectArray[1] = StringUtils.defaultIfEmpty((String)string, (String)"");
            link = this;
            string = null;
            string = link.getDisplayName();
            objectArray[2] = StringUtils.defaultIfEmpty((String)string, (String)"");
            return String.format(DEFAULT_LINK_FORMAT, objectArray);
        }

        public boolean isValid() {
            return this != EMPTY_LINK;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getHref() {
            return this.href;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setHref(String string) {
            this.href = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getClassName() {
            return this.className;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setClassName(String string) {
            this.className = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getDisplayName() {
            return this.displayName;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setDisplayName(String string) {
            this.displayName = string;
        }
    }
}

