/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.io.OutputStream;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ChunkedOutputStream
extends OutputStream {
    Results.Chunks.Out<byte[]> out;
    protected byte[] buf;
    protected int count;

    public ChunkedOutputStream(Results.Chunks.Out<byte[]> out, int size) {
        this.buf = size <= 0 ? new byte[16384] : new byte[size];
        this.out = out;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new UnsupportedOperationException("write(byte b[])");
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.chunkOut();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.count > 0) {
            this.chunkOut();
        }
        this.out.close();
    }

    private void chunkOut() {
        byte[] remainBuf = new byte[this.count];
        System.arraycopy(this.buf, 0, remainBuf, 0, this.count);
        this.out.write((Object)remainBuf);
        this.count = 0;
    }
}

