/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PathVariable {
    String url;
    public static final String rootPath = Configuration.root().getString("application.context", "");
    public static final String API_PREFIX = "/-_-api/v1/";
    private Map<String, String> pathVariable = new HashMap<String, String>();
    private boolean isApiPathCall = false;

    public PathVariable(String url) {
        String refinedUrl = url;
        if (StringUtils.isNotEmpty((CharSequence)rootPath)) {
            refinedUrl = refinedUrl.replaceFirst(rootPath, "");
        }
        if (refinedUrl.startsWith(API_PREFIX)) {
            refinedUrl = refinedUrl.replaceFirst(API_PREFIX, "");
            this.isApiPathCall = true;
            this.decomposeToPathVariable(refinedUrl);
        }
    }

    public String getPathVariable(String pathName) {
        return this.pathVariable.get(pathName);
    }

    public boolean isApiCall() {
        return this.isApiPathCall;
    }

    private void decomposeToPathVariable(String refinedUrl) {
        String[] decomposed = refinedUrl.split("/");
        for (int i = 0; i < decomposed.length; i += 2) {
            if (i + 1 > decomposed.length - 1) {
                this.pathVariable.put(decomposed[i], "");
                continue;
            }
            this.pathVariable.put(decomposed[i], decomposed[i + 1]);
        }
    }
}

