/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import utils.Config;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Url {
    public static String create(List<String> pathSegments) {
        return Url.create(Url.join(pathSegments));
    }

    public static String createWithContext(List<String> pathSegments) {
        String context = Configuration.root().getString("application.context");
        return Url.create((context == null ? "" : context) + Url.join(pathSegments));
    }

    public static String create(List<String> pathSegments, String defaultHostport) {
        return Url.create(Url.join(pathSegments), defaultHostport);
    }

    public static String create(List<String> pathSegments, String defaultHostport, String defaultScheme) {
        return Url.create(Url.join(pathSegments), defaultHostport, defaultScheme);
    }

    public static String create(String relativePath) {
        return Url.create(relativePath, Config.getHostport());
    }

    public static String create(String relativePath, String defaultHostport) {
        return Url.create(relativePath, defaultHostport, Config.getScheme());
    }

    public static String create(String relativePath, String defaultHostport, String defaultScheme) {
        return Config.getScheme(defaultScheme) + "://" + Config.getHostport(defaultHostport) + relativePath;
    }

    private static String join(List<String> pathSegments) {
        return "/" + StringUtils.join(pathSegments, (String)"/");
    }

    public static String removeFragment(String url) {
        int index2 = url.indexOf(35);
        return index2 >= 0 ? url.substring(0, index2) : url;
    }
}

