/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.mariadb.jdbc.internal.packet.read.RawPacket;

public class Reader {
    public ByteBuffer byteBuffer;

    public Reader(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public String readString(Charset charset) {
        byte ch;
        int cnt = 0;
        byte[] byteArrBuff = new byte[this.byteBuffer.remaining()];
        while (this.byteBuffer.remaining() > 0 && (ch = this.byteBuffer.get()) != 0) {
            byteArrBuff[cnt++] = ch;
        }
        return new String(byteArrBuff, 0, cnt, charset);
    }

    public short readShort() {
        return this.byteBuffer.getShort();
    }

    public int readInt() {
        return this.byteBuffer.getInt();
    }

    public long readLong() {
        return this.byteBuffer.getLong();
    }

    public byte readByte() {
        return this.byteBuffer.get();
    }

    public byte[] readRawBytes(int numberOfBytes) {
        byte[] tmpArr = new byte[numberOfBytes];
        this.byteBuffer.get(tmpArr, 0, numberOfBytes);
        return tmpArr;
    }

    public void skipByte() {
        this.byteBuffer.get();
    }

    public long skipBytes(int bytesToSkip) {
        this.byteBuffer.position(this.byteBuffer.position() + bytesToSkip);
        return bytesToSkip;
    }

    public Reader skipLengthEncodedBytes() {
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        this.skipBytes((int)encLength);
        return this;
    }

    public int read24bitword() {
        byte[] tmpArr = new byte[3];
        this.byteBuffer.get(tmpArr);
        return (tmpArr[0] & 0xFF) + ((tmpArr[1] & 0xFF) << 8) + ((tmpArr[2] & 0xFF) << 16);
    }

    public long getLengthEncodedBinary() {
        byte type = this.byteBuffer.get();
        if (type < -5) {
            return 0xFFL & (long)type;
        }
        switch (type) {
            case -5: {
                return -1L;
            }
            case -4: {
                return 0xFFFFL & (long)this.readShort();
            }
            case -3: {
                return 0xFFFFFF & this.read24bitword();
            }
            case -2: {
                return this.readLong();
            }
        }
        return 0xFFL & (long)type;
    }

    public byte[] getLengthEncodedBytes() throws IOException {
        if (this.byteBuffer.remaining() == 0) {
            return new byte[0];
        }
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)encLength];
        this.byteBuffer.get(tmpBuf);
        return tmpBuf;
    }

    public String getStringLengthEncodedBytes() throws IOException {
        if (this.byteBuffer.remaining() == 0) {
            return null;
        }
        long encLength = this.getLengthEncodedBinary();
        if (encLength == 0L) {
            return "";
        }
        if (encLength != -1L) {
            byte[] tmpBuf = new byte[(int)encLength];
            this.byteBuffer.get(tmpBuf);
            return new String(tmpBuf);
        }
        return null;
    }

    public byte[] getLengthEncodedBytesWithLength(long length) {
        byte[] tmpBuf = new byte[(int)length];
        this.byteBuffer.get(tmpBuf);
        return tmpBuf;
    }

    public byte getByteAt(int position) throws IOException {
        return this.byteBuffer.get(position);
    }

    public int getRemainingSize() {
        return this.byteBuffer.remaining();
    }

    public void appendPacket(RawPacket rawPacket) {
        ByteBuffer newBuffer = ByteBuffer.allocate(this.byteBuffer.capacity() + rawPacket.getByteBuffer().capacity()).order(ByteOrder.LITTLE_ENDIAN);
        int pos = this.byteBuffer.position();
        this.byteBuffer.rewind();
        newBuffer.put(this.byteBuffer);
        newBuffer.put(rawPacket.getByteBuffer());
        newBuffer.position(pos);
        this.byteBuffer = newBuffer;
    }

    public void appendPacket(RawPacket rawPacket, long encLength) {
        if (encLength < (long)this.byteBuffer.capacity()) {
            this.byteBuffer.rewind();
            this.byteBuffer.put(rawPacket.getByteBuffer());
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.byteBuffer.capacity() + rawPacket.getByteBuffer().capacity()).order(ByteOrder.LITTLE_ENDIAN);
            int pos = this.byteBuffer.position();
            this.byteBuffer.rewind();
            newBuffer.put(this.byteBuffer);
            newBuffer.put(rawPacket.getByteBuffer());
            newBuffer.position(pos);
            this.byteBuffer = newBuffer;
        }
    }

    public long getSilentLengthEncodedBinary() {
        if (this.byteBuffer.remaining() == 0) {
            return 0L;
        }
        int pos1 = this.byteBuffer.position();
        this.byteBuffer.mark();
        long valueLen = this.getLengthEncodedBinary();
        int pos2 = this.byteBuffer.position();
        this.byteBuffer.reset();
        return valueLen + (long)(pos2 - pos1);
    }
}

