/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.bean;

import com.avaje.ebean.bean.CallStack;
import java.io.Serializable;

public final class ObjectGraphOrigin
implements Serializable {
    private static final long serialVersionUID = 410937765287968708L;
    private final CallStack callStack;
    private final String beanType;
    private final int queryHash;
    private final String key;

    public ObjectGraphOrigin(int queryHash, CallStack callStack, String beanType) {
        this.callStack = callStack;
        this.beanType = beanType;
        this.queryHash = queryHash;
        this.key = callStack.getOriginKey(queryHash);
    }

    public String getKey() {
        return this.key;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public String getFirstStackElement() {
        return this.callStack.getFirstStackTraceElement().toString();
    }

    public String toString() {
        return "key[" + this.key + "] type[" + this.beanType + "] " + this.callStack.getFirstStackTraceElement() + " ";
    }

    public int hashCode() {
        int hc = 31 * this.callStack.hashCode();
        hc = 31 * hc + this.beanType.hashCode();
        hc = 31 * hc + this.queryHash;
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectGraphOrigin)) {
            return false;
        }
        ObjectGraphOrigin e = (ObjectGraphOrigin)obj;
        return e.queryHash == this.queryHash && e.beanType.equals(this.beanType) && e.callStack.equals(this.callStack);
    }
}

