/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.LoadBeanBuffer;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.LoadManyBuffer;
import com.avaje.ebeaninternal.api.LoadManyRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.DefaultServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanLoader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBeanLoader.class);
    private final DefaultServer server;

    protected DefaultBeanLoader(DefaultServer server) {
        this.server = server;
    }

    private int getBatchSize(int batchSize) {
        if (batchSize == 1) {
            return 1;
        }
        if (batchSize <= 5) {
            return 5;
        }
        if (batchSize <= 10) {
            return 10;
        }
        if (batchSize <= 20) {
            return 20;
        }
        if (batchSize <= 50) {
            return 50;
        }
        if (batchSize <= 100) {
            return 100;
        }
        return batchSize;
    }

    public void refreshMany(Object parentBean, String propertyName) {
        this.refreshMany(parentBean, propertyName, null);
    }

    public void loadMany(LoadManyRequest loadRequest) {
        List<BeanCollection<?>> batch = loadRequest.getBatch();
        int batchSize = this.getBatchSize(batch.size());
        LoadManyBuffer ctx = loadRequest.getLoadContext();
        BeanPropertyAssocMany<?> many = ctx.getBeanProperty();
        PersistenceContext pc = ctx.getPersistenceContext();
        ArrayList<Object> idList = new ArrayList<Object>(batchSize);
        for (int i = 0; i < batch.size(); ++i) {
            BeanCollection<?> bc = batch.get(i);
            Object ownerBean = bc.getOwnerBean();
            Object id = many.getParentId(ownerBean);
            idList.add(id);
        }
        int extraIds = batchSize - batch.size();
        if (extraIds > 0) {
            Object firstId = idList.get(0);
            for (int i = 0; i < extraIds; ++i) {
                idList.add(firstId);
            }
        }
        BeanDescriptor<?> desc = ctx.getBeanDescriptor();
        SpiQuery query = (SpiQuery)this.server.createQuery(many.getTargetType());
        query.setLazyLoadForParents(idList, many);
        many.addWhereParentIdIn(query, idList);
        query.setPersistenceContext(pc);
        String mode = loadRequest.isLazy() ? "+lazy" : "+query";
        query.setLoadDescription(mode, loadRequest.getDescription());
        ctx.configureQuery(query);
        if (loadRequest.isOnlyIds()) {
            query.select(many.getTargetIdProperty());
        }
        this.server.findList(query, loadRequest.getTransaction());
        for (int i = 0; i < batch.size(); ++i) {
            BeanCollection<?> bc = batch.get(i);
            if (bc.checkEmptyLazyLoad()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("BeanCollection after load was empty. Owner:" + batch.get(i).getOwnerBean());
                continue;
            }
            if (!loadRequest.isLoadCache()) continue;
            Object parentId = desc.getId(bc.getOwnerBean());
            desc.cachePutMany(many, bc, parentId);
        }
    }

    public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        Object parentBean = bc.getOwnerBean();
        String propertyName = bc.getPropertyName();
        this.loadManyInternal(parentBean, propertyName, null, false, null, onlyIds);
    }

    public void refreshMany(Object parentBean, String propertyName, Transaction t) {
        this.loadManyInternal(parentBean, propertyName, t, true, null, false);
    }

    private void loadManyInternal(Object parentBean, String propertyName, Transaction t, boolean refresh, ObjectGraphNode node, boolean onlyIds) {
        boolean useManyIdCache;
        EntityBeanIntercept ebi = ((EntityBean)parentBean)._ebean_getIntercept();
        PersistenceContext pc = ebi.getPersistenceContext();
        BeanDescriptor<?> parentDesc = this.server.getBeanDescriptor(parentBean.getClass());
        BeanPropertyAssocMany many = (BeanPropertyAssocMany)parentDesc.getBeanProperty(propertyName);
        BeanCollection beanCollection = null;
        ExpressionList<?> filterMany = null;
        Object currentValue = many.getValue(parentBean);
        if (currentValue instanceof BeanCollection) {
            beanCollection = (BeanCollection)currentValue;
            filterMany = beanCollection.getFilterMany();
        }
        Object parentId = parentDesc.getId(parentBean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            pc.put(parentId, parentBean);
        }
        boolean bl = useManyIdCache = beanCollection != null && parentDesc.cacheIsUseManyId();
        if (useManyIdCache) {
            Boolean readOnly = null;
            if (ebi != null && ebi.isReadOnly()) {
                readOnly = Boolean.TRUE;
            }
            if (parentDesc.cacheLoadMany(many, beanCollection, parentId, readOnly)) {
                return;
            }
        }
        SpiQuery query = (SpiQuery)this.server.createQuery(parentDesc.getBeanType());
        if (refresh) {
            Object emptyCollection = many.createEmpty(false);
            many.setValue(parentBean, emptyCollection);
            query.setLoadDescription("+refresh", null);
        } else {
            query.setLoadDescription("+lazy", null);
        }
        if (node != null) {
            query.setParentNode(node);
        }
        String idProperty = parentDesc.getIdBinder().getIdProperty();
        query.select(idProperty);
        if (onlyIds) {
            query.fetch(many.getName(), many.getTargetIdProperty());
        } else {
            query.fetch(many.getName());
        }
        if (filterMany != null) {
            query.setFilterMany(many.getName(), filterMany);
        }
        query.where().idEq(parentId);
        query.setUseCache(false);
        query.setMode(SpiQuery.Mode.LAZYLOAD_MANY);
        query.setLazyLoadManyPath(many.getName());
        query.setPersistenceContext(pc);
        if (ebi != null && ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        this.server.findUnique(query, t);
        if (beanCollection != null) {
            if (beanCollection.checkEmptyLazyLoad()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("BeanCollection after load was empty. Owner:" + beanCollection.getOwnerBean());
                }
            } else if (useManyIdCache) {
                parentDesc.cachePutMany(many, beanCollection, parentId);
            }
        }
    }

    public void loadBean(LoadBeanRequest loadRequest) {
        List<EntityBeanIntercept> batch = loadRequest.getBatch();
        if (batch.isEmpty()) {
            throw new RuntimeException("Nothing in batch?");
        }
        int batchSize = this.getBatchSize(batch.size());
        LoadBeanBuffer ctx = loadRequest.getLoadContext();
        BeanDescriptor<?> desc = ctx.getBeanDescriptor();
        Class<?> beanType = desc.getBeanType();
        EntityBeanIntercept[] ebis = batch.toArray(new EntityBeanIntercept[batch.size()]);
        ArrayList<Object> idList = new ArrayList<Object>(batchSize);
        for (int i = 0; i < batch.size(); ++i) {
            EntityBeanIntercept ebi = batch.get(i);
            EntityBean bean = ebi.getOwner();
            Object id = desc.getId(bean);
            idList.add(id);
        }
        if (idList.isEmpty()) {
            return;
        }
        int extraIds = batchSize - batch.size();
        if (extraIds > 0) {
            Object firstId = idList.get(0);
            for (int i = 0; i < extraIds; ++i) {
                idList.add(firstId);
            }
        }
        PersistenceContext persistenceContext = ctx.getPersistenceContext();
        for (int i = 0; i < ebis.length; ++i) {
            Object parentBean = ebis[i].getParentBean();
            if (parentBean == null) continue;
            BeanDescriptor<?> parentDesc = this.server.getBeanDescriptor(parentBean.getClass());
            Object parentId = parentDesc.getId(parentBean);
            persistenceContext.put(parentId, parentBean);
        }
        SpiQuery query = (SpiQuery)this.server.createQuery(beanType);
        query.setMode(SpiQuery.Mode.LAZYLOAD_BEAN);
        query.setPersistenceContext(persistenceContext);
        String mode = loadRequest.isLazy() ? "+lazy" : "+query";
        query.setLoadDescription(mode, loadRequest.getDescription());
        ctx.configureQuery(query, loadRequest.getLazyLoadProperty());
        if (idList.size() == 1) {
            query.where().idEq(idList.get(0));
        } else {
            query.where().idIn(idList);
        }
        List list = this.server.findList(query, loadRequest.getTransaction());
        if (loadRequest.isLoadCache()) {
            for (int i = 0; i < list.size(); ++i) {
                desc.cachePutBeanData(list.get(i));
            }
        }
        for (int i = 0; i < ebis.length; ++i) {
            if (!ebis[i].isReference()) continue;
            ebis[i].setLazyLoadFailure();
        }
    }

    public void refresh(Object bean) {
        this.refreshBeanInternal(bean, SpiQuery.Mode.REFRESH_BEAN);
    }

    public void loadBean(EntityBeanIntercept ebi) {
        this.refreshBeanInternal(ebi.getOwner(), SpiQuery.Mode.LAZYLOAD_BEAN);
    }

    private void refreshBeanInternal(Object bean, SpiQuery.Mode mode) {
        Object dbBean;
        EntityBeanIntercept ebi = ((EntityBean)bean)._ebean_getIntercept();
        PersistenceContext pc = ebi.getPersistenceContext();
        BeanDescriptor<?> desc = this.server.getBeanDescriptor(bean.getClass());
        Object id = desc.getId(bean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            pc.put(id, bean);
            if (ebi != null) {
                ebi.setPersistenceContext(pc);
            }
        }
        if (ebi != null) {
            if (SpiQuery.Mode.LAZYLOAD_BEAN.equals((Object)mode) && desc.isBeanCaching() && desc.loadFromCache(bean, ebi, id)) {
                return;
            }
            if (desc.lazyLoadMany(ebi)) {
                return;
            }
        }
        SpiQuery query = (SpiQuery)this.server.createQuery(desc.getBeanType());
        if (ebi != null) {
            Object parentBean = ebi.getParentBean();
            if (parentBean != null) {
                BeanDescriptor<?> parentDesc = this.server.getBeanDescriptor(parentBean.getClass());
                Object parentId = parentDesc.getId(parentBean);
                pc.putIfAbsent(parentId, parentBean);
            }
            query.setLazyLoadProperty(ebi.getLazyLoadProperty());
        }
        query.setUsageProfiling(false);
        query.setPersistenceContext(pc);
        query.setMode(mode);
        query.setId(id);
        if (mode.equals((Object)SpiQuery.Mode.REFRESH_BEAN)) {
            query.setUseCache(false);
        }
        if (ebi != null && ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        if ((dbBean = query.findUnique()) == null) {
            String msg = "Bean not found during lazy load or refresh. id[" + id + "] type[" + desc.getBeanType() + "]";
            throw new EntityNotFoundException(msg);
        }
    }
}

