/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.mail;

import akka.actor.Cancellable;
import com.typesafe.plugin.MailerAPI;
import com.typesafe.plugin.MailerPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import play.Configuration;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Akka;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Mailer {
    private static final String MAILER = "play-easymail/";
    private static final String CONFIG_BASE = "play-easymail";
    private final MailerPlugin plugin = (MailerPlugin)Play.application().plugin(MailerPlugin.class);
    private final FiniteDuration delay;
    private final String sender;
    private final boolean includeXMailerHeader;
    private static Mailer instance = null;

    public static Mailer getDefaultMailer() {
        if (instance == null) {
            instance = new Mailer(Mailer.getConfiguration());
        }
        return instance;
    }

    private static String getVersion() {
        return Mailer.getConfiguration().getString("version");
    }

    private static Configuration getConfiguration() {
        return Play.application().configuration().getConfig(CONFIG_BASE);
    }

    public static Mailer getCustomMailer(Configuration config) {
        return new Mailer(config);
    }

    public static String getEmailName(String email, String name) {
        boolean hasName;
        if (email == null || email.trim().isEmpty()) {
            throw new RuntimeException("email must not be null");
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = hasName = name != null && !name.trim().isEmpty();
        if (hasName) {
            sb.append("\"");
            sb.append(name);
            sb.append("\" <");
        }
        sb.append(email);
        if (hasName) {
            sb.append(">");
        }
        return sb.toString();
    }

    protected Mailer(Configuration config) {
        this.delay = Duration.create((long)config.getLong("delay", Long.valueOf(1L)), (TimeUnit)TimeUnit.SECONDS);
        Configuration fromConfig = config.getConfig("from");
        this.sender = Mailer.getEmailName(fromConfig.getString("email"), fromConfig.getString("name"));
        this.includeXMailerHeader = config.getBoolean("includeXMailerHeader", Boolean.valueOf(true));
    }

    public Cancellable sendMail(Mail email) {
        email.setFrom(this.sender);
        return Akka.system().scheduler().scheduleOnce(this.delay, (Runnable)new MailJob(email), (ExecutionContext)Akka.system().dispatcher());
    }

    public Cancellable sendMail(String subject, String textBody, String recipient) {
        Mail mail = new Mail(subject, new Mail.Body(textBody), new String[]{recipient});
        return this.sendMail(mail);
    }

    public Cancellable sendMail(String subject, Mail.Body body, String recipient) {
        Mail mail = new Mail(subject, body, new String[]{recipient});
        return this.sendMail(mail);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class MailJob
    implements Runnable {
        private Mail mail;

        public MailJob(Mail m) {
            this.mail = m;
        }

        @Override
        public void run() {
            MailerAPI api = Mailer.this.plugin.email();
            api.setSubject(this.mail.getSubject());
            api.setRecipient(this.mail.getRecipients());
            if (this.mail.getCc() != null) {
                api.setCc(this.mail.getCc());
            }
            if (this.mail.getBcc() != null) {
                api.setBcc(this.mail.getBcc());
            }
            api.setFrom(this.mail.getFrom());
            if (Mailer.this.includeXMailerHeader) {
                api.addHeader("X-Mailer", Mailer.MAILER + Mailer.getVersion());
            }
            for (Map.Entry<String, List<String>> entry : this.mail.getCustomHeaders().entrySet()) {
                String headerName = entry.getKey();
                for (String headerValue : entry.getValue()) {
                    api.addHeader(headerName, headerValue);
                }
            }
            if (this.mail.getReplyTo() != null) {
                api.setReplyTo(this.mail.getReplyTo());
            }
            for (Mail.Attachment attachment : this.mail.getAttachments()) {
                if (attachment.getData() != null) {
                    api.addAttachment(attachment.getName(), attachment.getData(), attachment.getMimeType(), attachment.getDescription(), attachment.getDisposition());
                    continue;
                }
                api.addAttachment(attachment.getName(), attachment.getFile(), attachment.getDescription(), attachment.getDisposition());
            }
            if (this.mail.getBody().isBoth()) {
                api.send(this.mail.getBody().getText(), this.mail.getBody().getHtml());
            } else if (this.mail.getBody().isText()) {
                api.send(this.mail.getBody().getText());
            } else {
                api.sendHtml(this.mail.getBody().getHtml());
            }
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class Mail {
        private final String subject;
        private final String[] recipients;
        private final String[] cc;
        private final String[] bcc;
        private String from;
        private final Body body;
        private String replyTo;
        private final Map<String, List<String>> customHeaders;
        private final List<Attachment> attachments = new ArrayList<Attachment>(1);

        public Mail(String subject, Body body, String[] recipients) {
            this(subject, body, recipients, null, null, null, null);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc) {
            this(subject, body, recipients, cc, null, null, null);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc, String[] bcc) {
            this(subject, body, recipients, cc, bcc, null, null);
        }

        public Mail(String subject, Body body, String[] recipients, String replyTo) {
            this(subject, body, recipients, null, null, null, replyTo);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc, String replyTo) {
            this(subject, body, recipients, cc, null, null, replyTo);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc, String[] bcc, String replyTo) {
            this(subject, body, recipients, cc, bcc, null, replyTo);
        }

        public Mail(String subject, Body body, String[] recipients, Map<String, List<String>> customHeaders) {
            this(subject, body, recipients, null, null, customHeaders, null);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc, Map<String, List<String>> customHeaders) {
            this(subject, body, recipients, cc, null, customHeaders, null);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc, String[] bcc, Map<String, List<String>> customHeaders) {
            this(subject, body, recipients, cc, bcc, customHeaders, null);
        }

        public Mail(String subject, Body body, String[] recipients, String[] cc, String[] bcc, Map<String, List<String>> customHeaders, String replyTo) {
            if (subject == null || subject.trim().isEmpty()) {
                throw new RuntimeException("Subject must not be null or empty");
            }
            this.subject = subject;
            if (body == null) {
                throw new RuntimeException("Body must not be null or empty");
            }
            this.body = body;
            if (recipients == null || recipients.length == 0) {
                throw new RuntimeException("There must be at least one recipient");
            }
            this.recipients = recipients;
            this.cc = cc;
            this.bcc = bcc;
            this.customHeaders = customHeaders != null ? customHeaders : new HashMap<String, List<String>>(1);
            if (replyTo != null) {
                this.replyTo = replyTo;
            }
        }

        public String getSubject() {
            return this.subject;
        }

        public String[] getRecipients() {
            return this.recipients;
        }

        public String[] getCc() {
            return this.cc;
        }

        public String[] getBcc() {
            return this.bcc;
        }

        public String getFrom() {
            return this.from;
        }

        private void setFrom(String from) {
            this.from = from;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public void setReplyTo(String replyTo) {
            this.replyTo = replyTo;
        }

        public Body getBody() {
            return this.body;
        }

        public Map<String, List<String>> getCustomHeaders() {
            return this.customHeaders;
        }

        public void addCustomHeader(String name, String ... values) {
            this.customHeaders.put(name, Arrays.asList(values));
        }

        public List<Attachment> getAttachments() {
            return this.attachments;
        }

        public void addAttachment(Attachment ... attachments) {
            this.attachments.addAll(Arrays.asList(attachments));
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public static class Attachment {
            private byte[] data;
            private String mimeType;
            private File file;
            private String name;
            private String description;
            private String disposition;

            public Attachment(String name, byte[] data, String mimeType) {
                this(name, data, mimeType, null);
            }

            public Attachment(String name, byte[] data, String mimeType, String description) {
                this(name, data, mimeType, description, null);
            }

            public Attachment(String name, byte[] data, String mimeType, String description, String disposition) {
                if (name == null || name.trim().isEmpty()) {
                    throw new RuntimeException("Name must not be null or empty");
                }
                if (data == null) {
                    throw new RuntimeException("Data must not be null");
                }
                this.name = name;
                this.data = data;
                this.mimeType = mimeType;
                this.description = description;
                this.disposition = disposition;
            }

            public Attachment(String name, File file) {
                this(name, file, null);
            }

            public Attachment(String name, File file, String description) {
                this(name, file, description, null);
            }

            public Attachment(String name, File file, String description, String disposition) {
                if (name == null || name.trim().isEmpty()) {
                    throw new RuntimeException("Name must not be null or empty");
                }
                if (file == null) {
                    throw new RuntimeException("File must not be null");
                }
                this.name = name;
                this.file = file;
                this.description = description;
                this.disposition = disposition;
            }

            public byte[] getData() {
                return this.data;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public File getFile() {
                return this.file;
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public String getDisposition() {
                return this.disposition;
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public static class Body {
            private final String html;
            private final String text;
            private final boolean isHtml;
            private final boolean isText;

            public Body(String text) {
                this(text, null);
            }

            public Body(String text, String html) {
                this.isHtml = html != null && !html.trim().isEmpty();
                boolean bl = this.isText = text != null && !text.trim().isEmpty();
                if (!this.isHtml && !this.isText) {
                    throw new RuntimeException("Text and HTML cannot both be empty or null");
                }
                this.html = this.isHtml ? html : null;
                this.text = this.isText ? text : null;
            }

            public boolean isHtml() {
                return this.isHtml;
            }

            public boolean isText() {
                return this.isText;
            }

            public boolean isBoth() {
                return this.isText() && this.isHtml();
            }

            public String getHtml() {
                return this.html;
            }

            public String getText() {
                return this.text;
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public static class TxtBody
        extends Body {
            public TxtBody(String text) {
                super(text, null);
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        public static class HtmlBody
        extends Body {
            public HtmlBody(String text) {
                super(null, text);
            }
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class SettingKeys {
        public static final String FROM = "from";
        public static final String FROM_EMAIL = "email";
        public static final String FROM_NAME = "name";
        public static final String INCLUDE_XMAILER_HEADER = "includeXMailerHeader";
        public static final String DELAY = "delay";
        private static final String VERSION = "version";
    }
}

