/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2;

import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.exceptions.AccessDeniedException;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.exceptions.RedirectUriMismatch;
import com.feth.play.module.pa.exceptions.ResolverMissingException;
import com.feth.play.module.pa.providers.ext.ExternalAuthProvider;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthInfo;
import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.AuthUserIdentity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import play.Application;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class OAuth2AuthProvider<U extends AuthUserIdentity, I extends OAuth2AuthInfo>
extends ExternalAuthProvider {
    private static final String STATE_TOKEN = "pa.oauth2.state";
    protected static final String CONTENT_TYPE = "Content-Type";

    public OAuth2AuthProvider(Application app) {
        super(app);
    }

    @Override
    protected List<String> neededSettingKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(super.neededSettingKeys());
        ret.add("accessTokenUrl");
        ret.add("authorizationUrl");
        ret.add("clientId");
        ret.add("clientSecret");
        return ret;
    }

    protected String getAccessTokenParams(Configuration c, String code, Http.Request request) throws ResolverMissingException {
        List<NameValuePair> params = this.getParams(request, c);
        params.add((NameValuePair)new BasicNameValuePair("client_secret", c.getString("clientSecret")));
        params.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        params.add((NameValuePair)new BasicNameValuePair("code", code));
        return URLEncodedUtils.format(params, (String)"UTF-8");
    }

    protected Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    protected I getAccessToken(String code, Http.Request request) throws AccessTokenException, ResolverMissingException {
        Configuration c = this.getConfiguration();
        String params = this.getAccessTokenParams(c, code, request);
        String url = c.getString("accessTokenUrl");
        WSRequestHolder wrh = WS.url((String)url);
        wrh.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            wrh.setHeader(header.getKey(), header.getValue());
        }
        WSResponse r = (WSResponse)wrh.post(params).get(10000L);
        return this.buildInfo(r);
    }

    protected abstract I buildInfo(WSResponse var1) throws AccessTokenException;

    protected String getAuthUrl(Http.Request request, String state) throws AuthException {
        Configuration c = this.getConfiguration();
        List<NameValuePair> params = this.getAuthParams(c, request, state);
        return OAuth2AuthProvider.generateURI(c.getString("authorizationUrl"), params);
    }

    protected List<NameValuePair> getAuthParams(Configuration c, Http.Request request, String state) throws AuthException {
        List<NameValuePair> params = this.getParams(request, c);
        if (c.getString("scope") != null) {
            params.add((NameValuePair)new BasicNameValuePair("scope", c.getString("scope")));
        }
        params.add((NameValuePair)new BasicNameValuePair("response_type", "code"));
        if (c.getString("accessType") != null) {
            params.add((NameValuePair)new BasicNameValuePair("access_type", c.getString("accessType")));
        }
        if (c.getString("approvalPrompt") != null) {
            params.add((NameValuePair)new BasicNameValuePair("approval_prompt", c.getString("approvalPrompt")));
        }
        if (state != null) {
            params.add((NameValuePair)new BasicNameValuePair("state", state));
        }
        return params;
    }

    protected List<NameValuePair> getParams(Http.Request request, Configuration c) throws ResolverMissingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("client_id", c.getString("clientId")));
        params.add((NameValuePair)new BasicNameValuePair(this.getRedirectUriKey(), this.getRedirectUrl(request)));
        return params;
    }

    protected String getRedirectUriKey() {
        return "redirect_uri";
    }

    @Override
    public Object authenticate(Http.Context context, Object payload) throws AuthException {
        String error;
        Http.Request request = context.request();
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)("Returned with URL: '" + request.uri() + "'"));
        }
        if ((error = request.getQueryString(this.getErrorParameterKey())) != null) {
            if (error.equals("access_denied")) {
                throw new AccessDeniedException(this.getKey());
            }
            if (error.equals("redirect_uri_mismatch")) {
                Logger.error((String)("You must set the redirect URI for your provider to whatever you defined in your routes file.For this provider it is: '" + this.getRedirectUrl(request) + "'"));
                throw new RedirectUriMismatch();
            }
            throw new AuthException(error);
        }
        if (this.isCallbackRequest(context)) {
            UUID storedState = (UUID)PlayAuthenticate.getFromCache(context.session(), STATE_TOKEN);
            if (storedState == null) {
                Logger.warn((String)"Cache either timed out, or you are using a setup with multiple servers and a non-shared cache implementation");
                return this.generateRedirectUrl(context, request);
            }
            String callbackState = request.getQueryString("state");
            if (!storedState.equals(UUID.fromString(callbackState))) {
                throw new AuthException(Messages.get((String)"playauthenticate.core.exception.oauth2.state_param_forged", (Object[])new Object[0]));
            }
            String code = request.getQueryString("code");
            I info = this.getAccessToken(code, request);
            return this.transform(info, callbackState);
        }
        return this.generateRedirectUrl(context, request);
    }

    private String generateRedirectUrl(Http.Context context, Http.Request request) throws AuthException {
        UUID state = UUID.randomUUID();
        PlayAuthenticate.storeInCache(context.session(), STATE_TOKEN, state);
        String url = this.getAuthUrl(request, state.toString());
        Logger.debug((String)("generated redirect URL for dialog: " + url));
        return url;
    }

    protected boolean isCallbackRequest(Http.Context context) {
        return context.request().queryString().containsKey("code");
    }

    protected String getErrorParameterKey() {
        return "error";
    }

    @Override
    public void afterSave(AuthUser user, Object identity, Http.Session session) {
        PlayAuthenticate.removeFromCache(session, STATE_TOKEN);
    }

    protected abstract AuthUserIdentity transform(I var1, String var2) throws AuthException;

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class Constants {
        public static final String CLIENT_ID = "client_id";
        public static final String CLIENT_SECRET = "client_secret";
        public static final String REDIRECT_URI = "redirect_uri";
        public static final String SCOPE = "scope";
        public static final String ACCESS_TYPE = "access_type";
        public static final String APPROVAL_PROMPT = "approval_prompt";
        public static final String RESPONSE_TYPE = "response_type";
        public static final String STATE = "state";
        public static final String GRANT_TYPE = "grant_type";
        public static final String AUTHORIZATION_CODE = "authorization_code";
        public static final String ACCESS_TOKEN = "access_token";
        public static final String ERROR = "error";
        public static final String CODE = "code";
        public static final String TOKEN_TYPE = "token_type";
        public static final String EXPIRES_IN = "expires_in";
        public static final String REFRESH_TOKEN = "refresh_token";
        public static final String ACCESS_DENIED = "access_denied";
        public static final String REDIRECT_URI_MISMATCH = "redirect_uri_mismatch";
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class SettingKeys {
        public static final String AUTHORIZATION_URL = "authorizationUrl";
        public static final String ACCESS_TOKEN_URL = "accessTokenUrl";
        public static final String CLIENT_ID = "clientId";
        public static final String CLIENT_SECRET = "clientSecret";
        public static final String SCOPE = "scope";
        public static final String ACCESS_TYPE = "accessType";
        public static final String APPROVAL_PROMPT = "approvalPrompt";
    }
}

