/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.foursquare;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth2.BasicOAuth2AuthUser;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthInfo;
import com.feth.play.module.pa.user.ExtendedIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FoursquareAuthUser
extends BasicOAuth2AuthUser
implements ExtendedIdentity,
PicturedIdentity {
    private static final long serialVersionUID = 1L;
    public static final String CONTACT_DETAIL_EMAIL = "email";
    public static final String CONTACT_DETAIL_TWITTER = "contact";
    public static final String CONTACT_DETAIL_FACEBOOK = "contact";
    private String firstName;
    private String lastName;
    private String homeCity;
    private String picture;
    private String gender;
    private String type;
    private String bio;
    private final Map<String, String> contact;

    public FoursquareAuthUser(JsonNode node, OAuth2AuthInfo info, String state) {
        super(node.get("id").asText(), info, state);
        JsonNode contactNode;
        if (node.has("firstName")) {
            this.firstName = node.get("firstName").asText();
        }
        if (node.has("lastName")) {
            this.lastName = node.get("lastName").asText();
        }
        if (node.has("homeCity")) {
            this.homeCity = node.get("homeCity").asText();
        }
        if (node.has("photo")) {
            StringBuilder sb = new StringBuilder();
            sb.append(node.get("photo").get("prefix").asText());
            sb.append("original");
            sb.append(node.get("photo").get("suffix").asText());
            this.picture = sb.toString();
        }
        if (node.has("gender")) {
            this.gender = node.get("gender").asText();
        }
        if (node.has("type")) {
            this.type = node.get("type").asText();
        }
        if (node.has("bio")) {
            this.bio = node.get("bio").asText();
        }
        if ((contactNode = node.get("contact")) != null) {
            HashMap<String, String> m = new HashMap<String, String>(contactNode.size());
            Iterator fieldIterator = contactNode.fields();
            while (fieldIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)fieldIterator.next();
                m.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
            this.contact = m;
        } else {
            this.contact = Collections.emptyMap();
        }
    }

    @Override
    public String getProvider() {
        return "foursquare";
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public String getHomeCity() {
        return this.homeCity;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    public String getType() {
        return this.type;
    }

    public String getBio() {
        return this.bio;
    }

    @Override
    public String getEmail() {
        return this.getContactDetail(CONTACT_DETAIL_EMAIL);
    }

    public String getContactDetail(String key) {
        return this.contact.get(key);
    }

    @Override
    public String getName() {
        boolean hasLastName;
        StringBuilder sb = new StringBuilder();
        boolean hasFirstName = this.getFirstName() != null && !this.getFirstName().isEmpty();
        boolean bl = hasLastName = this.getLastName() != null && !this.getLastName().isEmpty();
        if (hasFirstName) {
            sb.append(this.getFirstName());
            if (hasLastName) {
                sb.append(" ");
            }
        }
        if (hasLastName) {
            sb.append(this.getLastName());
        }
        return sb.toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private abstract class Constants {
        public static final String ID = "id";
        public static final String FIRST_NAME = "firstName";
        public static final String LAST_NAME = "lastName";
        public static final String HOME_CITY = "homeCity";
        public static final String PHOTO = "photo";
        public static final String PREFIX = "prefix";
        public static final String ORIGINAL = "original";
        public static final String SUFFIX = "suffix";
        public static final String GENDER = "gender";
        public static final String TYPE = "type";
        public static final String CONTACT = "contact";
        public static final String BIO = "bio";

        private Constants() {
        }
    }
}

