/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.untappd;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.exceptions.ResolverMissingException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.untappd.UntappdAuthInfo;
import com.feth.play.module.pa.providers.oauth2.untappd.UntappdAuthUser;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import play.Application;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class UntappdAuthProvider
extends OAuth2AuthProvider<UntappdAuthUser, UntappdAuthInfo> {
    public static final String PROVIDER_KEY = "untappd";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String NODE_USER = "user";
    private static final String NODE_RESPONSE = "response";
    private static final String NODE_META = "meta";
    private static final String ERROR_DETAIL = "error_detail";
    private static final String ERROR_TYPE = "error_type";
    private static final String REDIRECT_URL = "redirect_url";

    public UntappdAuthProvider(Application app) {
        super(app);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    protected UntappdAuthUser transform(UntappdAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter("access_token", info.getAccessToken()).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (result.get("error") != null) {
            throw new AuthException(result.get("error").asText());
        }
        Logger.debug((String)result.toString());
        return new UntappdAuthUser(result.get(NODE_RESPONSE).get(NODE_USER), info, state);
    }

    @Override
    protected String getErrorParameterKey() {
        return ERROR_TYPE;
    }

    @Override
    protected String getRedirectUriKey() {
        return REDIRECT_URL;
    }

    @Override
    protected UntappdAuthInfo getAccessToken(String code, Http.Request request) throws AccessTokenException, ResolverMissingException {
        Configuration c = this.getConfiguration();
        String url = c.getString("accessTokenUrl");
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter("client_id", c.getString("clientId")).setQueryParameter("client_secret", c.getString("clientSecret")).setQueryParameter("response_type", "code").setQueryParameter("code", code).setQueryParameter(this.getRedirectUriKey(), this.getRedirectUrl(request)).get().get(this.getTimeout());
        return this.buildInfo(r);
    }

    @Override
    protected List<NameValuePair> getParams(Http.Request request, Configuration c) throws ResolverMissingException {
        List<NameValuePair> params = super.getParams(request, c);
        params.add((NameValuePair)new BasicNameValuePair("client_secret", c.getString("clientSecret")));
        return params;
    }

    @Override
    protected UntappdAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        JsonNode n = r.asJson();
        JsonNode meta = n.get(NODE_META);
        if (meta.get(ERROR_TYPE) != null) {
            throw new AccessTokenException(meta.get(ERROR_DETAIL).asText());
        }
        return new UntappdAuthInfo(n.get(NODE_RESPONSE).get("access_token").asText());
    }
}

