/**
 *  Yona, 21st Century Project Hosting SW
 *  <p>
 *  Copyright Yona & Yobi Authors & NAVER Corp.
 *  https://yona.io
 **/
/**
 * It is modified and derived from https://github.com/file-icons/atom/blob/master/lib/icons/.icondb.js
 * @type {[*]}
 */
var fileType = [
    [new RegExp(/\.app$/i), 'apple-icon'],
    [new RegExp(/\.swp$/i), 'binary-icon dark-green'],
    [new RegExp(/\.lnk$/i), 'link-icon medium-blue'],
    [new RegExp(/^angular[^.]*\.js$/i), 'angular-icon medium-red'],
    [new RegExp(/^ant\.xml$|\.ant$/i), 'ant-icon dark-pink'],
    [new RegExp(/^(?:apache2?|httpd).conf$/i), 'apache-icon medium-red'],
    [new RegExp(/\.vhost$/i), 'apache-icon dark-green'],
    [new RegExp(/\.thrift$/i), 'apache-icon medium-green'],
    [new RegExp(/^appcelerator\.js$/i), 'appcelerator-icon medium-red'],
    [new RegExp(/^appveyor\.yml$/i), 'appveyor-icon medium-blue'],
    [new RegExp(/^\.install$/), 'archlinux-icon dark-purple'],
    [new RegExp(/^\.SRCINFO$/), 'archlinux-icon dark-maroon'],
    [new RegExp(/^pacman\.conf$/), 'archlinux-icon dark-yellow'],
    [new RegExp(/^pamac\.conf$/), 'archlinux-icon light-yellow'],
    [new RegExp(/^PKGBUILD$/), 'archlinux-icon dark-cyan'],
    [new RegExp(/yaourtrc$/i), 'archlinux-icon light-yellow'],
    [new RegExp(/^backbone(?:[-.]min|dev)?\.js$/i), 'backbone-icon dark-blue'],
    [new RegExp(/^Makefile\.boot$/i), 'boot-icon medium-green'],
    [new RegExp(/^(?:custom\.)?bootstrap\S*\.js$/i), 'bootstrap-icon medium-yellow'],
    [new RegExp(/^(?:custom\.)?bootstrap\S*\.css$/i), 'bootstrap-icon medium-blue'],
    [new RegExp(/^(?:custom\.)?bootstrap\S*\.less$/i), 'bootstrap-icon dark-blue'],
    [new RegExp(/^(?:custom\.)?bootstrap\S*\.scss$/i), 'bootstrap-icon light-pink'],
    [new RegExp(/^(?:custom\.)?bootstrap\S*\.styl$/i), 'bootstrap-icon medium-green'],
    [new RegExp(/^(?:\.bowerrc|bower\.json|Bowerfile)$/i), 'bower-icon medium-yellow'],
    [new RegExp(/brakeman\.yml$/i), 'brakeman-icon medium-red'],
    [new RegExp(/^brakeman\.ignore$/i), 'brakeman-icon dark-red'],
    [new RegExp(/^Brocfile\./i), 'broccoli-icon medium-green'],
    [new RegExp(/Cargo\.toml$/i), 'package-icon light-orange'],
    [new RegExp(/Cargo\.lock$/i), 'package-icon dark-orange'],
    [new RegExp(/^chai\.(?:[jt]sx?|es6?|coffee)$/i), 'chai-icon medium-red'],
    [new RegExp(/^Chart\.js$/i), 'chartjs-icon dark-pink'],
    [new RegExp(/^circle\.yml$/i), 'circleci-icon medium-green'],
    [new RegExp(/\.codeclimate\.yml$/i), 'cc-icon medium-green'],
    [new RegExp(/^codecov\.ya?ml$/i), 'codecov-icon dark-pink'],
    [new RegExp(/\.coffee\.ecr$/i), 'coffee-icon medium-cyan'],
    [new RegExp(/\.coffee\.erb$/i), 'coffee-icon medium-red'],
    [new RegExp(/^_?(?:compass|lemonade)\.scss$/i), 'compass-icon medium-red'],
    [new RegExp(/^composer\.(?:json|lock)$/i), 'composer-icon medium-yellow'],
    [new RegExp(/^composer\.phar$/i), 'composer-icon dark-blue'],
    [new RegExp(/^cordova(?:[^.]*\.|-(?:\d\.)+)js$/i), 'cordova-icon light-blue'],
    [new RegExp(/^d3(?:\.v\d+)?[^.]*\.js$/i), 'd3-icon medium-orange'],
    [new RegExp(/^METADATA\.pb$/), 'database-icon medium-red'],
    [new RegExp(/^(?:Dockerfile|docker-compose)|\.docker(?:file|ignore)$/i), 'docker-icon dark-blue'],
    [new RegExp(/^docker-sync\.yml$/i), 'docker-icon dark-orange'],
    [new RegExp(/^dojo\.js$/i), 'dojo-icon light-red'],
    [new RegExp(/^ember(?:\.|(?:-[^.]+)?-(?:\d+\.)+(?:debug\.)?)js$/i), 'ember-icon medium-red'],
    [new RegExp(/\.eslint(?:cache|ignore)$/i), 'eslint-icon medium-purple'],
    [new RegExp(/\.eslintrc(?:\.(?:js|json|ya?ml))?$/i), 'eslint-icon light-purple'],
    [new RegExp(/\bExtjs(?:-ext)?\.js$/i), 'extjs-icon light-green'],
    [new RegExp(/^fabfile\.py$/i), 'fabfile-icon medium-blue'],
    [new RegExp(/^fuelux(?:\.min)?\.(?:css|js)$/i), 'fuelux-icon medium-orange'],
    [new RegExp(/\.indent\.pro$/i), 'gear-icon medium-blue'],
    [new RegExp(/gruntfile\.js$/i), 'grunt-icon medium-yellow'],
    [new RegExp(/gruntfile\.coffee$/i), 'grunt-icon medium-maroon'],
    [new RegExp(/gulpfile\.js$|gulpfile\.babel\.js$/i), 'gulp-icon medium-red'],
    [new RegExp(/gulpfile\.coffee$/i), 'gulp-icon medium-maroon'],
    [new RegExp(/\.html?\.ecr$/i), 'html5-icon medium-cyan'],
    [new RegExp(/\.(?:html?\.erb|rhtml)$/i), 'html5-icon medium-red'],
    [new RegExp(/^ionic\.project$/), 'ionic-icon medium-blue'],
    [new RegExp(/\.js\.ecr$/i), 'js-icon medium-cyan'],
    [new RegExp(/\.js\.erb$/i), 'js-icon medium-red'],
    [new RegExp(/^jquery(?:[-.](?:min|latest|\d\.\d+(?:\.\d+)?))*\.(?:[jt]sx?|es6?|coffee|map)$/i), 'jquery-icon dark-blue'],
    [new RegExp(/^jquery(?:[-_.](?:ui[-_.](?:custom|dialog-?\w*)|effects)(?:\.[^.]*)?|[-.]?ui(?:-\d\.\d+(?:\.\d+)?)?(?:\.\w+)?)(?:[-_.]?min|dev)?\.(?:[jt]sx?|es6?|coffee|map|s?css|less|styl)$/i), 'jqueryui-icon dark-blue'],
    [new RegExp(/^karma\.conf\.js$/i), 'karma-icon medium-cyan'],
    [new RegExp(/^karma\.conf\.coffee$/i), 'karma-icon medium-maroon'],
    [new RegExp(/^knockout[-.](?:\d+\.){3}(?:debug\.)?js$/i), 'knockout-icon medium-red'],
    [new RegExp(/^leaflet\.(?:draw-src|draw|spin|coordinates-(?:\d+\.)\d+\.\d+\.src)\.(?:js|css)$|^wicket-leaflet\.js$/i), 'leaflet-icon medium-green'],
    [new RegExp(/project\.clj$/i), 'lein-icon null'],
    [new RegExp(/^tmac\.|^(?:mmn|mmt)$/i), 'manpage-icon dark-green'],
    [new RegExp(/\.marko$/i), 'marko-icon medium-blue'],
    [new RegExp(/\.marko\.js$/i), 'marko-icon medium-maroon'],
    [new RegExp(/^materialize(?:\.min)?\.(?:js|css)$/i), 'materialize-icon light-red'],
    [new RegExp(/^MathJax[^.]*\.js$/i), 'mathjax-icon dark-green'],
    [new RegExp(/^mocha\.(?:[jt]sx?|es6?|coffee)$/i), 'mocha-icon medium-maroon'],
    [new RegExp(/^mocha\.(?:s?css|less|styl)$/i), 'mocha-icon medium-red'],
    [new RegExp(/mocha\.opts$/i), 'mocha-icon light-maroon'],
    [new RegExp(/^modernizr(?:[-\.]custom|-\d\.\d+)(?:\.\d+)?\.js$/i), 'modernizr-icon medium-red'],
    [new RegExp(/^mootools[^.]*\d+\.\d+(?:.\d+)?[^.]*\.js$/i), 'mootools-icon medium-purple'],
    [new RegExp(/^run\.n$/), 'neko-icon dark-orange'],
    [new RegExp(/^newrelic\.yml/i), 'newrelic-icon medium-cyan'],
    [new RegExp(/^nginx\.conf$/i), 'nginx-icon dark-green'],
    [new RegExp(/\.ninja\.d$/i), 'shuriken-icon dark-cyan'],
    [new RegExp(/^nodemon\.json$|^\.nodemonignore$/i), 'nodemon-icon medium-green'],
    [new RegExp(/^normalize\.(?:css|less|scss|styl)$/i), 'normalize-icon medium-red'],
    [new RegExp(/^(?:package\.json|\.npmignore|\.?npmrc|npm-debug\.log|npm-shrinkwrap\.json)$/i), 'npm-icon medium-red'],
    [new RegExp(/\bpostcss\.config\.js$/i), 'postcss-icon medium-yellow'],
    [new RegExp(/^protractor\.conf\./i), 'protractor-icon medium-red'],
    [new RegExp(/^\.pug-lintrc/i), 'pug-icon medium-orange'],
    [new RegExp(/^raphael(?:\.min|\.no-deps)*\.js$/i), 'raphael-icon medium-orange'],
    [new RegExp(/^react(?:-[^.]*)?\.js$/i), 'react-icon dark-blue'],
    [new RegExp(/\.react\.js$/i), 'react-icon medium-blue'],
    [new RegExp(/^README(?:\b|_)|^(?:licen[sc]es?|(?:read|readme|click|delete|keep|test)\.me)$|\.(?:readme|1st)$/i), 'book-icon medium-blue'],
    [new RegExp(/^(?:notice|bugs|changes|change[-_]?log(?:[-._]?\d+)?|contribute|contributing|contributors|copying|hacking|history|install|maintainers|manifest|more\.stuff|projects|revision|terms|thanks)$/i), 'book-icon dark-blue'],
    [new RegExp(/^require(?:[-.]min|dev)?\.js$/i), 'requirejs-icon medium-blue'],
    [new RegExp(/^riemann\.config$/i), 'clojure-icon medium-maroon'],
    [new RegExp(/^rollup\.config\./i), 'rollup-icon medium-red'],
    [new RegExp(/_spec\.rb$/i), 'ruby-icon light-green'],
    [new RegExp(/\.scrutinizer\.yml$/i), 'scrutinizer-icon dark-blue'],
    [new RegExp(/^sencha(?:\.min)?\.js$/i), 'sencha-icon light-green'],
    [new RegExp(/^snap\.svg(?:[-.]min)?\.js$/i), 'snapsvg-icon medium-cyan'],
    [new RegExp(/\.css\.map$/i), 'sourcemap-icon medium-blue'],
    [new RegExp(/\.js\.map$/i), 'sourcemap-icon medium-yellow'],
    [new RegExp(/^\.stylelintrc(?:\.|$)/i), 'stylelint-icon medium-purple'],
    [new RegExp(/^stylelint\.config\.js$/i), 'stylelint-icon medium-yellow'],
    [new RegExp(/\.stylelintignore$/i), 'stylelint-icon dark-blue'],
    [new RegExp(/\.toc$/i), 'toc-icon medium-cyan'],
    [new RegExp(/\.8x[pk](?:\.txt)?$/i), 'calc-icon medium-maroon'],
    [new RegExp(/^\.travis/i), 'travis-icon medium-red'],
    [new RegExp(/^typedoc\.json$/i), 'typedoc-icon dark-purple'],
    [new RegExp(/^typings\.json$/i), 'typings-icon medium-maroon'],
    [new RegExp(/^uikit(?:\.min)?\.js$/i), 'uikit-icon medium-blue'],
    [new RegExp(/webpack\.config\.|^webpackfile\.js$/i), 'webpack-icon medium-blue'],
    [new RegExp(/^wercker\.ya?ml$/i), 'wercker-icon medium-purple'],
    [new RegExp(/^yarn\.lock$/i), 'yarn-icon medium-blue'],
    [new RegExp(/\.yo-rc\.json$/i), 'yeoman-icon medium-cyan'],
    [new RegExp(/^(?:yahoo-|yui)[^.]*\.js$/i), 'yui-icon dark-blue'],
    [new RegExp(/\.gnus$/i), 'emacs-icon medium-red'],
    [new RegExp(/\.viper$/i), 'emacs-icon dark-green'],
    [new RegExp(/^Cask$/), 'emacs-icon dark-blue'],
    [new RegExp(/^Project\.ede$/i), 'emacs-icon medium-blue'],
    [new RegExp(/\.bsl$/i), '_1c-icon medium-red'],
    [new RegExp(/\.sdbl$/i), '_1c-icon dark-orange'],
    [new RegExp(/\.os$/i), '_1c-icon dark-red'],
    [new RegExp(/\.mdo$/i), '_1c-alt-icon medium-red'],
    [new RegExp(/\.abap$/i), 'abap-icon medium-orange'],
    [new RegExp(/\.swf$/i), 'as-icon medium-blue'],
    [new RegExp(/\.as$/i), 'as-icon medium-red'],
    [new RegExp(/\.jsfl$/i), 'as-icon medium-yellow'],
    [new RegExp(/\.swc$/i), 'as-icon dark-red'],
    [new RegExp(/\.(?:ada|adb|ads)$/i), 'ada-icon medium-blue'],
    [new RegExp(/\.aep$/i), 'ae-icon dark-pink'],
    [new RegExp(/\.aet$/i), 'ae-icon dark-purple'],
    [new RegExp(/\.ai$/i), 'ai-icon medium-orange'],
    [new RegExp(/\.ait$/i), 'ai-icon dark-orange'],
    [new RegExp(/\.indd$|\.idml$/i), 'indesign-icon dark-pink'],
    [new RegExp(/\.indl$/i), 'indesign-icon medium-purple'],
    [new RegExp(/\.indt$|\.inx$/i), 'indesign-icon dark-purple'],
    [new RegExp(/\.indb$/i), 'indesign-icon dark-blue'],
    [new RegExp(/\.psd$/i), 'psd-icon medium-blue'],
    [new RegExp(/\.psb$/i), 'psd-icon dark-purple'],
    [new RegExp(/\.prproj$/i), 'premiere-icon dark-purple'],
    [new RegExp(/\.prel$/i), 'premiere-icon medium-maroon'],
    [new RegExp(/\.psq$/i), 'premiere-icon medium-purple'],
    [new RegExp(/\.als$/i), 'alloy-icon medium-red'],
    [new RegExp(/(?:\.|^)APKBUILD$/), 'alpine-icon dark-blue'],
    [new RegExp(/\.ampl$/i), 'ampl-icon dark-maroon'],
    [new RegExp(/\.ansiweatherrc$/i), 'sun-icon medium-yellow'],
    [new RegExp(/\.g$/i), 'antlr-icon medium-red'],
    [new RegExp(/\.g4$/i), 'antlr-icon medium-orange'],
    [new RegExp(/\.apacheconf$/i), 'apache-icon dark-red'],
    [new RegExp(/apache2[\\\/]magic$/i), 'apache-icon medium-purple'],
    [new RegExp(/\.apib$/i), 'api-icon medium-blue'],
    [new RegExp(/\.apl$/i), 'apl-icon dark-cyan'],
    [new RegExp(/\.apl\.history$/i), 'apl-icon medium-maroon'],
    [new RegExp(/\.(?:applescript|scpt)$/i), 'apple-icon medium-purple'],
    [new RegExp(/\.arc$/i), 'arc-icon medium-blue'],
    [new RegExp(/\.ino$/i), 'arduino-icon dark-cyan'],
    [new RegExp(/\.(?:ad|adoc|asc|asciidoc)$/i), 'asciidoc-icon medium-blue'],
    [new RegExp(/\.asp$/i), 'asp-icon dark-blue'],
    [new RegExp(/\.asax$/i), 'asp-icon medium-maroon'],
    [new RegExp(/\.ascx$/i), 'asp-icon dark-green'],
    [new RegExp(/\.ashx$/i), 'asp-icon medium-green'],
    [new RegExp(/\.asmx$/i), 'asp-icon dark-cyan'],
    [new RegExp(/\.aspx$/i), 'asp-icon medium-purple'],
    [new RegExp(/\.axd$/i), 'asp-icon medium-cyan'],
    [new RegExp(/\.aj$/i), 'eclipse-icon medium-maroon'],
    [new RegExp(/\.(?:l?a|[ls]?o|out|s|a51|n?asm|axf|elf|prx|puff|was[mt]|z80)$|\.rpy[bc]$/i), 'binary-icon medium-red'],
    [new RegExp(/\.agc$|\.d-objdump$/i), 'binary-icon dark-blue'],
    [new RegExp(/\.ko$/i), 'binary-icon dark-green'],
    [new RegExp(/\.lst$/i), 'binary-icon medium-blue'],
    [new RegExp(/\.(?:(?:c(?:[+px]{2}?)?-?)?objdump|bsdiff|bin|dat|pak|pdb)$/i), 'binary-icon dark-orange'],
    [new RegExp(/\.gcode|\.gco/i), 'binary-icon medium-orange'],
    [new RegExp(/\.py[co]$/i), 'binary-icon dark-purple'],
    [new RegExp(/\.DS_Store$/i), 'binary-icon null'],
    [new RegExp(/\.dats$/i), 'ats-icon medium-red'],
    [new RegExp(/\.hats$/i), 'ats-icon medium-blue'],
    [new RegExp(/\.sats$/i), 'ats-icon dark-yellow'],
    [new RegExp(/\.aup$/i), 'audacity-icon medium-yellow'],
    [new RegExp(/\.mp3$/i), 'audio-icon medium-red'],
    [new RegExp(/\.wav$/i), 'audio-icon dark-yellow'],
    [new RegExp(/\.(?:aac|ac3|m4p)$/i), 'audio-icon dark-cyan'],
    [new RegExp(/\.aif[fc]?$/i), 'audio-icon medium-purple'],
    [new RegExp(/\.au$/i), 'audio-icon medium-cyan'],
    [new RegExp(/\.flac$/i), 'audio-icon dark-red'],
    [new RegExp(/\.f4[ab]$/i), 'audio-icon medium-red'],
    [new RegExp(/\.m4a$/i), 'audio-icon medium-cyan'],
    [new RegExp(/\.(?:mpc|mp\+)$/i), 'audio-icon dark-green'],
    [new RegExp(/\.oga$/i), 'audio-icon dark-orange'],
    [new RegExp(/\.opus$/i), 'audio-icon dark-maroon'],
    [new RegExp(/\.r[am]$/i), 'audio-icon dark-blue'],
    [new RegExp(/\.wma$/i), 'audio-icon medium-blue'],
    [new RegExp(/\.aug$/i), 'augeas-icon dark-orange'],
    [new RegExp(/\.ahk$/i), 'ahk-icon dark-blue'],
    [new RegExp(/\.ahkl$/i), 'ahk-icon dark-purple'],
    [new RegExp(/\.au3$/i), 'autoit-icon medium-purple'],
    [new RegExp(/\.awk$/i), 'terminal-icon medium-blue'],
    [new RegExp(/\.gawk$/i), 'terminal-icon medium-red'],
    [new RegExp(/\.mawk$/i), 'terminal-icon medium-maroon'],
    [new RegExp(/\.nawk$/i), 'terminal-icon dark-green'],
    [new RegExp(/\.auk$/i), 'terminal-icon dark-cyan'],
    [new RegExp(/\.(?:babelrc|languagebabel|babel)$/i), 'babel-icon medium-yellow'],
    [new RegExp(/\.babelignore$/i), 'babel-icon dark-yellow'],
    [new RegExp(/\.cbx$/i), 'bibtex-icon medium-red'],
    [new RegExp(/\.bbx$/i), 'bibtex-icon medium-orange'],
    [new RegExp(/\.bib$/i), 'bibtex-icon medium-yellow'],
    [new RegExp(/\.bst$/i), 'bibtex-icon medium-green'],
    [new RegExp(/\.bison$/i), 'gnu-icon medium-red'],
    [new RegExp(/\.blend$/i), 'blender-icon medium-orange'],
    [new RegExp(/\.blend\d+$/i), 'blender-icon dark-orange'],
    [new RegExp(/\.bphys$/i), 'blender-icon dark-blue'],
    [new RegExp(/\.bsv$/i), 'bluespec-icon dark-blue'],
    [new RegExp(/\.boo$/i), 'boo-icon medium-green'],
    [new RegExp(/\.boot$/i), 'boot-icon null'],
    [new RegExp(/\.bf?$/i), 'brain-icon dark-pink'],
    [new RegExp(/^Brewfile$/), 'brew-icon medium-orange'],
    [new RegExp(/\.bro$/i), 'bro-icon dark-cyan'],
    [new RegExp(/\.dm$/i), 'byond-icon medium-blue'],
    [new RegExp(/\.c$/i), 'c-icon medium-blue'],
    [new RegExp(/\.h$|\.cats$/i), 'c-icon medium-purple'],
    [new RegExp(/\.idc$/i), 'c-icon medium-green'],
    [new RegExp(/\.w$/i), 'c-icon medium-maroon'],
    [new RegExp(/\.nc$/i), 'c-icon dark-blue'],
    [new RegExp(/\.upc$/i), 'c-icon medium-cyan'],
    [new RegExp(/\.cs$/i), 'csharp-icon medium-blue'],
    [new RegExp(/\.csx$/i), 'csscript-icon dark-green'],
    [new RegExp(/\.c[+px]{2}$|\.cc$/i), 'cpp-icon medium-blue'],
    [new RegExp(/\.h[+px]{2}$/i), 'cpp-icon medium-purple'],
    [new RegExp(/\.[it]pp$/i), 'cpp-icon medium-orange'],
    [new RegExp(/\.(?:tcc|inl)$/i), 'cpp-icon medium-red'],
    [new RegExp(/\.cabal$/i), 'cabal-icon medium-cyan'],
    [new RegExp(/\.cake$/i), 'cake-icon medium-yellow'],
    [new RegExp(/^Cakefile$/), 'cakefile-icon medium-red'],
    [new RegExp(/\.ctp$/i), 'cakephp-icon medium-red'],
    [new RegExp(/\.ceylon$/i), 'ceylon-icon medium-orange'],
    [new RegExp(/\.chpl$/i), 'chapel-icon medium-green'],
    [new RegExp(/\.crx$/i), 'chrome-icon medium-red'],
    [new RegExp(/\.ck$/i), 'chuck-icon medium-green'],
    [new RegExp(/\.cirru$/i), 'cirru-icon medium-pink'],
    [new RegExp(/\.clw$/i), 'clarion-icon medium-orange'],
    [new RegExp(/\.icl$/i), 'clean-icon dark-cyan'],
    [new RegExp(/\.dcl$/i), 'clean-icon medium-cyan'],
    [new RegExp(/\.abc$/i), 'clean-icon medium-blue'],
    [new RegExp(/\.click$/i), 'click-icon medium-yellow'],
    [new RegExp(/\.clp$/i), 'clips-icon dark-green'],
    [new RegExp(/\.clj$/i), 'clojure-icon medium-blue'],
    [new RegExp(/\.cl2$/i), 'clojure-icon medium-purple'],
    [new RegExp(/\.cljc$/i), 'clojure-icon medium-green'],
    [new RegExp(/\.cljx$|\.hic$/i), 'clojure-icon medium-red'],
    [new RegExp(/\.cljs(?:\.hl|cm)?$/i), 'cljs-icon medium-blue'],
    [new RegExp(/\.cmake$/i), 'cmake-icon medium-green'],
    [new RegExp(/^CMakeLists\.txt$/), 'cmake-icon medium-red'],
    [new RegExp(/\.coffee$/i), 'coffee-icon medium-maroon'],
    [new RegExp(/\.cjsx$/i), 'coffee-icon dark-maroon'],
    [new RegExp(/\.litcoffee$/i), 'coffee-icon light-maroon'],
    [new RegExp(/\.iced$/i), 'coffee-icon medium-blue'],
    [new RegExp(/\.cfc$/i), 'cf-icon light-cyan'],
    [new RegExp(/\.cfml?$/i), 'cf-icon medium-cyan'],
    [new RegExp(/\.dae$/i), 'khronos-icon medium-orange'],
    [new RegExp(/\.cl$/i), 'cl-icon medium-orange'],
    [new RegExp(/\.cp$/i), 'cp-icon medium-maroon'],
    [new RegExp(/\.cps$/i), 'cp-icon dark-red'],
    [new RegExp(/\.(?:zip|z|xz)$/i), 'zip-icon null'],
    [new RegExp(/\.rar$/i), 'zip-icon medium-blue'],
    [new RegExp(/\.t?gz$|\.tar$|\.whl$/i), 'zip-icon dark-blue'],
    [new RegExp(/\.(?:lzo?|lzma|tlz|tar\.lzma)$/i), 'zip-icon medium-maroon'],
    [new RegExp(/\.7z$/i), 'zip-icon medium-maroon'],
    [new RegExp(/\.apk$|\.gem$/i), 'zip-icon medium-red'],
    [new RegExp(/\.bz2$/i), 'zip-icon dark-cyan'],
    [new RegExp(/\.iso$/i), 'zip-icon medium-blue'],
    [new RegExp(/\.xpi$/i), 'zip-icon medium-orange'],
    [new RegExp(/\.epub$/i), 'zip-icon medium-green'],
    [new RegExp(/\.jar$/i), 'zip-icon dark-pink'],
    [new RegExp(/\.war$/i), 'zip-icon medium-purple'],
    [new RegExp(/\.xar$/i), 'zip-icon dark-orange'],
    [new RegExp(/\.egg$/i), 'zip-icon light-orange'],
    [new RegExp(/\.(?:ini|desktop|directory|cfg|conf|prefs)$/i), 'config-icon medium-yellow'],
    [new RegExp(/\.properties$/i), 'config-icon medium-purple'],
    [new RegExp(/\.toml$|\.opts$/i), 'config-icon medium-green'],
    [new RegExp(/\.ld$/i), 'config-icon dark-red'],
    [new RegExp(/\.lds$|\.reek$/i), 'config-icon medium-red'],
    [new RegExp(/\.terminal$/i), 'config-icon dark-blue'],
    [new RegExp(/^ld\.script$/i), 'config-icon medium-orange'],
    [new RegExp(/^\/(?:private\/)?etc\/(?:[^\/]+\/)*[^\/]*\.(?:cf|conf|ini)(?:\.default)?$/i), 'config-icon dark-orange'],
    [new RegExp(/^\/(?:private\/)?etc\/(?:aliases|auto_(?:home|master)|ftpusers|group|gettytab|hosts(?:\.equiv)?|manpaths|networks|paths|protocols|services|shells|sudoers|ttys)$/i), 'config-icon medium-maroon'],
    [new RegExp(/\.coq$/i), 'coq-icon medium-maroon'],
    [new RegExp(/\.creole$/i), 'creole-icon medium-blue'],
    [new RegExp(/\.e?cr$/i), 'crystal-icon medium-cyan'],
    [new RegExp(/\.orc$/i), 'csound-icon medium-maroon'],
    [new RegExp(/\.udo$/i), 'csound-icon dark-orange'],
    [new RegExp(/\.csd$/i), 'csound-icon dark-maroon'],
    [new RegExp(/\.sco$/i), 'csound-icon dark-blue'],
    [new RegExp(/\.css$/i), 'css3-icon medium-blue'],
    [new RegExp(/\.less$/i), 'css3-icon dark-blue'],
    [new RegExp(/\.feature$/i), 'cucumber-icon medium-green'],
    [new RegExp(/\.cu$/i), 'nvidia-icon medium-green'],
    [new RegExp(/\.cuh$/i), 'nvidia-icon dark-green'],
    [new RegExp(/\.pyx$/i), 'cython-icon medium-orange'],
    [new RegExp(/\.pxd$/i), 'cython-icon medium-blue'],
    [new RegExp(/\.pxi$/i), 'cython-icon dark-blue'],
    [new RegExp(/\.di?$/i), 'dlang-icon medium-red'],
    [new RegExp(/\.dnh$/i), 'yang-icon medium-red'],
    [new RegExp(/\.d(?:arcs)?patch$/i), 'darcs-icon medium-green'],
    [new RegExp(/\.dart$/i), 'dart-icon medium-cyan'],
    [new RegExp(/\.s[kl]im$/i), 'dashboard-icon medium-orange'],
    [new RegExp(/\.cpuprofile$/i), 'dashboard-icon medium-green'],
    [new RegExp(/\.(?:h|geo|topo)?json$/i), 'database-icon medium-yellow'],
    [new RegExp(/\.ya?ml$/i), 'database-icon light-red'],
    [new RegExp(/\.cson$|\.ston$|^mime\.types$/i), 'database-icon medium-maroon'],
    [new RegExp(/\.json5$/i), 'database-icon dark-yellow'],
    [new RegExp(/\.http$|\.pot?$/i), 'database-icon medium-red'],
    [new RegExp(/\.ndjson$|\.pytb$/i), 'database-icon medium-orange'],
    [new RegExp(/\.fea$/i), 'database-icon light-blue'],
    [new RegExp(/\.json\.eex$|\.edn$/i), 'database-icon medium-purple'],
    [new RegExp(/\.proto$/i), 'database-icon dark-cyan'],
    [new RegExp(/\.pydeps$|\.rviz$/i), 'database-icon dark-blue'],
    [new RegExp(/\.eam\.fs$/i), 'database-icon dark-purple'],
    [new RegExp(/\.qml$/i), 'database-icon medium-pink'],
    [new RegExp(/\.qbs$/i), 'database-icon dark-pink'],
    [new RegExp(/\.ttl$/i), 'database-icon medium-cyan'],
    [new RegExp(/\.syntax$/i), 'database-icon medium-blue'],
    [new RegExp(/\.dbf$/i), 'dbase-icon medium-red'],
    [new RegExp(/\.deb$/i), 'debian-icon medium-red'],
    [new RegExp(/^control$/), 'debian-icon dark-cyan'],
    [new RegExp(/^rules$/), 'debian-icon medium-cyan'],
    [new RegExp(/\.diff$/i), 'diff-icon medium-orange'],
    [new RegExp(/\.zone$/i), 'earth-icon medium-blue'],
    [new RegExp(/\.arpa$/i), 'earth-icon medium-green'],
    [new RegExp(/^CNAME$/), 'earth-icon dark-blue'],
    [new RegExp(/^Doxyfile$/), 'doxygen-icon medium-blue'],
    [new RegExp(/\.dyalog$/i), 'dyalog-icon medium-orange'],
    [new RegExp(/\.(?:dylib|bundle)$/i), 'dylib-icon medium-cyan'],
    [new RegExp(/\.E$/), 'e-icon medium-green'],
    [new RegExp(/\.sch$/i), 'eagle-icon medium-red'],
    [new RegExp(/\.brd$/i), 'eagle-icon dark-red'],
    [new RegExp(/\.ec$/i), 'ec-icon dark-blue'],
    [new RegExp(/\.eh$/i), 'ec-icon dark-purple'],
    [new RegExp(/\.epj$/i), 'ecere-icon medium-blue'],
    [new RegExp(/\.c?project$/), 'eclipse-icon dark-blue'],
    [new RegExp(/\.classpath$/i), 'eclipse-icon medium-red'],
    [new RegExp(/\.editorconfig$/i), 'editorconfig-icon medium-orange'],
    [new RegExp(/\.e$/), 'eiffel-icon medium-cyan'],
    [new RegExp(/\.ex$/i), 'elixir-icon dark-purple'],
    [new RegExp(/\.(?:exs|eex)$/i), 'elixir-icon medium-purple'],
    [new RegExp(/mix\.exs?$/i), 'elixir-icon light-purple'],
    [new RegExp(/\.elm$/i), 'elm-icon medium-blue'],
    [new RegExp(/(?:^|\.)(?:el|_?emacs|spacemacs|emacs\.desktop|abbrev[-_]defs)$/i), 'emacs-icon medium-purple'],
    [new RegExp(/(?:^|\.)(?:elc|eld)$/i), 'emacs-icon dark-purple'],
    [new RegExp(/^(?:authors|owners)$/i), 'at-icon medium-red'],
    [new RegExp(/\.emberscript$/i), 'em-icon medium-red'],
    [new RegExp(/\.em(?:blem)?$/i), 'mustache-icon medium-blue'],
    [new RegExp(/\.eq$/i), 'eq-icon medium-orange'],
    [new RegExp(/\.erl$/i), 'erlang-icon medium-red'],
    [new RegExp(/\.beam$/i), 'erlang-icon dark-red'],
    [new RegExp(/\.hrl$/i), 'erlang-icon medium-maroon'],
    [new RegExp(/\.xrl$/i), 'erlang-icon medium-green'],
    [new RegExp(/\.yrl$/i), 'erlang-icon dark-green'],
    [new RegExp(/\.app\.src$/i), 'erlang-icon dark-maroon'],
    [new RegExp(/\.factor$/i), 'factor-icon medium-orange'],
    [new RegExp(/\.factor-rc$/i), 'factor-icon dark-orange'],
    [new RegExp(/\.factor-boot-rc$/i), 'factor-icon medium-red'],
    [new RegExp(/\.fy$/i), 'fancy-icon dark-blue'],
    [new RegExp(/\.fancypack$/i), 'fancy-icon medium-blue'],
    [new RegExp(/^Fakefile$/), 'fancy-icon medium-green'],
    [new RegExp(/\.fan$/i), 'fantom-icon medium-blue'],
    [new RegExp(/\.fbx$/i), 'fbx-icon medium-maroon'],
    [new RegExp(/^Icon\r$/), 'finder-icon medium-blue'],
    [new RegExp(/\.rsrc$/i), 'finder-icon dark-blue'],
    [new RegExp(/\.(?:flowconfig|js\.flow)$/i), 'flow-icon medium-orange'],
    [new RegExp(/\.fx$/i), 'flux-icon medium-blue'],
    [new RegExp(/\.flux$/i), 'flux-icon dark-blue'],
    [new RegExp(/\.woff2$/i), 'font-icon dark-blue'],
    [new RegExp(/\.woff$/i), 'font-icon medium-blue'],
    [new RegExp(/\.eot$/i), 'font-icon light-green'],
    [new RegExp(/\.ttc$/i), 'font-icon dark-green'],
    [new RegExp(/\.ttf$/i), 'font-icon medium-green'],
    [new RegExp(/\.otf$/i), 'font-icon dark-yellow'],
    [new RegExp(/\.pfb$/i), 'font-icon dark-red'],
    [new RegExp(/\.pfm$/i), 'font-icon medium-red'],
    [new RegExp(/\.pe$/i), 'ff-icon medium-orange'],
    [new RegExp(/\.sfd$/i), 'ff-icon dark-blue'],
    [new RegExp(/\.f$/i), 'fortran-icon medium-maroon'],
    [new RegExp(/\.f90$/i), 'fortran-icon medium-green'],
    [new RegExp(/\.f03$/i), 'fortran-icon medium-red'],
    [new RegExp(/\.f08$/i), 'fortran-icon medium-blue'],
    [new RegExp(/\.f77$/i), 'fortran-icon medium-maroon'],
    [new RegExp(/\.f95$/i), 'fortran-icon dark-pink'],
    [new RegExp(/\.for$/i), 'fortran-icon dark-cyan'],
    [new RegExp(/\.fpp$/i), 'fortran-icon dark-yellow'],
    [new RegExp(/\.ftl$/i), 'freemarker-icon medium-blue'],
    [new RegExp(/\.fr$/i), 'frege-icon dark-red'],
    [new RegExp(/\.fs[xi]?$/i), 'fsharp-icon medium-blue'],
    [new RegExp(/\.gml$/i), 'gml-icon medium-green'],
    [new RegExp(/\.gms$/i), 'gams-icon dark-red'],
    [new RegExp(/\.gap$/i), 'gap-icon medium-yellow'],
    [new RegExp(/\.gi$/i), 'gap-icon dark-blue'],
    [new RegExp(/\.tst$/i), 'gap-icon medium-orange'],
    [new RegExp(/\.gdb$/i), 'gdb-icon medium-green'],
    [new RegExp(/gdbinit$/i), 'gdb-icon medium-cyan'],
    [new RegExp(/\.gd$/i), 'godot-icon medium-blue'],
    [new RegExp(/^\.htaccess$|\.yardopts$/i), 'gear-icon medium-red'],
    [new RegExp(/^\.htpasswd$/i), 'gear-icon medium-orange'],
    [new RegExp(/^\.env\.|\.pairs$/i), 'gear-icon dark-green'],
    [new RegExp(/^\.lesshintrc$/i), 'gear-icon dark-yellow'],
    [new RegExp(/^\.csscomb\.json$|\.csslintrc$|\.jsbeautifyrc$|\.jshintrc$|\.jscsrc$/i), 'gear-icon medium-yellow'],
    [new RegExp(/\.coffeelintignore$|\.codoopts$/i), 'gear-icon medium-maroon'],
    [new RegExp(/\.module$/i), 'gear-icon medium-blue'],
    [new RegExp(/\.arcconfig$|\.python-version$/i), 'gear-icon dark-blue'],
    [new RegExp(/\.lintstagedrc$/i), 'gear-icon dark-orange'],
    [new RegExp(/\.dll$/i), 'gears-icon dark-orange'],
    [new RegExp(/\.xml$|\.config$|\.4th$|\.cocci$|\.dyl$|\.dylan$|\.ecl$|\.forth$|\.launch$|\.manifest$|\.menu$|\.srdf$|\.st$|\.ui$|\.wsf$|\.x3d$|\.xaml$/i), 'code-icon medium-blue'],
    [new RegExp(/\.rdf$|\.capnp$|\.dotsettings$|\.flex$|\.fsh$|\.fsproj$|\.prw$|\.xproj$/i), 'code-icon dark-red'],
    [new RegExp(/^_service$/), 'code-icon medium-blue'],
    [new RegExp(/^configure\.ac$|\.ML$/), 'code-icon medium-red'],
    [new RegExp(/^Settings\.StyleCop$/), 'code-icon medium-green'],
    [new RegExp(/\.abnf$|\.ditaval$|\.storyboard$|\.xmi$|\.yacc$/i), 'code-icon medium-green'],
    [new RegExp(/\.aepx$|\.dita$|\.grace$|\.lid$|\.nproj$/i), 'code-icon medium-purple'],
    [new RegExp(/\.agda$|\.plist$|\.wisp$|\.xlf$|\.xslt$/i), 'code-icon dark-cyan'],
    [new RegExp(/\.appxmanifest$|\.befunge$|\.fun$|\.muf$|\.xul$/i), 'code-icon medium-orange'],
    [new RegExp(/\.ash$|\.asn1?$|\.lagda$|\.lex$|\.props$|\.resx$|\.smt2$|\.vsh$|\.xsl$|\.yy$/i), 'code-icon medium-cyan'],
    [new RegExp(/\.axml$|\.bmx$|\.brs$|\.ccxml$|\.clixml$|\.fth$|\.intr$|\.mdpolicy$|\.mtml$|\.myt$|\.xsd$/i), 'code-icon dark-blue'],
    [new RegExp(/\.bnf$|\.cbl$|\.cob$|\.cobol$|\.fxml$/i), 'code-icon medium-maroon'],
    [new RegExp(/\.ccp$|\.cpy$|\.mxml$/i), 'code-icon dark-maroon'],
    [new RegExp(/\.ch$|\.cw$|\.ebnf$|\.iml$|\.jflex$|\.m4$|\.mask$|\.mumps$|\.prg$|\.pt$|\.rl$|\.sml$|\.targets$|\.webidl$|\.wsdl$|\.xacro$|\.xliff$/i), 'code-icon medium-red'],
    [new RegExp(/\.ct$|\.zcml$/i), 'code-icon dark-pink'],
    [new RegExp(/\.cy$|\.eclxml$|\.ivy$|\.sed$|\.tml$|\.y$/i), 'code-icon dark-green'],
    [new RegExp(/\.ditamap$|\.frt$|\.lp$|\.omgrofl$|\.osm$|\.wxs$|\.xib$/i), 'code-icon dark-purple'],
    [new RegExp(/\.filters$|\.lol$|\.pig$/i), 'code-icon medium-pink'],
    [new RegExp(/\.grxml$|\.urdf$/i), 'code-icon dark-orange'],
    [new RegExp(/\.jelly$/i), 'code-icon medium-yellow'],
    [new RegExp(/\.jsproj$|\.ohm$|\.sgml?$/i), 'code-icon dark-yellow'],
    [new RegExp(/\.mq[45h]$/i), 'code-icon dark-blue'],
    [new RegExp(/\.odd$/i), 'code-icon light-green'],
    [new RegExp(/\.psc1$|\.smt$/i), 'code-icon light-blue'],
    [new RegExp(/\.scxml$/i), 'code-icon light-cyan'],
    [new RegExp(/\.sig$|\.wxl$/i), 'code-icon light-maroon'],
    [new RegExp(/\.ux$|\.wxi$/i), 'code-icon light-orange'],
    [new RegExp(/\.vxml$/i), 'code-icon light-purple'],
    [new RegExp(/\.kid$/i), 'genshi-icon medium-red'],
    [new RegExp(/\.ebuild$/i), 'gentoo-icon dark-cyan'],
    [new RegExp(/\.eclass$/i), 'gentoo-icon medium-blue'],
    [new RegExp(/^COMMIT_EDITMSG$/), 'git-commit-icon medium-red'],
    [new RegExp(/^MERGE_(?:HEAD|MODE|MSG)$/), 'git-merge-icon medium-red'],
    [new RegExp(/\.glade$/i), 'glade-icon medium-green'],
    [new RegExp(/\.glf$/i), 'pointwise-icon medium-blue'],
    [new RegExp(/\.glyphs$/i), 'glyphs-icon medium-green'],
    [new RegExp(/\.gn$/i), 'gn-icon dark-blue'],
    [new RegExp(/\.gni$/i), 'gn-icon medium-blue'],
    [new RegExp(/\.(?:gnu|gplv[23])$/i), 'gnu-icon medium-red'],
    [new RegExp(/\.(?:gp|plo?t|gnuplot)$/i), 'graph-icon medium-red'],
    [new RegExp(/\.go$/i), 'go-icon medium-blue'],
    [new RegExp(/\.golo$/i), 'golo-icon medium-orange'],
    [new RegExp(/\.gs$/i), 'gosu-icon medium-blue'],
    [new RegExp(/\.gst$/i), 'gosu-icon medium-green'],
    [new RegExp(/\.gsx$/i), 'gosu-icon dark-green'],
    [new RegExp(/\.vark$/i), 'gosu-icon dark-blue'],
    [new RegExp(/\.gradle$/i), 'gradle-icon medium-blue'],
    [new RegExp(/gradlew$/i), 'gradle-icon dark-purple'],
    [new RegExp(/\.gf$/i), 'gf-icon medium-red'],
    [new RegExp(/\.graphql$/i), 'graphql-icon medium-pink'],
    [new RegExp(/\.gql$/i), 'graphql-icon medium-purple'],
    [new RegExp(/\.gv$/i), 'graphviz-icon medium-blue'],
    [new RegExp(/\.dot$/i), 'graphviz-icon dark-cyan'],
    [new RegExp(/\.(?:groovy|grt|gtpl|gsp|gvy)$/i), 'groovy-icon light-blue'],
    [new RegExp(/\.hh$/i), 'hack-icon medium-orange'],
    [new RegExp(/\.haml$/i), 'haml-icon medium-yellow'],
    [new RegExp(/\.hamlc$/i), 'haml-icon medium-maroon'],
    [new RegExp(/\.hb$/i), 'harbour-icon dark-blue'],
    [new RegExp(/\.hcl$/i), 'hashicorp-icon dark-purple'],
    [new RegExp(/\.hs$/i), 'haskell-icon medium-purple'],
    [new RegExp(/\.hsc$/i), 'haskell-icon medium-blue'],
    [new RegExp(/\.c2hs$/i), 'haskell-icon dark-purple'],
    [new RegExp(/\.lhs$/i), 'haskell-icon dark-blue'],
    [new RegExp(/\.hx(?:[sm]l|)?$/), 'haxe-icon medium-orange'],
    [new RegExp(/^Procfile$/), 'heroku-icon medium-purple'],
    [new RegExp(/\.buildpacks$/i), 'heroku-icon light-purple'],
    [new RegExp(/^\.vendor_urls$/), 'heroku-icon dark-purple'],
    [new RegExp(/\.x?html?$/i), 'html5-icon medium-orange'],
    [new RegExp(/\.cshtml$|\.latte$/i), 'html5-icon medium-red'],
    [new RegExp(/\.ejs$|\.kit$|\.swig$/i), 'html5-icon medium-green'],
    [new RegExp(/\.gohtml$|\.phtml$/i), 'html5-icon dark-blue'],
    [new RegExp(/\.html\.eex$|\.jsp$/i), 'html5-icon medium-purple'],
    [new RegExp(/\.shtml$/i), 'html5-icon medium-cyan'],
    [new RegExp(/\.scaml$/i), 'html5-icon dark-red'],
    [new RegExp(/\.vash$/i), 'html5-icon medium-red'],
    [new RegExp(/\.dtml$/i), 'html5-icon medium-blue'],
    [new RegExp(/\.hy$/i), 'hy-icon dark-blue'],
    [new RegExp(/\.dlm$/i), 'idl-icon medium-blue'],
    [new RegExp(/\.idr$/i), 'idris-icon dark-red'],
    [new RegExp(/\.lidr$/i), 'idris-icon medium-maroon'],
    [new RegExp(/\.ipf$/i), 'igorpro-icon dark-red'],
    [new RegExp(/\.a?png$|\.svgz$/i), 'image-icon light-orange'],
    [new RegExp(/\.gif$|\.ora$|\.sgi$/i), 'image-icon medium-yellow'],
    [new RegExp(/\.jpe?g$/i), 'image-icon medium-green'],
    [new RegExp(/\.ico$/i), 'image-icon medium-blue'],
    [new RegExp(/\.webp$|\.iff$|\.lbm$|\.liff$|\.nrrd$|\.pcx$|\.vsdx?$/i), 'image-icon dark-blue'],
    [new RegExp(/\.bmp$/i), 'image-icon medium-red'],
    [new RegExp(/\.bpg$/i), 'image-icon medium-red'],
    [new RegExp(/\.cin$/i), 'image-icon medium-orange'],
    [new RegExp(/\.cd5$/i), 'image-icon dark-green'],
    [new RegExp(/\.cpc$/i), 'image-icon light-yellow'],
    [new RegExp(/\.cr2$/i), 'image-icon medium-orange'],
    [new RegExp(/\.dcm$|\.mpo$|\.pbm$/i), 'image-icon medium-pink'],
    [new RegExp(/\.dds$/i), 'image-icon dark-green'],
    [new RegExp(/\.djvu?$|\.pxr$/i), 'image-icon medium-purple'],
    [new RegExp(/\.dpx$|\.raw$/i), 'image-icon dark-orange'],
    [new RegExp(/\.ecw$|\.sct$/i), 'image-icon light-blue'],
    [new RegExp(/\.exr$/i), 'image-icon dark-yellow'],
    [new RegExp(/\.fits?$|\.fts$/i), 'image-icon medium-cyan'],
    [new RegExp(/\.flif$|\.hdp$|\.heic$|\.heif$|\.jxr$|\.wdp$/i), 'image-icon dark-red'],
    [new RegExp(/\.hdr$/i), 'image-icon medium-blue'],
    [new RegExp(/\.icns$/i), 'image-icon medium-pink'],
    [new RegExp(/\.(?:jp[f2xm]|j2c|mj2)$/i), 'image-icon dark-green'],
    [new RegExp(/\.jps$/i), 'image-icon dark-cyan'],
    [new RegExp(/\.mng$/i), 'image-icon medium-orange'],
    [new RegExp(/\.pgf$/i), 'image-icon light-red'],
    [new RegExp(/\.pict$/i), 'image-icon light-purple'],
    [new RegExp(/\.tga$/i), 'image-icon dark-orange'],
    [new RegExp(/\.tiff?$/i), 'image-icon medium-red'],
    [new RegExp(/\.wbm$/i), 'image-icon dark-maroon'],
    [new RegExp(/\.ni$/i), 'inform7-icon medium-blue'],
    [new RegExp(/\.i7x$/i), 'inform7-icon dark-blue'],
    [new RegExp(/\.iss$/i), 'inno-icon dark-blue'],
    [new RegExp(/\.io$/i), 'io-icon dark-purple'],
    [new RegExp(/\.ik$/i), 'ioke-icon medium-red'],
    [new RegExp(/\.thy$/i), 'isabelle-icon dark-red'],
    [new RegExp(/^ROOT$/), 'isabelle-icon dark-blue'],
    [new RegExp(/\.ijs$/i), 'j-icon light-blue'],
    [new RegExp(/\.jade$/i), 'jade-icon medium-red'],
    [new RegExp(/^Jakefile$/), 'jake-icon medium-maroon'],
    [new RegExp(/\.jake$/i), 'jake-icon medium-yellow'],
    [new RegExp(/\.java$/i), 'java-icon medium-purple'],
    [new RegExp(/\.js$|\.es6$|\.es$/i), 'js-icon medium-yellow'],
    [new RegExp(/\._js$/i), 'js-icon medium-orange'],
    [new RegExp(/\.jsb$|\.dust$/i), 'js-icon medium-maroon'],
    [new RegExp(/\.jsm$|\.mjs$|\.xsjslib$/i), 'js-icon medium-blue'],
    [new RegExp(/\.jss$/i), 'js-icon medium-green'],
    [new RegExp(/\.sjs$/i), 'js-icon medium-pink'],
    [new RegExp(/\.ssjs$/i), 'js-icon medium-red'],
    [new RegExp(/\.xsjs$/i), 'js-icon medium-purple'],
    [new RegExp(/^Jenkinsfile$/), 'jenkins-icon medium-red'],
    [new RegExp(/\.jinja$/i), 'jinja-icon dark-red'],
    [new RegExp(/\.jinja2$/i), 'jinja-icon medium-red'],
    [new RegExp(/\.jsonld$/i), 'jsonld-icon medium-blue'],
    [new RegExp(/\.jq$/i), 'sql-icon medium-blue'],
    [new RegExp(/\.jsx$/i), 'jsx-icon medium-blue'],
    [new RegExp(/\.jl$/i), 'julia-icon medium-purple'],
    [new RegExp(/\.ipynb$/i), 'jupyter-icon dark-orange'],
    [new RegExp(/^Notebook$/), 'jupyter-icon dark-cyan'],
    [new RegExp(/\.keynote$/i), 'keynote-icon medium-blue'],
    [new RegExp(/\.knt$/i), 'keynote-icon dark-blue'],
    [new RegExp(/\.kv$/i), 'kivy-icon dark-maroon'],
    [new RegExp(/\.kml$/i), 'earth-icon medium-green'],
    [new RegExp(/\.kt$/i), 'kotlin-icon dark-blue'],
    [new RegExp(/\.ktm$/i), 'kotlin-icon medium-blue'],
    [new RegExp(/\.kts$/i), 'kotlin-icon medium-orange'],
    [new RegExp(/\.krl$/i), 'krl-icon medium-blue'],
    [new RegExp(/\.lvproj$/i), 'labview-icon dark-blue'],
    [new RegExp(/\.blade\.php$/i), 'laravel-icon medium-orange'],
    [new RegExp(/\.lasso$|\.las$/i), 'lasso-icon dark-blue'],
    [new RegExp(/\.lasso8$/i), 'lasso-icon medium-blue'],
    [new RegExp(/\.lasso9$/i), 'lasso-icon medium-purple'],
    [new RegExp(/\.ldml$/i), 'lasso-icon medium-red'],
    [new RegExp(/\.lean$/i), 'lean-icon dark-purple'],
    [new RegExp(/\.hlean$/i), 'lean-icon dark-red'],
    [new RegExp(/\.lfe$/i), 'lfe-icon dark-red'],
    [new RegExp(/\.lwo$/i), 'lightwave-icon medium-red'],
    [new RegExp(/\.lws$/i), 'lightwave-icon medium-blue'],
    [new RegExp(/\.lsp$/i), 'lisp-icon medium-red'],
    [new RegExp(/\.lisp$/i), 'lisp-icon dark-red'],
    [new RegExp(/\.l$|\.nl$/i), 'lisp-icon medium-maroon'],
    [new RegExp(/\.ny$|\.sexp$/i), 'lisp-icon medium-blue'],
    [new RegExp(/\.podsl$/i), 'lisp-icon medium-purple'],
    [new RegExp(/\.ls$/i), 'ls-icon medium-blue'],
    [new RegExp(/\._ls$/i), 'ls-icon dark-blue'],
    [new RegExp(/^Slakefile$/), 'ls-icon medium-green'],
    [new RegExp(/\.ll$/i), 'llvm-icon dark-green'],
    [new RegExp(/\.clang-format$/i), 'llvm-icon medium-yellow'],
    [new RegExp(/\.xm$/i), 'mobile-icon dark-blue'],
    [new RegExp(/\.xi$/i), 'mobile-icon dark-red'],
    [new RegExp(/\.(?:logtalk|lgt)$/i), 'logtalk-icon medium-red'],
    [new RegExp(/\.lookml$/i), 'lookml-icon medium-purple'],
    [new RegExp(/\.lsl$/i), 'lsl-icon medium-cyan'],
    [new RegExp(/\.lslp$/i), 'lsl-icon dark-cyan'],
    [new RegExp(/\.lua$/i), 'lua-icon medium-blue'],
    [new RegExp(/\.pd_lua$/i), 'lua-icon dark-blue'],
    [new RegExp(/\.rbxs$/i), 'lua-icon dark-purple'],
    [new RegExp(/\.wlua$/i), 'lua-icon dark-red'],
    [new RegExp(/^Makefile|^makefile$/), 'checklist-icon medium-yellow'],
    [new RegExp(/\.(?:mk|mak|make)$|^mkfile$/i), 'checklist-icon medium-yellow'],
    [new RegExp(/^BSDmakefile$|\.am$/i), 'checklist-icon medium-red'],
    [new RegExp(/^GNUmakefile$/i), 'checklist-icon medium-green'],
    [new RegExp(/^Kbuild$/), 'checklist-icon medium-blue'],
    [new RegExp(/\.bb$/i), 'checklist-icon dark-blue'],
    [new RegExp(/^DEPS$/), 'checklist-icon dark-blue'],
    [new RegExp(/\.mms$/i), 'checklist-icon medium-blue'],
    [new RegExp(/\.mmk$/i), 'checklist-icon light-blue'],
    [new RegExp(/\.pri$/i), 'checklist-icon dark-purple'],
    [new RegExp(/\.mak?o$/i), 'mako-icon dark-blue'],
    [new RegExp(/\.(?:1(?:[bcmsx]|has|in)?|[24568]|3(?:avl|bsm|3c|in|m|qt|x)?|7(?:d|fs|i|ipp|m|p)?|9[efps]?|chem|eqn|groff|man|mandoc|mdoc|me|mom|n|nroff|pic|tmac|tmac-u|tr|troff)$/i), 'manpage-icon dark-green'],
    [new RegExp(/\.(?:rnh|rno|roff|run|runoff)$/i), 'manpage-icon dark-maroon'],
    [new RegExp(/\.mss$/i), 'mapbox-icon medium-cyan'],
    [new RegExp(/\.(?:md|mdown|markdown|mkd|mkdown|mkdn|rmd|ron)$/i), 'markdown-icon'],
    [new RegExp(/\.mathematica$|\.nbp$/i), 'mathematica-icon dark-red'],
    [new RegExp(/\.cdf$/i), 'mathematica-icon medium-red'],
    [new RegExp(/\.ma$/i), 'mathematica-icon medium-orange'],
    [new RegExp(/\.mt$/i), 'mathematica-icon medium-maroon'],
    [new RegExp(/\.nb$/i), 'mathematica-icon dark-orange'],
    [new RegExp(/\.wl$/i), 'mathematica-icon medium-yellow'],
    [new RegExp(/\.wlt$/i), 'mathematica-icon dark-yellow'],
    [new RegExp(/\.matlab$/i), 'matlab-icon medium-yellow'],
    [new RegExp(/\.maxpat$/i), 'max-icon dark-purple'],
    [new RegExp(/\.maxhelp$/i), 'max-icon medium-red'],
    [new RegExp(/\.maxproj$/i), 'max-icon medium-blue'],
    [new RegExp(/\.mxt$/i), 'max-icon medium-purple'],
    [new RegExp(/\.pat$/i), 'max-icon medium-green'],
    [new RegExp(/\.ms$/i), 'maxscript-icon dark-blue'],
    [new RegExp(/\.mcr$/i), 'maxscript-icon dark-purple'],
    [new RegExp(/\.mce$/i), 'maxscript-icon medium-red'],
    [new RegExp(/\.max$/i), 'maxscript-icon dark-cyan'],
    [new RegExp(/\.3ds$/i), 'maxscript-icon medium-cyan'],
    [new RegExp(/\.mb$/i), 'maya-icon dark-cyan'],
    [new RegExp(/\.mel$/i), 'maya-icon dark-blue'],
    [new RegExp(/\.mcf[ip]$/i), 'maya-icon dark-purple'],
    [new RegExp(/\.mediawiki$/i), 'mediawiki-icon medium-yellow'],
    [new RegExp(/\.wiki$/i), 'mediawiki-icon medium-orange'],
    [new RegExp(/^\.mention-bot$/i), 'bullhorn-icon medium-orange'],
    [new RegExp(/\.moo$/i), 'mercury-icon medium-cyan'],
    [new RegExp(/\.metal$/i), 'metal-icon dark-cyan'],
    [new RegExp(/\.accda$/i), 'access-icon dark-maroon'],
    [new RegExp(/\.accdb$/i), 'access-icon medium-maroon'],
    [new RegExp(/\.accde$/i), 'access-icon medium-green'],
    [new RegExp(/\.accdr$/i), 'access-icon medium-red'],
    [new RegExp(/\.accdt$/i), 'access-icon dark-red'],
    [new RegExp(/\.adn$|\.laccdb$/i), 'access-icon light-maroon'],
    [new RegExp(/\.mdw$/i), 'access-icon dark-purple'],
    [new RegExp(/\.xls$/i), 'excel-icon dark-orange'],
    [new RegExp(/\.xlsx$/i), 'excel-icon dark-green'],
    [new RegExp(/\.xlsm$/i), 'excel-icon medium-green'],
    [new RegExp(/\.xlsb$/i), 'excel-icon medium-red'],
    [new RegExp(/\.xlt$/i), 'excel-icon dark-cyan'],
    [new RegExp(/\.one$/i), 'onenote-icon dark-purple'],
    [new RegExp(/\.pps$/i), 'powerpoint-icon dark-red'],
    [new RegExp(/\.ppsx$/i), 'powerpoint-icon medium-orange'],
    [new RegExp(/\.ppt$/i), 'powerpoint-icon dark-orange'],
    [new RegExp(/\.pptx$/i), 'powerpoint-icon medium-red'],
    [new RegExp(/\.potm$/i), 'powerpoint-icon medium-maroon'],
    [new RegExp(/\.mpp$/i), 'powerpoint-icon dark-green'],
    [new RegExp(/\.doc$/i), 'word-icon medium-blue'],
    [new RegExp(/\.docx$/i), 'word-icon dark-blue'],
    [new RegExp(/\.docm$/i), 'word-icon medium-maroon'],
    [new RegExp(/\.docxml$/i), 'word-icon dark-cyan'],
    [new RegExp(/\.dotm$/i), 'word-icon dark-maroon'],
    [new RegExp(/\.dotx$/i), 'word-icon medium-cyan'],
    [new RegExp(/\.wri$/i), 'word-icon medium-orange'],
    [new RegExp(/^mcmod\.info$/i), 'minecraft-icon dark-green'],
    [new RegExp(/\.dr?uby$/g), 'mirah-icon medium-blue'],
    [new RegExp(/\.mir(?:ah)?$/g), 'mirah-icon light-blue'],
    [new RegExp(/\.obj$/i), 'model-icon medium-red'],
    [new RegExp(/\.mtl$/i), 'model-icon dark-blue'],
    [new RegExp(/\.stl$/i), 'model-icon dark-green'],
    [new RegExp(/\.u3d$/i), 'model-icon medium-orange'],
    [new RegExp(/\.mo$/i), 'circle-icon light-red'],
    [new RegExp(/\.mod$/i), 'modula2-icon medium-blue'],
    [new RegExp(/\.def$/i), 'modula2-icon medium-green'],
    [new RegExp(/\.m2$/i), 'modula2-icon medium-red'],
    [new RegExp(/\.monkey$/i), 'monkey-icon medium-maroon'],
    [new RegExp(/\.moon$/i), 'moon-icon medium-yellow'],
    [new RegExp(/\.mrb$/i), 'mruby-icon medium-red'],
    [new RegExp(/\.dsql$/i), 'msql-icon medium-purple'],
    [new RegExp(/\.mu$/i), 'mupad-icon medium-red'],
    [new RegExp(/\.chord$/i), 'music-icon medium-orange'],
    [new RegExp(/\.midi?$/i), 'music-icon dark-blue'],
    [new RegExp(/\.ly$/i), 'music-icon medium-green'],
    [new RegExp(/\.ily$/i), 'music-icon dark-green'],
    [new RegExp(/\.pd$/i), 'music-icon dark-red'],
    [new RegExp(/\.(?:hbs|handlebars|mustache)$/i), 'mustache-icon medium-orange'],
    [new RegExp(/\.build$/i), 'nant-icon medium-orange'],
    [new RegExp(/\.ncl$/i), 'earth-icon medium-green'],
    [new RegExp(/\.neko$/i), 'neko-icon medium-orange'],
    [new RegExp(/\.axs$/i), 'amx-icon medium-blue'],
    [new RegExp(/\.axi$/i), 'amx-icon dark-blue'],
    [new RegExp(/\.nlogo$/i), 'netlogo-icon medium-red'],
    [new RegExp(/\.nginxconf$/i), 'nginx-icon medium-green'],
    [new RegExp(/\.nib$/i), 'nib-icon dark-orange'],
    [new RegExp(/\.nim(?:rod)?$/i), 'nimrod-icon medium-green'],
    [new RegExp(/\.ninja$/i), 'shuriken-icon medium-blue'],
    [new RegExp(/\.nit$/i), 'nit-icon dark-green'],
    [new RegExp(/\.nix$/i), 'nix-icon medium-cyan'],
    [new RegExp(/\.nse$/i), 'nmap-icon dark-blue'],
    [new RegExp(/\.njs$|\.nvmrc$/i), 'node-icon medium-green'],
    [new RegExp(/\.node-version$/i), 'node-icon dark-green'],
    [new RegExp(/\.nsi$/i), 'nsis-icon medium-purple'],
    [new RegExp(/\.nsh$/i), 'nsis-icon dark-cyan'],
    [new RegExp(/\.nu$/i), 'recycle-icon light-green'],
    [new RegExp(/^Nukefile$/), 'recycle-icon dark-green'],
    [new RegExp(/\.nuspec$/i), 'nuget-icon medium-blue'],
    [new RegExp(/\.pkgproj$/i), 'nuget-icon dark-purple'],
    [new RegExp(/\.numpy$/i), 'numpy-icon dark-blue'],
    [new RegExp(/\.numpyw$/i), 'numpy-icon medium-blue'],
    [new RegExp(/\.numsc$/i), 'numpy-icon medium-orange'],
    [new RegExp(/\.(?:nunjucks|njk)$/i), 'nunjucks-icon dark-green'],
    [new RegExp(/\.mm?$/i), 'objc-icon medium-blue'],
    [new RegExp(/\.pch$/i), 'objc-icon dark-red'],
    [new RegExp(/\.x$/i), 'objc-icon dark-green'],
    [new RegExp(/\.j$/i), 'objj-icon dark-orange'],
    [new RegExp(/\.sj$/i), 'objj-icon dark-red'],
    [new RegExp(/\.ml$/i), 'ocaml-icon medium-orange'],
    [new RegExp(/\.mli$/i), 'ocaml-icon dark-orange'],
    [new RegExp(/\.eliom$/i), 'ocaml-icon medium-red'],
    [new RegExp(/\.eliomi$/i), 'ocaml-icon dark-red'],
    [new RegExp(/\.ml4$/i), 'ocaml-icon medium-green'],
    [new RegExp(/\.mll$/i), 'ocaml-icon dark-green'],
    [new RegExp(/\.mly$/i), 'ocaml-icon dark-yellow'],
    [new RegExp(/\.ooc$/i), 'ooc-icon medium-green'],
    [new RegExp(/\.opa$/i), 'opa-icon medium-blue'],
    [new RegExp(/\.opencl$/i), 'opencl-icon medium-red'],
    [new RegExp(/\.p$/i), 'progress-icon medium-red'],
    [new RegExp(/\.odt$/i), 'openoffice-icon medium-blue'],
    [new RegExp(/\.ott$/i), 'openoffice-icon dark-blue'],
    [new RegExp(/\.fodt$/i), 'openoffice-icon dark-purple'],
    [new RegExp(/\.ods$/i), 'openoffice-icon medium-green'],
    [new RegExp(/\.ots$/i), 'openoffice-icon dark-green'],
    [new RegExp(/\.fods$/i), 'openoffice-icon dark-cyan'],
    [new RegExp(/\.odp$/i), 'openoffice-icon medium-purple'],
    [new RegExp(/\.otp$/i), 'openoffice-icon dark-pink'],
    [new RegExp(/\.fodp$/i), 'openoffice-icon medium-pink'],
    [new RegExp(/\.odg$/i), 'openoffice-icon medium-red'],
    [new RegExp(/\.otg$/i), 'openoffice-icon dark-red'],
    [new RegExp(/\.fodg$/i), 'openoffice-icon dark-orange'],
    [new RegExp(/\.odf$/i), 'openoffice-icon medium-maroon'],
    [new RegExp(/\.odb$/i), 'openoffice-icon light-pink'],
    [new RegExp(/\.scad$/i), 'scad-icon medium-orange'],
    [new RegExp(/\.jscad$/i), 'scad-icon medium-yellow'],
    [new RegExp(/\.org$/i), 'org-icon dark-green'],
    [new RegExp(/\.dmg$/i), 'osx-icon medium-red'],
    [new RegExp(/\.ox$/i), 'ox-icon medium-cyan'],
    [new RegExp(/\.oxh$/i), 'ox-icon medium-green'],
    [new RegExp(/\.oxo$/i), 'ox-icon medium-blue'],
    [new RegExp(/\.oxygene$/i), 'oxygene-icon medium-cyan'],
    [new RegExp(/\.oz$/i), 'oz-icon medium-yellow'],
    [new RegExp(/\.pan$/i), 'pan-icon medium-red'],
    [new RegExp(/\.psc$/i), 'papyrus-icon medium-green'],
    [new RegExp(/\.parrot$/i), 'parrot-icon medium-green'],
    [new RegExp(/\.pasm$/i), 'parrot-icon dark-green'],
    [new RegExp(/\.pir$/i), 'parrot-icon dark-blue'],
    [new RegExp(/\.pas(?:cal)?$/i), 'pascal-icon medium-purple'],
    [new RegExp(/\.dfm$/i), 'pascal-icon medium-blue'],
    [new RegExp(/\.dpr$/i), 'pascal-icon dark-blue'],
    [new RegExp(/\.lpr$/i), 'pascal-icon dark-purple'],
    [new RegExp(/\.patch$/i), 'patch-icon medium-green'],
    [new RegExp(/\.pwn$/i), 'pawn-icon medium-orange'],
    [new RegExp(/\.pdf$/i), 'pdf-icon medium-red'],
    [new RegExp(/\.p(?:er)?l$|\.t$/i), 'perl-icon medium-blue'],
    [new RegExp(/\.ph$/i), 'perl-icon dark-purple'],
    [new RegExp(/\.plx$/i), 'perl-icon medium-purple'],
    [new RegExp(/\.pm$/i), 'perl-icon dark-blue'],
    [new RegExp(/\.(?:psgi|xs)$/i), 'perl-icon medium-red'],
    [new RegExp(/\.pl6$/i), 'perl6-icon medium-purple'],
    [new RegExp(/\.[tp]6$|\.6pl$/i), 'perl6-icon light-blue'],
    [new RegExp(/\.(?:pm6|p6m)$/i), 'perl6-icon dark-pink'],
    [new RegExp(/\.6pm$/i), 'perl6-icon dark-cyan'],
    [new RegExp(/\.nqp$/i), 'perl6-icon dark-purple'],
    [new RegExp(/\.p6l$/i), 'perl6-icon medium-blue'],
    [new RegExp(/\.pod6$/i), 'perl6-icon dark-green'],
    [new RegExp(/^Rexfile$/), 'perl6-icon medium-green'],
    [new RegExp(/\.volt$/i), 'phalcon-icon medium-cyan'],
    [new RegExp(/\.php(?:[st\d]|_cs)?$/i), 'php-icon dark-blue'],
    [new RegExp(/^Phakefile/), 'php-icon dark-green'],
    [new RegExp(/\.pkl$/i), 'pickle-icon dark-cyan'],
    [new RegExp(/\.pike$/i), 'pike-icon dark-cyan'],
    [new RegExp(/\.pmod$/i), 'pike-icon medium-blue'],
    [new RegExp(/\.(?:pls|pck|pks|plb|plsql|pkb)$/i), 'sql-icon medium-red'],
    [new RegExp(/\.pod$/i), 'pod-icon dark-blue'],
    [new RegExp(/\.pogo$/i), 'pogo-icon medium-orange'],
    [new RegExp(/\.pony$/i), 'pony-icon light-maroon'],
    [new RegExp(/\.p(?:ost)?css$/i), 'postcss-icon dark-red'],
    [new RegExp(/\.sss$/i), 'postcss-icon dark-pink'],
    [new RegExp(/\.postcssrc$/i), 'postcss-icon medium-orange'],
    [new RegExp(/\.ps$/i), 'postscript-icon medium-red'],
    [new RegExp(/\.eps$/i), 'postscript-icon medium-orange'],
    [new RegExp(/\.pfa$/i), 'postscript-icon dark-blue'],
    [new RegExp(/\.afm$/i), 'postscript-icon medium-green'],
    [new RegExp(/\.pov$/i), 'povray-icon dark-blue'],
    [new RegExp(/\.pbl$|\.sra$/i), 'powerbuilder-icon medium-blue'],
    [new RegExp(/\.pbt$/i), 'powerbuilder-icon dark-blue'],
    [new RegExp(/\.srw$/i), 'powerbuilder-icon medium-red'],
    [new RegExp(/\.sru$/i), 'powerbuilder-icon medium-orange'],
    [new RegExp(/\.srp$/i), 'powerbuilder-icon medium-maroon'],
    [new RegExp(/\.srj$/i), 'powerbuilder-icon medium-purple'],
    [new RegExp(/\.ps1$/i), 'powershell-icon medium-blue'],
    [new RegExp(/\.psd1$/i), 'powershell-icon dark-blue'],
    [new RegExp(/\.psm1$/i), 'powershell-icon medium-purple'],
    [new RegExp(/\.ps1xml$/i), 'powershell-icon dark-purple'],
    [new RegExp(/\.ppd$/i), 'print-icon dark-cyan'],
    [new RegExp(/\.pde$/i), 'processing-icon dark-blue'],
    [new RegExp(/\.pro$/i), 'prolog-icon medium-blue'],
    [new RegExp(/\.prolog$/i), 'prolog-icon medium-cyan'],
    [new RegExp(/\.yap$/i), 'prolog-icon medium-purple'],
    [new RegExp(/\.spin$/i), 'propeller-icon medium-orange'],
    [new RegExp(/\.pug$/i), 'pug-icon medium-red'],
    [new RegExp(/\.pp$/i), 'puppet-icon medium-purple'],
    [new RegExp(/Modulefile$/i), 'puppet-icon dark-blue'],
    [new RegExp(/\.pb$/i), 'purebasic-icon medium-red'],
    [new RegExp(/\.pbi$/i), 'purebasic-icon dark-orange'],
    [new RegExp(/\.purs$/i), 'purescript-icon dark-purple'],
    [new RegExp(/\.py$|\.bzl$|\.py3$|\.?(?:pypirc|pythonrc|python-venv)$/i), 'python-icon dark-blue'],
    [new RegExp(/\.ipy$/i), 'python-icon medium-blue'],
    [new RegExp(/\.isolate$|\.gypi$|\.pyt$/i), 'python-icon dark-green'],
    [new RegExp(/\.pep$|\.pyde$/i), 'python-icon medium-orange'],
    [new RegExp(/\.gyp$/i), 'python-icon medium-green'],
    [new RegExp(/\.pyp$/i), 'python-icon dark-purple'],
    [new RegExp(/\.pyw$/i), 'python-icon medium-maroon'],
    [new RegExp(/\.tac$/i), 'python-icon dark-pink'],
    [new RegExp(/\.wsgi$/i), 'python-icon dark-red'],
    [new RegExp(/\.xpy$/i), 'python-icon medium-yellow'],
    [new RegExp(/\.rpy$/i), 'python-icon medium-pink'],
    [new RegExp(/^(?:BUCK|BUILD|SConstruct|SConscript)$/), 'python-icon dark-green'],
    [new RegExp(/^(?:Snakefile|WATCHLISTS)$/), 'python-icon medium-green'],
    [new RegExp(/^wscript$/), 'python-icon dark-maroon'],
    [new RegExp(/\.(?:r|Rprofile|rsx|rd)$/i), 'r-icon medium-blue'],
    [new RegExp(/\.rkt$/i), 'racket-icon medium-red'],
    [new RegExp(/\.rktd$/i), 'racket-icon medium-blue'],
    [new RegExp(/\.rktl$/i), 'racket-icon light-red'],
    [new RegExp(/\.scrbl$/i), 'racket-icon dark-blue'],
    [new RegExp(/\.raml$/i), 'raml-icon medium-cyan'],
    [new RegExp(/\.rsc$/i), 'rascal-icon medium-yellow'],
    [new RegExp(/\.rdoc$/i), 'rdoc-icon medium-red'],
    [new RegExp(/\.rbbas$/i), 'xojo-icon medium-green'],
    [new RegExp(/\.rbfrm$/i), 'xojo-icon dark-green'],
    [new RegExp(/\.rbmnu$/i), 'xojo-icon dark-cyan'],
    [new RegExp(/\.rbres$/i), 'xojo-icon medium-cyan'],
    [new RegExp(/\.rbtbar$/i), 'xojo-icon medium-blue'],
    [new RegExp(/\.rbuistate$/i), 'xojo-icon dark-blue'],
    [new RegExp(/\.re$/i), 'reason-icon medium-red'],
    [new RegExp(/\.rei$/i), 'reason-icon medium-orange'],
    [new RegExp(/\.reb(?:ol)?$/i), 'rebol-icon dark-green'],
    [new RegExp(/\.r2$/i), 'rebol-icon dark-red'],
    [new RegExp(/\.r3$/i), 'rebol-icon dark-blue'],
    [new RegExp(/\.red$/i), 'red-icon medium-red'],
    [new RegExp(/\.reds$/i), 'red-icon light-red'],
    [new RegExp(/\.rpm$/i), 'red-hat-icon medium-red'],
    [new RegExp(/\.spec$/i), 'red-hat-icon dark-red'],
    [new RegExp(/\.regexp?$/i), 'regex-icon medium-green'],
    [new RegExp(/\.rsh$/i), 'android-icon dark-maroon'],
    [new RegExp(/\.re?st(?:\.txt)?$/i), 'rst-icon dark-blue'],
    [new RegExp(/\.rexx?$/i), 'rexx-icon medium-red'],
    [new RegExp(/\.pprx$/i), 'rexx-icon medium-blue'],
    [new RegExp(/\.tag$/i), 'riot-icon medium-red'],
    [new RegExp(/\.robot$/i), 'robot-icon medium-purple'],
    [new RegExp(/\.rg$/i), 'clojure-icon medium-red'],
    [new RegExp(/\.rss$/i), 'rss-icon medium-orange'],
    [new RegExp(/\.(?:rb|ru|ruby|erb|gemspec|god|mspec|pluginspec|podspec|rabl|rake|opal)$|^\.?(?:irbrc|gemrc|pryrc|rspec|ruby-(?:gemset|version))$/i), 'ruby-icon medium-red'],
    [new RegExp(/^(?:Appraisals|(?:Rake|Gem|[bB]uild|Berks|Cap|Danger|Deliver|Fast|Guard|Jar|Maven|Pod|Puppet|Snap)file(?:\.lock)?)$|^rails$/), 'ruby-icon medium-red'],
    [new RegExp(/\.(?:jbuilder|rbuild|rb[wx]|builder)$/i), 'ruby-icon dark-red'],
    [new RegExp(/\.watchr$/i), 'ruby-icon dark-yellow'],
    [new RegExp(/\.rs$/i), 'rust-icon medium-maroon'],
    [new RegExp(/\.rlib$/i), 'rust-icon light-maroon'],
    [new RegExp(/\.sage$/i), 'sage-icon medium-blue'],
    [new RegExp(/\.sagews$/i), 'sage-icon dark-blue'],
    [new RegExp(/\.sls$/i), 'saltstack-icon medium-blue'],
    [new RegExp(/\.sas$/i), 'sas-icon medium-blue'],
    [new RegExp(/\.scss$/i), 'sass-icon light-pink'],
    [new RegExp(/\.sass$/i), 'sass-icon dark-pink'],
    [new RegExp(/\.sbt$/i), 'sbt-icon dark-purple'],
    [new RegExp(/\.(?:sc|scala)$/i), 'scala-icon medium-red'],
    [new RegExp(/\.scm$/i), 'scheme-icon medium-red'],
    [new RegExp(/\.sld$/i), 'scheme-icon medium-blue'],
    [new RegExp(/\.sps$/i), 'scheme-icon medium-purple'],
    [new RegExp(/\.sci$/i), 'scilab-icon dark-purple'],
    [new RegExp(/\.sce$/i), 'scilab-icon dark-blue'],
    [new RegExp(/\.tst$/i), 'scilab-icon dark-cyan'],
    [new RegExp(/\.secret$/i), 'secret-icon null'],
    [new RegExp(/\.self$/i), 'self-icon dark-blue'],
    [new RegExp(/\.csv$/i), 'graph-icon light-red'],
    [new RegExp(/\.(?:tab|tsv)$/i), 'graph-icon light-green'],
    [new RegExp(/\.dif$/i), 'graph-icon medium-green'],
    [new RegExp(/\.slk$/i), 'graph-icon medium-cyan'],
    [new RegExp(/\.sfproj$/i), 'sf-icon light-orange'],
    [new RegExp(/\.(?:sh|rc|bats|bash|tool|install|command)$/i), 'terminal-icon medium-purple'],
    [new RegExp(/^(?:\.?bash(?:rc|[-_]?(?:profile|login|logout|history|prompt))|_osc|config|install-sh|PKGBUILD)$/i), 'terminal-icon dark-purple'],
    [new RegExp(/\.ksh$/i), 'terminal-icon dark-yellow'],
    [new RegExp(/\.sh-session$/i), 'terminal-icon medium-yellow'],
    [new RegExp(/\.zsh(?:-theme|_history)?$|^\.?(?:antigen|zpreztorc|zlogin|zlogout|zprofile|zshenv|zshrc)$|\.tmux$/i), 'terminal-icon medium-blue'],
    [new RegExp(/\.fish$|^\.fishrc$|\.tcsh$/i), 'terminal-icon medium-green'],
    [new RegExp(/\.inputrc$/i), 'terminal-icon medium-red'],
    [new RegExp(/^(?:configure|config\.(?:guess|rpath|status|sub)|depcomp|libtool|compile)$/), 'terminal-icon medium-red'],
    [new RegExp(/^\/(?:private\/)?etc\/(?:[^\/]+\/)*(?:profile$|nanorc$|rc\.|csh\.)/i), 'terminal-icon dark-purple'],
    [new RegExp(/\.csh$/i), 'terminal-icon medium-yellow'],
    [new RegExp(/\.shen$/i), 'shen-icon dark-cyan'],
    [new RegExp(/\.liquid$/i), 'shopify-icon medium-green'],
    [new RegExp(/\.sigils$/i), 'sigils-icon dark-red'],
    [new RegExp(/\.ss$/i), 'silverstripe-icon medium-blue'],
    [new RegExp(/\.sketch$/i), 'sketch-icon medium-orange'],
    [new RegExp(/\.sl$/i), 'slash-icon dark-blue'],
    [new RegExp(/\.smali$/i), 'android-icon medium-green'],
    [new RegExp(/\.tpl$/i), 'smarty-icon medium-yellow'],
    [new RegExp(/\.snyk$/i), 'snyk-icon dark-purple'],
    [new RegExp(/\.(?:sma|sp)$/i), 'clojure-icon medium-yellow'],
    [new RegExp(/\.sparql$/i), 'sparql-icon medium-blue'],
    [new RegExp(/\.rq$/i), 'sparql-icon dark-blue'],
    [new RegExp(/\.sqf$/i), 'sqf-icon dark-maroon'],
    [new RegExp(/\.hqf$/i), 'sqf-icon dark-red'],
    [new RegExp(/\.(?:my)?sql$/i), 'sql-icon medium-orange'],
    [new RegExp(/\.ddl$/i), 'sql-icon medium-blue'],
    [new RegExp(/\.udf$/i), 'sql-icon medium-green'],
    [new RegExp(/\.viw$/i), 'sql-icon dark-cyan'],
    [new RegExp(/\.prc$/i), 'sql-icon dark-blue'],
    [new RegExp(/\.db2$/i), 'sql-icon medium-purple'],
    [new RegExp(/\.sqlite$/i), 'sqlite-icon medium-blue'],
    [new RegExp(/\.sqlite3$/i), 'sqlite-icon dark-blue'],
    [new RegExp(/\.db$/i), 'sqlite-icon medium-purple'],
    [new RegExp(/\.db3$/i), 'sqlite-icon dark-purple'],
    [new RegExp(/\.nut$/i), 'squirrel-icon medium-maroon'],
    [new RegExp(/\.pub$/i), 'key-icon medium-yellow'],
    [new RegExp(/\.pem$/i), 'key-icon medium-orange'],
    [new RegExp(/\.key$|\.crt$/i), 'key-icon medium-blue'],
    [new RegExp(/\.der$/i), 'key-icon medium-purple'],
    [new RegExp(/^id_rsa/), 'key-icon medium-red'],
    [new RegExp(/\.glyphs\d*License$|^git-credential-osxkeychain$/i), 'key-icon medium-green'],
    [new RegExp(/^(?:master\.)?passwd$/i), 'key-icon dark-green'],
    [new RegExp(/\.stan$/i), 'stan-icon medium-red'],
    [new RegExp(/\.do$/i), 'stata-icon medium-blue'],
    [new RegExp(/\.ado$/i), 'stata-icon dark-blue'],
    [new RegExp(/\.doh$/i), 'stata-icon light-blue'],
    [new RegExp(/\.ihlp$/i), 'stata-icon medium-cyan'],
    [new RegExp(/\.mata$/i), 'stata-icon dark-cyan'],
    [new RegExp(/\.matah$/i), 'stata-icon light-cyan'],
    [new RegExp(/\.sthlp$/i), 'stata-icon medium-purple'],
    [new RegExp(/\.story$/i), 'storyist-icon medium-blue'],
    [new RegExp(/\.strings$/i), 'strings-icon medium-red'],
    [new RegExp(/\.styl$/i), 'stylus-icon medium-green'],
    [new RegExp(/\.(?:stTheme|sublime[-_](?:build|commands|completions|keymap|macro|menu|mousemap|project|settings|theme|workspace|metrics|session|snippet))$/i), 'sublime-icon medium-orange'],
    [new RegExp(/\.sublime-syntax$/i), 'sublime-icon dark-orange'],
    [new RegExp(/\.scd$/i), 'scd-icon medium-red'],
    [new RegExp(/\.svg$/i), 'svg-icon dark-yellow'],
    [new RegExp(/\.swift$/i), 'swift-icon medium-green'],
    [new RegExp(/\.sv$/i), 'sysverilog-icon medium-blue'],
    [new RegExp(/\.svh$/i), 'sysverilog-icon medium-green'],
    [new RegExp(/\.vh$/i), 'sysverilog-icon medium-cyan'],
    [new RegExp(/\.?c?tags$/i), 'tag-icon medium-blue'],
    [new RegExp(/\.gemtags/i), 'tag-icon medium-red'],
    [new RegExp(/\.tcl$/i), 'tcl-icon dark-orange'],
    [new RegExp(/\.adp$/i), 'tcl-icon medium-orange'],
    [new RegExp(/\.tm$/i), 'tcl-icon medium-red'],
    [new RegExp(/\.tea$/i), 'coffee-icon medium-orange'],
    [new RegExp(/\.tt2?$/i), 'tt-icon medium-blue'],
    [new RegExp(/\.tt3$/i), 'tt-icon medium-purple'],
    [new RegExp(/\.tern-project$/i), 'tern-icon medium-blue'],
    [new RegExp(/\.tf(?:vars)?$/i), 'terraform-icon dark-purple'],
    [new RegExp(/\.tex$|\.ltx$|\.lbx$/i), 'tex-icon medium-blue'],
    [new RegExp(/\.aux$|\.ins$/i), 'tex-icon medium-green'],
    [new RegExp(/\.sty$|\.texi$/i), 'tex-icon medium-red'],
    [new RegExp(/\.dtx$/i), 'tex-icon medium-maroon'],
    [new RegExp(/\.cls$|\.mkiv$|\.mkvi$|\.mkii$/i), 'tex-icon medium-orange'],
    [new RegExp(/\.te?xt$|\.irclog$|\.uot$/i), 'text-icon medium-blue'],
    [new RegExp(/\.log$|^Terminal[-_\s]Saved[-_\s]Output$|\.brf$/i), 'text-icon medium-maroon'],
    [new RegExp(/\.err$|\.no$|^(?:bug-report|fdl|for-release|tests)$/i), 'text-icon medium-red'],
    [new RegExp(/\.rtf$|\.uof$/i), 'text-icon dark-red'],
    [new RegExp(/\.i?nfo$/i), 'text-icon dark-blue'],
    [new RegExp(/\.abt$|\.sub$/i), 'text-icon dark-purple'],
    [new RegExp(/\.ans$/i), 'text-icon dark-orange'],
    [new RegExp(/\.etx$/i), 'text-icon medium-yellow'],
    [new RegExp(/\.msg$/i), 'text-icon medium-orange'],
    [new RegExp(/\.srt$|\.uop$/i), 'text-icon medium-purple'],
    [new RegExp(/\.(?:utxt|utf8)$/i), 'text-icon medium-cyan'],
    [new RegExp(/\.weechatlog$|\.uos$/i), 'text-icon medium-green'],
    [new RegExp(/\.textile$/i), 'textile-icon medium-orange'],
    [new RegExp(/\.tmcg$/i), 'textmate-icon dark-green'],
    [new RegExp(/\.tmLanguage$/i), 'textmate-icon dark-purple'],
    [new RegExp(/\.tmCommand$/i), 'textmate-icon medium-blue'],
    [new RegExp(/\.tmPreferences$/i), 'textmate-icon dark-blue'],
    [new RegExp(/\.tmSnippet$/i), 'textmate-icon dark-orange'],
    [new RegExp(/\.tmTheme$/i), 'textmate-icon medium-pink'],
    [new RegExp(/\.tmMacro$/i), 'textmate-icon medium-maroon'],
    [new RegExp(/\.yaml-tmlanguage$/i), 'textmate-icon medium-orange'],
    [new RegExp(/\.JSON-tmLanguage$/i), 'textmate-icon medium-purple'],
    [new RegExp(/\.thor$/i), 'thor-icon medium-orange'],
    [new RegExp(/^Thorfile$/i), 'thor-icon dark-orange'],
    [new RegExp(/\.tsx$/i), 'tsx-icon light-blue'],
    [new RegExp(/\.tu$/i), 'turing-icon medium-red'],
    [new RegExp(/\.twig$/i), 'twig-icon medium-green'],
    [new RegExp(/\.txl$/i), 'txl-icon medium-orange'],
    [new RegExp(/\.ts$/i), 'ts-icon medium-blue'],
    [new RegExp(/\.anim$/i), 'unity3d-icon dark-blue'],
    [new RegExp(/\.asset$/i), 'unity3d-icon dark-green'],
    [new RegExp(/\.mat$/i), 'unity3d-icon medium-red'],
    [new RegExp(/\.meta$/i), 'unity3d-icon dark-red'],
    [new RegExp(/\.prefab$/i), 'unity3d-icon dark-cyan'],
    [new RegExp(/\.unity$/i), 'unity3d-icon medium-blue'],
    [new RegExp(/\.unityproj$/i), 'unity3d-icon medium-maroon'],
    [new RegExp(/\.uno$/i), 'uno-icon dark-blue'],
    [new RegExp(/\.uc$/i), 'unreal-icon null'],
    [new RegExp(/\.url$/i), 'link-icon dark-blue'],
    [new RegExp(/\.ur$/i), 'urweb-icon medium-maroon'],
    [new RegExp(/\.urs$/i), 'urweb-icon dark-blue'],
    [new RegExp(/^Vagrantfile$/i), 'vagrant-icon medium-cyan'],
    [new RegExp(/\.vala$/i), 'gnome-icon medium-purple'],
    [new RegExp(/\.vapi$/i), 'gnome-icon dark-purple'],
    [new RegExp(/\.vcl$/i), 'varnish-icon dark-blue'],
    [new RegExp(/\.v$/i), 'verilog-icon dark-green'],
    [new RegExp(/\.veo$/i), 'verilog-icon medium-red'],
    [new RegExp(/\.vhdl$/i), 'vhdl-icon dark-green'],
    [new RegExp(/\.vhd$/i), 'vhdl-icon medium-green'],
    [new RegExp(/\.vhf$/i), 'vhdl-icon dark-blue'],
    [new RegExp(/\.vhi$/i), 'vhdl-icon medium-blue'],
    [new RegExp(/\.vho$/i), 'vhdl-icon dark-purple'],
    [new RegExp(/\.vhs$/i), 'vhdl-icon medium-purple'],
    [new RegExp(/\.vht$/i), 'vhdl-icon dark-red'],
    [new RegExp(/\.vhw$/i), 'vhdl-icon dark-orange'],
    [new RegExp(/\.3gpp?$/i), 'video-icon medium-blue'],
    [new RegExp(/\.(?:mp4|m4v|h264)$/i), 'video-icon dark-blue'],
    [new RegExp(/\.avi$/i), 'video-icon medium-blue'],
    [new RegExp(/\.mov$/i), 'video-icon medium-cyan'],
    [new RegExp(/\.mkv$/i), 'video-icon medium-purple'],
    [new RegExp(/\.flv$/i), 'video-icon medium-red'],
    [new RegExp(/\.webm$/i), 'video-icon dark-blue'],
    [new RegExp(/\.mpe?g$/i), 'video-icon medium-red'],
    [new RegExp(/\.(?:asf|wmv)$/i), 'video-icon dark-purple'],
    [new RegExp(/\.(?:ogm|og[gv])$/i), 'video-icon medium-orange'],
    [new RegExp(/\.(?:vim|n?vimrc)$/i), 'vim-icon medium-green'],
    [new RegExp(/^[gn_]?vim(?:rc|info)$/i), 'vim-icon dark-green'],
    [new RegExp(/\.(?:vba?|fr[mx]|bas)$/i), 'vs-icon medium-blue'],
    [new RegExp(/\.vbhtml$/i), 'vs-icon medium-red'],
    [new RegExp(/\.vbs$/i), 'vs-icon medium-green'],
    [new RegExp(/\.csproj$/i), 'vs-icon dark-blue'],
    [new RegExp(/\.vbproj$/i), 'vs-icon dark-red'],
    [new RegExp(/\.vcx?proj$/i), 'vs-icon dark-purple'],
    [new RegExp(/\.vssettings$/i), 'vs-icon dark-green'],
    [new RegExp(/\.builds$/i), 'vs-icon medium-maroon'],
    [new RegExp(/\.sln$/i), 'vs-icon medium-orange'],
    [new RegExp(/\.vue$/i), 'vue-icon light-green'],
    [new RegExp(/\.owl$/i), 'owl-icon dark-blue'],
    [new RegExp(/\.bat$|\.cmd$/i), 'windows-icon medium-purple'],
    [new RegExp(/\.(?:exe|com|msi)$/i), 'windows-icon null'],
    [new RegExp(/\.reg$/i), 'windows-icon medium-blue'],
    [new RegExp(/\.x10$/i), 'x10-icon light-maroon'],
    [new RegExp(/\.X(?:authority|clients|initrc|profile|resources|session-errors|screensaver)$/i), 'x11-icon medium-orange'],
    [new RegExp(/\.xc$/i), 'xmos-icon medium-orange'],
    [new RegExp(/\.(?:pbxproj|pbxuser|mode\dv\3|xcplugindata|xcrequiredplugins)$/i), 'appstore-icon medium-blue'],
    [new RegExp(/\.xojo_code$/i), 'xojo-icon medium-green'],
    [new RegExp(/\.xojo_menu$/i), 'xojo-icon medium-blue'],
    [new RegExp(/\.xojo_report$/i), 'xojo-icon medium-red'],
    [new RegExp(/\.xojo_script$/i), 'xojo-icon dark-green'],
    [new RegExp(/\.xojo_toolbar$/i), 'xojo-icon dark-purple'],
    [new RegExp(/\.xojo_window$/i), 'xojo-icon dark-cyan'],
    [new RegExp(/\.xsp-config$/i), 'xpages-icon medium-blue'],
    [new RegExp(/\.xsp\.metadata$/i), 'xpages-icon dark-blue'],
    [new RegExp(/\.xpl$/i), 'xmos-icon dark-blue'],
    [new RegExp(/\.xproc$/i), 'xmos-icon medium-purple'],
    [new RegExp(/\.(?:xquery|xq|xql|xqm|xqy)$/i), 'sql-icon dark-red'],
    [new RegExp(/\.xtend$/i), 'xtend-icon dark-purple'],
    [new RegExp(/\.yang$/i), 'yang-icon medium-yellow'],
    [new RegExp(/\.zpr$/i), 'zbrush-icon dark-purple'],
    [new RegExp(/\.zep$/i), 'zephir-icon medium-pink'],
    [new RegExp(/\.(?:zimpl|zmpl|zpl)$/i), 'zimpl-icon medium-orange'],
    [new RegExp(/^com\.apple\./), 'apple-icon medium-blue'],
    [new RegExp(/^httpd\.conf/i), 'apache-icon medium-red'],
    [new RegExp(/TODO/), 'checklist-icon medium-yellow'],
    [new RegExp(/config|settings|option|pref/i), 'config-icon null'],
    [new RegExp(/\.djs$/i), 'doge-icon medium-yellow'],
    [new RegExp(/^\./), 'gear-icon null'],
    [new RegExp(/\b(?:changelog|copying(?:v?\d)?|install|read[-_]?me)\b|^licen[sc]es?[-._]/i), 'book-icon medium-blue'],
    [new RegExp(/^news(?:[-_.]?[-\d]+)?$/i), 'book-icon dark-blue'],
    [new RegExp(/^(?:[dv]8|v8[-_.][^.]*|mksnapshot|mkpeephole)$/i), 'v8-icon medium-blue'],
    [new RegExp(/rc/i), 'terminal-icon medium-purple']
];

