/*
 * Decompiled with CFR 0.152.
 */
import com.avaje.ebean.Ebean;
import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.exceptions.AccessDeniedException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import controllers.SvnApp;
import controllers.UserApp;
import controllers.routes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import javax.persistence.PersistenceException;
import mailbox.MailboxService;
import models.Attachment;
import models.NotificationEvent;
import models.NotificationMail;
import models.Property;
import models.PullRequest;
import models.SiteAdmin;
import models.User;
import models.YobiUpdate;
import org.apache.commons.lang3.StringUtils;
import play.Application;
import play.Configuration;
import play.GlobalSettings;
import play.Logger;
import play.Play;
import play.api.mvc.Handler;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.AccessLogger;
import utils.ErrorViews;
import utils.FileUtil;
import utils.Timestamp;
import utils.YamlUtil;
import views.html.error.internalServerError_default;
import views.html.welcome.restart;
import views.html.welcome.secret;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Global
extends GlobalSettings {
    private static final String[] INITIAL_ENTITY_NAME = new String[]{"users", "roles", "siteAdmins"};
    private final String DEFAULT_SECRET = "VA2v:_I=h9>?FYOH:@ZhW]01P<mWZAKlQ>kk>Bo`mdCiA>pDw64FcBuZdDh<47Ew";
    private boolean isSecretInvalid = false;
    private boolean isRestartRequired = false;
    private MailboxService mailboxService = new MailboxService();
    private boolean hasFailedToUpdateSecretKey = false;
    private ConfigFile configFile = new ConfigFile("config", "application.conf");
    private ConfigFile loggerConfigFile = new ConfigFile("logger", "application-logger.xml");
    private ConfigFile oAuthProviderConfFile = new ConfigFile("conf", "social-login.conf");

    public Configuration onLoadConfig(Configuration config, File path, ClassLoader classloader) {
        this.initLoggerConfig();
        this.initAuthProviderConfig();
        return this.initConfig(classloader);
    }

    private Configuration initConfig(ClassLoader classloader) {
        if (this.configFile.isLocationSpecified()) {
            return null;
        }
        try {
            if (this.configFile.getPath().toFile().exists()) {
                return null;
            }
        }
        catch (URISyntaxException e) {
            Logger.error((String)"Failed to check whether the config file exists", (Throwable)e);
            return null;
        }
        try {
            this.configFile.createByDefault();
            return new Configuration(ConfigFactory.load((ClassLoader)classloader, (Config)ConfigFactory.parseFileAnySyntax((File)this.configFile.getPath().toFile())));
        }
        catch (Exception e) {
            Logger.error((String)"Failed to initialize configuration", (Throwable)e);
            return null;
        }
    }

    private void initLoggerConfig() {
        try {
            if (!this.loggerConfigFile.isLocationSpecified() && !this.loggerConfigFile.getPath().toFile().exists()) {
                try {
                    this.loggerConfigFile.createByDefault();
                }
                catch (Exception e) {
                    Logger.error((String)"Failed to initialize logger configuration", (Throwable)e);
                }
            }
        }
        catch (URISyntaxException e) {
            Logger.error((String)"Failed to check whether the logger config file exists", (Throwable)e);
        }
    }

    private void initAuthProviderConfig() {
        try {
            if (!this.oAuthProviderConfFile.isLocationSpecified() && !this.oAuthProviderConfFile.getPath().toFile().exists()) {
                try {
                    this.oAuthProviderConfFile.createByDefault();
                }
                catch (Exception e) {
                    Logger.error((String)"Failed to initialize social-login.conf", (Throwable)e);
                }
            }
        }
        catch (URISyntaxException e) {
            Logger.error((String)"Failed to check whether the social-login.conf file exists", (Throwable)e);
        }
    }

    public void onStart(Application app) {
        this.isSecretInvalid = this.equalsDefaultSecret();
        Global.insertInitialData();
        Timestamp timestamp = new Timestamp("=== Yona server starting initialization ===");
        utils.Config.onStart();
        timestamp.logElapsedTime("--- Config reading: ok!");
        Property.onStart();
        timestamp.logElapsedTime("--- Property reading: ok!");
        PullRequest.onStart();
        timestamp.logElapsedTime("--- Pull request checking: ok!");
        NotificationMail.onStart();
        timestamp.logElapsedTime("--- Notification mail scheduler: ok!");
        NotificationEvent.onStart();
        timestamp.logElapsedTime("--- Notification event cleanup scheduler: ok!");
        Attachment.onStart();
        timestamp.logElapsedTime("--- Temporary files cleanup scheduler: ok!");
        AccessControl.onStart();
        timestamp.logElapsedTime("--- Basic access controller config reading: ok!");
        if (!this.isSecretInvalid) {
            YobiUpdate.onStart();
            timestamp.logElapsedTime("--- Update checker run: ok! ");
            this.mailboxService.start();
            timestamp.logElapsedTime("--- MailboxService checker run: ok!");
        }
        PlayAuthenticate.setResolver((PlayAuthenticate.Resolver)new PlayAuthenticate.Resolver(){

            public Call login() {
                return routes.Application.index();
            }

            public Call afterAuth() {
                return routes.Application.index();
            }

            public Call afterLogout() {
                return routes.Application.index();
            }

            public Call auth(String provider) {
                return routes.Application.oAuth(provider);
            }

            public Call onException(AuthException e) {
                if (e instanceof AccessDeniedException) {
                    return routes.Application.oAuthDenied(((AccessDeniedException)e).getProviderKey());
                }
                return super.onException(e);
            }

            public Call askLink() {
                return null;
            }

            public Call askMerge() {
                return null;
            }
        });
    }

    private boolean equalsDefaultSecret() {
        return "VA2v:_I=h9>?FYOH:@ZhW]01P<mWZAKlQ>kk>Bo`mdCiA>pDw64FcBuZdDh<47Ew".equals(Configuration.root().getString("application.secret"));
    }

    private static void insertInitialData() {
        if (Ebean.find(User.class).findRowCount() == 0) {
            YamlUtil.insertDataFromYaml("initial-data.yml", INITIAL_ENTITY_NAME);
        }
    }

    public Action<Void> onRequest(Http.Request request, Method actionMethod) {
        if (this.isSecretInvalid) {
            if (this.isRestartRequired) {
                return this.getRestartAction();
            }
            return this.getConfigSecretAction();
        }
        return this.getDefaultAction(request);
    }

    private Action<Void> getDefaultAction(final Http.Request request) {
        final long start = System.currentTimeMillis();
        return new Action.Simple(){

            public F.Promise<Result> call(Http.Context ctx) throws Throwable {
                UserApp.initTokenUser();
                try {
                    UserApp.updatePreferredLanguage();
                }
                catch (Exception e) {
                    Logger.warn((String)"Failed to update the preferred language", (Throwable)e);
                }
                ctx.response().setHeader("Date", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
                ctx.response().setHeader("Cache-Control", "no-cache");
                F.Promise promise = this.delegate.call(ctx);
                AccessLogger.log(request, (F.Promise<Result>)promise, start);
                return promise;
            }
        };
    }

    private Action<Void> getRestartAction() {
        return new Action.Simple(){

            public F.Promise<Result> call(Http.Context ctx) throws Throwable {
                return F.Promise.pure((Object)3.ok((Content)restart.render(Global.this.hasFailedToUpdateSecretKey)));
            }
        };
    }

    private Action<Void> getConfigSecretAction() {
        return new Action.Simple(){

            public F.Promise<Result> call(Http.Context ctx) throws Throwable {
                if (ctx.request().method().toLowerCase().equals("post")) {
                    Form newSiteAdminUserForm = Form.form(User.class).bindFromRequest(new String[0]);
                    if (this.hasError((Form<User>)newSiteAdminUserForm)) {
                        return F.Promise.pure((Object)4.badRequest((Content)secret.render("admin", (Form<User>)newSiteAdminUserForm)));
                    }
                    User siteAdmin = SiteAdmin.updateDefaultSiteAdmin((User)newSiteAdminUserForm.get());
                    try {
                        User user = siteAdmin;
                        String string = null;
                        string = user.getLoginId();
                        StringBuilder stringBuilder = new StringBuilder().append(string).append(":");
                        user = siteAdmin;
                        string = null;
                        string = user.getPassword();
                        this.updateSiteSecretKey(this.createSeed(stringBuilder.append(string).toString()));
                    }
                    catch (Exception e) {
                        Logger.warn((String)"Failed to update secret key", (Throwable)e);
                        Global.this.hasFailedToUpdateSecretKey = true;
                    }
                    Global.this.isRestartRequired = true;
                    return F.Promise.pure((Object)4.ok((Content)restart.render(Global.this.hasFailedToUpdateSecretKey)));
                }
                return F.Promise.pure((Object)4.ok((Content)secret.render("admin", (Form<User>)new Form(User.class))));
            }

            private String createSeed(String basicSeed) {
                String seed = basicSeed;
                try {
                    seed = seed + InetAddress.getLocalHost();
                }
                catch (Exception e) {
                    Logger.warn((String)"Failed to get localhost address", (Throwable)e);
                }
                return seed;
            }

            private void updateSiteSecretKey(String seed) throws Exception {
                SecureRandom random = new SecureRandom(seed.getBytes(utils.Config.getCharset()));
                String secret2 = new BigInteger(130, random).toString(32);
                if (Global.this.configFile.isExternal()) {
                    throw new Exception("Cowardly refusing to update an external file: " + Global.this.configFile.getPath());
                }
                byte[] bytes = Files.readAllBytes(Global.this.configFile.getPath());
                String config = new String(bytes, utils.Config.getCharset());
                config = config.replace("VA2v:_I=h9>?FYOH:@ZhW]01P<mWZAKlQ>kk>Bo`mdCiA>pDw64FcBuZdDh<47Ew", secret2);
                Files.write(Global.this.configFile.getPath(), config.getBytes(utils.Config.getCharset()), new OpenOption[0]);
            }

            private boolean hasError(Form<User> newUserForm) {
                if (StringUtils.isBlank((CharSequence)newUserForm.field("loginId").value())) {
                    newUserForm.reject("loginId", "user.wrongloginId.alert");
                }
                if (!newUserForm.field("loginId").value().equals("admin")) {
                    newUserForm.reject("loginId", "user.wrongloginId.alert");
                }
                if (StringUtils.isBlank((CharSequence)newUserForm.field("password").value())) {
                    newUserForm.reject("password", "user.wrongPassword.alert");
                }
                if (!newUserForm.field("password").value().equals(newUserForm.field("retypedPassword").value())) {
                    newUserForm.reject("retypedPassword", "user.confirmPassword.alert");
                }
                if (StringUtils.isBlank((CharSequence)newUserForm.field("email").value())) {
                    newUserForm.reject("email", "validation.invalidEmail");
                }
                if (User.isEmailExist(newUserForm.field("email").value())) {
                    newUserForm.reject("email", "user.email.duplicate");
                }
                return newUserForm.hasErrors();
            }
        };
    }

    public Handler onRouteRequest(Http.RequestHeader request) {
        if (SvnApp.isWebDavMethod(request.method())) {
            return routes.ref.SvnApp.service().handler();
        }
        return super.onRouteRequest(request);
    }

    public void onStop(Application app) {
        this.mailboxService.stop();
    }

    public F.Promise<Result> onHandlerNotFound(Http.RequestHeader request) {
        AccessLogger.log(request, null, 404);
        return F.Promise.pure((Object)Results.notFound((Content)ErrorViews.NotFound.render()));
    }

    public F.Promise<Result> onError(Http.RequestHeader request, Throwable t) {
        AccessLogger.log(request, null, 500);
        if (Play.isProd()) {
            String messageKey = t.getCause() instanceof PersistenceException && StringUtils.contains((CharSequence)t.getMessage(), (CharSequence)"timed out") ? "error.timeout" : "error.internalServerError";
            return F.Promise.pure((Object)Results.internalServerError((Content)internalServerError_default.render(messageKey)));
        }
        return super.onError(request, t);
    }

    public F.Promise<Result> onBadRequest(Http.RequestHeader request, String error) {
        AccessLogger.log(request, null, 400);
        return F.Promise.pure((Object)Results.badRequest((Content)ErrorViews.BadRequest.render()));
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class ConfigFile {
        private static final String CONFIG_DIRNAME = "conf";
        private final String fileName;
        private final String defaultFileName;
        private final String propertyGroup;

        ConfigFile(String propertyGroup, String fileName) {
            this.propertyGroup = propertyGroup;
            this.fileName = fileName;
            this.defaultFileName = fileName + ".default";
        }

        String getProperty(@Nonnull String key) {
            return System.getProperty(this.propertyGroup + "." + key);
        }

        String getProperty(@Nonnull String key, String defaultValue) {
            return System.getProperty(this.propertyGroup + "." + key, defaultValue);
        }

        boolean isLocationSpecified() {
            return this.getProperty("resource") != null || this.getProperty("file") != null || this.getProperty("url") != null;
        }

        void createByDefault() throws IOException, URISyntaxException {
            InputStream stream = utils.Config.class.getClassLoader().getResourceAsStream(this.defaultFileName);
            this.getPath().toFile().getParentFile().mkdirs();
            if (stream != null) {
                Files.copy(stream, this.getPath(), new CopyOption[0]);
            } else {
                Files.copy(ConfigFile.getDirectoryPath().resolve(this.defaultFileName), this.getPath(), new CopyOption[0]);
            }
        }

        Path getPath() throws URISyntaxException {
            if (this.getProperty("url") != null) {
                return Paths.get(new URI(this.getProperty("url")));
            }
            if (this.getProperty("file") != null) {
                return Paths.get(this.getProperty("file"), new String[0]);
            }
            String filename = this.getProperty("resource", this.fileName);
            return ConfigFile.getDirectoryPath().resolve(filename);
        }

        static Path getDirectoryPath() {
            return Paths.get(utils.Config.getYonaDataDir(""), CONFIG_DIRNAME);
        }

        boolean isExternal() throws IOException, URISyntaxException {
            return !FileUtil.isSubpathOf(this.getPath(), ConfigFile.getDirectoryPath()) && !FileUtil.isSubpathOf(this.getPath(), Paths.get(utils.Config.getYonaDataDir(), new String[0]));
        }
    }
}

