/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.AbstractProjectCheckAction;
import actions.support.PathParser;
import controllers.UserApp;
import controllers.annotation.IsCreatable;
import models.Project;
import models.User;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.AccessLogger;
import utils.ErrorViews;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IsCreatableAction
extends AbstractProjectCheckAction<IsCreatable> {
    @Override
    protected F.Promise<Result> call(Project project2, Http.Context context, PathParser parser) throws Throwable {
        User currentUser = UserApp.currentUser();
        if (!AccessControl.isProjectResourceCreatable(currentUser, project2, ((IsCreatable)this.configuration).value())) {
            F.Promise promise = F.Promise.pure((Object)IsCreatableAction.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2)));
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        return this.delegate.call(context);
    }
}

