/*
 * Decompiled with CFR 0.152.
 */
package actors;

import akka.actor.UntypedActor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import models.PostReceiveMessage;
import models.Project;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.GitRepository;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class PostReceiveActor
extends UntypedActor {
    public void onReceive(Object message) {
        if (!(message instanceof PostReceiveMessage)) {
            return;
        }
        PostReceiveMessage cap = (PostReceiveMessage)message;
        this.doReceive(cap);
    }

    abstract void doReceive(PostReceiveMessage var1);

    protected CommitAndRefNames commitAndRefNames(PostReceiveMessage message) {
        CommitAndRefNames car = new CommitAndRefNames();
        for (ReceiveCommand command : message.getCommands()) {
            if (!this.isNewOrUpdateCommand(command)) continue;
            car.addAll(this.parseCommitsFrom(command, message.getProject()));
            car.add(command.getRefName());
        }
        return car;
    }

    protected boolean isNewOrUpdateCommand(ReceiveCommand command) {
        ArrayList<ReceiveCommand.Type> allowdTypes = new ArrayList<ReceiveCommand.Type>();
        allowdTypes.add(ReceiveCommand.Type.CREATE);
        allowdTypes.add(ReceiveCommand.Type.UPDATE);
        allowdTypes.add(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
        return allowdTypes.contains(command.getType());
    }

    protected Collection<? extends RevCommit> parseCommitsFrom(ReceiveCommand command, Project project2) {
        Repository repository = GitRepository.buildGitRepository(project2);
        ArrayList<RevCommit> list2 = new ArrayList<RevCommit>();
        try {
            ObjectId endRange = command.getNewId();
            ObjectId startRange = command.getOldId();
            RevWalk rw = new RevWalk(repository);
            rw.markStart(rw.parseCommit((AnyObjectId)endRange));
            if (startRange.equals((AnyObjectId)ObjectId.zeroId())) {
                list2.add(rw.parseCommit((AnyObjectId)endRange));
                rw.dispose();
                return list2;
            }
            rw.markUninteresting(rw.parseCommit((AnyObjectId)startRange));
            for (RevCommit rev : rw) {
                list2.add(rev);
            }
            rw.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    class CommitAndRefNames {
        List<RevCommit> commits = new ArrayList<RevCommit>();
        List<String> refNames = new ArrayList<String>();

        CommitAndRefNames() {
        }

        public List<RevCommit> getCommits() {
            return this.commits;
        }

        public void setCommits(List<RevCommit> commits) {
            this.commits = commits;
        }

        public List<String> getRefNames() {
            return this.refNames;
        }

        public void setRefNames(List<String> refNames) {
            this.refNames = refNames;
        }

        public void addAll(Collection<? extends RevCommit> revCommits) {
            this.commits.addAll(revCommits);
        }

        public void add(String refName) {
            this.refNames.add(refName);
        }
    }
}

