/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.CodeAccessCheckAction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.routes;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import models.Project;
import models.enumeration.Operation;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.tmatesoft.svn.core.SVNException;
import play.cache.Cache;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import play.twirl.api.Content;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.ErrorViews;
import utils.FileUtil;
import utils.HttpUtil;
import utils.Url;
import views.html.code.nohead;
import views.html.code.nohead_svn;
import views.html.code.view;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CodeApp
extends Controller {
    public static String hostName;
    private static Tika tika;

    @IsAllowed(value=Operation.READ)
    @Transactional
    public static Result codeBrowser(String userName, String projectName) throws IOException, UnsupportedOperationException, ServletException {
        String defaultBranch;
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(userName, projectName);
        String string = null;
        string = project3.getVcs();
        if (!"GIT".equals(string)) {
            project3 = project2;
            string = null;
            string = project3.getVcs();
            if (!"Subversion".equals(string)) {
                project3 = project2;
                string = null;
                string = project3.getVcs();
                return CodeApp.status((int)501, (String)(string + " is not supported!"));
            }
        }
        project3 = project2;
        boolean bl = false;
        bl = project3.getIsCodeAccessibleMemberOnly();
        if (bl && !project2.hasMember(UserApp.currentUser())) {
            return CodeApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        PlayRepository repository = RepositoryService.getRepository(project2);
        if (repository.isEmpty()) {
            project3 = project2;
            String string2 = null;
            string2 = project3.getVcs();
            switch (string2) {
                case "GIT": {
                    return CodeApp.ok((Content)nohead.render(project2));
                }
                case "Subversion": {
                    return CodeApp.ok((Content)nohead_svn.render(project2));
                }
            }
        }
        if ((defaultBranch = project2.defaultBranch()) == null) {
            defaultBranch = "HEAD";
        } else if (defaultBranch.split("/").length >= 3) {
            defaultBranch = defaultBranch.split("/", 3)[2];
        }
        defaultBranch = URLEncoder.encode(defaultBranch, "UTF-8");
        return CodeApp.redirect((Call)routes.CodeApp.codeBrowserWithBranch(userName, projectName, defaultBranch, ""));
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result codeBrowserWithBranch(String owner, String projectName, String branch, String path) throws UnsupportedOperationException, IOException, SVNException, GitAPIException, ServletException {
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(owner, projectName);
        String string = null;
        string = project3.getVcs();
        if (!"GIT".equals(string)) {
            project3 = project2;
            string = null;
            string = project3.getVcs();
            if (!"Subversion".equals(string)) {
                project3 = project2;
                string = null;
                string = project3.getVcs();
                return CodeApp.status((int)501, (String)(string + " is not supported!"));
            }
        }
        branch = HttpUtil.decodePathSegment(branch);
        path = HttpUtil.decodePathSegment(path);
        PlayRepository repository = RepositoryService.getRepository(project2);
        List<String> branches2 = repository.getRefNames();
        List<ObjectNode> recursiveData = null;
        project3 = project2;
        string = null;
        string = project3.getVcs();
        if ("GIT".equals(string)) {
            String cacheKey = owner + ":" + projectName + ":" + branch + ":" + path + ":" + project2.lastUpdateDate().getTime();
            recursiveData = (List<ObjectNode>)Cache.get((String)cacheKey);
            if (recursiveData == null) {
                recursiveData = RepositoryService.getMetaDataFromAncestorDirectories(repository, branch, path);
                Cache.set((String)cacheKey, recursiveData);
            }
        } else {
            project3 = project2;
            string = null;
            string = project3.getVcs();
            if ("Subversion".equals(string)) {
                recursiveData = RepositoryService.getMetaDataFromAncestorDirectories(repository, branch, path);
            }
        }
        if (recursiveData == null) {
            return CodeApp.notFound((Content)ErrorViews.NotFound.render(branch, project2, "code"));
        }
        return CodeApp.ok((Content)view.render(project2, branches2, recursiveData, branch, path));
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result ajaxRequest(String userName, String projectName, String path) throws Exception {
        PlayRepository repository = RepositoryService.getRepository(userName, projectName);
        ObjectNode fileInfo = repository.getMetaDataFromPath(path = HttpUtil.decodePathSegment(path));
        if (fileInfo != null) {
            return CodeApp.ok((JsonNode)fileInfo);
        }
        return CodeApp.notFound();
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result download(String userName, String projectName, String branch, String path) throws UnsupportedOperationException, IOException, SVNException, GitAPIException, ServletException {
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(userName, projectName);
        String string = null;
        string = project3.getVcs();
        if (!"GIT".equals(string)) {
            project3 = project2;
            string = null;
            string = project3.getVcs();
            if (!"Subversion".equals(string)) {
                project3 = project2;
                string = null;
                string = project3.getVcs();
                return CodeApp.status((int)501, (String)(string + " is not supported!"));
            }
        }
        final String targetBranch = HttpUtil.decodePathSegment(branch);
        String targetPath = HttpUtil.decodePathSegment(path);
        final PlayRepository repository = RepositoryService.getRepository(project2);
        List<ObjectNode> recursiveData = RepositoryService.getMetaDataFromAncestorDirectories(repository, targetBranch, targetPath);
        if (recursiveData == null) {
            return CodeApp.notFound((Content)ErrorViews.NotFound.render());
        }
        Results.ByteChunks chunks = new Results.ByteChunks(){

            public void onReady(Results.Chunks.Out<byte[]> out) {
                repository.getArchive(out, targetBranch);
            }
        };
        CodeApp.response().setHeader("Content-Disposition", "attachment; filename=" + projectName + "-" + branch + ".zip");
        return CodeApp.ok((Results.Chunks)chunks);
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result ajaxRequestWithBranch(String userName, String projectName, String branch, String path) throws UnsupportedOperationException, IOException, SVNException, GitAPIException, ServletException {
        hostName = CodeApp.request().host();
        PlayRepository repository = RepositoryService.getRepository(userName, projectName);
        ObjectNode fileInfo = repository.getMetaDataFromPath(branch = HttpUtil.decodePathSegment(branch), path = HttpUtil.decodePathSegment(path));
        if (fileInfo != null) {
            return CodeApp.ok((JsonNode)fileInfo);
        }
        return CodeApp.notFound();
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result showRawFile(String userName, String projectName, String revision, String path) throws Exception {
        path = HttpUtil.decodePathSegment(path);
        byte[] fileAsRaw = RepositoryService.getFileAsRaw(userName, projectName, revision = HttpUtil.decodePathSegment(revision), path);
        if (fileAsRaw == null) {
            return CodeApp.redirect((Call)routes.CodeApp.codeBrowserWithBranch(userName, projectName, revision, path));
        }
        MediaType mediaType = FileUtil.detectMediaType(fileAsRaw, FilenameUtils.getName((String)path));
        String mediaTypeString = "text/plain";
        String charset = FileUtil.getCharset(mediaType);
        if (charset != null) {
            mediaTypeString = mediaTypeString + "; charset=" + charset;
        }
        return CodeApp.ok((byte[])fileAsRaw).as(mediaTypeString);
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result showImageFile(String userName, String projectName, String revision, String path) throws Exception {
        revision = HttpUtil.decodePathSegment(revision);
        path = HttpUtil.decodePathSegment(path);
        byte[] fileAsRaw = RepositoryService.getFileAsRaw(userName, projectName, revision, path);
        String mimeType = tika.detect(fileAsRaw);
        return CodeApp.ok((byte[])fileAsRaw).as(mimeType);
    }

    public static String getURL(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        return CodeApp.getURL(project2);
    }

    public static String getURL(Project project2) {
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        String string = null;
        string = project3.getVcs();
        if ("GIT".equals(string)) {
            String[] stringArray = new String[2];
            project3 = project2;
            string = null;
            string = project3.getOwner();
            stringArray[0] = HttpUtil.encodeUrlString(string);
            project3 = project2;
            string = null;
            string = project3.getName();
            stringArray[1] = HttpUtil.encodeUrlString(string);
            return Url.createWithContext(Arrays.asList(stringArray));
        }
        project3 = project2;
        string = null;
        string = project3.getVcs();
        if ("Subversion".equals(string)) {
            String[] stringArray = new String[3];
            stringArray[0] = "svn";
            project3 = project2;
            string = null;
            stringArray[1] = string = project3.getOwner();
            project3 = project2;
            string = null;
            stringArray[2] = string = project3.getName();
            return Url.createWithContext(Arrays.asList(stringArray));
        }
        return null;
    }

    public static String getURLWithLoginId(Project project2) {
        String loginId;
        String url = CodeApp.getURL(project2);
        if (url != null && (loginId = (String)CodeApp.session().get((Object)"loginId")) != null && !loginId.isEmpty()) {
            url = url.replace("://", "://" + loginId + "@");
        }
        return url;
    }

    @IsAllowed(value=Operation.READ)
    public static Result openFile(String userName, String projectName, String revision, String path) throws Exception {
        byte[] raw = RepositoryService.getFileAsRaw(userName, projectName, revision = HttpUtil.decodePathSegment(revision), path = HttpUtil.decodePathSegment(path));
        if (raw == null) {
            return CodeApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        return CodeApp.ok((byte[])raw).as(FileUtil.detectMediaType(raw, FilenameUtils.getName((String)path)).toString());
    }

    static {
        tika = new Tika();
    }
}

