/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.CodeAccessCheckAction;
import actions.DefaultProjectCheckAction;
import actions.NullProjectCheckAction;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.routes;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import models.Attachment;
import models.CodeCommentThread;
import models.CodeRange;
import models.CommentThread;
import models.CommitComment;
import models.NonRangedCodeCommentThread;
import models.NotificationEvent;
import models.Project;
import models.ReviewComment;
import models.User;
import models.UserIdent;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.tmatesoft.svn.core.SVNException;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.With;
import play.twirl.api.Content;
import playRepository.Commit;
import playRepository.FileDiff;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.AccessControl;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.RouteUtil;
import views.html.code.diff;
import views.html.code.history;
import views.html.code.nohead;
import views.html.code.svnDiff;
import views.html.error.notfound;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CodeHistoryApp
extends Controller {
    private static final int HISTORY_ITEM_LIMIT = 25;

    @With(value={CodeAccessCheckAction.class})
    public static Result historyUntilHead(String ownerName, String projectName) throws IOException, UnsupportedOperationException, ServletException, GitAPIException, SVNException {
        return CodeHistoryApp.history(ownerName, projectName, null, null);
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result history(String ownerName, String projectName, String branch, String path) throws IOException, UnsupportedOperationException, ServletException, GitAPIException, SVNException {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        PlayRepository repository = RepositoryService.getRepository(project2);
        branch = HttpUtil.decodePathSegment(branch);
        path = HttpUtil.decodePathSegment(path);
        String pageStr = HttpUtil.getFirstValueFromQuery(CodeHistoryApp.request().queryString(), "page");
        int page = 0;
        if (StringUtils.isNotEmpty((String)pageStr)) {
            page = Integer.parseInt(pageStr);
        }
        try {
            List<Commit> commits = repository.getHistory(page, 25, branch, path);
            if (commits == null) {
                return CodeHistoryApp.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2));
            }
            return CodeHistoryApp.ok((Content)history.render(project2, commits, page, branch, path));
        }
        catch (NoHeadException e) {
            return CodeHistoryApp.notFound((Content)nohead.render(project2));
        }
    }

    @With(value={CodeAccessCheckAction.class})
    public static Result show(String ownerName, String projectName, String commitId) throws IOException, UnsupportedOperationException, ServletException, GitAPIException, SVNException, NoSuchMethodException {
        Commit commit;
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        PlayRepository repository = RepositoryService.getRepository(project2);
        try {
            commit = repository.getCommit(commitId);
        }
        catch (MissingObjectException e) {
            return CodeHistoryApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.commit", project2));
        }
        if (commit == null) {
            return CodeHistoryApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.commit", project2));
        }
        Commit parentCommit = repository.getParentCommitOf(commitId);
        List<CommentThread> threads = CommentThread.findByCommitId(CommentThread.find, project2, commit.getId());
        String selectedBranch = StringUtils.defaultIfBlank((String)CodeHistoryApp.request().getQueryString("branch"), (String)"HEAD");
        String path = StringUtils.defaultIfBlank((String)CodeHistoryApp.request().getQueryString("path"), (String)"");
        Project project3 = project2;
        Object object = null;
        object = project3.getVcs();
        if (((String)object).equals("Subversion")) {
            String patch = repository.getPatch(commitId);
            if (patch == null) {
                return CodeHistoryApp.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2));
            }
            project3 = project2;
            object = null;
            object = project3.getId();
            List comments = CommitComment.find.where().eq("commitId", (Object)commitId).eq("project.id", object).order("createdDate").findList();
            return CodeHistoryApp.ok((Content)svnDiff.render(project2, commit, parentCommit, patch, comments, selectedBranch, path));
        }
        List<FileDiff> fileDiffs = repository.getDiff(commitId);
        if (fileDiffs == null) {
            return CodeHistoryApp.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2));
        }
        return CodeHistoryApp.ok((Content)diff.render(project2, commit, parentCommit, threads, selectedBranch, fileDiffs, path));
    }

    @With(value={NullProjectCheckAction.class})
    public static Result newSVNComment(String ownerName, String projectName, String commitId) throws IOException, ServletException, SVNException {
        Form codeCommentForm = new Form(CommitComment.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (codeCommentForm.hasErrors()) {
            return CodeHistoryApp.badRequest((Content)ErrorViews.BadRequest.render("error.validation", project2));
        }
        Commit commit = RepositoryService.getRepository(project2).getCommit(commitId);
        if (commit == null) {
            return CodeHistoryApp.notFound((Content)notfound.render("error.notfound", project2, CodeHistoryApp.request().path()));
        }
        if (!AccessControl.isResourceCreatable(UserApp.currentUser(), commit.asResource(project2), ResourceType.COMMIT_COMMENT)) {
            return CodeHistoryApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        CommitComment codeComment = (CommitComment)codeCommentForm.get();
        Object object = project2;
        CommitComment commitComment = codeComment;
        commitComment.setProject((Project)object);
        object = commitId;
        commitComment = codeComment;
        commitComment.setCommitId((String)object);
        object = new Date();
        commitComment = codeComment;
        commitComment.setCreatedDate((Date)object);
        codeComment.setAuthor(UserApp.currentUser());
        codeComment.save();
        Attachment.moveAll(UserApp.currentUser().asResource(), codeComment.asResource());
        NotificationEvent.afterNewSVNCommitComment(project2, codeComment);
        return CodeHistoryApp.redirect((String)RouteUtil.getUrl(codeComment));
    }

    @IsCreatable(value=ResourceType.COMMIT_COMMENT)
    public static Result newComment(String ownerName, String projectName, String commitId) throws IOException, ServletException, SVNException {
        Form codeRangeForm = new Form(CodeRange.class).bindFromRequest(new String[0]);
        Form reviewCommentForm = new Form(ReviewComment.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getVcs();
        if (((String)object2).equals("Subversion")) {
            return CodeHistoryApp.newSVNComment(ownerName, projectName, commitId);
        }
        if (reviewCommentForm.hasErrors()) {
            return CodeHistoryApp.badRequest((Content)ErrorViews.BadRequest.render("error.validation", project2));
        }
        if (RepositoryService.getRepository(project2).getCommit(commitId) == null) {
            return CodeHistoryApp.notFound((Content)notfound.render("error.notfound", project2, CodeHistoryApp.request().path()));
        }
        ReviewComment comment = (ReviewComment)reviewCommentForm.get();
        object2 = new UserIdent(UserApp.currentUser());
        object = comment;
        ((ReviewComment)object).setAuthor((UserIdent)object2);
        object = comment;
        object2 = null;
        object2 = ((ReviewComment)object).getThread();
        if (object2 == null) {
            if (codeRangeForm.errors().isEmpty()) {
                CodeCommentThread thread = new CodeCommentThread();
                object2 = commitId;
                object = thread;
                ((CodeCommentThread)object).setCommitId((String)object2);
                object2 = null;
                object = thread;
                ((CodeCommentThread)object).setPrevCommitId((String)object2);
                User codeAuthor = RepositoryService.getRepository(project2).getCommit(commitId).getAuthor();
                if (!codeAuthor.isAnonymous()) {
                    object = thread;
                    object2 = null;
                    object2 = ((CodeCommentThread)object).getCodeAuthors();
                    object2.add((User)codeAuthor);
                }
                object2 = (CodeRange)codeRangeForm.get();
                object = thread;
                ((CodeCommentThread)object).setCodeRange((CodeRange)object2);
                object2 = thread;
                object = comment;
                ((ReviewComment)object).setThread((CommentThread)object2);
            } else {
                NonRangedCodeCommentThread thread = new NonRangedCodeCommentThread();
                object2 = commitId;
                object = thread;
                ((NonRangedCodeCommentThread)object).setCommitId((String)object2);
                object2 = null;
                object = thread;
                ((NonRangedCodeCommentThread)object).setPrevCommitId((String)object2);
                object2 = thread;
                object = comment;
                ((ReviewComment)object).setThread((CommentThread)object2);
            }
            object = comment;
            object2 = null;
            object2 = ((ReviewComment)object).getThread();
            List<User> list2 = object2;
            object2 = project2;
            object = list2;
            ((CommentThread)object).setProject((Project)object2);
            object = comment;
            object2 = null;
            Object object3 = object2 = ((ReviewComment)object).getThread();
            object2 = CommentThread.ThreadState.OPEN;
            object = object3;
            ((CommentThread)object).setState((CommentThread.ThreadState)((Object)object2));
            object = comment;
            object2 = null;
            Object object4 = object2 = ((ReviewComment)object).getThread();
            object = comment;
            object2 = null;
            object2 = ((ReviewComment)object).getCreatedDate();
            object = object4;
            ((CommentThread)object).setCreatedDate((Date)object2);
            object = comment;
            object2 = null;
            Object object5 = object2 = ((ReviewComment)object).getThread();
            object = comment;
            object2 = null;
            object2 = ((ReviewComment)object).getAuthor();
            object = object5;
            ((CommentThread)object).setAuthor((UserIdent)object2);
        } else {
            object = comment;
            object2 = null;
            object = object2 = ((ReviewComment)object).getThread();
            object2 = null;
            object2 = ((CommentThread)object).getId();
            object2 = (CommentThread)CommentThread.find.byId(object2);
            object = comment;
            ((ReviewComment)object).setThread((CommentThread)object2);
        }
        comment.save();
        Attachment.moveAll(UserApp.currentUser().asResource(), comment.asResource());
        NotificationEvent.afterNewCommitComment(project2, comment, commitId);
        return CodeHistoryApp.redirect((String)RouteUtil.getUrl(comment));
    }

    @With(value={DefaultProjectCheckAction.class})
    @IsAllowed(value=Operation.DELETE, resourceType=ResourceType.COMMIT_COMMENT)
    public static Result deleteComment(String ownerName, String projectName, String commitId, Long id) {
        CommitComment codeComment = (CommitComment)CommitComment.find.byId((Object)id);
        codeComment.delete();
        play.api.mvc.Call toView = routes.CodeHistoryApp.show(ownerName, projectName, commitId);
        return CodeHistoryApp.redirect((Call)toView);
    }
}

