/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.github.zafarkhaja.semver.Version;
import controllers.UserApp;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import models.Project;
import models.User;
import models.enumeration.Operation;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.With;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.AccessControl;
import utils.BasicAuthAction;
import utils.Config;
import utils.HttpUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GitApp
extends Controller {
    public static boolean isSupportedService(String service2) {
        return service2 != null && (service2.equals("git-upload-pack") || service2.equals("git-receive-pack"));
    }

    private static boolean isAllowed(Project project2, String service2) throws UnsupportedOperationException, IOException, ServletException {
        Operation operation = Operation.UPDATE;
        if (service2.equals("git-upload-pack")) {
            operation = Operation.READ;
        }
        Project project3 = project2;
        boolean bl = false;
        bl = project3.getIsCodeAccessibleMemberOnly();
        if (bl && !project2.hasMember(UserApp.currentUser())) {
            operation = Operation.UPDATE;
        }
        PlayRepository repository = RepositoryService.getRepository(project2);
        return AccessControl.isAllowed(UserApp.currentUser(), repository.asResource(), operation);
    }

    private static boolean isCharsetAllowed(String userAgent) {
        try {
            String version = Config.semverize(userAgent.substring(userAgent.indexOf(47) + 1));
            if (Version.valueOf((String)version).greaterThanOrEqualTo(Version.forIntegers((int)2, (int)1, (int)0))) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Result service(String ownerName, String projectName, String service2, boolean isAdvertise) throws IOException, UnsupportedOperationException, ServletException {
        if (!GitApp.isSupportedService(service2)) {
            return GitApp.forbidden((String)String.format("Unsupported service: '%s'", service2));
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (project2 == null) {
            Project previousProject = Project.findByPreviousPlaceOf(ownerName, projectName);
            if (previousProject != null) {
                project2 = previousProject;
            } else {
                return GitApp.notFound();
            }
        }
        Model model = project2;
        String string = null;
        string = model.getVcs();
        if (!string.equals("GIT")) {
            return GitApp.notFound();
        }
        User user = UserApp.currentUser();
        if (!GitApp.isAllowed(project2, service2)) {
            String message;
            if (user.isAnonymous()) {
                return BasicAuthAction.unauthorized(GitApp.response());
            }
            String contentType = "text/plain";
            if (GitApp.isCharsetAllowed(GitApp.request().getHeader("User-Agent"))) {
                contentType = contentType + ";charset=" + Config.getCharset();
                Object[] objectArray = new Object[3];
                model = user;
                string = null;
                string = model.getLoginId();
                objectArray[0] = string;
                objectArray[1] = ownerName;
                objectArray[2] = projectName;
                message = Messages.get((String)"git.error.permission", (Object[])objectArray);
            } else {
                Object[] objectArray = new Object[3];
                model = user;
                string = null;
                string = model.getLoginId();
                objectArray[0] = string;
                objectArray[1] = ownerName;
                objectArray[2] = projectName;
                message = Messages.get((Lang)Lang.defaultLang(), (String)"git.error.notAllowedCharset", (Object[])objectArray);
            }
            GitApp.response().setHeader("Content-Type", contentType);
            return GitApp.forbidden((String)message);
        }
        if (isAdvertise) {
            return GitApp.ok((byte[])RepositoryService.gitAdvertise(project2, service2, GitApp.response()));
        }
        if (GitApp.request().body().isMaxSizeExceeded()) {
            return GitApp.status((int)413);
        }
        user.visits(project2);
        return GitApp.ok((InputStream)RepositoryService.gitRpc(project2, service2, GitApp.request(), GitApp.response()));
    }

    @With(value={BasicAuthAction.class})
    public static Result advertise(String ownerName, String projectName, String service2) throws UnsupportedOperationException, IOException, ServletException {
        if (service2 == null) {
            return GitApp.forbidden((String)"Unsupported service: getanyfile");
        }
        return GitApp.service(ownerName, HttpUtil.decodeUrlString(projectName), service2, true);
    }

    @With(value={BasicAuthAction.class})
    public static Result serviceRpc(String ownerName, String projectName, String service2) throws UnsupportedOperationException, IOException, ServletException {
        return GitApp.service(ownerName, projectName, service2, false);
    }
}

