/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.routes;
import info.schleichardt.play2.mailplugin.Mailer;
import models.AuthInfo;
import models.User;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.DynamicForm;
import play.data.Form;
import play.i18n.Messages;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.Config;
import utils.ErrorViews;
import utils.PasswordReset;
import utils.Url;
import views.html.site.lostPassword;
import views.html.user.login;
import views.html.user.resetPassword;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PasswordResetApp
extends Controller {
    public static Result lostPassword() {
        return PasswordResetApp.ok((Content)lostPassword.render("site.resetPasswordEmail.title", null, null, false));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Result requestResetPasswordEmail() {
        DynamicForm requestData = Form.form().bindFromRequest(new String[0]);
        String loginId = requestData.get("loginId");
        String emailAddress = requestData.get("emailAddress");
        Logger.debug((String)("request reset password email by [" + loginId + ":" + emailAddress + "]"));
        User targetUser = User.findByLoginId(loginId);
        boolean isMailSent = false;
        String errorMessage = null;
        if (!targetUser.isAnonymous()) {
            User user = targetUser;
            String string = null;
            string = user.getEmail();
            if (string.equals(emailAddress)) {
                user = targetUser;
                string = null;
                string = user.getLoginId();
                String hashString = PasswordReset.generateResetHash(string);
                user = targetUser;
                string = null;
                string = user.getLoginId();
                PasswordReset.addHashToResetTable(string, hashString);
                isMailSent = PasswordResetApp.sendPasswordResetMail(targetUser, hashString);
                return PasswordResetApp.ok((Content)lostPassword.render("site.resetPasswordEmail.title", emailAddress, errorMessage, isMailSent));
            }
        }
        Logger.debug((String)("wrong user: " + loginId));
        errorMessage = Messages.get((String)"site.resetPasswordEmail.invalidRequest", (Object[])new Object[0]);
        return PasswordResetApp.ok((Content)lostPassword.render("site.resetPasswordEmail.title", emailAddress, errorMessage, isMailSent));
    }

    private static boolean sendPasswordResetMail(User user, String hashString) {
        String sender = Config.getEmailFromSmtp();
        String resetPasswordUrl = PasswordResetApp.getResetPasswordUrl(hashString);
        try {
            SimpleEmail email = new SimpleEmail();
            User user2 = user;
            String string = null;
            string = user2.getEmail();
            email.setFrom(sender).setSubject("[" + Config.getSiteName() + "] " + Messages.get((String)"site.resetPasswordEmail.title", (Object[])new Object[0])).addTo(string).setMsg(Messages.get((String)"site.resetPasswordEmail.mailContents", (Object[])new Object[0]) + "\n\n" + resetPasswordUrl).setCharset("utf-8");
            Logger.debug((String)("password reset mail send: " + Mailer.send((Email)email)));
            return true;
        }
        catch (EmailException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String getResetPasswordUrl(String hashString) {
        return Url.create(routes.PasswordResetApp.resetPasswordForm(hashString).url());
    }

    public static Result resetPasswordForm(String hashString) {
        return PasswordResetApp.ok((Content)resetPassword.render("title.resetPassword", (Form<User>)Form.form(User.class), hashString));
    }

    public static Result resetPassword() {
        DynamicForm requestData = Form.form().bindFromRequest(new String[0]);
        String hashString = requestData.get("hashString");
        String newPassword = requestData.get("password");
        if (!PasswordReset.isValidResetHash(hashString)) {
            Logger.debug((String)"Not a valid request!");
            return PasswordResetApp.badRequest((Content)ErrorViews.BadRequest.render("site.resetPasswordEmail.wrongUrl"));
        }
        PasswordReset.resetPassword(hashString, newPassword);
        Logger.debug((String)"Password was reset");
        PasswordResetApp.flash((String)"warning", (String)"user.loginWithNewPassword");
        return PasswordResetApp.ok((Content)login.render("title.login", (Form<AuthInfo>)Form.form(AuthInfo.class), null));
    }
}

