/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Application;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import models.Organization;
import models.PageParam;
import models.Project;
import models.Search;
import models.SearchResult;
import models.User;
import models.enumeration.Operation;
import models.enumeration.SearchType;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.ErrorViews;
import views.html.search.result;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SearchApp
extends Controller {
    private static final PageParam DEFAULT_PAGE = new PageParam(0, 20);

    public static Result searchInAll() {
        String searchTypeValue = SearchApp.request().getQueryString("searchType");
        String keyword = SearchApp.request().getQueryString("keyword");
        PageParam pageParam = SearchApp.getPage();
        if (StringUtils.isEmpty((CharSequence)keyword) || StringUtils.isEmpty((CharSequence)searchTypeValue)) {
            return SearchApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        User user = UserApp.currentUser();
        SearchType searchType = SearchType.getValue(searchTypeValue);
        if (searchType == SearchType.NA) {
            return SearchApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        SearchResult searchResult = SearchApp.getSearchResult(keyword, user, searchType);
        switch (searchResult.getSearchType()) {
            case ISSUE: {
                searchResult.setIssues(Search.findIssues(keyword, user, pageParam));
                break;
            }
            case USER: {
                searchResult.setUsers(Search.findUsers(keyword, pageParam));
                break;
            }
            case PROJECT: {
                searchResult.setProjects(Search.findProjects(keyword, user, pageParam));
                break;
            }
            case POST: {
                searchResult.setPosts(Search.findPosts(keyword, user, pageParam));
                break;
            }
            case MILESTONE: {
                searchResult.setMilestones(Search.findMilestones(keyword, user, pageParam));
                break;
            }
            case ISSUE_COMMENT: {
                searchResult.setIssueComments(Search.findIssueComments(keyword, user, pageParam));
                break;
            }
            case POST_COMMENT: {
                searchResult.setPostComments(Search.findPostComments(keyword, user, pageParam));
                break;
            }
            case REVIEW: {
                searchResult.setReviews(Search.findReviews(keyword, user, pageParam));
            }
        }
        return SearchApp.ok((Content)result.render("title.search", null, null, searchResult));
    }

    private static SearchResult getSearchResult(String keyword, User user, SearchType searchType) {
        SearchResult searchResult = new SearchResult();
        searchResult.setKeyword(keyword);
        searchResult.setSearchType(searchType);
        searchResult.setProjectsCount(Search.countProjects(keyword, user));
        searchResult.setUsersCount(Search.countUsers(keyword));
        searchResult.setIssuesCount(Search.countIssues(keyword, user));
        searchResult.setPostsCount(Search.countPosts(keyword, user));
        searchResult.setMilestonesCount(Search.countMilestones(keyword, user));
        searchResult.setIssueCommentsCount(Search.countIssueComments(keyword, user));
        searchResult.setPostCommentsCount(Search.countPostComments(keyword, user));
        searchResult.setReviewsCount(Search.countReviews(keyword, user));
        searchResult.updateSearchType();
        return searchResult;
    }

    public static Result searchInAGroup(String organizationName) {
        String searchTypeValue = SearchApp.request().getQueryString("searchType");
        String keyword = SearchApp.request().getQueryString("keyword");
        PageParam pageParam = SearchApp.getPage();
        if (StringUtils.isEmpty((CharSequence)organizationName) || StringUtils.isEmpty((CharSequence)keyword) || StringUtils.isEmpty((CharSequence)searchTypeValue)) {
            return SearchApp.badRequest();
        }
        Organization organization2 = Organization.findByName(organizationName);
        User user = UserApp.currentUser();
        if (!(!Application.HIDE_PROJECT_LISTING || user.isMemberOf(organization2) && user.isAdminOf(organization2))) {
            return SearchApp.badRequest();
        }
        SearchType searchType = SearchType.getValue(searchTypeValue);
        if (searchType == SearchType.NA || organization2 == null) {
            return SearchApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        SearchResult searchResult = SearchApp.getSearchResult(keyword, user, organization2, searchType);
        switch (searchResult.getSearchType()) {
            case ISSUE: {
                searchResult.setIssues(Search.findIssues(keyword, user, organization2, pageParam));
                break;
            }
            case USER: {
                searchResult.setUsers(Search.findUsers(keyword, organization2, pageParam));
                break;
            }
            case PROJECT: {
                searchResult.setProjects(Search.findProjects(keyword, user, organization2, pageParam));
                break;
            }
            case POST: {
                searchResult.setPosts(Search.findPosts(keyword, user, organization2, pageParam));
                break;
            }
            case MILESTONE: {
                searchResult.setMilestones(Search.findMilestones(keyword, user, organization2, pageParam));
                break;
            }
            case ISSUE_COMMENT: {
                searchResult.setIssueComments(Search.findIssueComments(keyword, user, organization2, pageParam));
                break;
            }
            case POST_COMMENT: {
                searchResult.setPostComments(Search.findPostComments(keyword, user, organization2, pageParam));
                break;
            }
            case REVIEW: {
                searchResult.setReviews(Search.findReviews(keyword, user, organization2, pageParam));
            }
        }
        return SearchApp.ok((Content)result.render("title.search", organization2, null, searchResult));
    }

    private static SearchResult getSearchResult(String keyword, User user, Organization organization2, SearchType searchType) {
        SearchResult searchResult = new SearchResult();
        searchResult.setSearchType(searchType);
        searchResult.setKeyword(keyword);
        searchResult.setProjectsCount(Search.countProjects(keyword, user, organization2));
        searchResult.setUsersCount(Search.countUsers(keyword, organization2));
        searchResult.setIssuesCount(Search.countIssues(keyword, user, organization2));
        searchResult.setPostsCount(Search.countPosts(keyword, user, organization2));
        searchResult.setMilestonesCount(Search.countMilestones(keyword, user, organization2));
        searchResult.setIssueCommentsCount(Search.countIssueComments(keyword, user, organization2));
        searchResult.setPostCommentsCount(Search.countPostComments(keyword, user, organization2));
        searchResult.setReviewsCount(Search.countReviews(keyword, user, organization2));
        searchResult.updateSearchType();
        return searchResult;
    }

    @IsAllowed(value=Operation.READ)
    public static Result searchInAProject(String loginId, String projectName) {
        String searchTypeValue = SearchApp.request().getQueryString("searchType");
        String keyword = SearchApp.request().getQueryString("keyword");
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        PageParam pageParam = SearchApp.getPage();
        if (StringUtils.isEmpty((CharSequence)keyword) || StringUtils.isEmpty((CharSequence)searchTypeValue) || project2 == null) {
            return SearchApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        User user = UserApp.currentUser();
        SearchType searchType = SearchType.getValue(searchTypeValue);
        if (searchType == SearchType.NA || searchType == SearchType.PROJECT) {
            return SearchApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        SearchResult searchResult = SearchApp.getSearchResult(keyword, user, project2, searchType);
        switch (searchResult.getSearchType()) {
            case ISSUE: {
                searchResult.setIssues(Search.findIssues(keyword, user, project2, pageParam));
                break;
            }
            case USER: {
                searchResult.setUsers(Search.findUsers(keyword, project2, pageParam));
                break;
            }
            case POST: {
                searchResult.setPosts(Search.findPosts(keyword, user, project2, pageParam));
                break;
            }
            case MILESTONE: {
                searchResult.setMilestones(Search.findMilestones(keyword, user, project2, pageParam));
                break;
            }
            case ISSUE_COMMENT: {
                searchResult.setIssueComments(Search.findIssueComments(keyword, user, project2, pageParam));
                break;
            }
            case POST_COMMENT: {
                searchResult.setPostComments(Search.findPostComments(keyword, user, project2, pageParam));
                break;
            }
            case REVIEW: {
                searchResult.setReviews(Search.findReviews(keyword, user, project2, pageParam));
            }
        }
        return SearchApp.ok((Content)result.render("title.search", null, project2, searchResult));
    }

    private static SearchResult getSearchResult(String keyword, User user, Project project2, SearchType searchType) {
        SearchResult searchResult = new SearchResult();
        searchResult.setSearchType(searchType);
        searchResult.setKeyword(keyword);
        searchResult.setUsersCount(Search.countUsers(keyword, project2));
        searchResult.setIssuesCount(Search.countIssues(keyword, user, project2));
        searchResult.setPostsCount(Search.countPosts(keyword, user, project2));
        searchResult.setMilestonesCount(Search.countMilestones(keyword, user, project2));
        searchResult.setIssueCommentsCount(Search.countIssueComments(keyword, user, project2));
        searchResult.setPostCommentsCount(Search.countPostComments(keyword, user, project2));
        searchResult.setReviewsCount(Search.countReviews(keyword, user, project2));
        searchResult.updateSearchType();
        return searchResult;
    }

    private static PageParam getPage() {
        PageParam pageParam = new PageParam(DEFAULT_PAGE.getPage(), DEFAULT_PAGE.getSize());
        String pageNumString = SearchApp.request().getQueryString("pageNum");
        if (pageNumString != null) {
            int pageNum = Integer.parseInt(pageNumString);
            pageParam.setPage(pageNum - 1);
        }
        return pageParam;
    }
}

