/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserApp;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import models.Project;
import models.User;
import models.enumeration.Operation;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.With;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.AccessControl;
import utils.BasicAuthAction;
import utils.PlayServletRequest;
import utils.PlayServletResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SvnApp
extends Controller {
    private static final String[] WEBDAV_METHODS = new String[]{"PROPFIND", "REPORT", "TRACE", "PROPPATCH", "COPY", "MOVE", "LOCK", "UNLOCK", "MKCOL", "VERSION-CONTROL", "MKWORKSPACE", "MKACTIVITY", "CHECKIN", "CHECKOUT", "MERGE"};

    public static boolean isWebDavMethod(String method) {
        for (String webDavMethod : WEBDAV_METHODS) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)webDavMethod, (CharSequence)method)) continue;
            return true;
        }
        return false;
    }

    @With(value={BasicAuthAction.class})
    @BodyParser.Of(value=BodyParser.Raw.class, maxLength=0x7FFFFFFF)
    public static Result serviceWithPath(String path) throws ServletException, IOException, InterruptedException {
        return SvnApp.service();
    }

    @With(value={BasicAuthAction.class})
    @BodyParser.Of(value=BodyParser.Raw.class, maxLength=0x7FFFFFFF)
    public static Result service() throws ServletException, IOException, InterruptedException {
        String[] segments;
        String path;
        try {
            path = new URI(SvnApp.request().uri()).getPath();
        }
        catch (URISyntaxException e) {
            return SvnApp.badRequest();
        }
        path = StringUtils.removeStart((String)path, (String)Configuration.root().getString("application.context"));
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((segments = path.split("/", 3)).length < 3) {
            return SvnApp.forbidden();
        }
        String userName = segments[1];
        String pathInfo = segments[2];
        String projectName = pathInfo.split("/", 2)[0];
        User currentUser = UserApp.currentUser();
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        if (project2 == null) {
            Project previousProject = Project.findByPreviousPlaceOf(userName, projectName);
            if (previousProject != null) {
                project2 = previousProject;
            } else {
                return SvnApp.notFound();
            }
        }
        Project project3 = project2;
        String string = null;
        string = project3.getVcs();
        if (!string.equals("Subversion")) {
            return SvnApp.notFound();
        }
        PlayRepository repository = RepositoryService.getRepository(project2);
        if (!AccessControl.isAllowed(currentUser, repository.asResource(), SvnApp.getRequestedOperation(SvnApp.request().method()))) {
            if (currentUser.isAnonymous()) {
                return BasicAuthAction.unauthorized(SvnApp.response());
            }
            return SvnApp.forbidden((String)"You have no permission to access this repository.");
        }
        PlayServletResponse response = SvnApp.startDavService(userName, pathInfo);
        int status = response.waitAndGetStatus();
        UserApp.currentUser().visits(project2);
        return SvnApp.sendResponse(SvnApp.request().method(), status, response.getInputStream());
    }

    private static PlayServletResponse startDavService(final String ownerName, String pathInfo) throws IOException {
        User user = UserApp.currentUser();
        String string = null;
        string = user.getLoginId();
        final PlayServletRequest request = new PlayServletRequest(SvnApp.request(), string, pathInfo);
        final PlayServletResponse response = new PlayServletResponse(SvnApp.response());
        new Thread(){

            @Override
            public void run() {
                try {
                    RepositoryService.createDavServlet(ownerName).service((HttpServletRequest)request, (HttpServletResponse)response);
                    response.flushBuffer();
                    response.getOutputStream().close();
                }
                catch (Exception e) {
                    response.setStatus(500);
                    response.getStatusLock().notifyAll();
                    Logger.error((String)"Failed to process a SVN request.", (Throwable)e);
                }
            }
        }.start();
        return response;
    }

    private static Result sendResponse(String requestMethod, int statusCode, PipedInputStream input) {
        if (statusCode < 200 || statusCode == 204 || statusCode == 304 || requestMethod.toUpperCase().equals("HEAD")) {
            return SvnApp.status((int)statusCode);
        }
        if (statusCode == 205) {
            return SvnApp.status((int)statusCode, (String)"");
        }
        SvnApp.response().getHeaders().remove("Content-Length");
        return SvnApp.status((int)statusCode, (InputStream)input);
    }

    private static Operation getRequestedOperation(String method) {
        if ("OPTIONS".equals(method) || "PROPFIND".equals(method) || "GET".equals(method) || "REPORT".equals(method)) {
            return Operation.READ;
        }
        return Operation.UPDATE;
    }
}

