/*
 * Decompiled with CFR 0.152.
 */
package mailbox;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class EmailAddressWithDetail {
    @Nonnull
    private final String user;
    @Nonnull
    private String detail;
    @Nonnull
    private final String domain;

    public EmailAddressWithDetail(@Nonnull String address) {
        int plus = address.indexOf(43);
        int at2 = address.indexOf(64);
        if (plus < 0) {
            this.user = address.substring(0, at2);
            this.detail = "";
        } else {
            this.user = address.substring(0, plus);
            this.detail = address.substring(plus + 1, at2);
        }
        this.domain = address.substring(at2 + 1);
    }

    public boolean isToYobi() {
        Configuration imapConfig = Configuration.root().getConfig("imap");
        String yobiAddr = imapConfig.getString("address", imapConfig.getString("user"));
        return this.equalsExceptDetails(new EmailAddressWithDetail(yobiAddr));
    }

    @Nonnull
    public String getUser() {
        return this.user;
    }

    @Nonnull
    public String getDetail() {
        return this.detail;
    }

    @Nonnull
    public String getDomain() {
        return this.domain;
    }

    public void setDetail(@Nonnull String detail) {
        if (detail == null) {
            throw new IllegalArgumentException("detail must not be null");
        }
        this.detail = detail;
    }

    public boolean equalsExceptDetails(@Nonnull EmailAddressWithDetail that) {
        return this.getUser().equals(that.getUser()) && this.getDomain().equals(that.getDomain());
    }

    public String toString() {
        return StringUtils.join((Object[])new String[]{this.user, this.detail}, (String)"+") + "@" + this.domain;
    }
}

