/*
 * Decompiled with CFR 0.152.
 */
package mailbox;

import com.sun.mail.imap.IMAPMessage;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import models.User;
import org.apache.commons.lang.ArrayUtils;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IMAPMessageUtil {
    public static User extractSender(Message msg) throws MessagingException {
        for (Address addr : msg.getFrom()) {
            User user = User.findByEmail(((InternetAddress)addr).getAddress());
            if (user.equals(User.anonymous)) continue;
            return user;
        }
        return User.anonymous;
    }

    public static String asString(IMAPMessage msg) throws MessagingException {
        return String.format("{Subject: %s, From: %s, To: %s}", msg.getSubject(), ArrayUtils.toString((Object)msg.getFrom()), ArrayUtils.toString((Object)msg.getAllRecipients()));
    }

    public static String getIdLeftFromMessageId(String messageId) {
        int start = messageId.indexOf(60);
        int at2 = messageId.indexOf(64);
        return messageId.substring(start + 1, at2).trim().replaceFirst("^/", "");
    }
}

