/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import models.Attachment;
import models.Comment;
import models.IssueLabel;
import models.Mention;
import models.NotificationEvent;
import models.Project;
import models.TitleHead;
import models.User;
import models.Watch;
import models.enumeration.ResourceType;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Duration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.format.Formats;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.F;
import utils.JodaDateUtil;

@MappedSuperclass
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class AbstractPosting
extends Model
implements ResourceConvertible,
EntityBean {
    public static final Model.Finder<Long, AbstractPosting> finder = new Model.Finder(Long.class, AbstractPosting.class);
    public static final int FIRST_PAGE_NUMBER = 0;
    public static final int NUMBER_OF_ONE_MORE_COMMENTS = 1;
    private static final long serialVersionUID = 1L;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @Size(max=255)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String title;
    @Lob
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String body;
    @Lob
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String history;
    @Constraints.Required
    @Formats.DateTime(pattern="YYYY/MM/DD/hh/mm/ss")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    @Constraints.Required
    @Formats.DateTime(pattern="YYYY/MM/DD/hh/mm/ss")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date updatedDate;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long authorId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String authorLoginId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String authorName;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long updatedByAuthorId;
    @Transient
    public User author;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    protected Long number;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public int numOfComments;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Boolean isPublish;
    private static String _EBEAN_MARKER = "models.AbstractPosting";

    public abstract int computeNumOfComments();

    public AbstractPosting() {
        Comparable<Boolean> comparable = false;
        AbstractPosting abstractPosting = this;
        abstractPosting.setIsPublish((Boolean)comparable);
        comparable = JodaDateUtil.now();
        abstractPosting = this;
        abstractPosting.setCreatedDate((Date)comparable);
        comparable = JodaDateUtil.now();
        abstractPosting = this;
        abstractPosting.setUpdatedDate((Date)comparable);
    }

    public AbstractPosting(Project project2, User author, String title, String body) {
        this();
        this.setAuthor(author);
        Object object = project2;
        AbstractPosting abstractPosting = this;
        abstractPosting.setProject((Project)object);
        object = title;
        abstractPosting = this;
        abstractPosting.setTitle((String)object);
        object = body;
        abstractPosting = this;
        abstractPosting.setBody((String)object);
    }

    protected abstract Long increaseNumber();

    protected abstract void fixLastNumber();

    public Long getNumber() {
        return this._ebean_get_number();
    }

    public void setNumber(Long number) {
        this._ebean_set_number(number);
    }

    @Transactional
    public void save() {
        if (this._ebean_get_number() == null) {
            this._ebean_set_number(this.increaseNumber());
        }
        int n = this.computeNumOfComments();
        AbstractPosting abstractPosting = this;
        abstractPosting.setNumOfComments(n);
        try {
            super.save();
            abstractPosting = this;
            Object object = null;
            object = abstractPosting.getProject();
            Project project2 = object;
            abstractPosting = this;
            object = null;
            object = abstractPosting.getTitle();
            TitleHead.saveTitleHeadKeyword(project2, (String)object);
            this.updateMention();
        }
        catch (PersistenceException e) {
            Long oldNumber = this._ebean_get_number();
            this.fixLastNumber();
            this._ebean_set_number(this.increaseNumber());
            if (!oldNumber.equals(this._ebean_get_number())) {
                Logger.warn((String)String.format("%s/%s: Invalid last number %d is fixed to %d", new Object[]{this.asResource().getProject(), this.asResource().getType(), oldNumber, this._ebean_get_number()}));
                super.save();
            }
            throw e;
        }
    }

    @Transactional
    public void saveWithNumber(long number) {
        this._ebean_set_number(number);
        int n = this.computeNumOfComments();
        AbstractPosting abstractPosting = this;
        abstractPosting.setNumOfComments(n);
        super.save();
        this.updateMention();
    }

    @Transactional
    public void update() {
        try {
            int n = this.computeNumOfComments();
            AbstractPosting abstractPosting = this;
            abstractPosting.setNumOfComments(n);
            super.update();
        }
        catch (PersistenceException ole) {
            Logger.warn((String)("PersistenceException: " + ole.getMessage()));
        }
        catch (Exception e) {
            Logger.warn((String)e.getMessage());
        }
        this.updateMention();
    }

    public void directSave() {
        this.updateMention();
        super.save();
    }

    public void updateNumber() {
        this._ebean_set_number(this.increaseNumber());
        super.update();
    }

    public static <T> T findByNumber(Model.Finder<Long, T> finder, Project project2, Long number) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return (T)finder.where().eq("project.id", (Object)l).eq("number", (Object)number).findUnique();
    }

    public static <T> List<T> findByProject(Model.Finder<Long, T> finder, Project project2) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return finder.where().eq("project.id", (Object)l).findList();
    }

    public Duration ago() {
        AbstractPosting abstractPosting = this;
        Date date = null;
        date = abstractPosting.getCreatedDate();
        return JodaDateUtil.ago(date);
    }

    public Resource asResource(final ResourceType type) {
        return new Resource(){

            @Override
            public String getId() {
                AbstractPosting abstractPosting = AbstractPosting.this;
                Long l = null;
                l = abstractPosting.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                AbstractPosting abstractPosting = AbstractPosting.this;
                Project project2 = null;
                project2 = abstractPosting.getProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return type;
            }

            @Override
            public Long getAuthorId() {
                AbstractPosting abstractPosting = AbstractPosting.this;
                Long l = null;
                l = abstractPosting.getAuthorId();
                return l;
            }
        };
    }

    @Transient
    public void setAuthor(User user) {
        Model model = user;
        Object object = null;
        object = model.getId();
        model = this;
        model.setAuthorId((Long)object);
        model = user;
        object = null;
        object = model.getLoginId();
        model = this;
        model.setAuthorLoginId((String)object);
        model = user;
        object = null;
        object = model.getName();
        model = this;
        model.setAuthorName((String)object);
    }

    @Transient
    public User getAuthor() {
        AbstractPosting abstractPosting = this;
        String string = null;
        string = abstractPosting.getAuthorLoginId();
        return User.findByLoginId(string);
    }

    public abstract List<? extends Comment> getComments();

    public void delete() {
        for (Comment comment : this.getComments()) {
            comment.delete();
        }
        AbstractPosting abstractPosting = this;
        Object object = null;
        object = abstractPosting.getProject();
        Project project2 = object;
        abstractPosting = this;
        object = null;
        object = abstractPosting.getTitle();
        TitleHead.deleteTitleHeadKeyword(project2, (String)object);
        Attachment.deleteAll(this.asResource());
        NotificationEvent.deleteBy(this.asResource());
        super.delete();
    }

    public void deleteOnly() {
        super.delete();
    }

    public void updateProperties() {
    }

    @Transient
    public Set<User> getWatchers() {
        return this.getWatchers(true);
    }

    @Transient
    public Set<User> getWatchers(boolean allowedWatchersOnly) {
        return this.getWatchers(new HashSet<User>(), allowedWatchersOnly);
    }

    @Transient
    public Set<User> getWatchers(Set<User> baseWatchers, boolean allowedWatchersOnly) {
        HashSet<User> actualWatchers = new HashSet<User>();
        actualWatchers.addAll(baseWatchers);
        actualWatchers.add(this.getAuthor());
        return Watch.findActualWatchers(actualWatchers, this.asResource(), allowedWatchersOnly);
    }

    protected void updateMention() {
        AbstractPosting abstractPosting = this;
        String string = null;
        string = abstractPosting.getBody();
        if (string != null) {
            abstractPosting = this;
            string = null;
            string = abstractPosting.getBody();
            Mention.update(this.asResource(), NotificationEvent.getMentionedUsers(string));
        }
    }

    public abstract void checkLabels() throws IssueLabel.IssueLabelException;

    public boolean isAuthoredBy(@Nonnull User user) {
        Model model = this;
        String string = null;
        String string2 = string = model.getAuthorLoginId();
        model = user;
        string = null;
        string = model.getLoginId();
        return StringUtils.equalsIgnoreCase((String)string2, (String)string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getTitle() {
        return this._ebean_get_title();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTitle(String string) {
        this._ebean_set_title(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getBody() {
        return this._ebean_get_body();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setBody(String string) {
        this._ebean_set_body(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getHistory() {
        return this._ebean_get_history();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setHistory(String string) {
        this._ebean_set_history(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getUpdatedDate() {
        return this._ebean_get_updatedDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUpdatedDate(Date date) {
        this._ebean_set_updatedDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getAuthorId() {
        return this._ebean_get_authorId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorId(Long l) {
        this._ebean_set_authorId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getAuthorLoginId() {
        return this._ebean_get_authorLoginId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorLoginId(String string) {
        this._ebean_set_authorLoginId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getAuthorName() {
        return this._ebean_get_authorName();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorName(String string) {
        this._ebean_set_authorName(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getUpdatedByAuthorId() {
        return this._ebean_get_updatedByAuthorId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUpdatedByAuthorId(Long l) {
        this._ebean_set_updatedByAuthorId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public int getNumOfComments() {
        return this._ebean_get_numOfComments();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNumOfComments(int n) {
        this._ebean_set_numOfComments(n);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Boolean getIsPublish() {
        return this.isPublish;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsPublish(Boolean bl) {
        this.isPublish = bl;
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_title() {
        this._ebean_intercept.preGetter("title");
        return this.title;
    }

    protected void _ebean_set_title(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "title", (Object)this._ebean_get_title(), (Object)newValue);
        this.title = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_title() {
        return this.title;
    }

    protected void _ebean_setni_title(String _newValue) {
        this.title = _newValue;
    }

    protected String _ebean_get_body() {
        this._ebean_intercept.preGetter("body");
        return this.body;
    }

    protected void _ebean_set_body(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "body", (Object)this._ebean_get_body(), (Object)newValue);
        this.body = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_body() {
        return this.body;
    }

    protected void _ebean_setni_body(String _newValue) {
        this.body = _newValue;
    }

    protected String _ebean_get_history() {
        this._ebean_intercept.preGetter("history");
        return this.history;
    }

    protected void _ebean_set_history(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "history", (Object)this._ebean_get_history(), (Object)newValue);
        this.history = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_history() {
        return this.history;
    }

    protected void _ebean_setni_history(String _newValue) {
        this.history = _newValue;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
    }

    protected Date _ebean_get_updatedDate() {
        this._ebean_intercept.preGetter("updatedDate");
        return this.updatedDate;
    }

    protected void _ebean_set_updatedDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "updatedDate", (Object)this._ebean_get_updatedDate(), (Object)newValue);
        this.updatedDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_updatedDate() {
        return this.updatedDate;
    }

    protected void _ebean_setni_updatedDate(Date _newValue) {
        this.updatedDate = _newValue;
    }

    protected Long _ebean_get_authorId() {
        this._ebean_intercept.preGetter("authorId");
        return this.authorId;
    }

    protected void _ebean_set_authorId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "authorId", (Object)this._ebean_get_authorId(), (Object)newValue);
        this.authorId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_authorId() {
        return this.authorId;
    }

    protected void _ebean_setni_authorId(Long _newValue) {
        this.authorId = _newValue;
    }

    protected String _ebean_get_authorLoginId() {
        this._ebean_intercept.preGetter("authorLoginId");
        return this.authorLoginId;
    }

    protected void _ebean_set_authorLoginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "authorLoginId", (Object)this._ebean_get_authorLoginId(), (Object)newValue);
        this.authorLoginId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_authorLoginId() {
        return this.authorLoginId;
    }

    protected void _ebean_setni_authorLoginId(String _newValue) {
        this.authorLoginId = _newValue;
    }

    protected String _ebean_get_authorName() {
        this._ebean_intercept.preGetter("authorName");
        return this.authorName;
    }

    protected void _ebean_set_authorName(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "authorName", (Object)this._ebean_get_authorName(), (Object)newValue);
        this.authorName = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_authorName() {
        return this.authorName;
    }

    protected void _ebean_setni_authorName(String _newValue) {
        this.authorName = _newValue;
    }

    protected Long _ebean_get_updatedByAuthorId() {
        this._ebean_intercept.preGetter("updatedByAuthorId");
        return this.updatedByAuthorId;
    }

    protected void _ebean_set_updatedByAuthorId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "updatedByAuthorId", (Object)this._ebean_get_updatedByAuthorId(), (Object)newValue);
        this.updatedByAuthorId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_updatedByAuthorId() {
        return this.updatedByAuthorId;
    }

    protected void _ebean_setni_updatedByAuthorId(Long _newValue) {
        this.updatedByAuthorId = _newValue;
    }

    protected User _ebean_get_author() {
        return this.author;
    }

    protected void _ebean_set_author(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "author", (Object)this._ebean_get_author(), (Object)newValue);
        this.author = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_author() {
        return this.author;
    }

    protected void _ebean_setni_author(User _newValue) {
        this.author = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected Long _ebean_get_number() {
        this._ebean_intercept.preGetter("number");
        return this.number;
    }

    protected void _ebean_set_number(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "number", (Object)this._ebean_get_number(), (Object)newValue);
        this.number = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_number() {
        return this.number;
    }

    protected void _ebean_setni_number(Long _newValue) {
        this.number = _newValue;
    }

    protected int _ebean_get_numOfComments() {
        this._ebean_intercept.preGetter("numOfComments");
        return this.numOfComments;
    }

    protected void _ebean_set_numOfComments(int newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "numOfComments", this._ebean_get_numOfComments(), newValue);
        this.numOfComments = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected int _ebean_getni_numOfComments() {
        return this.numOfComments;
    }

    protected void _ebean_setni_numOfComments(int _newValue) {
        this.numOfComments = _newValue;
    }

    protected Boolean _ebean_get_isPublish() {
        return this.isPublish;
    }

    protected void _ebean_set_isPublish(Boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "isPublish", (Object)this._ebean_get_isPublish(), (Object)newValue);
        this.isPublish = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Boolean _ebean_getni_isPublish() {
        return this.isPublish;
    }

    protected void _ebean_setni_isPublish(Boolean _newValue) {
        this.isPublish = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        AbstractPosting abstractPosting = new AbstractPosting();
        abstractPosting.id = this.id;
        abstractPosting.title = this.title;
        abstractPosting.body = this.body;
        abstractPosting.history = this.history;
        abstractPosting.createdDate = this.createdDate;
        abstractPosting.updatedDate = this.updatedDate;
        abstractPosting.authorId = this.authorId;
        abstractPosting.authorLoginId = this.authorLoginId;
        abstractPosting.authorName = this.authorName;
        abstractPosting.updatedByAuthorId = this.updatedByAuthorId;
        abstractPosting.project = this.project;
        abstractPosting.number = this.number;
        abstractPosting.numOfComments = this.numOfComments;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        AbstractPosting p = (AbstractPosting)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.title;
            }
            case 3: {
                return p.body;
            }
            case 4: {
                return p.history;
            }
            case 5: {
                return p.createdDate;
            }
            case 6: {
                return p.updatedDate;
            }
            case 7: {
                return p.authorId;
            }
            case 8: {
                return p.authorLoginId;
            }
            case 9: {
                return p.authorName;
            }
            case 10: {
                return p.updatedByAuthorId;
            }
            case 11: {
                return p.author;
            }
            case 12: {
                return p.project;
            }
            case 13: {
                return p.number;
            }
            case 14: {
                return p.numOfComments;
            }
            case 15: {
                return p.isPublish;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        AbstractPosting p = (AbstractPosting)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_title();
            }
            case 3: {
                return p._ebean_get_body();
            }
            case 4: {
                return p._ebean_get_history();
            }
            case 5: {
                return p._ebean_get_createdDate();
            }
            case 6: {
                return p._ebean_get_updatedDate();
            }
            case 7: {
                return p._ebean_get_authorId();
            }
            case 8: {
                return p._ebean_get_authorLoginId();
            }
            case 9: {
                return p._ebean_get_authorName();
            }
            case 10: {
                return p._ebean_get_updatedByAuthorId();
            }
            case 11: {
                return p._ebean_get_author();
            }
            case 12: {
                return p._ebean_get_project();
            }
            case 13: {
                return p._ebean_get_number();
            }
            case 14: {
                return p._ebean_get_numOfComments();
            }
            case 15: {
                return p._ebean_get_isPublish();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        AbstractPosting p = (AbstractPosting)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.title = (String)arg;
                return;
            }
            case 3: {
                p.body = (String)arg;
                return;
            }
            case 4: {
                p.history = (String)arg;
                return;
            }
            case 5: {
                p.createdDate = (Date)arg;
                return;
            }
            case 6: {
                p.updatedDate = (Date)arg;
                return;
            }
            case 7: {
                p.authorId = (Long)arg;
                return;
            }
            case 8: {
                p.authorLoginId = (String)arg;
                return;
            }
            case 9: {
                p.authorName = (String)arg;
                return;
            }
            case 10: {
                p.updatedByAuthorId = (Long)arg;
                return;
            }
            case 11: {
                p.author = (User)arg;
                return;
            }
            case 12: {
                p.project = (Project)arg;
                return;
            }
            case 13: {
                p.number = (Long)arg;
                return;
            }
            case 14: {
                p.numOfComments = (Integer)arg;
                return;
            }
            case 15: {
                p.isPublish = (Boolean)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        AbstractPosting p = (AbstractPosting)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_body((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_history((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_updatedDate((Date)arg);
                return;
            }
            case 7: {
                p._ebean_set_authorId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_set_authorLoginId((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_authorName((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_updatedByAuthorId((Long)arg);
                return;
            }
            case 11: {
                p._ebean_set_author((User)arg);
                return;
            }
            case 12: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 13: {
                p._ebean_set_number((Long)arg);
                return;
            }
            case 14: {
                p._ebean_set_numOfComments((Integer)arg);
                return;
            }
            case 15: {
                p._ebean_set_isPublish((Boolean)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "title", "body", "history", "createdDate", "updatedDate", "authorId", "authorLoginId", "authorName", "updatedByAuthorId", "author", "project", "number", "numOfComments", "isPublish"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        AbstractPosting abstractPosting = this;
        synchronized (abstractPosting) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((AbstractPosting)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new AbstractPosting();
    }
}

