/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import models.Issue;
import models.NotificationEvent;
import models.Project;
import models.TimelineItem;
import models.enumeration.EventType;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueEvent
extends Model
implements TimelineItem,
EntityBean {
    private static final long serialVersionUID = 4029013291153199185L;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date created;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String senderLoginId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String senderEmail;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Issue issue;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public EventType eventType;
    @Lob
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String oldValue;
    @Lob
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String newValue;
    private static final int DRAFT_TIME_IN_MILLIS = Configuration.root().getMilliseconds("application.issue-event.draft-time", Long.valueOf(30000L)).intValue();
    public static final Model.Finder<Long, IssueEvent> find = new Model.Finder(Long.class, IssueEvent.class);
    private static String _EBEAN_MARKER = "models.IssueEvent";

    public static void add(IssueEvent event) {
        Date draftDate = DateTime.now().minusMillis(DRAFT_TIME_IN_MILLIS).toDate();
        Model model = event;
        Object object = null;
        object = model.getIssue();
        model = object;
        object = null;
        object = model.getId();
        IssueEvent lastEvent = (IssueEvent)find.where().eq("issue.id", object).gt("created", (Object)draftDate).orderBy("id desc").setMaxRows(1).findUnique();
        if (lastEvent != null && IssueEvent.isSameUserEventAsPrevious(event, lastEvent)) {
            model = lastEvent;
            object = null;
            object = model.getOldValue();
            model = event;
            model.setOldValue((String)object);
            lastEvent.delete();
            model = event;
            object = null;
            Object object2 = object = model.getOldValue();
            model = event;
            object = null;
            object = model.getNewValue();
            if (StringUtils.equals((CharSequence)object2, (CharSequence)object)) {
                return;
            }
        }
        event.save();
    }

    public static void addWithoutSkipEvent(IssueEvent event) {
        Date draftDate = DateTime.now().minusMillis(DRAFT_TIME_IN_MILLIS).toDate();
        Model model = event;
        Object object = null;
        object = model.getIssue();
        model = object;
        object = null;
        object = model.getId();
        IssueEvent lastEvent = (IssueEvent)find.where().eq("issue.id", object).gt("created", (Object)draftDate).orderBy("id desc").setMaxRows(1).findUnique();
        if (lastEvent != null && IssueEvent.isSameUserEventAsPrevious(event, lastEvent) && IssueEvent.isRevertingTheValue(event, lastEvent)) {
            lastEvent.delete();
            return;
        }
        event.save();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRevertingTheValue(IssueEvent event, IssueEvent lastEvent) {
        IssueEvent issueEvent = event;
        String string = null;
        String string2 = string = issueEvent.getOldValue();
        issueEvent = lastEvent;
        string = null;
        string = issueEvent.getNewValue();
        if (!StringUtils.equals((CharSequence)string2, (CharSequence)string)) return false;
        issueEvent = event;
        string = null;
        String string3 = string = issueEvent.getNewValue();
        issueEvent = lastEvent;
        string = null;
        string = issueEvent.getOldValue();
        if (!StringUtils.equals((CharSequence)string3, (CharSequence)string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSameUserEventAsPrevious(IssueEvent event, IssueEvent lastEvent) {
        IssueEvent issueEvent = lastEvent;
        Object var3_3 = null;
        EventType eventType = issueEvent.getEventType();
        issueEvent = event;
        Object var3_5 = null;
        EventType eventType2 = issueEvent.getEventType();
        if (eventType != eventType2) return false;
        issueEvent = event;
        Object var3_7 = null;
        String string = issueEvent.getSenderLoginId();
        issueEvent = lastEvent;
        Object var3_9 = null;
        String string2 = issueEvent.getSenderLoginId();
        if (!StringUtils.equals((CharSequence)string, (CharSequence)string2)) return false;
        return true;
    }

    public static void addFromNotificationEvent(NotificationEvent notiEvent, Issue updatedIssue, String senderLoginId) {
        IssueEvent event = new IssueEvent();
        Model model = notiEvent;
        Object object = null;
        object = model.getCreated();
        model = event;
        model.setCreated((Date)object);
        object = senderLoginId;
        model = event;
        model.setSenderLoginId((String)object);
        object = updatedIssue;
        model = event;
        model.setIssue((Issue)object);
        model = notiEvent;
        object = null;
        object = model.getEventType();
        model = event;
        model.setEventType((EventType)((Object)object));
        object = notiEvent.oldValue;
        model = event;
        model.setOldValue((String)object);
        object = notiEvent.newValue;
        model = event;
        model.setNewValue((String)object);
        IssueEvent.add(event);
    }

    public static void addFromNotificationEventWithoutSkipEvent(NotificationEvent notiEvent, Issue updatedIssue, String senderLoginId) {
        IssueEvent event = new IssueEvent();
        Model model = notiEvent;
        Object object = null;
        object = model.getCreated();
        model = event;
        model.setCreated((Date)object);
        object = senderLoginId;
        model = event;
        model.setSenderLoginId((String)object);
        object = updatedIssue;
        model = event;
        model.setIssue((Issue)object);
        model = notiEvent;
        object = null;
        object = model.getEventType();
        model = event;
        model.setEventType((EventType)((Object)object));
        object = notiEvent.oldValue;
        model = event;
        model.setOldValue((String)object);
        object = notiEvent.newValue;
        model = event;
        model.setNewValue((String)object);
        IssueEvent.addWithoutSkipEvent(event);
    }

    @Override
    public Date getDate() {
        IssueEvent issueEvent = this;
        Date date = null;
        date = issueEvent.getCreated();
        return date;
    }

    public static Set<Issue> findReferredIssue(String message, Project project2) {
        Matcher m = Issue.ISSUE_PATTERN.matcher(message);
        HashSet<Issue> referredIssues = new HashSet<Issue>();
        while (m.find()) {
            String issueText = m.group();
            String issueNumber = issueText.substring(1);
            Issue issue2 = Issue.findByNumber(project2, Long.parseLong(issueNumber));
            if (issue2 == null) continue;
            referredIssues.add(issue2);
        }
        return referredIssues;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreated() {
        return this._ebean_get_created();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreated(Date date) {
        this._ebean_set_created(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSenderLoginId() {
        return this._ebean_get_senderLoginId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSenderLoginId(String string) {
        this._ebean_set_senderLoginId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSenderEmail() {
        return this._ebean_get_senderEmail();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSenderEmail(String string) {
        this._ebean_set_senderEmail(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Issue getIssue() {
        return this._ebean_get_issue();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssue(Issue issue2) {
        this._ebean_set_issue(issue2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public EventType getEventType() {
        return this._ebean_get_eventType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEventType(EventType eventType) {
        this._ebean_set_eventType(eventType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getOldValue() {
        return this._ebean_get_oldValue();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOldValue(String string) {
        this._ebean_set_oldValue(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getNewValue() {
        return this._ebean_get_newValue();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNewValue(String string) {
        this._ebean_set_newValue(string);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected Date _ebean_get_created() {
        this._ebean_intercept.preGetter("created");
        return this.created;
    }

    protected void _ebean_set_created(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "created", (Object)this._ebean_get_created(), (Object)newValue);
        this.created = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_created() {
        return this.created;
    }

    protected void _ebean_setni_created(Date _newValue) {
        this.created = _newValue;
    }

    protected String _ebean_get_senderLoginId() {
        this._ebean_intercept.preGetter("senderLoginId");
        return this.senderLoginId;
    }

    protected void _ebean_set_senderLoginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "senderLoginId", (Object)this._ebean_get_senderLoginId(), (Object)newValue);
        this.senderLoginId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_senderLoginId() {
        return this.senderLoginId;
    }

    protected void _ebean_setni_senderLoginId(String _newValue) {
        this.senderLoginId = _newValue;
    }

    protected String _ebean_get_senderEmail() {
        this._ebean_intercept.preGetter("senderEmail");
        return this.senderEmail;
    }

    protected void _ebean_set_senderEmail(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "senderEmail", (Object)this._ebean_get_senderEmail(), (Object)newValue);
        this.senderEmail = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_senderEmail() {
        return this.senderEmail;
    }

    protected void _ebean_setni_senderEmail(String _newValue) {
        this.senderEmail = _newValue;
    }

    protected Issue _ebean_get_issue() {
        this._ebean_intercept.preGetter("issue");
        return this.issue;
    }

    protected void _ebean_set_issue(Issue newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "issue", (Object)this._ebean_get_issue(), (Object)newValue);
        this.issue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Issue _ebean_getni_issue() {
        return this.issue;
    }

    protected void _ebean_setni_issue(Issue _newValue) {
        this.issue = _newValue;
    }

    protected EventType _ebean_get_eventType() {
        this._ebean_intercept.preGetter("eventType");
        return this.eventType;
    }

    protected void _ebean_set_eventType(EventType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "eventType", (Object)this._ebean_get_eventType(), (Object)newValue);
        this.eventType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected EventType _ebean_getni_eventType() {
        return this.eventType;
    }

    protected void _ebean_setni_eventType(EventType _newValue) {
        this.eventType = _newValue;
    }

    protected String _ebean_get_oldValue() {
        this._ebean_intercept.preGetter("oldValue");
        return this.oldValue;
    }

    protected void _ebean_set_oldValue(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "oldValue", (Object)this._ebean_get_oldValue(), (Object)newValue);
        this.oldValue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_oldValue() {
        return this.oldValue;
    }

    protected void _ebean_setni_oldValue(String _newValue) {
        this.oldValue = _newValue;
    }

    protected String _ebean_get_newValue() {
        this._ebean_intercept.preGetter("newValue");
        return this.newValue;
    }

    protected void _ebean_set_newValue(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "newValue", (Object)this._ebean_get_newValue(), (Object)newValue);
        this.newValue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_newValue() {
        return this.newValue;
    }

    protected void _ebean_setni_newValue(String _newValue) {
        this.newValue = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        IssueEvent issueEvent = new IssueEvent();
        issueEvent.id = this.id;
        issueEvent.created = this.created;
        issueEvent.senderLoginId = this.senderLoginId;
        issueEvent.senderEmail = this.senderEmail;
        issueEvent.issue = this.issue;
        issueEvent.eventType = this.eventType;
        issueEvent.oldValue = this.oldValue;
        issueEvent.newValue = this.newValue;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        IssueEvent p = (IssueEvent)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.created;
            }
            case 3: {
                return p.senderLoginId;
            }
            case 4: {
                return p.senderEmail;
            }
            case 5: {
                return p.issue;
            }
            case 6: {
                return p.eventType;
            }
            case 7: {
                return p.oldValue;
            }
            case 8: {
                return p.newValue;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        IssueEvent p = (IssueEvent)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_created();
            }
            case 3: {
                return p._ebean_get_senderLoginId();
            }
            case 4: {
                return p._ebean_get_senderEmail();
            }
            case 5: {
                return p._ebean_get_issue();
            }
            case 6: {
                return p._ebean_get_eventType();
            }
            case 7: {
                return p._ebean_get_oldValue();
            }
            case 8: {
                return p._ebean_get_newValue();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        IssueEvent p = (IssueEvent)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.created = (Date)arg;
                return;
            }
            case 3: {
                p.senderLoginId = (String)arg;
                return;
            }
            case 4: {
                p.senderEmail = (String)arg;
                return;
            }
            case 5: {
                p.issue = (Issue)arg;
                return;
            }
            case 6: {
                p.eventType = (EventType)((Object)arg);
                return;
            }
            case 7: {
                p.oldValue = (String)arg;
                return;
            }
            case 8: {
                p.newValue = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        IssueEvent p = (IssueEvent)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_created((Date)arg);
                return;
            }
            case 3: {
                p._ebean_set_senderLoginId((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_senderEmail((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_issue((Issue)arg);
                return;
            }
            case 6: {
                p._ebean_set_eventType((EventType)((Object)arg));
                return;
            }
            case 7: {
                p._ebean_set_oldValue((String)arg);
                return;
            }
            case 8: {
                p._ebean_set_newValue((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "created", "senderLoginId", "senderEmail", "issue", "eventType", "oldValue", "newValue"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        IssueEvent issueEvent = this;
        synchronized (issueEvent) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((IssueEvent)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new IssueEvent();
    }
}

