/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import com.google.common.collect.Lists;
import controllers.Application;
import info.schleichardt.play2.mailplugin.Mailer;
import java.beans.PropertyChangeEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import mailbox.EmailAddressWithDetail;
import models.CommentThread;
import models.Issue;
import models.IssueComment;
import models.MailRecipient;
import models.NotificationEvent;
import models.User;
import models.enumeration.EventType;
import models.enumeration.ResourceType;
import models.enumeration.UserState;
import models.resource.Resource;
import notification.INotificationEvent;
import notification.MergedNotificationEvent;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.joda.time.DateTime;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import play.Configuration;
import play.Logger;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.Akka;
import play.libs.F;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import utils.Config;
import utils.HttpUtil;
import utils.Markdown;
import utils.Url;
import views.html.common.notificationMail;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class NotificationMail
extends Model
implements EntityBean {
    private static final long serialVersionUID = 1L;
    private static final int RECIPIENT_NO_LIMIT = 0;
    static boolean hideAddress = true;
    private static int recipientLimit = 0;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @OneToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public NotificationEvent notificationEvent;
    public static final Model.Finder<Long, NotificationMail> find = new Model.Finder(Long.class, NotificationMail.class);
    private static String _EBEAN_MARKER = "models.NotificationMail";

    public static void onStart() {
        hideAddress = Configuration.root().getBoolean("application.notification.bymail.hideAddress", Boolean.valueOf(true));
        recipientLimit = Configuration.root().getInt("application.notification.bymail.recipientLimit", Integer.valueOf(0));
        if (NotificationMail.notificationEnabled()) {
            NotificationMail.startSchedule();
        }
    }

    private static boolean notificationEnabled() {
        Configuration config = Configuration.root();
        Boolean notificationEnabled = config.getBoolean("notification.bymail.enabled");
        return notificationEnabled == null || notificationEnabled != false;
    }

    public static void startSchedule() {
        Long MAIL_NOTIFICATION_INITDELAY_IN_MILLIS = Configuration.root().getMilliseconds("application.notification.bymail.initdelay", Long.valueOf(5000L));
        Long MAIL_NOTIFICATION_INTERVAL_IN_MILLIS = Configuration.root().getMilliseconds("application.notification.bymail.interval", Long.valueOf(60000L));
        final int MAIL_NOTIFICATION_DELAY_IN_MILLIS = Configuration.root().getMilliseconds("application.notification.bymail.delay", Long.valueOf(180000L)).intValue();
        Akka.system().scheduler().schedule(Duration.create((long)MAIL_NOTIFICATION_INITDELAY_IN_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS), Duration.create((long)MAIL_NOTIFICATION_INTERVAL_IN_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable(){

            @Override
            public void run() {
                try {
                    this.sendMail();
                }
                catch (Exception e) {
                    Logger.warn((String)"Error occurred while sending notification mails", (Throwable)e);
                }
            }

            private void sendMail() {
                Date createdUntil = DateTime.now().minusMillis(MAIL_NOTIFICATION_DELAY_IN_MILLIS).toDate();
                List mails = find.where().lt("notificationEvent.created", (Object)createdUntil).orderBy("notificationEvent.created ASC").findList();
                List events = this.extractEventsAndDelete(mails);
                try {
                    events = NotificationMail.mergeEvents(events);
                }
                catch (Exception e) {
                    Logger.warn((String)"Failed to group events", (Throwable)e);
                }
                for (INotificationEvent event : events) {
                    try {
                        if (!event.resourceExists()) continue;
                        NotificationMail.sendNotification(event);
                    }
                    catch (Exception e) {
                        Logger.warn((String)"Error occurred while sending a notification mail", (Throwable)e);
                    }
                }
            }

            private List<INotificationEvent> extractEventsAndDelete(List<NotificationMail> mails) {
                ArrayList<INotificationEvent> events = new ArrayList<INotificationEvent>();
                for (NotificationMail mail2 : mails) {
                    try {
                        NotificationMail notificationMail2 = mail2;
                        NotificationEvent notificationEvent = null;
                        NotificationEvent event = notificationEvent = notificationMail2.getNotificationEvent();
                        mail2.delete();
                        events.add(event);
                    }
                    catch (Exception e) {
                        Logger.warn((String)"Error occurred while collecting notification events", (Throwable)e);
                    }
                }
                return events;
            }
        }, (ExecutionContext)Akka.system().dispatcher());
    }

    private static List<? extends INotificationEvent> mergeEvents(List<? extends INotificationEvent> events) {
        LinkedList<MergedNotificationEvent> result2 = new LinkedList<MergedNotificationEvent>();
        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        class EventHashKey {
            private final Resource resource;
            private final User sender;

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EventHashKey that = (EventHashKey)o;
                if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
                    return false;
                }
                return !(this.sender != null ? !this.sender.equals(that.sender) : that.sender != null);
            }

            public int hashCode() {
                int result2 = this.resource != null ? this.resource.hashCode() : 0;
                result2 = 31 * result2 + (this.sender != null ? this.sender.hashCode() : 0);
                return result2;
            }

            public EventHashKey(INotificationEvent event) {
                this(event.getResource(), event.getSender());
            }

            public EventHashKey(Resource resource, User sender) {
                this.resource = resource;
                this.sender = sender;
            }
        }
        HashMap<EventHashKey, MergedNotificationEvent> stateChangedEvents = new HashMap<EventHashKey, MergedNotificationEvent>();
        ListIterator<? extends INotificationEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            EventHashKey key;
            MergedNotificationEvent stateChangedEvent;
            INotificationEvent event = it.previous();
            if (event.getType().equals((Object)EventType.ISSUE_STATE_CHANGED) || event.getType().equals((Object)EventType.REVIEW_THREAD_STATE_CHANGED)) {
                MergedNotificationEvent stateChangedEvent2 = new MergedNotificationEvent(event);
                stateChangedEvents.put(new EventHashKey(event), stateChangedEvent2);
                result2.add(0, stateChangedEvent2);
                continue;
            }
            if ((event.getType().equals((Object)EventType.NEW_COMMENT) || event.getType().equals((Object)EventType.NEW_REVIEW_COMMENT)) && (stateChangedEvent = (MergedNotificationEvent)stateChangedEvents.remove(key = new EventHashKey(event.getResource().getContainer(), event.getSender()))) != null) {
                Set<User> commentReceivers;
                Set<User> stateReceivers = stateChangedEvent.findReceivers();
                if (ObjectUtils.equals(stateReceivers, commentReceivers = event.findReceivers())) {
                    stateChangedEvent.getMessageSources().add(0, event);
                    continue;
                }
                HashSet<User> intersect = new HashSet<User>(stateReceivers);
                intersect.retainAll(commentReceivers);
                MergedNotificationEvent mergedEvent = new MergedNotificationEvent(stateChangedEvent, Arrays.asList(event, stateChangedEvent));
                mergedEvent.setReceivers(intersect);
                result2.add(0, mergedEvent);
                MergedNotificationEvent commentEvent = new MergedNotificationEvent(event);
                commentReceivers.removeAll(intersect);
                commentEvent.setReceivers(commentReceivers);
                result2.add(0, commentEvent);
                stateReceivers.removeAll(intersect);
                stateChangedEvent.setReceivers(stateReceivers);
                continue;
            }
            result2.add(0, new MergedNotificationEvent(event));
        }
        return result2;
    }

    private static void sendNotification(INotificationEvent event) {
        Set<User> receivers = event.findReceivers();
        Iterator<User> iterator = receivers.iterator();
        while (iterator.hasNext()) {
            User user;
            User user2 = user = iterator.next();
            UserState userState = null;
            userState = user2.getState();
            if (userState == UserState.ACTIVE) continue;
            iterator.remove();
        }
        receivers.remove(User.anonymous);
        if (StringUtils.isNotBlank((CharSequence)Application.ALLOWED_SENDING_MAIL_DOMAINS)) {
            receivers.removeAll(NotificationMail.getUsersUsingNoAcceptableEmails(receivers));
        }
        if (receivers.isEmpty()) {
            return;
        }
        int partialRecipientSize = NotificationMail.getPartialRecipientSize(receivers);
        if (partialRecipientSize <= 0) {
            return;
        }
        HashMap<String, ArrayList<User>> usersByLang = new HashMap<String, ArrayList<User>>();
        for (User receiver : receivers) {
            String lang = receiver.getPreferredLanguage();
            if (usersByLang.containsKey(lang)) {
                ((List)usersByLang.get(lang)).add(receiver);
                continue;
            }
            usersByLang.put(lang, new ArrayList<User>(Arrays.asList(receiver)));
        }
        for (String langCode : usersByLang.keySet()) {
            List subLists = Lists.partition((List)((List)usersByLang.get(langCode)), (int)partialRecipientSize);
            for (List list2 : subLists) {
                Set<MailRecipient> toList = NotificationMail.getToList(list2);
                Set<MailRecipient> bccList = NotificationMail.getBccList(list2);
                NotificationMail.sendMail(event, toList, bccList, langCode);
            }
        }
    }

    private static String getDomainFromEmail(String email) {
        if (email == null) {
            return null;
        }
        int lastIndex = email.lastIndexOf(64);
        return lastIndex < 0 || lastIndex + 1 >= email.length() ? null : email.substring(lastIndex + 1);
    }

    private static Set<User> getUsersUsingNoAcceptableEmails(Set<User> users2) {
        ArrayList<String> acceptableDomains = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)Application.ALLOWED_SENDING_MAIL_DOMAINS)) {
            for (String domain : Application.ALLOWED_SENDING_MAIL_DOMAINS.split(",")) {
                acceptableDomains.add(StringUtils.defaultString((String)domain, (String)"").toLowerCase().trim());
            }
        }
        HashSet<User> filteredUsers = new HashSet<User>();
        Iterator<User> iterator = users2.iterator();
        while (iterator.hasNext()) {
            User user;
            String domain;
            User user2 = user = iterator.next();
            String string = null;
            string = user2.getEmail();
            domain = NotificationMail.getDomainFromEmail(string);
            if (domain != null && acceptableDomains.contains(domain.toLowerCase())) continue;
            filteredUsers.add(user);
        }
        return filteredUsers;
    }

    public static boolean isAllowedEmailDomains(String email) {
        ArrayList<String> acceptableDomains = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)Application.ALLOWED_SENDING_MAIL_DOMAINS)) {
            return true;
        }
        for (String domain : Application.ALLOWED_SENDING_MAIL_DOMAINS.split(",")) {
            acceptableDomains.add(StringUtils.defaultString((String)domain, (String)"").toLowerCase().trim());
        }
        String domain = NotificationMail.getDomainFromEmail(email);
        return domain != null && acceptableDomains.contains(domain.toLowerCase());
    }

    private static int getPartialRecipientSize(Set<User> receivers) {
        if (recipientLimit == 0) {
            return receivers.size();
        }
        return hideAddress ? recipientLimit - NotificationMail.getDefaultToList().size() : recipientLimit;
    }

    private static Set<MailRecipient> getToList(List<User> users2) {
        return hideAddress ? NotificationMail.getDefaultToList() : NotificationMail.getMailRecipientsFromUsers(users2);
    }

    private static Set<MailRecipient> getBccList(List<User> users2) {
        return hideAddress ? NotificationMail.getMailRecipientsFromUsers(users2) : new HashSet<MailRecipient>();
    }

    private static Set<MailRecipient> getDefaultToList() {
        HashSet<MailRecipient> list2 = new HashSet<MailRecipient>();
        list2.add(new MailRecipient(Config.getEmailFromSmtp(), Config.getSiteName()));
        return list2;
    }

    private static Set<MailRecipient> getMailRecipientsFromUsers(List<User> users2) {
        HashSet<MailRecipient> list2 = new HashSet<MailRecipient>();
        Iterator<User> iterator = users2.iterator();
        while (iterator.hasNext()) {
            User user;
            User user2 = user = iterator.next();
            String string = null;
            String string2 = string = user2.getEmail();
            user2 = user;
            string = null;
            string = user2.getName();
            list2.add(new MailRecipient(string2, string));
        }
        return list2;
    }

    private static void sendMail(INotificationEvent event, Set<MailRecipient> toList, Set<MailRecipient> bccList, String langCode) {
        if (toList.isEmpty()) {
            return;
        }
        EventEmail email = new EventEmail(event);
        email.setCharset("utf-8");
        try {
            Model model = event.getSender();
            Object object = null;
            object = model.getName();
            email.setFrom(Config.getEmailFromSmtp(), (String)object);
            String replyTo = NotificationMail.getReplyTo(event.getResource());
            boolean acceptsReply = false;
            if (replyTo != null) {
                email.addReplyTo(replyTo);
                acceptsReply = true;
            }
            for (MailRecipient recipient : toList) {
                email.addTo(recipient.email, recipient.name);
            }
            for (MailRecipient recipient : bccList) {
                email.addBcc(recipient.email, recipient.name);
            }
            Lang lang = Lang.apply((String)langCode);
            String message = event.getMessage(lang);
            String plainMessage = event.getPlainMessage(lang);
            if (message == null || plainMessage == null) {
                return;
            }
            String urlToView = event.getUrlToView();
            email.setSubject(event.getTitle());
            Resource resource = event.getResource();
            if (resource.getType() == ResourceType.ISSUE_COMMENT) {
                IssueComment issueComment = (IssueComment)IssueComment.find.byId((Object)Long.valueOf(resource.getId()));
                model = issueComment;
                object = null;
                object = model.getIssue();
                resource = ((Issue)object).asResource();
            }
            if (event.getType() == EventType.ISSUE_BODY_CHANGED || event.getType() == EventType.POSTING_BODY_CHANGED) {
                email.setHtmlMsg(NotificationMail.removeHeadAnchor(NotificationMail.getRenderedMail(lang, message, urlToView, resource, acceptsReply)));
            } else {
                email.setHtmlMsg(NotificationMail.removeHeadAnchor(NotificationMail.getHtmlMessage(lang, message, urlToView, resource, acceptsReply)));
            }
            email.setTextMsg(NotificationMail.getPlainMessage(lang, plainMessage, Url.create(urlToView), acceptsReply));
            email.addReferences();
            email.setSentDate(event.getCreatedDate());
            Mailer.send((Email)email);
            String escapedTitle = email.getSubject().replace("\"", "\\\"");
            HashSet recipients = new HashSet();
            recipients.addAll(email.getToAddresses());
            recipients.addAll(email.getCcAddresses());
            recipients.addAll(email.getBccAddresses());
            String logEntry = String.format("\"%s\" %s", escapedTitle, recipients);
            Logger.of((String)"mail.out").info(logEntry);
        }
        catch (Exception e) {
            Logger.warn((String)("Failed to send a notification: " + (Object)((Object)email) + "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private static String removeHeadAnchor(String htmlText) {
        return htmlText.replaceAll("head-anchor\">#</a>", "\"></a>");
    }

    @Nullable
    public static String getReplyTo(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (Config.getEmailFromImap() == null) {
            return null;
        }
        String detail = null;
        switch (resource.getType()) {
            case ISSUE_COMMENT: 
            case NONISSUE_COMMENT: 
            case COMMIT_COMMENT: 
            case REVIEW_COMMENT: {
                detail = resource.getContainer().getDetail();
                break;
            }
            case ISSUE_POST: 
            case BOARD_POST: 
            case COMMIT: {
                detail = resource.getDetail();
                break;
            }
        }
        if (detail != null) {
            EmailAddressWithDetail addr = new EmailAddressWithDetail(Config.getEmailFromImap());
            addr.setDetail(HttpUtil.getEncodeEachPathName(detail));
            return addr.toString();
        }
        return null;
    }

    private static String getHtmlMessage(Lang lang, String message, String urlToView, Resource resource, boolean acceptsReply) {
        String renderred = null;
        renderred = resource == null || resource.getType() == ResourceType.ORGANIZATION ? Markdown.render(message) : Markdown.render(message, resource.getProject(), lang.code());
        return NotificationMail.getRenderedMail(lang, renderred, urlToView, resource, acceptsReply);
    }

    private static String getRenderedMail(Lang lang, String message, String urlToView, Resource resource, boolean acceptsReply) {
        String content = notificationMail.render(lang, message, urlToView, resource, acceptsReply).toString();
        Document doc = Jsoup.parse((String)content);
        NotificationMail.handleLinks(doc);
        NotificationMail.handleImages(doc);
        doc.outputSettings().prettyPrint(false);
        String html = doc.html();
        return html;
    }

    public static void handleLinks(Document doc) {
        String hostname = Config.getHostname();
        String[] attrNames = new String[]{"src", "href"};
        Boolean noreferrer = Configuration.root().getBoolean("application.noreferrer", Boolean.valueOf(false));
        for (String attrName : attrNames) {
            Elements tags = doc.select("*[" + attrName + "]");
            for (Element tag : tags) {
                boolean isNoreferrerRequired = false;
                String uriString = tag.attr(attrName);
                if (noreferrer.booleanValue() && attrName.equals("href")) {
                    isNoreferrerRequired = true;
                }
                try {
                    URI uri = new URI(uriString);
                    if (!uri.isAbsolute()) {
                        tag.attr(attrName, Url.create(uriString));
                    }
                    if (uri.getHost() == null || uri.getHost().equals(hostname)) {
                        isNoreferrerRequired = false;
                    }
                }
                catch (URISyntaxException e) {
                    Logger.info((String)"A malformed URI is detected while checking an email to send", (Throwable)e);
                }
                if (!isNoreferrerRequired) continue;
                tag.attr("rel", tag.attr("rel") + " noreferrer");
            }
        }
    }

    private static void handleImages(Document doc) {
        for (Element img : doc.select("img")) {
            img.attr("style", "max-width:1024px;" + img.attr("style"));
            img.wrap(String.format("<a href=\"%s\" target=\"_blank\" style=\"border:0;outline:0;\"></a>", img.attr("src")));
        }
    }

    private static String getPlainMessage(Lang lang, String message, String urlToView, boolean acceptsReply) {
        String msg = message;
        msg = msg + "\n\n Yona \uc5d0\uc11c \uc790\uc138\ud788 \ubcf4\uac70\ub098 \ud639\uc740 \uc774 \uba54\uc77c\uc5d0 \uc9c1\uc811 \ud68c\uc2e0\ud558\uc2e4 \uc218\ub3c4 \uc788\uc2b5\ub2c8\ub2e4.";
        return msg;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public NotificationEvent getNotificationEvent() {
        return this._ebean_get_notificationEvent();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNotificationEvent(NotificationEvent notificationEvent) {
        this._ebean_set_notificationEvent(notificationEvent);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected NotificationEvent _ebean_get_notificationEvent() {
        this._ebean_intercept.preGetter("notificationEvent");
        return this.notificationEvent;
    }

    protected void _ebean_set_notificationEvent(NotificationEvent newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "notificationEvent", (Object)this._ebean_get_notificationEvent(), (Object)newValue);
        this.notificationEvent = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected NotificationEvent _ebean_getni_notificationEvent() {
        return this.notificationEvent;
    }

    protected void _ebean_setni_notificationEvent(NotificationEvent _newValue) {
        this.notificationEvent = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        NotificationMail notificationMail2 = new NotificationMail();
        notificationMail2.id = this.id;
        notificationMail2.notificationEvent = this.notificationEvent;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        NotificationMail p = (NotificationMail)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.notificationEvent;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        NotificationMail p = (NotificationMail)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_notificationEvent();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        NotificationMail p = (NotificationMail)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.notificationEvent = (NotificationEvent)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        NotificationMail p = (NotificationMail)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_notificationEvent((NotificationEvent)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "notificationEvent"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        NotificationMail notificationMail2 = this;
        synchronized (notificationMail2) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((NotificationMail)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new NotificationMail();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class EventEmail
    extends HtmlEmail {
        private INotificationEvent event;

        public EventEmail(INotificationEvent event) {
            this.event = event;
        }

        protected MimeMessage createMimeMessage(Session aSession) {
            return new MimeMessage(aSession){

                protected void updateMessageID() throws MessagingException {
                    if (event != null && event.getType().isCreating()) {
                        this.setHeader("Message-ID", event.getResource().getMessageId());
                    } else {
                        super.updateMessageID();
                    }
                }
            };
        }

        public void addReferences() {
            if (this.event == null || this.event.getResourceType() == null || this.event.getResourceId() == null) {
                return;
            }
            Resource resource = Resource.get(this.event.getResourceType(), this.event.getResourceId());
            if (resource == null) {
                return;
            }
            Resource container = resource.getContainer();
            if (container != null) {
                String reference;
                switch (container.getType()) {
                    case COMMENT_THREAD: {
                        CommentThread thread = (CommentThread)CommentThread.find.byId((Object)Long.valueOf(container.getId()));
                        reference = thread.getFirstReviewComment().asResource().getMessageId();
                        break;
                    }
                    default: {
                        reference = container.getMessageId();
                    }
                }
                this.addHeader("References", reference);
            }
        }
    }
}

