/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Expr;
import com.avaje.ebean.PagingList;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import controllers.Application;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.servlet.ServletException;
import models.FavoriteProject;
import models.NotificationEvent;
import models.OrganizationUser;
import models.Project;
import models.User;
import models.enumeration.RequestState;
import models.enumeration.ResourceType;
import models.resource.GlobalResource;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import play.core.enhancers.PropertiesEnhancer;
import play.data.format.Formats;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.F;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.ReservedWordsValidator;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Organization
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = -1L;
    public static final Model.Finder<Long, Organization> find = new Model.Finder(Long.class, Organization.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Pattern(value="^[a-zA-Z0-9\uac00-\ud7a3-]+([_.][a-z_.A-Z0-9\uac00-\ud7a3-]+)*$", message="user.wrongloginId.alert")
    @Constraints.Required
    @Constraints.ValidateWith(value=ReservedWordsValidator.class, message="validation.reservedWord")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @Formats.DateTime(pattern="yyyy-MM-dd")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date created;
    @OneToMany(mappedBy="organization", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Project> projects;
    @OneToMany(mappedBy="organization", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<OrganizationUser> users;
    @ManyToMany(mappedBy="enrolledOrganizations")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<User> enrolledUsers;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String descr;
    private static String _EBEAN_MARKER = "models.Organization";

    public void add(OrganizationUser ou) {
        Organization organization2 = this;
        List<OrganizationUser> list2 = null;
        list2 = organization2.getUsers();
        list2.add(ou);
    }

    public static Organization findByName(String name) {
        return (Organization)find.where().ieq("name", name).findUnique();
    }

    public static PagingList<Organization> findByNameLike(String name) {
        return find.where().or(Expr.like((String)"name", (String)("%" + name + "%")), Expr.like((String)"descr", (String)("%" + name + "%"))).orderBy("id desc").findPagingList(30);
    }

    public static boolean isNameExist(String name) {
        int findRowCount = find.where().ieq("name", name).findRowCount();
        return findRowCount != 0;
    }

    public List<Project> getSortedByProjectName() {
        Organization organization2 = this;
        List<Project> list2 = null;
        list2 = organization2.getProjects();
        list2.sort(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                Project project2 = o1;
                String string = null;
                String string2 = string = project2.getName();
                project2 = o2;
                string = null;
                string = project2.getName();
                return string2.compareToIgnoreCase(string);
            }
        });
        organization2 = this;
        list2 = null;
        list2 = organization2.getProjects();
        return list2;
    }

    public boolean isLastAdmin(User currentUser) {
        return OrganizationUser.isAdmin(this, currentUser) && this.getAdmins().size() == 1;
    }

    @Transactional
    public void cleanEnrolledUsers() {
        Model model = this;
        Object object = null;
        object = model.getEnrolledUsers();
        List<User> enrolledUsers = object;
        ArrayList<Object> acceptedUsers = new ArrayList<Object>();
        model = this;
        object = null;
        object = model.getUsers();
        List<Model> members2 = object;
        for (OrganizationUser organizationUser : members2) {
            model = organizationUser;
            object = null;
            object = model.getUser();
            Object user = object;
            if (!enrolledUsers.contains(user)) continue;
            acceptedUsers.add(user);
        }
        for (User user : acceptedUsers) {
            user.cancelEnroll(this);
            NotificationEvent.afterOrganizationMemberRequest(this, user, RequestState.ACCEPT);
        }
    }

    public List<Project> getVisibleProjects(User user) {
        ArrayList<Project> result2;
        block5: {
            Object object;
            Model model;
            block6: {
                block4: {
                    result2 = new ArrayList<Project>();
                    model = this;
                    object = null;
                    object = model.getId();
                    Long l = object;
                    model = user;
                    object = null;
                    object = model.getId();
                    if (!OrganizationUser.isAdmin(l, (Long)object) && !user.isSiteManager()) break block4;
                    model = this;
                    object = null;
                    object = model.getProjects();
                    result2.addAll((Collection<Project>)object);
                    break block5;
                }
                model = this;
                object = null;
                List<Project> list2 = object = model.getId();
                model = user;
                object = null;
                object = model.getId();
                if (!OrganizationUser.isMember((Long)((Object)list2), (Long)object)) break block6;
                model = this;
                object = null;
                object = model.getProjects();
                Iterator<Project> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Project project2 = iterator.next();
                    if (project2.isPrivate() && !user.isMemberOf(project2)) continue;
                    result2.add(project2);
                }
                break block5;
            }
            if (Application.HIDE_PROJECT_LISTING) break block5;
            model = this;
            object = null;
            object = model.getProjects();
            Iterator<Project> iterator = object.iterator();
            while (iterator.hasNext()) {
                Project project3;
                block8: {
                    block7: {
                        project3 = iterator.next();
                        if (!project3.isPublic()) break block7;
                        model = user;
                        boolean bl = false;
                        bl = model.getIsGuest();
                        if (!bl) break block8;
                    }
                    if (!user.isMemberOf(project3)) continue;
                }
                result2.add(project3);
            }
        }
        Collections.sort(result2, new Comparator<Project>(){

            @Override
            public int compare(Project p1, Project p2) {
                Project project2 = p1;
                String string = null;
                String string2 = string = project2.getName();
                project2 = p2;
                string = null;
                string = project2.getName();
                return string2.compareTo(string);
            }
        });
        return result2;
    }

    public static List<Organization> findOrganizationsByUserLoginId(String userLoginId) {
        return find.where().eq("users.user.loginId", (Object)userLoginId).orderBy("created DESC").findList();
    }

    public static List<Organization> findAllOrganizations() {
        List projects2 = find.fetch("projects").where().orderBy("name asc, projects.name asc").findList();
        projects2.sort(new Comparator<Organization>(){

            @Override
            public int compare(Organization o1, Organization o2) {
                Organization organization2 = o1;
                String string = null;
                String string2 = string = organization2.getName();
                organization2 = o2;
                string = null;
                string = organization2.getName();
                return string2.compareToIgnoreCase(string);
            }
        });
        return projects2;
    }

    public static List<Organization> findAllOrganizations(String loginId) {
        User user = User.findByLoginId(loginId);
        if (user.isAnonymous()) {
            return new ArrayList<Organization>();
        }
        TreeSet<String> owners = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        Iterator<FavoriteProject> iterator = user.favoriteProjects.iterator();
        while (iterator.hasNext()) {
            FavoriteProject fp;
            FavoriteProject favoriteProject = fp = iterator.next();
            String string = null;
            string = favoriteProject.getOwner();
            owners.add(string);
        }
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        for (String owner : owners) {
            Organization org = Organization.findByName(owner);
            if (org == null) continue;
            orgs.add(org);
        }
        return orgs;
    }

    @Override
    public Resource asResource() {
        return new GlobalResource(){

            @Override
            public String getId() {
                Organization organization2 = Organization.this;
                Long l = null;
                l = organization2.getId();
                return l.toString();
            }

            @Override
            public ResourceType getType() {
                return ResourceType.ORGANIZATION;
            }
        };
    }

    public List<OrganizationUser> getAdmins() {
        return OrganizationUser.findAdminsOf(this);
    }

    public void updateWith(Organization modifiedOrganization) throws IOException, ServletException {
        Organization organization2 = this;
        String string = null;
        String string2 = string = organization2.getName();
        organization2 = modifiedOrganization;
        string = null;
        string = organization2.getName();
        if (!string2.equals(string)) {
            organization2 = modifiedOrganization;
            string = null;
            string = organization2.getName();
            this.updateProjects(string);
        }
        modifiedOrganization.update();
    }

    private void updateProjects(String newOwner) throws IOException, ServletException {
        Model model = this;
        Object object = null;
        object = model.getProjects();
        Iterator<Project> iterator = object.iterator();
        while (iterator.hasNext()) {
            Project project2 = iterator.next();
            model = project2;
            object = null;
            object = model.getOwner();
            if (!newOwner.equals(object)) {
                PlayRepository repository = RepositoryService.getRepository(project2);
                model = project2;
                object = null;
                Object object2 = object = model.getOwner();
                model = project2;
                object = null;
                Object object3 = object = model.getName();
                model = project2;
                object = null;
                object = model.getName();
                repository.move((String)object2, (String)object3, newOwner, (String)object);
            }
            object = newOwner;
            model = project2;
            model.setOwner((String)object);
            project2.update();
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreated() {
        return this._ebean_get_created();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreated(Date date) {
        this._ebean_set_created(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<Project> getProjects() {
        return this._ebean_get_projects();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjects(List<Project> list2) {
        this._ebean_set_projects(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<OrganizationUser> getUsers() {
        return this._ebean_get_users();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUsers(List<OrganizationUser> list2) {
        this._ebean_set_users(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<User> getEnrolledUsers() {
        return this._ebean_get_enrolledUsers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEnrolledUsers(List<User> list2) {
        this._ebean_set_enrolledUsers(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getDescr() {
        return this._ebean_get_descr();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDescr(String string) {
        this._ebean_set_descr(string);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected Date _ebean_get_created() {
        this._ebean_intercept.preGetter("created");
        return this.created;
    }

    protected void _ebean_set_created(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "created", (Object)this._ebean_get_created(), (Object)newValue);
        this.created = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_created() {
        return this.created;
    }

    protected void _ebean_setni_created(Date _newValue) {
        this.created = _newValue;
    }

    protected List _ebean_get_projects() {
        this._ebean_intercept.preGetter("projects");
        if (this.projects == null) {
            this.projects = new BeanList();
        }
        return this.projects;
    }

    protected void _ebean_set_projects(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "projects", (Object)this._ebean_get_projects(), (Object)newValue);
        this.projects = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_projects() {
        return this.projects;
    }

    protected void _ebean_setni_projects(List _newValue) {
        this.projects = _newValue;
    }

    protected List _ebean_get_users() {
        this._ebean_intercept.preGetter("users");
        if (this.users == null) {
            this.users = new BeanList();
        }
        return this.users;
    }

    protected void _ebean_set_users(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "users", (Object)this._ebean_get_users(), (Object)newValue);
        this.users = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_users() {
        return this.users;
    }

    protected void _ebean_setni_users(List _newValue) {
        this.users = _newValue;
    }

    protected List _ebean_get_enrolledUsers() {
        this._ebean_intercept.preGetter("enrolledUsers");
        if (this.enrolledUsers == null) {
            this.enrolledUsers = new BeanList();
            ((BeanCollection)this.enrolledUsers).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.enrolledUsers;
    }

    protected void _ebean_set_enrolledUsers(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "enrolledUsers", (Object)this._ebean_get_enrolledUsers(), (Object)newValue);
        this.enrolledUsers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_enrolledUsers() {
        return this.enrolledUsers;
    }

    protected void _ebean_setni_enrolledUsers(List _newValue) {
        this.enrolledUsers = _newValue;
    }

    protected String _ebean_get_descr() {
        this._ebean_intercept.preGetter("descr");
        return this.descr;
    }

    protected void _ebean_set_descr(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "descr", (Object)this._ebean_get_descr(), (Object)newValue);
        this.descr = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_descr() {
        return this.descr;
    }

    protected void _ebean_setni_descr(String _newValue) {
        this.descr = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Organization organization2 = new Organization();
        organization2.id = this.id;
        organization2.name = this.name;
        organization2.created = this.created;
        organization2.projects = this.projects;
        organization2.users = this.users;
        organization2.enrolledUsers = this.enrolledUsers;
        organization2.descr = this.descr;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Organization p = (Organization)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.name;
            }
            case 3: {
                return p.created;
            }
            case 4: {
                return p.projects;
            }
            case 5: {
                return p.users;
            }
            case 6: {
                return p.enrolledUsers;
            }
            case 7: {
                return p.descr;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Organization p = (Organization)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_name();
            }
            case 3: {
                return p._ebean_get_created();
            }
            case 4: {
                return p._ebean_get_projects();
            }
            case 5: {
                return p._ebean_get_users();
            }
            case 6: {
                return p._ebean_get_enrolledUsers();
            }
            case 7: {
                return p._ebean_get_descr();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Organization p = (Organization)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.name = (String)arg;
                return;
            }
            case 3: {
                p.created = (Date)arg;
                return;
            }
            case 4: {
                p.projects = (List)arg;
                return;
            }
            case 5: {
                p.users = (List)arg;
                return;
            }
            case 6: {
                p.enrolledUsers = (List)arg;
                return;
            }
            case 7: {
                p.descr = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Organization p = (Organization)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_created((Date)arg);
                return;
            }
            case 4: {
                p._ebean_set_projects((List)arg);
                return;
            }
            case 5: {
                p._ebean_set_users((List)arg);
                return;
            }
            case 6: {
                p._ebean_set_enrolledUsers((List)arg);
                return;
            }
            case 7: {
                p._ebean_set_descr((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "name", "created", "projects", "users", "enrolledUsers", "descr"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Organization organization2 = this;
        synchronized (organization2) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Organization)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Organization();
    }
}

