/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import com.avaje.ebean.common.BeanSet;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.servlet.ServletException;
import models.Assignee;
import models.CommentThread;
import models.CommitComment;
import models.Issue;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.Label;
import models.LabelOwner;
import models.Milestone;
import models.NotificationEvent;
import models.Organization;
import models.Posting;
import models.ProjectMenuSetting;
import models.ProjectTransfer;
import models.ProjectUser;
import models.PullRequest;
import models.PushedBranch;
import models.User;
import models.UserProjectNotification;
import models.Watch;
import models.Webhook;
import models.enumeration.ProjectScope;
import models.enumeration.RequestState;
import models.enumeration.ResourceType;
import models.enumeration.RoleType;
import models.resource.GlobalResource;
import models.resource.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.tmatesoft.svn.core.SVNException;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.F;
import playRepository.Commit;
import playRepository.GitRepository;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import playRepository.SVNRepository;
import utils.CacheStore;
import utils.FileUtil;
import utils.HttpUtil;
import utils.JodaDateUtil;
import validation.ExConstraints;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Project
extends Model
implements LabelOwner,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, Project> find = new Model.Finder(Long.class, Project.class);
    private static final int DRAFT_TIME_IN_MILLIS = 3600000;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @Constraints.Pattern(value="^[a-zA-Z0-9-_\\.\uac00-\ud7a3]+$")
    @ExConstraints.Restricted(value={".", "..", ".git"})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String overview;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String vcs;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String siteurl;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String owner;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Issue> issues;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<ProjectUser> projectUser;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Posting> posts;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Milestone> milestones;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<UserProjectNotification> notifications;
    private long lastIssueNumber;
    private long lastPostingNumber;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean isCodeAccessibleMemberOnly;
    @ManyToMany
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Label> labels;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project originalProject;
    @OneToMany(mappedBy="originalProject")
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<Project> forkingProjects;
    @OneToMany(mappedBy="project")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Webhook> webhooks;
    @OneToMany(mappedBy="project")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Set<Assignee> assignees;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date lastPushedDate;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<PushedBranch> pushedBranches;
    @ManyToMany(mappedBy="enrolledProjects")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<User> enrolledUsers;
    @OneToMany(cascade={CascadeType.REMOVE})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<CommitComment> codeComments;
    @OneToMany(cascade={CascadeType.REMOVE})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<CommentThread> commentThreads;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Integer defaultReviewerCount;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean isUsingReviewerCount;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Organization organization;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public ProjectScope projectScope;
    @OneToOne(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public ProjectMenuSetting menuSetting;
    private String previousOwnerLoginId;
    private String previousName;
    private Long previousNameChangedTime;
    @OneToMany(mappedBy="project", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<IssueLabel> issueLabels;
    private static String _EBEAN_MARKER = "models.Project";

    public Project() {
        Integer n = 1;
        Project project2 = this;
        project2.setDefaultReviewerCount(n);
    }

    public static Long create(Project newProject2) {
        Project project2 = newProject2;
        Object object = null;
        object = project2.getName();
        object = "http://localhost:9000/" + (String)object;
        project2 = newProject2;
        project2.setSiteurl((String)object);
        object = new Date();
        project2 = newProject2;
        project2.setCreatedDate((Date)object);
        newProject2.save();
        project2 = newProject2;
        object = null;
        object = project2.getId();
        ProjectUser.assignRole(User.SITE_MANAGER_ID, (Long)object, RoleType.SITEMANAGER);
        project2 = newProject2;
        object = null;
        object = project2.getId();
        return object;
    }

    public static Page<Project> findByName(String name, int pageSize, int pageNum) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return find.where().order().desc("createdDate").findPagingList(pageSize).getPage(pageNum);
        }
        return find.where().ilike("name", "%" + HttpUtil.decodeUrlString(name) + "%").findPagingList(pageSize).getPage(pageNum);
    }

    public static Project findByOwnerAndProjectName(String loginId, String projectName) {
        String key = CacheStore.getProjectCacheKey(loginId, projectName);
        Long projectId = CacheStore.projectMap.get(key);
        if (projectId == null || projectId == 0L) {
            Project project2 = (Project)find.where().ieq("owner", HttpUtil.decodeUrlString(loginId)).ieq("name", HttpUtil.decodeUrlString(projectName)).findUnique();
            if (project2 == null) {
                project2 = Project.findByPreviousPlaceOf(HttpUtil.decodeUrlString(loginId), HttpUtil.decodeUrlString(projectName));
            }
            if (project2 != null) {
                Project project3 = project2;
                Long l = null;
                l = project3.getId();
                CacheStore.projectMap.put(key, l);
            }
            return project2;
        }
        return (Project)find.byId((Object)projectId);
    }

    public static List<Project> findByOwner(String loginId) {
        return find.where().ieq("owner", HttpUtil.decodeUrlString(loginId)).orderBy("name asc").findList();
    }

    public Set<User> findAuthors() {
        LinkedHashSet<User> allAuthors = new LinkedHashSet<User>();
        allAuthors.addAll(this.getIssueUsers());
        allAuthors.addAll(this.getPostingUsers());
        allAuthors.addAll(this.getPullRequestUsers());
        return allAuthors;
    }

    public Set<User> findAuthorsAndWatchers() {
        LinkedHashSet<User> allAuthors = new LinkedHashSet<User>();
        allAuthors.addAll(this.findAuthors());
        allAuthors.addAll(this.getWatchedUsers());
        return allAuthors;
    }

    private Set<User> getIssueUsers() {
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        String issueSql = "select distinct author_id id from issue where project_id=" + l;
        return User.find.setRawSql(RawSqlBuilder.parse((String)issueSql).create()).findSet();
    }

    private Set<User> getPostingUsers() {
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        String postSql = "SELECT distinct author_id id FROM posting where project_id=" + l;
        return User.find.setRawSql(RawSqlBuilder.parse((String)postSql).create()).findSet();
    }

    private Set<User> getPullRequestUsers() {
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        String postSql = "SELECT distinct contributor_id id FROM pull_request where to_project_id=" + l;
        return User.find.setRawSql(RawSqlBuilder.parse((String)postSql).create()).findSet();
    }

    public Set<User> getWatchedUsers() {
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        String postSql = "SELECT distinct user_id id FROM watch where resource_type='PROJECT' and resource_id=" + l;
        return User.find.setRawSql(RawSqlBuilder.parse((String)postSql).create()).findSet();
    }

    public boolean hasMember(User user) {
        return user.isMemberOf(this) || user.isManagerOf(this) || user.isSiteManager();
    }

    public static boolean exists(String loginId, String projectName) {
        int findRowCount = find.where().ieq("owner", loginId).ieq("name", projectName).findRowCount();
        return findRowCount != 0;
    }

    public static boolean projectNameChangeable(Long id, String userName, String projectName) {
        int findRowCount = find.where().ieq("name", HttpUtil.decodeUrlString(projectName)).ieq("owner", userName).ne("id", (Object)id).findRowCount();
        return findRowCount == 0;
    }

    public static boolean isOnlyManager(Long userId) {
        List projects2 = find.select("id").select("name").where().eq("projectUser.user.id", (Object)userId).eq("projectUser.role.id", (Object)RoleType.MANAGER.roleType()).findList();
        Iterator iterator = projects2.iterator();
        while (iterator.hasNext()) {
            Project project2;
            Project project3 = project2 = (Project)iterator.next();
            Long l = null;
            l = project3.getId();
            if (!ProjectUser.checkOneMangerPerOneProject(userId, l)) continue;
            return true;
        }
        return false;
    }

    public static List<Project> findProjectsByMember(Long userId) {
        return find.where().eq("projectUser.user.id", (Object)userId).findList();
    }

    public static List<Project> findProjectsJustMemberAndNotOwner(User user) {
        return Project.findProjectsJustMemberAndNotOwner(user, null);
    }

    public static List<Project> findProjectsJustMemberAndNotOwner(User user, String orderString) {
        User user2 = user;
        Object object = null;
        object = user2.getId();
        ExpressionList expressionList = find.where().eq("projectUser.user.id", object).ne("projectUser.role.id", (Object)RoleType.SITEMANAGER.roleType());
        user2 = user;
        object = null;
        object = user2.getLoginId();
        ExpressionList el = expressionList.ne("owner", object);
        if (StringUtils.isNotBlank((CharSequence)orderString)) {
            el.orderBy(orderString);
        }
        return el.findList();
    }

    public static List<Project> findProjectsByMemberWithFilter(Long userId, String orderString) {
        List userProjectList = find.where().eq("projectUser.user.id", (Object)userId).findList();
        if (orderString == null) {
            return userProjectList;
        }
        return Ebean.filter(Project.class).sort(orderString).filter(userProjectList);
    }

    public static List<Project> findProjectsCreatedByUser(String loginId, String orderString) {
        if (orderString == null) {
            return find.where().eq("owner", (Object)loginId).orderBy("createdDate desc").findList();
        }
        return find.where().eq("owner", (Object)loginId).orderBy(orderString).findList();
    }

    public static List<Project> findProjectsCreatedByUserAndScope(String loginId, ProjectScope projectScope, String orderString) {
        return find.where().eq("owner", (Object)loginId).eq("projectScope", (Object)projectScope).orderBy(orderString).findList();
    }

    public Date lastUpdateDate() {
        try {
            PlayRepository repository = RepositoryService.getRepository(this);
            List<String> branches2 = repository.getRefNames();
            if (!branches2.isEmpty() && repository instanceof GitRepository) {
                Project project2 = this;
                Object object = null;
                object = project2.getOwner();
                String string = object;
                project2 = this;
                object = null;
                object = project2.getName();
                GitRepository gitRepo = new GitRepository(string, (String)object);
                List<Commit> history2 = gitRepo.getHistory(0, 2, "HEAD", null);
                if (history2 == null) {
                    project2 = this;
                    object = null;
                    object = project2.getCreatedDate();
                    return object;
                }
                return history2.get(0).getAuthorDate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoHeadException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        Project project3 = this;
        Date date = null;
        date = project3.getCreatedDate();
        return date;
    }

    public String defaultBranch() {
        try {
            return RepositoryService.getRepository(this).getDefaultBranch();
        }
        catch (Exception exception) {
            return "HEAD";
        }
    }

    public Duration ago() {
        return JodaDateUtil.ago(this.lastUpdateDate());
    }

    public Duration lastPushedDateAgo() {
        Project project2 = this;
        Date date = null;
        date = project2.getLastPushedDate();
        if (date == null) {
            return null;
        }
        project2 = this;
        date = null;
        date = project2.getLastPushedDate();
        return JodaDateUtil.ago(date);
    }

    public String readme() {
        try {
            byte[] bytes = RepositoryService.getRepository(this).getRawFile("HEAD", this.getReadmeFileName());
            return new String(bytes, FileUtil.detectCharset(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getIssueTemplate() {
        try {
            byte[] bytes = RepositoryService.getRepository(this).getRawFile("HEAD", "ISSUE_TEMPLATE.md");
            return new String(bytes, FileUtil.detectCharset(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getReadmeFileName() throws IOException, SVNException, ServletException {
        String baseFileName = "README.md";
        PlayRepository repo = RepositoryService.getRepository(this);
        if (repo.isFile(baseFileName)) {
            return baseFileName;
        }
        if (repo.isFile(baseFileName.toLowerCase())) {
            return baseFileName.toLowerCase();
        }
        if (repo instanceof SVNRepository) {
            baseFileName = "/trunk/" + baseFileName;
            if (repo.isFile(baseFileName)) {
                return baseFileName;
            }
            if (repo.isFile(baseFileName = baseFileName.toLowerCase())) {
                return baseFileName;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLastIssueNumberCorrect() {
        Project project2 = this;
        Set<Issue> set = null;
        set = project2.getIssues();
        if (set == null) return true;
        project2 = this;
        set = null;
        set = project2.getIssues();
        if (this._ebean_get_lastIssueNumber() < (long)set.size()) return false;
        return true;
    }

    private Long getLastIssueNumber() {
        if (this.isLastIssueNumberCorrect()) {
            return this._ebean_get_lastIssueNumber();
        }
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        Issue issue2 = (Issue)Issue.finder.where().eq("project.id", (Object)l).order().desc("number").findList().get(0);
        issue2.refresh();
        return issue2.number == null ? 0L : issue2.number;
    }

    private void setLastIssueNumber(Long number) {
        this._ebean_set_lastIssueNumber(number);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLastPostingNumberCorrect() {
        Project project2 = this;
        List<Posting> list2 = null;
        list2 = project2.getPosts();
        if (list2 == null) return true;
        project2 = this;
        list2 = null;
        list2 = project2.getPosts();
        if (this._ebean_get_lastPostingNumber() < (long)list2.size()) return false;
        return true;
    }

    private Long getLastPostingNumber() {
        if (this.isLastPostingNumberCorrect()) {
            return this._ebean_get_lastPostingNumber();
        }
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        Posting posting = (Posting)Posting.finder.where().eq("project.id", (Object)l).order().desc("number").findList().get(0);
        posting.refresh();
        return posting.number == null ? 0L : posting.number;
    }

    private void setLastPostingNumber(Long number) {
        this._ebean_set_lastPostingNumber(number);
    }

    public static Long increaseLastIssueNumber(Long projectId) {
        Project project2 = (Project)find.byId((Object)projectId);
        project2.setLastIssueNumber(project2.getLastIssueNumber() + 1L);
        project2.update();
        return project2.lastIssueNumber;
    }

    public static void fixLastIssueNumber(Long projectId) {
        Project project2 = (Project)find.byId((Object)projectId);
        project2.refresh();
        project2.setLastIssueNumber(project2.getLastIssueNumber());
        project2.update();
    }

    public static Long increaseLastPostingNumber(Long projectId) {
        Project project2 = (Project)find.byId((Object)projectId);
        project2.setLastPostingNumber(project2.getLastPostingNumber() + 1L);
        project2.update();
        return project2.lastPostingNumber;
    }

    public static void fixLastPostingNumber(Long projectId) {
        Project project2 = (Project)find.byId((Object)projectId);
        project2.refresh();
        project2.setLastPostingNumber(project2.getLastPostingNumber());
        project2.update();
    }

    public Resource labelsAsResource() {
        return new Resource(){

            @Override
            public String getId() {
                Project project2 = Project.this;
                Long l = null;
                l = project2.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                return Project.this;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.PROJECT_LABELS;
            }
        };
    }

    @Override
    public Resource asResource() {
        return new GlobalResource(){

            @Override
            public String getId() {
                Project project2 = Project.this;
                Long l = null;
                l = project2.getId();
                return l.toString();
            }

            @Override
            public ResourceType getType() {
                return ResourceType.PROJECT;
            }

            @Override
            public Project getProject() {
                return Project.this;
            }
        };
    }

    public User getOwnerByLoginId(String loginId) {
        return User.findByLoginId(loginId);
    }

    public Boolean attachLabel(Label label) {
        Label label2 = label;
        Set<Project> set = null;
        set = label2.getProjects();
        if (set.contains(this)) {
            return false;
        }
        label2 = label;
        set = null;
        set = label2.getProjects();
        set.add(this);
        label.update();
        return true;
    }

    public void detachLabel(Label label) {
        Label label2 = label;
        Set<Project> set = null;
        set = label2.getProjects();
        set.remove(this);
        label2 = label;
        set = null;
        set = label2.getProjects();
        if (set.size() == 0) {
            label.delete();
        } else {
            label.update();
        }
    }

    public boolean isOwner(User user) {
        Model model = this;
        String string = null;
        string = model.getOwner();
        String string2 = string.toLowerCase();
        model = user;
        string = null;
        string = model.getLoginId();
        return string2.equals(string.toLowerCase());
    }

    public String toString() {
        Project project2 = this;
        String string = null;
        string = project2.getOwner();
        StringBuilder stringBuilder = new StringBuilder().append(string).append("/");
        project2 = this;
        string = null;
        string = project2.getName();
        return stringBuilder.append(string).toString();
    }

    public List<ProjectUser> members() {
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        return ProjectUser.findMemberListByProject(l);
    }

    public List<User> getAssignableUsers() {
        return User.findUsersByProjectAndOrganization(this);
    }

    public List<User> getAssignableUsersAndAssignee(Issue issue2) {
        List<User> users2 = this.getAssignableUsers();
        if (issue2 != null) {
            Model model = issue2;
            Model model2 = null;
            model2 = model.getAssignee();
            if (model2 != null) {
                model = issue2;
                model2 = null;
                model2 = model.getAssignee();
                model = model2;
                model2 = null;
                model2 = model.getUser();
                if (!users2.contains(model2)) {
                    model = issue2;
                    model2 = null;
                    model2 = model.getAssignee();
                    model = model2;
                    model2 = null;
                    model2 = model.getUser();
                    users2.add((User)model2);
                }
            }
        }
        return users2;
    }

    public boolean isProjectOrOrganizationUser(User user) {
        return User.findUsersByProjectAndOrganization(this).contains(user);
    }

    public boolean isAssignableUser(User user) {
        return this.getAssignableUsers().contains(user);
    }

    public boolean isForkedFromOrigin() {
        Project project2 = this;
        Project project3 = null;
        project3 = project2.getOriginalProject();
        return project3 != null;
    }

    public boolean hasForks() {
        return this._ebean_get_forkingProjects().size() > 0;
    }

    public List<Project> getForkingProjects() {
        if (this._ebean_get_forkingProjects() == null) {
            this._ebean_set_forkingProjects(new ArrayList());
        }
        return this._ebean_get_forkingProjects();
    }

    public void addFork(Project forkProject) {
        this.getForkingProjects().add(forkProject);
        Project project2 = this;
        Project project3 = forkProject;
        project3.setOriginalProject(project2);
    }

    public static List<Project> findByOwnerAndOriginalProject(String loginId, Project originalProject) {
        return find.where().eq("originalProject", (Object)originalProject).eq("owner", (Object)loginId).findList();
    }

    public void deleteFork() {
        Project project2 = this;
        Project project3 = null;
        project3 = project2.getOriginalProject();
        if (project3 != null) {
            project2 = this;
            project3 = null;
            project3 = project2.getOriginalProject();
            project3.deleteFork(this);
        }
    }

    private void deleteFork(Project project2) {
        this.getForkingProjects().remove(project2);
        Project project3 = null;
        Project project4 = project2;
        project4.setOriginalProject(project3);
    }

    public void fixInvalidForkData() {
        Project project2 = this;
        Object object = null;
        object = project2.getOriginalProject();
        if (object != null) {
            try {
                project2 = this;
                object = null;
                object = project2.getOriginalProject();
                project2 = object;
                object = null;
                Object object2 = object = project2.getOwner();
            }
            catch (EntityNotFoundException e) {
                object = null;
                project2 = this;
                project2.setOriginalProject((Project)object);
                super.update();
            }
        }
    }

    @Transactional
    public void cleanEnrolledUsers() {
        Model model = this;
        Object object = null;
        object = model.getEnrolledUsers();
        List<User> enrolledUsers = object;
        ArrayList<Object> acceptedUsers = new ArrayList<Object>();
        List<ProjectUser> members2 = this.members();
        for (ProjectUser projectUser : members2) {
            model = projectUser;
            object = null;
            object = model.getUser();
            Object user = object;
            if (!enrolledUsers.contains(user)) continue;
            acceptedUsers.add(user);
        }
        for (User user : acceptedUsers) {
            user.cancelEnroll(this);
            NotificationEvent.afterMemberRequest(this, user, RequestState.ACCEPT);
        }
    }

    public void changeVCS() throws Exception {
        Project project2;
        String string;
        if (this._ebean_get_forkingProjects() != null) {
            for (Project fork2 : this._ebean_get_forkingProjects()) {
                string = null;
                project2 = fork2;
                project2.setOriginalProject((Project)((Object)string));
                fork2.update();
            }
        }
        RepositoryService.deleteRepository(this);
        string = this.nextVCS();
        project2 = this;
        project2.setVcs(string);
        RepositoryService.getRepository(this).create();
        this.update();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCodeAvailable() {
        Model model = this;
        ProjectMenuSetting projectMenuSetting = null;
        projectMenuSetting = model.getMenuSetting();
        if (projectMenuSetting == null) return true;
        model = this;
        projectMenuSetting = null;
        projectMenuSetting = model.getMenuSetting();
        model = projectMenuSetting;
        boolean bl = false;
        bl = model.getCode();
        if (!bl) return false;
        return true;
    }

    public void recordRenameOrTransferHistoryIfLastChangePassed24HoursFrom(@Nonnull Project project2) {
        if (Project.isRenamedOrTransferredIn24Hours(project2)) {
            this._ebean_set_previousNameChangedTime(DateTime.now().getMillis());
            Project project3 = project2;
            String string = null;
            string = project3.getName();
            this._ebean_set_previousName(string);
            project3 = project2;
            string = null;
            string = project3.getOwner();
            this._ebean_set_previousOwnerLoginId(string);
        }
    }

    private static boolean isRenamedOrTransferredIn24Hours(@Nonnull Project project2) {
        return project2.previousNameChangedTime == null || Project.hasPassed24hoursFrom(project2.previousNameChangedTime);
    }

    private static boolean hasPassed24hoursFrom(Long time) {
        return new Duration(DateTime.now().getMillis() - time).getStandardHours() > 24L;
    }

    public void delete() {
        CacheStore.refreshProjectMap();
        Project project2 = this;
        Collection<Model> collection = null;
        collection = project2.getOwner();
        String string = collection;
        project2 = this;
        collection = null;
        collection = project2.getName();
        CacheStore.projectMap.remove(CacheStore.getProjectCacheKey(string, (String)((Object)collection)));
        this.deleteProjectTransfer();
        this.deleteFork();
        this.deleteCommentThreads();
        this.deletePullRequests();
        if (this.hasForks()) {
            for (Project project3 : this._ebean_get_forkingProjects()) {
                project3.deletePullRequests();
                project3.deleteOriginal();
                project3.update();
            }
        }
        project2 = this;
        collection = null;
        collection = project2.getIssues();
        for (Issue issue2 : collection) {
            issue2.delete();
        }
        for (IssueLabelCategory issueLabelCategory : IssueLabelCategory.findByProject(this)) {
            issueLabelCategory.delete();
        }
        project2 = this;
        collection = null;
        collection = project2.getAssignees();
        for (Assignee assignee : collection) {
            assignee.delete();
        }
        project2 = this;
        collection = null;
        collection = project2.getWebhooks();
        for (Webhook webhook : collection) {
            webhook.delete();
        }
        project2 = this;
        collection = null;
        collection = project2.getPosts();
        for (Posting posting : collection) {
            posting.delete();
        }
        for (Label label : this._ebean_get_labels()) {
            label.delete(this);
            label.update();
        }
        super.delete();
    }

    private void deleteProjectTransfer() {
        List<ProjectTransfer> pts = ProjectTransfer.findByProject(this);
        for (ProjectTransfer pt : pts) {
            pt.delete();
        }
    }

    private void deleteOriginal() {
        Project project2 = null;
        Project project3 = this;
        project3.setOriginalProject(project2);
    }

    private void deletePullRequests() {
        List<PullRequest> sentPullRequests2 = PullRequest.findSentPullRequests(this);
        for (PullRequest pullRequest2 : sentPullRequests2) {
            CommentThread.deleteByPullRequest(pullRequest2);
            pullRequest2.delete();
        }
        List<PullRequest> allReceivedRequests = PullRequest.allReceivedRequests(this);
        for (PullRequest pullRequest3 : allReceivedRequests) {
            CommentThread.deleteByPullRequest(pullRequest3);
            pullRequest3.delete();
        }
    }

    private void deleteCommentThreads() {
        Project project2 = this;
        List<CommentThread> list2 = null;
        list2 = project2.getCommentThreads();
        for (CommentThread commentThread : list2) {
            commentThread.delete();
        }
    }

    public static String newProjectName(String loginId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        if (project2 == null) {
            return projectName;
        }
        int i = 1;
        String newProjectName;
        while ((project2 = Project.findByOwnerAndProjectName(loginId, newProjectName = projectName + "-" + i)) != null) {
            ++i;
        }
        return newProjectName;
    }

    public static Project copy(Project project2, String owner) {
        Project copyProject = new Project();
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getName();
        object2 = Project.newProjectName(owner, object2);
        object = copyProject;
        ((Project)object).setName((String)object2);
        object = project2;
        object2 = null;
        object2 = ((Project)object).getOverview();
        object = copyProject;
        ((Project)object).setOverview((String)object2);
        object = project2;
        object2 = null;
        object2 = ((Project)object).getVcs();
        object = copyProject;
        ((Project)object).setVcs((String)object2);
        object2 = owner;
        object = copyProject;
        ((Project)object).setOwner((String)object2);
        object = project2;
        object2 = null;
        object2 = ((Project)object).getProjectScope();
        object = copyProject;
        ((Project)object).setProjectScope((ProjectScope)((Object)object2));
        object = project2;
        object2 = null;
        object2 = ((Project)object).getMenuSetting();
        object2 = new ProjectMenuSetting((ProjectMenuSetting)((Object)object2));
        object = copyProject;
        ((Project)object).setMenuSetting((ProjectMenuSetting)((Object)object2));
        object = copyProject;
        object2 = null;
        Object object3 = object2 = ((Project)object).getMenuSetting();
        object2 = copyProject;
        object = object3;
        ((ProjectMenuSetting)((Object)object)).setProject((Project)object2);
        object = copyProject;
        object2 = null;
        object2 = ((Project)object).getMenuSetting();
        object2.save();
        return copyProject;
    }

    public Set<Label> getLabels() {
        return this._ebean_get_labels();
    }

    public static int countProjectsJustMemberAndNotOwner(String loginId) {
        return find.where().eq("projectUser.user.loginId", (Object)loginId).ne("owner", (Object)loginId).findRowCount();
    }

    public static int countProjectsCreatedByUser(String loginId) {
        return find.where().eq("owner", (Object)loginId).findRowCount();
    }

    public List<PushedBranch> getRecentlyPushedBranches() {
        return PushedBranch.find.where().eq("project", (Object)this).gt("pushedDate", (Object)DateTime.now().minusMillis(3600000).toDate()).findList();
    }

    public List<PushedBranch> getOldPushedBranches() {
        return PushedBranch.find.where().eq("project", (Object)this).lt("pushedDate", (Object)DateTime.now().minusMillis(3600000).toDate()).findList();
    }

    public boolean isGit() {
        Project project2 = this;
        String string = null;
        string = project2.getVcs();
        return string.equals("GIT");
    }

    public List<Project> getAssociationProjects() {
        ArrayList<Project> projects2 = new ArrayList<Project>();
        projects2.add(this);
        projects2.addAll(this._ebean_get_forkingProjects());
        if (this.isForkedFromOrigin()) {
            Project project2 = this;
            Model model = null;
            project2 = model = project2.getOriginalProject();
            model = null;
            project2 = model = project2.getMenuSetting();
            boolean bl = false;
            bl = ((ProjectMenuSetting)((Object)project2)).getCode();
            if (bl) {
                project2 = this;
                Model model2 = null;
                project2 = model2 = project2.getOriginalProject();
                model2 = null;
                project2 = model2 = project2.getMenuSetting();
                boolean bl2 = false;
                bl2 = ((ProjectMenuSetting)((Object)project2)).getPullRequest();
                if (bl2) {
                    project2 = this;
                    Project project3 = null;
                    project3 = project2.getOriginalProject();
                    projects2.add(project3);
                }
            }
        }
        return projects2;
    }

    public int getMaxNumberOfRequiredReviewerCount() {
        Project project2 = this;
        Long l = null;
        l = project2.getId();
        List<ProjectUser> members2 = ProjectUser.findMemberListByProject(l);
        if (members2.size() > 1) {
            return members2.size();
        }
        return 1;
    }

    public int getWatchingCount() {
        Resource resource = this.asResource();
        return Watch.countBy(resource.getType(), resource.getId());
    }

    public boolean hasGroup() {
        Project project2 = this;
        Organization organization2 = null;
        organization2 = project2.getOrganization();
        return organization2 != null;
    }

    public boolean isPublic() {
        Project project2 = this;
        ProjectScope projectScope = null;
        projectScope = project2.getProjectScope();
        return projectScope == ProjectScope.PUBLIC;
    }

    public boolean isProtected() {
        Project project2 = this;
        ProjectScope projectScope = null;
        projectScope = project2.getProjectScope();
        return projectScope == ProjectScope.PROTECTED;
    }

    public boolean isPrivate() {
        Project project2 = this;
        ProjectScope projectScope = null;
        projectScope = project2.getProjectScope();
        return projectScope == ProjectScope.PRIVATE;
    }

    public String nextVCS() {
        Project project2 = this;
        String string = null;
        string = project2.getVcs();
        if (string.equals("GIT")) {
            return "Subversion";
        }
        return "GIT";
    }

    public static Project findByPreviousPlaceOf(String previousOwnerLoginid, String previousName) {
        List projects2 = find.where().ieq("previousOwnerLoginId", previousOwnerLoginid).ieq("previousName", previousName).setOrderBy("previousNameChangedTime desc").findList();
        if (CollectionUtils.isEmpty((Collection)projects2)) {
            return null;
        }
        return (Project)projects2.get(0);
    }

    public boolean hasOldPlace() {
        return !StringUtils.isBlank((CharSequence)this._ebean_get_previousName());
    }

    public String getOldPlace() {
        if (this._ebean_get_previousOwnerLoginId() == null) {
            return "";
        }
        if (this.hasOldPlace()) {
            return this._ebean_get_previousOwnerLoginId() + "/" + this._ebean_get_previousName();
        }
        return "";
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getOverview() {
        return this._ebean_get_overview();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOverview(String string) {
        this._ebean_set_overview(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getVcs() {
        return this._ebean_get_vcs();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setVcs(String string) {
        this._ebean_set_vcs(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSiteurl() {
        return this._ebean_get_siteurl();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSiteurl(String string) {
        this._ebean_set_siteurl(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getOwner() {
        return this._ebean_get_owner();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOwner(String string) {
        this._ebean_set_owner(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Issue> getIssues() {
        return this._ebean_get_issues();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssues(Set<Issue> set) {
        this._ebean_set_issues(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<ProjectUser> getProjectUser() {
        return this._ebean_get_projectUser();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectUser(List<ProjectUser> list2) {
        this._ebean_set_projectUser(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<Posting> getPosts() {
        return this._ebean_get_posts();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPosts(List<Posting> list2) {
        this._ebean_set_posts(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<Milestone> getMilestones() {
        return this._ebean_get_milestones();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMilestones(List<Milestone> list2) {
        this._ebean_set_milestones(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<UserProjectNotification> getNotifications() {
        return this._ebean_get_notifications();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNotifications(List<UserProjectNotification> list2) {
        this._ebean_set_notifications(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getIsCodeAccessibleMemberOnly() {
        return this._ebean_get_isCodeAccessibleMemberOnly();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsCodeAccessibleMemberOnly(boolean bl) {
        this._ebean_set_isCodeAccessibleMemberOnly(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLabels(Set<Label> set) {
        this._ebean_set_labels(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getOriginalProject() {
        return this._ebean_get_originalProject();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOriginalProject(Project project2) {
        this._ebean_set_originalProject(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setForkingProjects(List<Project> list2) {
        this._ebean_set_forkingProjects(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Webhook> getWebhooks() {
        return this._ebean_get_webhooks();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setWebhooks(Set<Webhook> set) {
        this._ebean_set_webhooks(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Assignee> getAssignees() {
        return this._ebean_get_assignees();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAssignees(Set<Assignee> set) {
        this._ebean_set_assignees(set);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getLastPushedDate() {
        return this._ebean_get_lastPushedDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLastPushedDate(Date date) {
        this._ebean_set_lastPushedDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<PushedBranch> getPushedBranches() {
        return this._ebean_get_pushedBranches();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPushedBranches(List<PushedBranch> list2) {
        this._ebean_set_pushedBranches(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<User> getEnrolledUsers() {
        return this._ebean_get_enrolledUsers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEnrolledUsers(List<User> list2) {
        this._ebean_set_enrolledUsers(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<CommitComment> getCodeComments() {
        return this._ebean_get_codeComments();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCodeComments(List<CommitComment> list2) {
        this._ebean_set_codeComments(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<CommentThread> getCommentThreads() {
        return this._ebean_get_commentThreads();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCommentThreads(List<CommentThread> list2) {
        this._ebean_set_commentThreads(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Integer getDefaultReviewerCount() {
        return this._ebean_get_defaultReviewerCount();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDefaultReviewerCount(Integer n) {
        this._ebean_set_defaultReviewerCount(n);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getIsUsingReviewerCount() {
        return this._ebean_get_isUsingReviewerCount();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsUsingReviewerCount(boolean bl) {
        this._ebean_set_isUsingReviewerCount(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Organization getOrganization() {
        return this._ebean_get_organization();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOrganization(Organization organization2) {
        this._ebean_set_organization(organization2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public ProjectScope getProjectScope() {
        return this._ebean_get_projectScope();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectScope(ProjectScope projectScope) {
        this._ebean_set_projectScope(projectScope);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public ProjectMenuSetting getMenuSetting() {
        return this._ebean_get_menuSetting();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMenuSetting(ProjectMenuSetting projectMenuSetting) {
        this._ebean_set_menuSetting(projectMenuSetting);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<IssueLabel> getIssueLabels() {
        return this._ebean_get_issueLabels();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIssueLabels(List<IssueLabel> list2) {
        this._ebean_set_issueLabels(list2);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected String _ebean_get_overview() {
        this._ebean_intercept.preGetter("overview");
        return this.overview;
    }

    protected void _ebean_set_overview(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "overview", (Object)this._ebean_get_overview(), (Object)newValue);
        this.overview = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_overview() {
        return this.overview;
    }

    protected void _ebean_setni_overview(String _newValue) {
        this.overview = _newValue;
    }

    protected String _ebean_get_vcs() {
        this._ebean_intercept.preGetter("vcs");
        return this.vcs;
    }

    protected void _ebean_set_vcs(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "vcs", (Object)this._ebean_get_vcs(), (Object)newValue);
        this.vcs = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_vcs() {
        return this.vcs;
    }

    protected void _ebean_setni_vcs(String _newValue) {
        this.vcs = _newValue;
    }

    protected String _ebean_get_siteurl() {
        this._ebean_intercept.preGetter("siteurl");
        return this.siteurl;
    }

    protected void _ebean_set_siteurl(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "siteurl", (Object)this._ebean_get_siteurl(), (Object)newValue);
        this.siteurl = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_siteurl() {
        return this.siteurl;
    }

    protected void _ebean_setni_siteurl(String _newValue) {
        this.siteurl = _newValue;
    }

    protected String _ebean_get_owner() {
        this._ebean_intercept.preGetter("owner");
        return this.owner;
    }

    protected void _ebean_set_owner(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "owner", (Object)this._ebean_get_owner(), (Object)newValue);
        this.owner = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_owner() {
        return this.owner;
    }

    protected void _ebean_setni_owner(String _newValue) {
        this.owner = _newValue;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
    }

    protected Set _ebean_get_issues() {
        this._ebean_intercept.preGetter("issues");
        if (this.issues == null) {
            this.issues = new BeanSet();
        }
        return this.issues;
    }

    protected void _ebean_set_issues(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "issues", (Object)this._ebean_get_issues(), (Object)newValue);
        this.issues = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_issues() {
        return this.issues;
    }

    protected void _ebean_setni_issues(Set _newValue) {
        this.issues = _newValue;
    }

    protected List _ebean_get_projectUser() {
        this._ebean_intercept.preGetter("projectUser");
        if (this.projectUser == null) {
            this.projectUser = new BeanList();
        }
        return this.projectUser;
    }

    protected void _ebean_set_projectUser(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "projectUser", (Object)this._ebean_get_projectUser(), (Object)newValue);
        this.projectUser = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_projectUser() {
        return this.projectUser;
    }

    protected void _ebean_setni_projectUser(List _newValue) {
        this.projectUser = _newValue;
    }

    protected List _ebean_get_posts() {
        this._ebean_intercept.preGetter("posts");
        if (this.posts == null) {
            this.posts = new BeanList();
        }
        return this.posts;
    }

    protected void _ebean_set_posts(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "posts", (Object)this._ebean_get_posts(), (Object)newValue);
        this.posts = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_posts() {
        return this.posts;
    }

    protected void _ebean_setni_posts(List _newValue) {
        this.posts = _newValue;
    }

    protected List _ebean_get_milestones() {
        this._ebean_intercept.preGetter("milestones");
        if (this.milestones == null) {
            this.milestones = new BeanList();
        }
        return this.milestones;
    }

    protected void _ebean_set_milestones(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "milestones", (Object)this._ebean_get_milestones(), (Object)newValue);
        this.milestones = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_milestones() {
        return this.milestones;
    }

    protected void _ebean_setni_milestones(List _newValue) {
        this.milestones = _newValue;
    }

    protected List _ebean_get_notifications() {
        this._ebean_intercept.preGetter("notifications");
        if (this.notifications == null) {
            this.notifications = new BeanList();
        }
        return this.notifications;
    }

    protected void _ebean_set_notifications(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "notifications", (Object)this._ebean_get_notifications(), (Object)newValue);
        this.notifications = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_notifications() {
        return this.notifications;
    }

    protected void _ebean_setni_notifications(List _newValue) {
        this.notifications = _newValue;
    }

    protected long _ebean_get_lastIssueNumber() {
        this._ebean_intercept.preGetter("lastIssueNumber");
        return this.lastIssueNumber;
    }

    protected void _ebean_set_lastIssueNumber(long newValue) {
        PropertyChangeEvent propertyChangeEvent = this._ebean_intercept.preSetter(true, "lastIssueNumber", this._ebean_get_lastIssueNumber(), newValue);
        this.lastIssueNumber = newValue;
        this._ebean_intercept.postSetter(propertyChangeEvent);
    }

    protected long _ebean_getni_lastIssueNumber() {
        return this.lastIssueNumber;
    }

    protected void _ebean_setni_lastIssueNumber(long _newValue) {
        this.lastIssueNumber = _newValue;
    }

    protected long _ebean_get_lastPostingNumber() {
        this._ebean_intercept.preGetter("lastPostingNumber");
        return this.lastPostingNumber;
    }

    protected void _ebean_set_lastPostingNumber(long newValue) {
        PropertyChangeEvent propertyChangeEvent = this._ebean_intercept.preSetter(true, "lastPostingNumber", this._ebean_get_lastPostingNumber(), newValue);
        this.lastPostingNumber = newValue;
        this._ebean_intercept.postSetter(propertyChangeEvent);
    }

    protected long _ebean_getni_lastPostingNumber() {
        return this.lastPostingNumber;
    }

    protected void _ebean_setni_lastPostingNumber(long _newValue) {
        this.lastPostingNumber = _newValue;
    }

    protected boolean _ebean_get_isCodeAccessibleMemberOnly() {
        this._ebean_intercept.preGetter("isCodeAccessibleMemberOnly");
        return this.isCodeAccessibleMemberOnly;
    }

    protected void _ebean_set_isCodeAccessibleMemberOnly(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "isCodeAccessibleMemberOnly", this._ebean_get_isCodeAccessibleMemberOnly(), newValue);
        this.isCodeAccessibleMemberOnly = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_isCodeAccessibleMemberOnly() {
        return this.isCodeAccessibleMemberOnly;
    }

    protected void _ebean_setni_isCodeAccessibleMemberOnly(boolean _newValue) {
        this.isCodeAccessibleMemberOnly = _newValue;
    }

    protected Set _ebean_get_labels() {
        this._ebean_intercept.preGetter("labels");
        if (this.labels == null) {
            this.labels = new BeanSet();
            ((BeanCollection)this.labels).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.labels;
    }

    protected void _ebean_set_labels(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "labels", (Object)this._ebean_get_labels(), (Object)newValue);
        this.labels = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_labels() {
        return this.labels;
    }

    protected void _ebean_setni_labels(Set _newValue) {
        this.labels = _newValue;
    }

    protected Project _ebean_get_originalProject() {
        this._ebean_intercept.preGetter("originalProject");
        return this.originalProject;
    }

    protected void _ebean_set_originalProject(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "originalProject", (Object)this._ebean_get_originalProject(), (Object)newValue);
        this.originalProject = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_originalProject() {
        return this.originalProject;
    }

    protected void _ebean_setni_originalProject(Project _newValue) {
        this.originalProject = _newValue;
    }

    protected List _ebean_get_forkingProjects() {
        this._ebean_intercept.preGetter("forkingProjects");
        if (this.forkingProjects == null) {
            this.forkingProjects = new BeanList();
        }
        return this.forkingProjects;
    }

    protected void _ebean_set_forkingProjects(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "forkingProjects", (Object)this._ebean_get_forkingProjects(), (Object)newValue);
        this.forkingProjects = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_forkingProjects() {
        return this.forkingProjects;
    }

    protected void _ebean_setni_forkingProjects(List _newValue) {
        this.forkingProjects = _newValue;
    }

    protected Set _ebean_get_webhooks() {
        this._ebean_intercept.preGetter("webhooks");
        if (this.webhooks == null) {
            this.webhooks = new BeanSet();
        }
        return this.webhooks;
    }

    protected void _ebean_set_webhooks(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "webhooks", (Object)this._ebean_get_webhooks(), (Object)newValue);
        this.webhooks = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_webhooks() {
        return this.webhooks;
    }

    protected void _ebean_setni_webhooks(Set _newValue) {
        this.webhooks = _newValue;
    }

    protected Set _ebean_get_assignees() {
        this._ebean_intercept.preGetter("assignees");
        if (this.assignees == null) {
            this.assignees = new BeanSet();
        }
        return this.assignees;
    }

    protected void _ebean_set_assignees(Set newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "assignees", (Object)this._ebean_get_assignees(), (Object)newValue);
        this.assignees = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Set _ebean_getni_assignees() {
        return this.assignees;
    }

    protected void _ebean_setni_assignees(Set _newValue) {
        this.assignees = _newValue;
    }

    protected Date _ebean_get_lastPushedDate() {
        this._ebean_intercept.preGetter("lastPushedDate");
        return this.lastPushedDate;
    }

    protected void _ebean_set_lastPushedDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "lastPushedDate", (Object)this._ebean_get_lastPushedDate(), (Object)newValue);
        this.lastPushedDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_lastPushedDate() {
        return this.lastPushedDate;
    }

    protected void _ebean_setni_lastPushedDate(Date _newValue) {
        this.lastPushedDate = _newValue;
    }

    protected List _ebean_get_pushedBranches() {
        this._ebean_intercept.preGetter("pushedBranches");
        if (this.pushedBranches == null) {
            this.pushedBranches = new BeanList();
        }
        return this.pushedBranches;
    }

    protected void _ebean_set_pushedBranches(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "pushedBranches", (Object)this._ebean_get_pushedBranches(), (Object)newValue);
        this.pushedBranches = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_pushedBranches() {
        return this.pushedBranches;
    }

    protected void _ebean_setni_pushedBranches(List _newValue) {
        this.pushedBranches = _newValue;
    }

    protected List _ebean_get_enrolledUsers() {
        this._ebean_intercept.preGetter("enrolledUsers");
        if (this.enrolledUsers == null) {
            this.enrolledUsers = new BeanList();
            ((BeanCollection)this.enrolledUsers).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.enrolledUsers;
    }

    protected void _ebean_set_enrolledUsers(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "enrolledUsers", (Object)this._ebean_get_enrolledUsers(), (Object)newValue);
        this.enrolledUsers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_enrolledUsers() {
        return this.enrolledUsers;
    }

    protected void _ebean_setni_enrolledUsers(List _newValue) {
        this.enrolledUsers = _newValue;
    }

    protected List _ebean_get_codeComments() {
        this._ebean_intercept.preGetter("codeComments");
        if (this.codeComments == null) {
            this.codeComments = new BeanList();
        }
        return this.codeComments;
    }

    protected void _ebean_set_codeComments(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "codeComments", (Object)this._ebean_get_codeComments(), (Object)newValue);
        this.codeComments = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_codeComments() {
        return this.codeComments;
    }

    protected void _ebean_setni_codeComments(List _newValue) {
        this.codeComments = _newValue;
    }

    protected List _ebean_get_commentThreads() {
        this._ebean_intercept.preGetter("commentThreads");
        if (this.commentThreads == null) {
            this.commentThreads = new BeanList();
        }
        return this.commentThreads;
    }

    protected void _ebean_set_commentThreads(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "commentThreads", (Object)this._ebean_get_commentThreads(), (Object)newValue);
        this.commentThreads = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_commentThreads() {
        return this.commentThreads;
    }

    protected void _ebean_setni_commentThreads(List _newValue) {
        this.commentThreads = _newValue;
    }

    protected Integer _ebean_get_defaultReviewerCount() {
        this._ebean_intercept.preGetter("defaultReviewerCount");
        return this.defaultReviewerCount;
    }

    protected void _ebean_set_defaultReviewerCount(Integer newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "defaultReviewerCount", (Object)this._ebean_get_defaultReviewerCount(), (Object)newValue);
        this.defaultReviewerCount = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Integer _ebean_getni_defaultReviewerCount() {
        return this.defaultReviewerCount;
    }

    protected void _ebean_setni_defaultReviewerCount(Integer _newValue) {
        this.defaultReviewerCount = _newValue;
    }

    protected boolean _ebean_get_isUsingReviewerCount() {
        this._ebean_intercept.preGetter("isUsingReviewerCount");
        return this.isUsingReviewerCount;
    }

    protected void _ebean_set_isUsingReviewerCount(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "isUsingReviewerCount", this._ebean_get_isUsingReviewerCount(), newValue);
        this.isUsingReviewerCount = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_isUsingReviewerCount() {
        return this.isUsingReviewerCount;
    }

    protected void _ebean_setni_isUsingReviewerCount(boolean _newValue) {
        this.isUsingReviewerCount = _newValue;
    }

    protected Organization _ebean_get_organization() {
        this._ebean_intercept.preGetter("organization");
        return this.organization;
    }

    protected void _ebean_set_organization(Organization newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "organization", (Object)this._ebean_get_organization(), (Object)newValue);
        this.organization = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Organization _ebean_getni_organization() {
        return this.organization;
    }

    protected void _ebean_setni_organization(Organization _newValue) {
        this.organization = _newValue;
    }

    protected ProjectScope _ebean_get_projectScope() {
        this._ebean_intercept.preGetter("projectScope");
        return this.projectScope;
    }

    protected void _ebean_set_projectScope(ProjectScope newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "projectScope", (Object)this._ebean_get_projectScope(), (Object)newValue);
        this.projectScope = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected ProjectScope _ebean_getni_projectScope() {
        return this.projectScope;
    }

    protected void _ebean_setni_projectScope(ProjectScope _newValue) {
        this.projectScope = _newValue;
    }

    protected ProjectMenuSetting _ebean_get_menuSetting() {
        this._ebean_intercept.preGetter("menuSetting");
        return this.menuSetting;
    }

    protected void _ebean_set_menuSetting(ProjectMenuSetting newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "menuSetting", (Object)this._ebean_get_menuSetting(), (Object)newValue);
        this.menuSetting = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected ProjectMenuSetting _ebean_getni_menuSetting() {
        return this.menuSetting;
    }

    protected void _ebean_setni_menuSetting(ProjectMenuSetting _newValue) {
        this.menuSetting = _newValue;
    }

    protected String _ebean_get_previousOwnerLoginId() {
        this._ebean_intercept.preGetter("previousOwnerLoginId");
        return this.previousOwnerLoginId;
    }

    protected void _ebean_set_previousOwnerLoginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "previousOwnerLoginId", (Object)this._ebean_get_previousOwnerLoginId(), (Object)newValue);
        this.previousOwnerLoginId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_previousOwnerLoginId() {
        return this.previousOwnerLoginId;
    }

    protected void _ebean_setni_previousOwnerLoginId(String _newValue) {
        this.previousOwnerLoginId = _newValue;
    }

    protected String _ebean_get_previousName() {
        this._ebean_intercept.preGetter("previousName");
        return this.previousName;
    }

    protected void _ebean_set_previousName(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "previousName", (Object)this._ebean_get_previousName(), (Object)newValue);
        this.previousName = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_previousName() {
        return this.previousName;
    }

    protected void _ebean_setni_previousName(String _newValue) {
        this.previousName = _newValue;
    }

    protected Long _ebean_get_previousNameChangedTime() {
        this._ebean_intercept.preGetter("previousNameChangedTime");
        return this.previousNameChangedTime;
    }

    protected void _ebean_set_previousNameChangedTime(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "previousNameChangedTime", (Object)this._ebean_get_previousNameChangedTime(), (Object)newValue);
        this.previousNameChangedTime = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_previousNameChangedTime() {
        return this.previousNameChangedTime;
    }

    protected void _ebean_setni_previousNameChangedTime(Long _newValue) {
        this.previousNameChangedTime = _newValue;
    }

    protected List _ebean_get_issueLabels() {
        this._ebean_intercept.preGetter("issueLabels");
        if (this.issueLabels == null) {
            this.issueLabels = new BeanList();
        }
        return this.issueLabels;
    }

    protected void _ebean_set_issueLabels(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "issueLabels", (Object)this._ebean_get_issueLabels(), (Object)newValue);
        this.issueLabels = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_issueLabels() {
        return this.issueLabels;
    }

    protected void _ebean_setni_issueLabels(List _newValue) {
        this.issueLabels = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Project project2 = new Project();
        project2.id = this.id;
        project2.name = this.name;
        project2.overview = this.overview;
        project2.vcs = this.vcs;
        project2.siteurl = this.siteurl;
        project2.owner = this.owner;
        project2.createdDate = this.createdDate;
        project2.issues = this.issues;
        project2.projectUser = this.projectUser;
        project2.posts = this.posts;
        project2.milestones = this.milestones;
        project2.notifications = this.notifications;
        project2.lastIssueNumber = this.lastIssueNumber;
        project2.lastPostingNumber = this.lastPostingNumber;
        project2.isCodeAccessibleMemberOnly = this.isCodeAccessibleMemberOnly;
        project2.labels = this.labels;
        project2.originalProject = this.originalProject;
        project2.forkingProjects = this.forkingProjects;
        project2.webhooks = this.webhooks;
        project2.assignees = this.assignees;
        project2.lastPushedDate = this.lastPushedDate;
        project2.pushedBranches = this.pushedBranches;
        project2.enrolledUsers = this.enrolledUsers;
        project2.codeComments = this.codeComments;
        project2.commentThreads = this.commentThreads;
        project2.defaultReviewerCount = this.defaultReviewerCount;
        project2.isUsingReviewerCount = this.isUsingReviewerCount;
        project2.organization = this.organization;
        project2.projectScope = this.projectScope;
        project2.menuSetting = this.menuSetting;
        project2.previousOwnerLoginId = this.previousOwnerLoginId;
        project2.previousName = this.previousName;
        project2.previousNameChangedTime = this.previousNameChangedTime;
        project2.issueLabels = this.issueLabels;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Project p = (Project)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.name;
            }
            case 3: {
                return p.overview;
            }
            case 4: {
                return p.vcs;
            }
            case 5: {
                return p.siteurl;
            }
            case 6: {
                return p.owner;
            }
            case 7: {
                return p.createdDate;
            }
            case 8: {
                return p.issues;
            }
            case 9: {
                return p.projectUser;
            }
            case 10: {
                return p.posts;
            }
            case 11: {
                return p.milestones;
            }
            case 12: {
                return p.notifications;
            }
            case 13: {
                return p.lastIssueNumber;
            }
            case 14: {
                return p.lastPostingNumber;
            }
            case 15: {
                return p.isCodeAccessibleMemberOnly;
            }
            case 16: {
                return p.labels;
            }
            case 17: {
                return p.originalProject;
            }
            case 18: {
                return p.forkingProjects;
            }
            case 19: {
                return p.webhooks;
            }
            case 20: {
                return p.assignees;
            }
            case 21: {
                return p.lastPushedDate;
            }
            case 22: {
                return p.pushedBranches;
            }
            case 23: {
                return p.enrolledUsers;
            }
            case 24: {
                return p.codeComments;
            }
            case 25: {
                return p.commentThreads;
            }
            case 26: {
                return p.defaultReviewerCount;
            }
            case 27: {
                return p.isUsingReviewerCount;
            }
            case 28: {
                return p.organization;
            }
            case 29: {
                return p.projectScope;
            }
            case 30: {
                return p.menuSetting;
            }
            case 31: {
                return p.previousOwnerLoginId;
            }
            case 32: {
                return p.previousName;
            }
            case 33: {
                return p.previousNameChangedTime;
            }
            case 34: {
                return p.issueLabels;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Project p = (Project)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_name();
            }
            case 3: {
                return p._ebean_get_overview();
            }
            case 4: {
                return p._ebean_get_vcs();
            }
            case 5: {
                return p._ebean_get_siteurl();
            }
            case 6: {
                return p._ebean_get_owner();
            }
            case 7: {
                return p._ebean_get_createdDate();
            }
            case 8: {
                return p._ebean_get_issues();
            }
            case 9: {
                return p._ebean_get_projectUser();
            }
            case 10: {
                return p._ebean_get_posts();
            }
            case 11: {
                return p._ebean_get_milestones();
            }
            case 12: {
                return p._ebean_get_notifications();
            }
            case 13: {
                return p._ebean_get_lastIssueNumber();
            }
            case 14: {
                return p._ebean_get_lastPostingNumber();
            }
            case 15: {
                return p._ebean_get_isCodeAccessibleMemberOnly();
            }
            case 16: {
                return p._ebean_get_labels();
            }
            case 17: {
                return p._ebean_get_originalProject();
            }
            case 18: {
                return p._ebean_get_forkingProjects();
            }
            case 19: {
                return p._ebean_get_webhooks();
            }
            case 20: {
                return p._ebean_get_assignees();
            }
            case 21: {
                return p._ebean_get_lastPushedDate();
            }
            case 22: {
                return p._ebean_get_pushedBranches();
            }
            case 23: {
                return p._ebean_get_enrolledUsers();
            }
            case 24: {
                return p._ebean_get_codeComments();
            }
            case 25: {
                return p._ebean_get_commentThreads();
            }
            case 26: {
                return p._ebean_get_defaultReviewerCount();
            }
            case 27: {
                return p._ebean_get_isUsingReviewerCount();
            }
            case 28: {
                return p._ebean_get_organization();
            }
            case 29: {
                return p._ebean_get_projectScope();
            }
            case 30: {
                return p._ebean_get_menuSetting();
            }
            case 31: {
                return p._ebean_get_previousOwnerLoginId();
            }
            case 32: {
                return p._ebean_get_previousName();
            }
            case 33: {
                return p._ebean_get_previousNameChangedTime();
            }
            case 34: {
                return p._ebean_get_issueLabels();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Project p = (Project)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.name = (String)arg;
                return;
            }
            case 3: {
                p.overview = (String)arg;
                return;
            }
            case 4: {
                p.vcs = (String)arg;
                return;
            }
            case 5: {
                p.siteurl = (String)arg;
                return;
            }
            case 6: {
                p.owner = (String)arg;
                return;
            }
            case 7: {
                p.createdDate = (Date)arg;
                return;
            }
            case 8: {
                p.issues = (Set)arg;
                return;
            }
            case 9: {
                p.projectUser = (List)arg;
                return;
            }
            case 10: {
                p.posts = (List)arg;
                return;
            }
            case 11: {
                p.milestones = (List)arg;
                return;
            }
            case 12: {
                p.notifications = (List)arg;
                return;
            }
            case 13: {
                p.lastIssueNumber = (Long)arg;
                return;
            }
            case 14: {
                p.lastPostingNumber = (Long)arg;
                return;
            }
            case 15: {
                p.isCodeAccessibleMemberOnly = (Boolean)arg;
                return;
            }
            case 16: {
                p.labels = (Set)arg;
                return;
            }
            case 17: {
                p.originalProject = (Project)arg;
                return;
            }
            case 18: {
                p.forkingProjects = (List)arg;
                return;
            }
            case 19: {
                p.webhooks = (Set)arg;
                return;
            }
            case 20: {
                p.assignees = (Set)arg;
                return;
            }
            case 21: {
                p.lastPushedDate = (Date)arg;
                return;
            }
            case 22: {
                p.pushedBranches = (List)arg;
                return;
            }
            case 23: {
                p.enrolledUsers = (List)arg;
                return;
            }
            case 24: {
                p.codeComments = (List)arg;
                return;
            }
            case 25: {
                p.commentThreads = (List)arg;
                return;
            }
            case 26: {
                p.defaultReviewerCount = (Integer)arg;
                return;
            }
            case 27: {
                p.isUsingReviewerCount = (Boolean)arg;
                return;
            }
            case 28: {
                p.organization = (Organization)arg;
                return;
            }
            case 29: {
                p.projectScope = (ProjectScope)((Object)arg);
                return;
            }
            case 30: {
                p.menuSetting = (ProjectMenuSetting)((Object)arg);
                return;
            }
            case 31: {
                p.previousOwnerLoginId = (String)arg;
                return;
            }
            case 32: {
                p.previousName = (String)arg;
                return;
            }
            case 33: {
                p.previousNameChangedTime = (Long)arg;
                return;
            }
            case 34: {
                p.issueLabels = (List)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Project p = (Project)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_overview((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_vcs((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_siteurl((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_owner((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 8: {
                p._ebean_set_issues((Set)arg);
                return;
            }
            case 9: {
                p._ebean_set_projectUser((List)arg);
                return;
            }
            case 10: {
                p._ebean_set_posts((List)arg);
                return;
            }
            case 11: {
                p._ebean_set_milestones((List)arg);
                return;
            }
            case 12: {
                p._ebean_set_notifications((List)arg);
                return;
            }
            case 13: {
                p._ebean_set_lastIssueNumber((Long)arg);
                return;
            }
            case 14: {
                p._ebean_set_lastPostingNumber((Long)arg);
                return;
            }
            case 15: {
                p._ebean_set_isCodeAccessibleMemberOnly((Boolean)arg);
                return;
            }
            case 16: {
                p._ebean_set_labels((Set)arg);
                return;
            }
            case 17: {
                p._ebean_set_originalProject((Project)arg);
                return;
            }
            case 18: {
                p._ebean_set_forkingProjects((List)arg);
                return;
            }
            case 19: {
                p._ebean_set_webhooks((Set)arg);
                return;
            }
            case 20: {
                p._ebean_set_assignees((Set)arg);
                return;
            }
            case 21: {
                p._ebean_set_lastPushedDate((Date)arg);
                return;
            }
            case 22: {
                p._ebean_set_pushedBranches((List)arg);
                return;
            }
            case 23: {
                p._ebean_set_enrolledUsers((List)arg);
                return;
            }
            case 24: {
                p._ebean_set_codeComments((List)arg);
                return;
            }
            case 25: {
                p._ebean_set_commentThreads((List)arg);
                return;
            }
            case 26: {
                p._ebean_set_defaultReviewerCount((Integer)arg);
                return;
            }
            case 27: {
                p._ebean_set_isUsingReviewerCount((Boolean)arg);
                return;
            }
            case 28: {
                p._ebean_set_organization((Organization)arg);
                return;
            }
            case 29: {
                p._ebean_set_projectScope((ProjectScope)((Object)arg));
                return;
            }
            case 30: {
                p._ebean_set_menuSetting((ProjectMenuSetting)((Object)arg));
                return;
            }
            case 31: {
                p._ebean_set_previousOwnerLoginId((String)arg);
                return;
            }
            case 32: {
                p._ebean_set_previousName((String)arg);
                return;
            }
            case 33: {
                p._ebean_set_previousNameChangedTime((Long)arg);
                return;
            }
            case 34: {
                p._ebean_set_issueLabels((List)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "name", "overview", "vcs", "siteurl", "owner", "createdDate", "issues", "projectUser", "posts", "milestones", "notifications", "lastIssueNumber", "lastPostingNumber", "isCodeAccessibleMemberOnly", "labels", "originalProject", "forkingProjects", "webhooks", "assignees", "lastPushedDate", "pushedBranches", "enrolledUsers", "codeComments", "commentThreads", "defaultReviewerCount", "isUsingReviewerCount", "organization", "projectScope", "menuSetting", "previousOwnerLoginId", "previousName", "previousNameChangedTime", "issueLabels"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Project project2 = this;
        synchronized (project2) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Project)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static enum State {
        PUBLIC,
        PRIVATE,
        ALL;

    }
}

