/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import models.NotificationEvent;
import models.PullRequest;
import models.PullRequestCommit;
import models.TimelineItem;
import models.User;
import models.enumeration.EventType;
import models.enumeration.State;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import utils.EventConstants;
import utils.JodaDateUtil;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PullRequestEvent
extends Model
implements TimelineItem,
EntityBean {
    private static final long serialVersionUID = 1981361242582594128L;
    public static final Model.Finder<Long, PullRequestEvent> finder = new Model.Finder(Long.class, PullRequestEvent.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String senderLoginId;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public PullRequest pullRequest;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public EventType eventType;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date created;
    @Lob
    @PropertiesEnhancer.GeneratedSetAccessor
    public String oldValue;
    @Lob
    @PropertiesEnhancer.GeneratedSetAccessor
    public String newValue;
    private static String _EBEAN_MARKER = "models.PullRequestEvent";

    @Override
    public Date getDate() {
        PullRequestEvent pullRequestEvent = this;
        Date date = null;
        date = pullRequestEvent.getCreated();
        return date;
    }

    public static void addFromNotificationEvent(NotificationEvent notiEvent, PullRequest pullRequest2) {
        PullRequestEvent event = new PullRequestEvent();
        Model model = notiEvent;
        Object object = null;
        object = model.getCreated();
        model = event;
        model.setCreated((Date)object);
        model = notiEvent.getSender();
        object = null;
        object = model.getLoginId();
        model = event;
        model.setSenderLoginId((String)object);
        object = pullRequest2;
        model = event;
        model.setPullRequest((PullRequest)object);
        model = notiEvent;
        object = null;
        object = model.getEventType();
        model = event;
        model.setEventType((EventType)((Object)object));
        object = notiEvent.getOldValue();
        model = event;
        model.setOldValue((String)object);
        object = notiEvent.newValue;
        model = event;
        model.setNewValue((String)object);
        PullRequestEvent.add(event);
    }

    private static void add(PullRequestEvent event) {
        PullRequestEvent lastEvent = PullRequestEvent.getLatestEventInDraftTime(event);
        if (PullRequestEvent.needToDeleteEvent(lastEvent, event)) {
            lastEvent.delete();
        } else {
            event.save();
        }
    }

    private static PullRequestEvent getLatestEventInDraftTime(PullRequestEvent event) {
        Date draftDate = DateTime.now().minusMillis(EventConstants.DRAFT_TIME_IN_MILLIS).toDate();
        Model model = event;
        Object object = null;
        object = model.getPullRequest();
        model = object;
        object = null;
        object = model.getId();
        return (PullRequestEvent)finder.where().eq("pull_request_id", object).gt("created", (Object)draftDate).orderBy("created desc").setMaxRows(1).findUnique();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean needToDeleteEvent(PullRequestEvent lastEvent, PullRequestEvent currentEvent) {
        if (lastEvent == null) return false;
        PullRequestEvent pullRequestEvent = currentEvent;
        Object var3_3 = null;
        EventType eventType = pullRequestEvent.getEventType();
        if (eventType != EventType.PULL_REQUEST_REVIEW_STATE_CHANGED) return false;
        pullRequestEvent = lastEvent;
        Object var3_5 = null;
        EventType eventType2 = pullRequestEvent.getEventType();
        if (eventType2 != EventType.PULL_REQUEST_REVIEW_STATE_CHANGED) return false;
        pullRequestEvent = currentEvent;
        Object var3_7 = null;
        String string = pullRequestEvent.getSenderLoginId();
        pullRequestEvent = lastEvent;
        Object var3_9 = null;
        String string2 = pullRequestEvent.getSenderLoginId();
        if (!StringUtils.equals((CharSequence)string, (CharSequence)string2)) return false;
        return true;
    }

    public static void addStateEvent(User sender, PullRequest pullRequest2, State state) {
        PullRequestEvent event = new PullRequestEvent();
        Object object = JodaDateUtil.now();
        Model model = event;
        model.setCreated((Date)object);
        model = sender;
        object = null;
        object = model.getLoginId();
        model = event;
        model.setSenderLoginId((String)object);
        object = pullRequest2;
        model = event;
        model.setPullRequest((PullRequest)object);
        object = EventType.PULL_REQUEST_STATE_CHANGED;
        model = event;
        model.setEventType((EventType)((Object)object));
        object = state.state();
        model = event;
        model.setNewValue((String)object);
        event.save();
    }

    public static void addMergeEvent(User sender, EventType eventType, State state, PullRequest pullRequest2) {
        PullRequestEvent event = new PullRequestEvent();
        Object object = new Date();
        Model model = event;
        model.setCreated((Date)object);
        model = sender;
        object = null;
        object = model.getLoginId();
        model = event;
        model.setSenderLoginId((String)object);
        object = pullRequest2;
        model = event;
        model.setPullRequest((PullRequest)object);
        object = eventType;
        model = event;
        model.setEventType((EventType)((Object)object));
        object = state.state();
        model = event;
        model.setNewValue((String)object);
        event.save();
    }

    public static void addCommitEvents(User sender, PullRequest pullRequest2, List<PullRequestCommit> commits, String oldValue) {
        Date createdDate = new Date();
        PullRequestEvent event = new PullRequestEvent();
        Object object = createdDate;
        Model model = event;
        model.setCreated((Date)object);
        model = sender;
        object = null;
        object = model.getLoginId();
        model = event;
        model.setSenderLoginId((String)object);
        object = pullRequest2;
        model = event;
        model.setPullRequest((PullRequest)object);
        object = EventType.PULL_REQUEST_COMMIT_CHANGED;
        model = event;
        model.setEventType((EventType)((Object)object));
        object = "";
        model = event;
        model.setNewValue((String)object);
        object = oldValue;
        model = event;
        model.setOldValue((String)object);
        for (int i = 0; i < commits.size(); ++i) {
            PullRequestEvent pullRequestEvent = event;
            model = commits.get(i);
            object = null;
            object = model.getId();
            object = pullRequestEvent.newValue + object;
            model = pullRequestEvent;
            model.setNewValue((String)object);
            if (i == commits.size() - 1) continue;
            PullRequestEvent pullRequestEvent2 = event;
            object = pullRequestEvent2.newValue + ",";
            model = pullRequestEvent2;
            model.setNewValue((String)object);
        }
        event.save();
    }

    public static List<PullRequestEvent> findByPullRequest(PullRequest pullRequest2) {
        return finder.where().eq("pullRequest", (Object)pullRequest2).findList();
    }

    @Transient
    public List<PullRequestCommit> getPullRequestCommits() {
        String[] commitIds;
        ArrayList<PullRequestCommit> commits = new ArrayList<PullRequestCommit>();
        for (String commitId : commitIds = this.newValue.split(",")) {
            commits.add(PullRequestCommit.findById(commitId));
        }
        Collections.sort(commits, TimelineItem.DESC);
        return commits;
    }

    public String getOldValue() {
        return this._ebean_get_oldValue();
    }

    public String getNewValue() {
        return this._ebean_get_newValue();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSenderLoginId() {
        return this._ebean_get_senderLoginId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSenderLoginId(String string) {
        this._ebean_set_senderLoginId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public PullRequest getPullRequest() {
        return this._ebean_get_pullRequest();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPullRequest(PullRequest pullRequest2) {
        this._ebean_set_pullRequest(pullRequest2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public EventType getEventType() {
        return this._ebean_get_eventType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEventType(EventType eventType) {
        this._ebean_set_eventType(eventType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreated() {
        return this._ebean_get_created();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreated(Date date) {
        this._ebean_set_created(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOldValue(String string) {
        this._ebean_set_oldValue(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNewValue(String string) {
        this._ebean_set_newValue(string);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_senderLoginId() {
        this._ebean_intercept.preGetter("senderLoginId");
        return this.senderLoginId;
    }

    protected void _ebean_set_senderLoginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "senderLoginId", (Object)this._ebean_get_senderLoginId(), (Object)newValue);
        this.senderLoginId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_senderLoginId() {
        return this.senderLoginId;
    }

    protected void _ebean_setni_senderLoginId(String _newValue) {
        this.senderLoginId = _newValue;
    }

    protected PullRequest _ebean_get_pullRequest() {
        this._ebean_intercept.preGetter("pullRequest");
        return this.pullRequest;
    }

    protected void _ebean_set_pullRequest(PullRequest newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "pullRequest", (Object)this._ebean_get_pullRequest(), (Object)newValue);
        this.pullRequest = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected PullRequest _ebean_getni_pullRequest() {
        return this.pullRequest;
    }

    protected void _ebean_setni_pullRequest(PullRequest _newValue) {
        this.pullRequest = _newValue;
    }

    protected EventType _ebean_get_eventType() {
        this._ebean_intercept.preGetter("eventType");
        return this.eventType;
    }

    protected void _ebean_set_eventType(EventType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "eventType", (Object)this._ebean_get_eventType(), (Object)newValue);
        this.eventType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected EventType _ebean_getni_eventType() {
        return this.eventType;
    }

    protected void _ebean_setni_eventType(EventType _newValue) {
        this.eventType = _newValue;
    }

    protected Date _ebean_get_created() {
        this._ebean_intercept.preGetter("created");
        return this.created;
    }

    protected void _ebean_set_created(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "created", (Object)this._ebean_get_created(), (Object)newValue);
        this.created = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_created() {
        return this.created;
    }

    protected void _ebean_setni_created(Date _newValue) {
        this.created = _newValue;
    }

    protected String _ebean_get_oldValue() {
        this._ebean_intercept.preGetter("oldValue");
        return this.oldValue;
    }

    protected void _ebean_set_oldValue(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "oldValue", (Object)this._ebean_get_oldValue(), (Object)newValue);
        this.oldValue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_oldValue() {
        return this.oldValue;
    }

    protected void _ebean_setni_oldValue(String _newValue) {
        this.oldValue = _newValue;
    }

    protected String _ebean_get_newValue() {
        this._ebean_intercept.preGetter("newValue");
        return this.newValue;
    }

    protected void _ebean_set_newValue(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "newValue", (Object)this._ebean_get_newValue(), (Object)newValue);
        this.newValue = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_newValue() {
        return this.newValue;
    }

    protected void _ebean_setni_newValue(String _newValue) {
        this.newValue = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        PullRequestEvent pullRequestEvent = new PullRequestEvent();
        pullRequestEvent.id = this.id;
        pullRequestEvent.senderLoginId = this.senderLoginId;
        pullRequestEvent.pullRequest = this.pullRequest;
        pullRequestEvent.eventType = this.eventType;
        pullRequestEvent.created = this.created;
        pullRequestEvent.oldValue = this.oldValue;
        pullRequestEvent.newValue = this.newValue;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        PullRequestEvent p = (PullRequestEvent)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.senderLoginId;
            }
            case 3: {
                return p.pullRequest;
            }
            case 4: {
                return p.eventType;
            }
            case 5: {
                return p.created;
            }
            case 6: {
                return p.oldValue;
            }
            case 7: {
                return p.newValue;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        PullRequestEvent p = (PullRequestEvent)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_senderLoginId();
            }
            case 3: {
                return p._ebean_get_pullRequest();
            }
            case 4: {
                return p._ebean_get_eventType();
            }
            case 5: {
                return p._ebean_get_created();
            }
            case 6: {
                return p._ebean_get_oldValue();
            }
            case 7: {
                return p._ebean_get_newValue();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        PullRequestEvent p = (PullRequestEvent)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.senderLoginId = (String)arg;
                return;
            }
            case 3: {
                p.pullRequest = (PullRequest)arg;
                return;
            }
            case 4: {
                p.eventType = (EventType)((Object)arg);
                return;
            }
            case 5: {
                p.created = (Date)arg;
                return;
            }
            case 6: {
                p.oldValue = (String)arg;
                return;
            }
            case 7: {
                p.newValue = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        PullRequestEvent p = (PullRequestEvent)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_senderLoginId((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_pullRequest((PullRequest)arg);
                return;
            }
            case 4: {
                p._ebean_set_eventType((EventType)((Object)arg));
                return;
            }
            case 5: {
                p._ebean_set_created((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_oldValue((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_newValue((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "senderLoginId", "pullRequest", "eventType", "created", "oldValue", "newValue"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        PullRequestEvent pullRequestEvent = this;
        synchronized (pullRequestEvent) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PullRequestEvent)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new PullRequestEvent();
    }
}

