/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.routes;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Size;
import models.AbstractPosting;
import models.Comment;
import models.Issue;
import models.Posting;
import models.Project;
import models.PullRequest;
import models.ReviewComment;
import models.User;
import models.WebhookThread;
import models.enumeration.EventType;
import models.enumeration.PullRequestReviewAction;
import models.enumeration.ResourceType;
import models.enumeration.WebhookType;
import models.resource.GlobalResource;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.revwalk.RevCommit;
import play.Logger;
import play.Play;
import play.api.i18n.Lang;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.libs.F;
import play.libs.Json;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import playRepository.GitCommit;
import utils.Config;
import utils.RouteUtil;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Webhook
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, Webhook> find = new Model.Finder(Long.class, Webhook.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @Constraints.Required
    @Size(max=2000, message="project.webhook.payloadUrl.tooLong")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String payloadUrl;
    @Size(max=250, message="project.webhook.secret.tooLong")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String secret;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Boolean gitPush;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public WebhookType webhookType;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdAt;
    private static String _EBEAN_MARKER = "models.Webhook";

    public Webhook(Long projectId, String payloadUrl, String secret2, Boolean gitPush, WebhookType webhookType) {
        Object object = WebhookType.SIMPLE;
        Webhook webhook = this;
        webhook.setWebhookType((WebhookType)((Object)object));
        if (secret2 == null) {
            secret2 = "";
        }
        object = (Project)Project.find.byId((Object)projectId);
        webhook = this;
        webhook.setProject((Project)object);
        object = payloadUrl;
        webhook = this;
        webhook.setPayloadUrl((String)object);
        object = secret2;
        webhook = this;
        webhook.setSecret((String)object);
        object = gitPush;
        webhook = this;
        webhook.setGitPush((Boolean)object);
        object = webhookType;
        webhook = this;
        webhook.setWebhookType((WebhookType)((Object)object));
        object = new Date();
        webhook = this;
        webhook.setCreatedAt((Date)object);
    }

    @Override
    public Resource asResource() {
        return new GlobalResource(){

            @Override
            public String getId() {
                Webhook webhook = Webhook.this;
                Long l = null;
                l = webhook.getId();
                return l.toString();
            }

            @Override
            public ResourceType getType() {
                return ResourceType.WEBHOOK;
            }
        };
    }

    public static List<Webhook> findByProject(Long projectId) {
        return find.where().eq("project.id", (Object)projectId).findList();
    }

    public static void create(Long projectId, String payloadUrl, String secret2, Boolean gitPush, WebhookType webhookType) {
        if (!payloadUrl.isEmpty()) {
            Webhook webhook = new Webhook(projectId, payloadUrl, secret2, gitPush, webhookType);
            webhook.save();
        }
    }

    public static void delete(Long webhookId, Long projectId) {
        Webhook.findByIds(webhookId, projectId).delete();
    }

    public void delete(Long projectId) {
        Project targetProject;
        Project project2 = targetProject = (Project)Project.find.byId((Object)projectId);
        Set<Webhook> set = null;
        set = project2.getWebhooks();
        set.remove(this);
        targetProject.update();
        super.delete();
    }

    public static Webhook findByIds(Long webhookId, Long projectId) {
        return (Webhook)find.where().eq("webhook.id", (Object)webhookId).eq("project.id", (Object)projectId).findUnique();
    }

    public static Webhook findById(Long webhookId) {
        return (Webhook)find.where().eq("id", (Object)webhookId).findUnique();
    }

    private String getBaseUrl() {
        return String.format("%s://%s", Config.getScheme(), Config.getHostport("localhost:9000"));
    }

    private String buildRequestMessage(String url, String message) {
        StringBuilder requestMessage = new StringBuilder();
        requestMessage.append(String.format(" <%s%s|", this.getBaseUrl(), url));
        Webhook webhook = this;
        WebhookType webhookType = null;
        webhookType = webhook.getWebhookType();
        if (webhookType == WebhookType.DETAIL_SLACK) {
            requestMessage.append(message.replace(">", "&gt;"));
        } else {
            requestMessage.append(message);
        }
        requestMessage.append(">");
        return requestMessage.toString();
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, Issue eventIssue) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventIssue);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_SLACK) {
            ArrayNode attachments = this.buildIssueDetails(eventIssue, eventType);
            requestBodyString = this.buildRequestJsonWithAttachments(requestMessage, attachments);
        } else {
            webhook = this;
            object = null;
            object = webhook.getWebhookType();
            if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
                ObjectNode thread = this.buildThreadJSON(eventIssue.asResource());
                requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
            } else {
                requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
            }
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventIssue.asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, Issue eventIssue) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[2];
        Object object = this;
        Object object2 = null;
        object2 = ((Webhook)object).getProject();
        object = object2;
        object2 = null;
        object2 = ((Project)object).getName();
        objectArray[0] = object2;
        object = sender;
        object2 = null;
        object2 = ((User)object).getName();
        objectArray[1] = object2;
        requestMessage.append(String.format("[%s] %s ", objectArray));
        switch (eventType) {
            case NEW_ISSUE: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.new.issue", (Object[])new Object[0]));
                break;
            }
            case ISSUE_STATE_CHANGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.issue.state.changed", (Object[])new Object[0]));
                break;
            }
            case ISSUE_ASSIGNEE_CHANGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.issue.assignee.changed", (Object[])new Object[0]));
                break;
            }
            case ISSUE_BODY_CHANGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.issue.body.changed", (Object[])new Object[0]));
                break;
            }
            case ISSUE_MILESTONE_CHANGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.milestone.changed", (Object[])new Object[0]));
                break;
            }
            case RESOURCE_DELETED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.issue.deleted", (Object[])new Object[0]));
                break;
            }
            default: {
                Logger.warn((String)String.format("Unknown webhook event: %s", new Object[]{eventType}));
            }
        }
        object = eventIssue;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        Object object3 = object2 = ((Project)object).getOwner();
        object = eventIssue;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        String eventIssueUrl = routes.IssueApp.issue((String)object3, (String)object2, eventIssue.getNumber()).url();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = eventIssue.number;
        object = eventIssue;
        object2 = null;
        objectArray2[1] = object2 = ((AbstractPosting)object).getTitle();
        requestMessage.append(this.buildRequestMessage(eventIssueUrl, String.format("#%d: %s", objectArray2)));
        return requestMessage.toString();
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, Issue eventIssue, Project previous) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventIssue, previous);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_SLACK) {
            ArrayNode attachments = this.buildIssueDetails(eventIssue, eventType);
            requestBodyString = this.buildRequestJsonWithAttachments(requestMessage, attachments);
        } else {
            webhook = this;
            object = null;
            object = webhook.getWebhookType();
            if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
                ObjectNode thread = this.buildThreadJSON(eventIssue.asResource());
                requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
            } else {
                requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
            }
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventIssue.asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, Issue eventIssue, Project previous) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[2];
        Object object = this;
        Object object2 = null;
        object = object2 = ((Webhook)object).getProject();
        object2 = null;
        objectArray[0] = object2 = ((Project)object).getName();
        object = sender;
        object2 = null;
        objectArray[1] = object2 = ((User)object).getName();
        requestMessage.append(String.format("[%s] %s ", objectArray));
        Object[] objectArray2 = new Object[2];
        object = previous;
        object2 = null;
        objectArray2[0] = object2 = ((Project)object).getName();
        object = this;
        object2 = null;
        object = object2 = ((Webhook)object).getProject();
        object2 = null;
        objectArray2[1] = object2 = ((Project)object).getName();
        requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.issue.moved", (Object[])objectArray2));
        object = eventIssue;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        Object object3 = object2 = ((Project)object).getOwner();
        object = eventIssue;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        String string = routes.IssueApp.issue((String)object3, (String)object2, eventIssue.getNumber()).url();
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = eventIssue.number;
        object = eventIssue;
        object2 = null;
        objectArray3[1] = object2 = ((AbstractPosting)object).getTitle();
        requestMessage.append(this.buildRequestMessage(string, String.format("#%d: %s", objectArray3)));
        return requestMessage.toString();
    }

    private ArrayNode buildIssueDetails(Issue eventIssue, EventType eventType) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode attachments = mapper.createArrayNode();
        ArrayNode detailFields = mapper.createArrayNode();
        Model model = eventIssue;
        Object object = null;
        object = model.getMilestone();
        if (object != null) {
            model = eventIssue;
            object = null;
            object = model.getMilestone();
            model = object;
            object = null;
            object = model.getTitle();
            detailFields.add((JsonNode)this.buildTitleValueJSON(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.milestone.changed", (Object[])new Object[0]), (String)object, true));
        }
        detailFields.add((JsonNode)this.buildTitleValueJSON(Messages.get((Lang)Lang.defaultLang(), (String)"", (Object[])new Object[0]), eventIssue.assigneeName(), true));
        model = eventIssue;
        object = null;
        object = model.getState();
        detailFields.add((JsonNode)this.buildTitleValueJSON(Messages.get((Lang)Lang.defaultLang(), (String)"issue.state", (Object[])new Object[0]), ((Enum)object).toString(), true));
        model = eventIssue;
        object = null;
        object = model.getBody();
        attachments.add((JsonNode)this.buildAttachmentJSON((String)object, detailFields, eventType));
        return attachments;
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, Posting eventPost) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventPost);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            ObjectNode thread = this.buildThreadJSON(eventPost.asResource());
            requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
        } else {
            requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventPost.asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, Posting eventPost) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[2];
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getName();
        objectArray[0] = object;
        model = sender;
        object = null;
        object = model.getName();
        objectArray[1] = object;
        requestMessage.append(String.format("[%s] %s ", objectArray));
        switch (eventType) {
            case NEW_POSTING: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.new.posting", (Object[])new Object[0]));
                break;
            }
            default: {
                Logger.warn((String)("Unknown webhook event: " + (Object)((Object)eventType)));
            }
        }
        String eventPostUrl = RouteUtil.getUrl(eventPost);
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = eventPost.number;
        model = eventPost;
        object = null;
        objectArray2[1] = object = model.getTitle();
        requestMessage.append(this.buildRequestMessage(eventPostUrl, String.format("#%d: %s", objectArray2)));
        return requestMessage.toString();
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, Comment eventComment) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventComment);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_SLACK) {
            ArrayNode attachments = this.buildCommentDetails(eventComment, eventType);
            requestBodyString = this.buildRequestJsonWithAttachments(requestMessage, attachments);
        } else {
            webhook = this;
            object = null;
            object = webhook.getWebhookType();
            if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
                ObjectNode thread = this.buildThreadJSON(eventComment.getParent().asResource());
                requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
            } else {
                requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
            }
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventComment.getParent().asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, Comment eventComment) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[2];
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getName();
        objectArray[0] = object;
        model = sender;
        object = null;
        object = model.getName();
        objectArray[1] = object;
        requestMessage.append(String.format("[%s] %s ", objectArray));
        switch (eventType) {
            case NEW_COMMENT: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.new.comment", (Object[])new Object[0]));
                break;
            }
            case COMMENT_UPDATED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.comment.updated", (Object[])new Object[0]));
            }
        }
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = eventComment.getParent().number;
        model = eventComment.getParent();
        object = null;
        objectArray2[1] = object = model.getTitle();
        requestMessage.append(this.buildRequestMessage(RouteUtil.getUrl(eventComment), String.format("#%d: %s", objectArray2)));
        return requestMessage.toString();
    }

    private ArrayNode buildCommentDetails(Comment eventComment, EventType eventType) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode attachments = mapper.createArrayNode();
        Comment comment = eventComment;
        String string = null;
        string = comment.getContents();
        attachments.add((JsonNode)this.buildAttachmentJSON(string, null, eventType));
        return attachments;
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, PullRequest eventPullRequest) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventPullRequest);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_SLACK) {
            ArrayNode attachments = this.buildJsonWithPullReqtuestDetails(eventPullRequest, requestMessage, eventType);
            requestBodyString = this.buildRequestJsonWithAttachments(requestMessage, attachments);
        } else {
            webhook = this;
            object = null;
            object = webhook.getWebhookType();
            if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
                ObjectNode thread = this.buildThreadJSON(eventPullRequest.asResource());
                requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
            } else {
                requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
            }
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventPullRequest.asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, PullRequest eventPullRequest) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[2];
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getName();
        objectArray[0] = object;
        model = sender;
        object = null;
        object = model.getName();
        objectArray[1] = object;
        requestMessage.append(String.format("[%s] %s ", objectArray));
        switch (eventType) {
            case NEW_PULL_REQUEST: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.new.pullrequest", (Object[])new Object[0]));
                break;
            }
            case PULL_REQUEST_STATE_CHANGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.pullrequest.state.changed", (Object[])new Object[0]));
                break;
            }
            case PULL_REQUEST_MERGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.pullrequest.merged", (Object[])new Object[0]));
                break;
            }
            case PULL_REQUEST_COMMIT_CHANGED: {
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.pullrequest.commit.changed", (Object[])new Object[0]));
            }
        }
        Object[] objectArray2 = new Object[2];
        model = eventPullRequest;
        object = null;
        objectArray2[0] = object = model.getNumber();
        model = eventPullRequest;
        object = null;
        objectArray2[1] = object = model.getTitle();
        requestMessage.append(this.buildRequestMessage(RouteUtil.getUrl(eventPullRequest), String.format("#%d: %s", objectArray2)));
        return requestMessage.toString();
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, PullRequest eventPullRequest, PullRequestReviewAction reviewAction) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventPullRequest, reviewAction);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_SLACK) {
            ArrayNode attachments = this.buildJsonWithPullReqtuestDetails(eventPullRequest, requestMessage, eventType);
            requestBodyString = this.buildRequestJsonWithAttachments(requestMessage, attachments);
        } else {
            webhook = this;
            object = null;
            object = webhook.getWebhookType();
            if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
                ObjectNode thread = this.buildThreadJSON(eventPullRequest.asResource());
                requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
            } else {
                requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
            }
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventPullRequest.asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, PullRequest eventPullRequest, PullRequestReviewAction reviewAction) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[1];
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        object = model.getName();
        objectArray[0] = object;
        requestMessage.append(String.format("[%s] ", objectArray));
        switch (eventType) {
            case PULL_REQUEST_REVIEW_STATE_CHANGED: {
                if (PullRequestReviewAction.DONE.equals((Object)reviewAction)) {
                    Object[] objectArray2 = new Object[1];
                    model = sender;
                    object = null;
                    objectArray2[0] = object = model.getName();
                    requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.pullrequest.reviewed", (Object[])objectArray2));
                    break;
                }
                Object[] objectArray3 = new Object[1];
                model = sender;
                object = null;
                objectArray3[0] = object = model.getName();
                requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.pullrequest.unreviewed", (Object[])objectArray3));
            }
        }
        Object[] objectArray4 = new Object[2];
        model = eventPullRequest;
        object = null;
        objectArray4[0] = object = model.getNumber();
        model = eventPullRequest;
        object = null;
        objectArray4[1] = object = model.getTitle();
        requestMessage.append(this.buildRequestMessage(RouteUtil.getUrl(eventPullRequest), String.format("#%d: %s", objectArray4)));
        return requestMessage.toString();
    }

    public void sendRequestToPayloadUrl(EventType eventType, User sender, PullRequest eventPullRequest, ReviewComment reviewComment) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(eventType, sender, eventPullRequest, reviewComment);
        Webhook webhook = this;
        Object object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_SLACK) {
            ArrayNode attachments = this.buildJsonWithPullReqtuestDetails(eventPullRequest, requestMessage, eventType);
            requestBodyString = this.buildRequestJsonWithAttachments(requestMessage, attachments);
        } else {
            webhook = this;
            object = null;
            object = webhook.getWebhookType();
            if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
                ObjectNode thread = this.buildThreadJSON(eventPullRequest.asResource());
                requestBodyString = this.buildRequestJsonWithThread(requestMessage, thread);
            } else {
                requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
            }
        }
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        if (object == WebhookType.DETAIL_HANGOUT_CHAT) {
            webhook = this;
            object = null;
            object = webhook.getId();
            this.sendRequest(requestBodyString, (Long)object, eventPullRequest.asResource());
        } else {
            this.sendRequest(requestBodyString);
        }
    }

    private String buildRequestBody(EventType eventType, User sender, PullRequest eventPullRequest, ReviewComment reviewComment) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[2];
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        objectArray[0] = object = model.getName();
        model = sender;
        object = null;
        objectArray[1] = object = model.getName();
        requestMessage.append(String.format("[%s] %s ", objectArray));
        requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.type.new.simple.comment", (Object[])new Object[0]));
        requestMessage.append(String.format(" <%s://%s%s|", Config.getScheme(), Config.getHostport("localhost:9000"), RouteUtil.getUrl(reviewComment)));
        Object[] objectArray2 = new Object[2];
        model = eventPullRequest;
        object = null;
        objectArray2[0] = object = model.getNumber();
        model = eventPullRequest;
        object = null;
        objectArray2[1] = object = model.getTitle();
        requestMessage.append(String.format("#%d: %s>", objectArray2));
        return requestMessage.toString();
    }

    private ArrayNode buildJsonWithPullReqtuestDetails(PullRequest eventPullRequest, String requestMessage, EventType eventType) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode detailFields = mapper.createArrayNode();
        Model model = eventPullRequest;
        Object object = null;
        object = model.getContributor();
        model = object;
        object = null;
        object = model.getName();
        detailFields.add((JsonNode)this.buildTitleValueJSON(Messages.get((Lang)Lang.defaultLang(), (String)"pullRequest.sender", (Object[])new Object[0]), (String)object, false));
        model = eventPullRequest;
        object = null;
        object = model.getFromBranch();
        detailFields.add((JsonNode)this.buildTitleValueJSON(Messages.get((Lang)Lang.defaultLang(), (String)"pullRequest.from", (Object[])new Object[0]), (String)object, true));
        model = eventPullRequest;
        object = null;
        object = model.getToBranch();
        detailFields.add((JsonNode)this.buildTitleValueJSON(Messages.get((Lang)Lang.defaultLang(), (String)"pullRequest.to", (Object[])new Object[0]), (String)object, true));
        ArrayNode attachments = mapper.createArrayNode();
        model = eventPullRequest;
        object = null;
        object = model.getBody();
        attachments.add((JsonNode)this.buildAttachmentJSON((String)object, detailFields, eventType));
        return attachments;
    }

    private String buildTextPropertyOnlyJSON(String requestMessage) {
        ObjectNode requestBody = Json.newObject();
        requestBody.put("text", requestMessage);
        return Json.stringify((JsonNode)requestBody);
    }

    private String buildRequestJsonWithAttachments(String requestMessage, ArrayNode attachments) {
        ObjectNode requestBody = Json.newObject();
        requestBody.put("text", requestMessage);
        requestBody.put("attachments", (JsonNode)attachments);
        return Json.stringify((JsonNode)requestBody);
    }

    private String buildRequestJsonWithThread(String requestMessage, ObjectNode thread) {
        ObjectNode requestBody = Json.newObject();
        requestBody.put("text", requestMessage);
        requestBody.put("thread", (JsonNode)thread);
        return Json.stringify((JsonNode)requestBody);
    }

    private ObjectNode buildTitleValueJSON(String title, String value, Boolean shorten) {
        ObjectNode titleJSON = Json.newObject();
        titleJSON.put("title", title);
        titleJSON.put("value", value);
        titleJSON.put("short", shorten);
        return titleJSON;
    }

    private ObjectNode buildAttachmentJSON(String text, ArrayNode detailFields, EventType eventType) {
        ObjectNode attachmentsJSON = Json.newObject();
        attachmentsJSON.put("text", text);
        attachmentsJSON.put("fields", (JsonNode)detailFields);
        String color = Play.application().configuration().getString("slack." + (Object)((Object)eventType), "");
        attachmentsJSON.put("color", color);
        return attachmentsJSON;
    }

    private ObjectNode buildSenderJSON(User sender) {
        ObjectNode senderJSON = Json.newObject();
        User user = sender;
        Object object = null;
        object = user.getLoginId();
        senderJSON.put("login", (String)object);
        user = sender;
        object = null;
        object = user.getId();
        senderJSON.put("id", (Long)object);
        senderJSON.put("avatar_url", sender.avatarUrl());
        senderJSON.put("type", "User");
        senderJSON.put("site_admin", sender.isSiteManager());
        return senderJSON;
    }

    private ObjectNode buildPusherJSON(User sender) {
        ObjectNode pusherJSON = Json.newObject();
        User user = sender;
        String string = null;
        string = user.getName();
        pusherJSON.put("name", string);
        user = sender;
        string = null;
        string = user.getEmail();
        pusherJSON.put("email", string);
        return pusherJSON;
    }

    private ObjectNode buildRepositoryJSON() {
        ObjectNode repositoryJSON = Json.newObject();
        Object object = this;
        Object object2 = null;
        object = object2 = ((Webhook)object).getProject();
        object2 = null;
        object2 = ((Project)object).getId();
        repositoryJSON.put("id", (Long)object2);
        object = this;
        object2 = null;
        object = object2 = ((Webhook)object).getProject();
        object2 = null;
        object2 = ((Project)object).getName();
        repositoryJSON.put("name", (String)object2);
        object = this;
        object2 = null;
        object = object2 = ((Webhook)object).getProject();
        object2 = null;
        object2 = ((Project)object).getOwner();
        repositoryJSON.put("owner", (String)object2);
        object = this;
        object2 = null;
        object2 = ((Webhook)object).getProject();
        repositoryJSON.put("html_url", RouteUtil.getUrl((Project)object2));
        object = this;
        object2 = null;
        object = object2 = ((Webhook)object).getProject();
        object2 = null;
        object2 = ((Project)object).getOverview();
        repositoryJSON.put("overview", (String)object2);
        object = this;
        object2 = null;
        object2 = ((Webhook)object).getProject();
        repositoryJSON.put("private", ((Project)object2).isPrivate());
        return repositoryJSON;
    }

    private ObjectNode buildThreadJSON(Resource resource) {
        ObjectNode threadJSON = Json.newObject();
        Model model = this;
        Object object = null;
        object = model.getId();
        WebhookThread webhookthread = WebhookThread.getWebhookThread((Long)object, resource);
        if (webhookthread != null) {
            model = webhookthread;
            object = null;
            object = model.getThreadId();
            threadJSON.put("name", (String)object);
        }
        return threadJSON;
    }

    private void sendRequest(final String payload) {
        Logger.info((String)payload);
        try {
            Webhook webhook = this;
            String string = null;
            string = webhook.getPayloadUrl();
            WSRequestHolder requestHolder = WS.url((String)string);
            webhook = this;
            string = null;
            string = webhook.getSecret();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                Object[] objectArray = new Object[1];
                webhook = this;
                string = null;
                string = webhook.getSecret();
                objectArray[0] = string;
                requestHolder.setHeader("Authorization", String.format("token %s ", objectArray));
            }
            requestHolder.setHeader("Content-Type", "application/json").setHeader("User-Agent", "Yobi-Hookshot").post(payload).map((F.Function)new F.Function<WSResponse, Integer>(){

                public Integer apply(WSResponse response) {
                    int statusCode = response.getStatus();
                    String statusText = response.getStatusText();
                    if (statusCode < 200 || statusCode >= 300) {
                        Logger.info((String)String.format("[Webhook] Request responded code  %d: %s", statusCode, statusText));
                        Logger.info((String)String.format("[Webhook] Request payload: %s", payload));
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            Webhook webhook = this;
            String string = null;
            string = webhook.getPayloadUrl();
            Logger.info((String)("[Webhook] Request failed at given payload URL: " + string));
        }
    }

    private void sendRequest(final String payload, final Long webhookId, final Resource resource) {
        Logger.info((String)payload);
        try {
            Webhook webhook = this;
            String string = null;
            string = webhook.getPayloadUrl();
            WSRequestHolder requestHolder = WS.url((String)string);
            webhook = this;
            string = null;
            string = webhook.getSecret();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                Object[] objectArray = new Object[1];
                webhook = this;
                string = null;
                string = webhook.getSecret();
                objectArray[0] = string;
                requestHolder.setHeader("Authorization", String.format("token %s ", objectArray));
            }
            requestHolder.setHeader("Content-Type", "application/json").setHeader("User-Agent", "Yobi-Hookshot").post(payload).map((F.Function)new F.Function<WSResponse, Integer>(){

                public Integer apply(WSResponse response) {
                    int statusCode = response.getStatus();
                    String statusText = response.getStatusText();
                    if (statusCode < 200 || statusCode >= 300) {
                        Logger.info((String)String.format("[Webhook] Request responded code  %d: %s", statusCode, statusText));
                        Logger.info((String)String.format("[Webhook] Request payload: %s", payload));
                    } else {
                        WebhookThread webhookthread = WebhookThread.getWebhookThread(webhookId, resource);
                        if (webhookthread == null) {
                            String threadId = response.asJson().findPath("thread").findPath("name").asText();
                            webhookthread = WebhookThread.create(webhookId, resource, threadId);
                        }
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            Webhook webhook = this;
            String string = null;
            string = webhook.getPayloadUrl();
            Logger.info((String)("[Webhook] Request failed at given payload URL: " + string));
        }
    }

    public void sendRequestToPayloadUrl(List<RevCommit> commits, List<String> refNames, User sender, String title) {
        String requestBodyString = "";
        String requestMessage = this.buildRequestBody(commits, refNames, sender, title);
        requestBodyString = this.buildTextPropertyOnlyJSON(requestMessage);
        this.sendRequest(requestBodyString);
    }

    private String buildRequestBody(List<RevCommit> commits, List<String> refNames, User sender, String title) {
        StringBuilder requestMessage = new StringBuilder();
        Object[] objectArray = new Object[3];
        Model model = this;
        Object object = null;
        object = model.getProject();
        model = object;
        object = null;
        objectArray[0] = object = model.getName();
        objectArray[1] = commits.size();
        objectArray[2] = refNames.get(0);
        requestMessage.append(Messages.get((Lang)Lang.defaultLang(), (String)"notification.pushed.commits.to", (Object[])objectArray));
        return requestMessage.toString();
    }

    public void sendRequestToPayloadUrl(List<RevCommit> commits, List<String> refNames, User sender) {
        String requestBodyString = this.buildRequestBody(commits, refNames, sender);
        this.sendRequest(requestBodyString);
    }

    private String buildRequestBody(List<RevCommit> commits, List<String> refNames, User sender) {
        ObjectNode requestBody = Json.newObject();
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode refNamesNodes = mapper.createArrayNode();
        ArrayNode commitsNodes = mapper.createArrayNode();
        for (String refName : refNames) {
            refNamesNodes.add(refName);
        }
        requestBody.put("ref", (JsonNode)refNamesNodes);
        for (RevCommit commit : commits) {
            Webhook webhook = this;
            Project project2 = null;
            project2 = webhook.getProject();
            commitsNodes.add((JsonNode)this.buildJSONFromCommit(project2, commit));
        }
        requestBody.put("commits", (JsonNode)commitsNodes);
        requestBody.put("head_commit", commitsNodes.get(0));
        requestBody.put("sender", (JsonNode)this.buildSenderJSON(sender));
        requestBody.put("pusher", (JsonNode)this.buildPusherJSON(sender));
        requestBody.put("repository", (JsonNode)this.buildRepositoryJSON());
        return Json.stringify((JsonNode)requestBody);
    }

    private ObjectNode buildJSONFromCommit(Project project2, RevCommit commit) {
        GitCommit gitCommit = new GitCommit(commit);
        ObjectNode commitJSON = Json.newObject();
        ObjectNode authorJSON = Json.newObject();
        ObjectNode committerJSON = Json.newObject();
        commitJSON.put("id", gitCommit.getFullId());
        commitJSON.put("message", gitCommit.getMessage());
        commitJSON.put("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ").format(new Date(gitCommit.getCommitTime() * 1000L)));
        commitJSON.put("url", String.format("%s%s/commit/%s ", this.getBaseUrl(), RouteUtil.getUrl(project2), gitCommit.getFullId()));
        authorJSON.put("name", gitCommit.getAuthorName());
        authorJSON.put("email", gitCommit.getAuthorEmail());
        committerJSON.put("name", gitCommit.getCommitterName());
        committerJSON.put("email", gitCommit.getCommitterEmail());
        commitJSON.put("author", (JsonNode)authorJSON);
        commitJSON.put("committer", (JsonNode)committerJSON);
        return commitJSON;
    }

    public String toString() {
        Webhook webhook = this;
        Object object = null;
        object = webhook.getId();
        StringBuilder stringBuilder = new StringBuilder().append("Webhook{id=").append(object).append(", project=");
        webhook = this;
        object = null;
        object = webhook.getProject();
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", payloadUrl='");
        webhook = this;
        object = null;
        object = webhook.getPayloadUrl();
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object).append('\'').append(", secret='");
        webhook = this;
        object = null;
        object = webhook.getSecret();
        StringBuilder stringBuilder4 = stringBuilder3.append((String)object).append('\'').append(", gitPush=");
        webhook = this;
        object = null;
        object = webhook.getGitPush();
        StringBuilder stringBuilder5 = stringBuilder4.append(object).append(", webhookType=");
        webhook = this;
        object = null;
        object = webhook.getWebhookType();
        StringBuilder stringBuilder6 = stringBuilder5.append(object).append(", createdAt=");
        webhook = this;
        object = null;
        object = webhook.getCreatedAt();
        return stringBuilder6.append(object).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPayloadUrl() {
        return this._ebean_get_payloadUrl();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPayloadUrl(String string) {
        this._ebean_set_payloadUrl(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSecret() {
        return this._ebean_get_secret();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSecret(String string) {
        this._ebean_set_secret(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Boolean getGitPush() {
        return this._ebean_get_gitPush();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setGitPush(Boolean bl) {
        this._ebean_set_gitPush(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public WebhookType getWebhookType() {
        return this._ebean_get_webhookType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setWebhookType(WebhookType webhookType) {
        this._ebean_set_webhookType(webhookType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedAt() {
        return this._ebean_get_createdAt();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedAt(Date date) {
        this._ebean_set_createdAt(date);
    }

    public Webhook() {
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected String _ebean_get_payloadUrl() {
        this._ebean_intercept.preGetter("payloadUrl");
        return this.payloadUrl;
    }

    protected void _ebean_set_payloadUrl(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "payloadUrl", (Object)this._ebean_get_payloadUrl(), (Object)newValue);
        this.payloadUrl = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_payloadUrl() {
        return this.payloadUrl;
    }

    protected void _ebean_setni_payloadUrl(String _newValue) {
        this.payloadUrl = _newValue;
    }

    protected String _ebean_get_secret() {
        this._ebean_intercept.preGetter("secret");
        return this.secret;
    }

    protected void _ebean_set_secret(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "secret", (Object)this._ebean_get_secret(), (Object)newValue);
        this.secret = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_secret() {
        return this.secret;
    }

    protected void _ebean_setni_secret(String _newValue) {
        this.secret = _newValue;
    }

    protected Boolean _ebean_get_gitPush() {
        this._ebean_intercept.preGetter("gitPush");
        return this.gitPush;
    }

    protected void _ebean_set_gitPush(Boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "gitPush", (Object)this._ebean_get_gitPush(), (Object)newValue);
        this.gitPush = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Boolean _ebean_getni_gitPush() {
        return this.gitPush;
    }

    protected void _ebean_setni_gitPush(Boolean _newValue) {
        this.gitPush = _newValue;
    }

    protected WebhookType _ebean_get_webhookType() {
        this._ebean_intercept.preGetter("webhookType");
        return this.webhookType;
    }

    protected void _ebean_set_webhookType(WebhookType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "webhookType", (Object)this._ebean_get_webhookType(), (Object)newValue);
        this.webhookType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected WebhookType _ebean_getni_webhookType() {
        return this.webhookType;
    }

    protected void _ebean_setni_webhookType(WebhookType _newValue) {
        this.webhookType = _newValue;
    }

    protected Date _ebean_get_createdAt() {
        this._ebean_intercept.preGetter("createdAt");
        return this.createdAt;
    }

    protected void _ebean_set_createdAt(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdAt", (Object)this._ebean_get_createdAt(), (Object)newValue);
        this.createdAt = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdAt() {
        return this.createdAt;
    }

    protected void _ebean_setni_createdAt(Date _newValue) {
        this.createdAt = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Webhook webhook = new Webhook();
        webhook.id = this.id;
        webhook.project = this.project;
        webhook.payloadUrl = this.payloadUrl;
        webhook.secret = this.secret;
        webhook.gitPush = this.gitPush;
        webhook.webhookType = this.webhookType;
        webhook.createdAt = this.createdAt;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Webhook p = (Webhook)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.project;
            }
            case 3: {
                return p.payloadUrl;
            }
            case 4: {
                return p.secret;
            }
            case 5: {
                return p.gitPush;
            }
            case 6: {
                return p.webhookType;
            }
            case 7: {
                return p.createdAt;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Webhook p = (Webhook)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_project();
            }
            case 3: {
                return p._ebean_get_payloadUrl();
            }
            case 4: {
                return p._ebean_get_secret();
            }
            case 5: {
                return p._ebean_get_gitPush();
            }
            case 6: {
                return p._ebean_get_webhookType();
            }
            case 7: {
                return p._ebean_get_createdAt();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Webhook p = (Webhook)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.project = (Project)arg;
                return;
            }
            case 3: {
                p.payloadUrl = (String)arg;
                return;
            }
            case 4: {
                p.secret = (String)arg;
                return;
            }
            case 5: {
                p.gitPush = (Boolean)arg;
                return;
            }
            case 6: {
                p.webhookType = (WebhookType)((Object)arg);
                return;
            }
            case 7: {
                p.createdAt = (Date)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Webhook p = (Webhook)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 3: {
                p._ebean_set_payloadUrl((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_secret((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_gitPush((Boolean)arg);
                return;
            }
            case 6: {
                p._ebean_set_webhookType((WebhookType)((Object)arg));
                return;
            }
            case 7: {
                p._ebean_set_createdAt((Date)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "project", "payloadUrl", "secret", "gitPush", "webhookType", "createdAt"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Webhook webhook = this;
        synchronized (webhook) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Webhook)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Webhook();
    }
}

